/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flight.details;

import ch.icit.pegasus.client.gui.modules.flight.details.AdHocFlightDataDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.utils.FlightProviderRule;
import ch.icit.pegasus.client.gui.modules.flightschedule.details.utils.LegTable;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ConfigButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.StowagePositionIdentifier;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight_;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AdHocStwDetailsPanel
extends DefaultDetailsPanel<FlightLight>
implements SearchTextField2Listener {
    private static final long serialVersionUID = 1L;
    private TitledItem<SearchTextField2<StowingListTemplateComplete>> stowingList;
    private TitledItem<SearchTextField2<AircraftLight>> aircraft;
    private TitledItem<LegTable> legs;
    private ConfigButton aircraftMapping;
    private ConfigButton stowingMapping;
    private boolean aircraftMapped = true;
    private StowingListTemplateVariantLight currentStowingList;
    private AdHocFlightDataDetailsPanel detailsPanel;
    private LegTable referencedLegTable;

    public AdHocStwDetailsPanel(RowEditor<FlightLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.FLIGHT_ROUTE);
        this.stowingList = new TitledItem<SearchTextField2<StowingListTemplateComplete>>(SearchTextField2Factory.getStowingTemplateSearchField(true, null), Words.STOWING_LIST_TEMPLATE, TitledItem.TitledItemOrientation.NORTH);
        this.stowingList.getElement().addSearchTextFieldListener(this);
        this.aircraft = new TitledItem<SearchTextField2<AircraftLight>>(SearchTextField2Factory.getAircraftSearchField(true, null), Words.AIRCRAFT, TitledItem.TitledItemOrientation.NORTH);
        this.aircraft.getElement().addSearchTextFieldListener(this);
        this.legs = new TitledItem<LegTable>(new LegTable(provider, LegTable.LegTableType.ADHOC, false, true), WordsToolkit.toCapitalLetter((String)Words.LEGS), TitledItem.TitledItemOrientation.NORTH);
        this.legs.setTitleInset(this.horizontalBorder);
        this.legs.getElement().setWriteStdData(true);
        this.aircraftMapping = new ConfigButton();
        this.stowingMapping = new ConfigButton();
        this.aircraftMapping.addButtonListener(this);
        this.stowingMapping.addButtonListener(this);
        this.setCustomLayouter(new Layout());
        this.addToView(this.stowingList);
        this.addToView(this.aircraft);
        this.addToView(this.legs);
        this.addToView(this.aircraftMapping);
        this.addToView(this.stowingMapping);
    }

    public void setReferencedLegTable(LegTable referencedLegTable) {
        this.referencedLegTable = referencedLegTable;
    }

    public void setDetailsPanel(AdHocFlightDataDetailsPanel detailsPanel) {
        this.detailsPanel = detailsPanel;
    }

    private boolean hasSameAircraft() {
        if (this.aircraft.getElement().getNode().getValue() != null && this.currentStowingList != null) {
            return ((AircraftLight)this.aircraft.getElement().getNode().getValue()).equals((Object)this.currentStowingList.getAircraft());
        }
        return false;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.aircraftMapping) {
            if (!this.hasSameAircraft()) {
                InnerPopupFactory.showAircraftMappingPopup(this.aircraftMapping, (Node<StowingListTemplateVariantLight>)INodeCreator.getDefaultImpl().getNode4DTO((Object)this.currentStowingList, false, true), this.aircraft.getElement().getNode(), (Node<Map<StowagePositionIdentifier, StowagePositionIdentifier>>)this.editor.getModel().getNode().getChildNamed(DtoFieldConstants.AIRCRAFT_MAPPING));
            } else {
                InnerPopupFactory.showMessageDialog(Words.NO_MAPPING_NEEDED, this.aircraftMapping);
            }
            this.aircraftMapped = true;
        } else if (source == this.stowingMapping) {
            InnerPopupFactory.showLegMappingPopup(this.stowingMapping, this.createSourceLegList(), this.createDestinationLegList(), (Node<Map<ALegComplete, ALegComplete>>)this.editor.getModel().getNode().getChildNamed(DtoFieldConstants.LEG_MAPPING), Words.LEG_FROM_STOWING_LIST, Words.IS_REPLACE_BY_LEG_FROM_FLIGHT);
        }
    }

    private List<Node<ALegComplete>> createDestinationLegList() {
        ArrayList<Node<ALegComplete>> destLegs = new ArrayList<Node<ALegComplete>>();
        Iterator it = this.legs.getElement().getNode().getFailSafeChildIterator();
        while (it.hasNext()) {
            Node l = (Node)it.next();
            l.commitThis();
            destLegs.add((Node<ALegComplete>)l);
        }
        return destLegs;
    }

    private boolean isStowingListMappingReady() {
        Iterator fl = this.legs.getElement().getNode().getFailSafeChildIterator();
        Node mappingNode = this.editor.getModel().getNode().getChildNamed(DtoFieldConstants.LEG_MAPPING);
        Map maps = (Map)mappingNode.getValue();
        ArrayList legs = new ArrayList();
        boolean found = false;
        if (maps != null) {
            while (fl.hasNext()) {
                Node f = (Node)fl.next();
                f.commitThis();
                if (!maps.containsKey(f.getValue()) && !maps.containsValue(f.getValue())) continue;
                found = true;
            }
            for (Map.Entry e : maps.entrySet()) {
                if (legs.contains(e.getKey())) {
                    found = true;
                }
                if (!legs.contains(e.getValue())) continue;
                found = true;
            }
        }
        return found;
    }

    private List<Node<ALegComplete>> createSourceLegList() {
        ArrayList<Node<ALegComplete>> sourceLegs = new ArrayList<Node<ALegComplete>>();
        Iterator it = this.stowingList.getElement().getNode().getChildNamed(StowingListTemplateVariantLight_.legs).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node l = (Node)it.next();
            sourceLegs.add((Node<ALegComplete>)l);
        }
        return sourceLegs;
    }

    @Override
    public void setNode(Node<?> node) {
        Node legNode;
        Node airNode;
        Node stwNode;
        super.setNode(node);
        if (this.provider.getAdditionalRule() == null) {
            this.provider.setAdditionalRule(new FlightProviderRule((FlightComplete)node.getValue(FlightComplete.class)));
        }
        if ((stwNode = node.getChildNamed(DtoFieldConstants.NEW_STW)) == null) {
            stwNode = new DTOProxyNode();
            stwNode.setName(DtoFieldConstants.NEW_STW);
            node.addChild(stwNode, 0L);
        }
        if ((airNode = node.getChildNamed(DtoFieldConstants.NEW_AIR)) == null) {
            airNode = new DTOProxyNode();
            airNode.setName(DtoFieldConstants.NEW_AIR);
            node.addChild(airNode, 0L);
        }
        if ((legNode = node.getChildNamed(DtoFieldConstants.NEW_LEGS)) == null) {
            legNode = new ViewNode(DtoFieldConstants.NEW_LEGS.toString());
            legNode.setName(DtoFieldConstants.NEW_LEGS);
            node.addChild(legNode, 0L);
        }
        this.stowingList.getElement().setNode(stwNode);
        this.aircraft.getElement().setNode(airNode);
        this.legs.getElement().setNode(legNode);
        this.legs.getElement().setAdHocNode(node);
        Object[] o = new Object[]{this.editor.getModel().getNode().getChildNamed(FlightLight_.customer)};
        this.stowingList.getElement().setAdditionalSearchField(o);
        if (node.getChildNamed(DtoFieldConstants.LEG_MAPPING) == null) {
            Node legMappingNode = new Node();
            legMappingNode.setName(DtoFieldConstants.LEG_MAPPING);
            node.addChild(legMappingNode, 0L);
        }
        node.getChildNamed(DtoFieldConstants.LEG_MAPPING).setValue(null, 0L);
        node.getChildNamed(DtoFieldConstants.LEG_MAPPING).updateNode();
        if (node.getChildNamed(DtoFieldConstants.AIRCRAFT_MAPPING) == null) {
            Node am = new Node();
            am.setName(DtoFieldConstants.AIRCRAFT_MAPPING);
            node.addChild(am, 0L);
        }
        node.getChildNamed(DtoFieldConstants.AIRCRAFT_MAPPING).setValue(null, 0L);
        node.getChildNamed(DtoFieldConstants.AIRCRAFT_MAPPING).updateNode();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.stowingList.setEnabled(isEnabled);
        boolean eb = isEnabled && this.stowingList.getElement().isItemSelected();
        this.stowingMapping.setEnabled(eb);
        this.aircraft.setEnabled(eb);
        boolean ab = eb && this.aircraft.getElement().isItemSelected();
        this.aircraftMapping.setEnabled(ab);
        this.legs.setEnabled(eb);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.stowingList.kill();
        this.stowingList = null;
        this.aircraft.kill();
        this.aircraft = null;
        this.aircraftMapping.kill();
        this.aircraftMapping = null;
        this.stowingMapping.kill();
        this.stowingMapping = null;
        this.legs.kill();
        this.legs = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.stowingList);
        CheckedListAdder.addToList(focusList, this.stowingMapping);
        CheckedListAdder.addToList(focusList, this.aircraft);
        CheckedListAdder.addToList(focusList, this.aircraftMapping);
        CheckedListAdder.addToList(focusList, this.legs);
        return focusList;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.stowingList.requestFocusInWindowNow();
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (!this.stowingList.getElement().isItemSelected()) {
            this.stowingList.getElement().setInValid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_STOWING_LIST));
        } else if (!this.aircraft.getElement().isItemSelected()) {
            this.aircraft.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_AIRCRAFT));
        } else {
            if (!this.isStowingListMappingReady()) {
                this.stowingMapping.setInvalid();
                this.stowingList.getElement().setInValid();
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_STW_LEG_MAPPING));
            } else {
                this.stowingMapping.setValid();
                this.stowingList.getElement().setValid();
            }
            if (!this.hasSameAircraft() && !this.aircraftMapped) {
                this.aircraft.getElement().setInValid();
                this.aircraftMapping.setInvalid();
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_AIRCRAFT_MAPPING));
            } else {
                this.aircraft.getElement().setValid();
                this.aircraftMapping.setValid();
            }
        }
        return validationObjects;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    public void setStwVariant(StowingListTemplateVariantLight currentStowingList) {
        this.currentStowingList = currentStowingList;
    }

    public LegTable getLegTable() {
        return this.legs.getElement();
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> node) {
        if (source == this.stowingList.getElement()) {
            if (node.getValue() != null) {
                Timestamp std = (Timestamp)this.editor.getModel().getNode().getChildNamed(FlightLight_.std).getValue();
                this.reloadStowingList((StowingListTemplateComplete)node.getValue(), std);
            }
        } else if (this.aircraft.getElement() == source) {
            this.aircraftMapped = node.getValue() == null;
        }
        this.setEnabled(this.isEnabled());
    }

    private void reloadStowingList(final StowingListTemplateComplete stwL, final Timestamp std) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                AdHocStwDetailsPanel.this.currentStowingList = (StowingListTemplateVariantLight)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).resolveVariant(new StowingListTemplateReference(stwL.getId()), new TimestampWrapper(std)).getValue();
                AdHocStwDetailsPanel.this.detailsPanel.setStwVariant(AdHocStwDetailsPanel.this.currentStowingList);
                AdHocStwDetailsPanel.this.referencedLegTable.setCurrentStowingList(AdHocStwDetailsPanel.this.currentStowingList);
                return INodeCreator.getDefaultImpl().getNode4DTO((Object)stwL, false, true);
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        ((LegTable)AdHocStwDetailsPanel.this.legs.getElement()).getNode().removeAllChilds();
                        ((LegTable)AdHocStwDetailsPanel.this.legs.getElement()).getTable().resetTable();
                        StowingListTemplateComplete stwL = (StowingListTemplateComplete)node.getValue();
                        if (stwL != null) {
                            Iterator it = node.getChildNamed(StowingListTemplateVariantLight_.legs).getFailSafeChildIterator();
                            while (it.hasNext()) {
                                Node sn = (Node)it.next();
                                FlightLegComplete nl = new FlightLegComplete();
                                nl.setArrivalAirport(((StowingListTemplateLegComplete)sn.getValue()).getArrivalAirport());
                                nl.setDepartureAirport(((StowingListTemplateLegComplete)sn.getValue()).getDepartureAirport());
                                nl.setClientOId(Long.valueOf(ADTO.getNextId()));
                                nl.setLegType(((StowingListTemplateLegComplete)sn.getValue()).getLegType());
                                nl.setNumber(((StowingListTemplateLegComplete)sn.getValue()).getNumber());
                                nl.setCateringLeg(Boolean.valueOf(true));
                                nl.setShowLegOnDailyOps(Boolean.valueOf(true));
                                ((LegTable)AdHocStwDetailsPanel.this.legs.getElement()).getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)nl, true, false), 0L);
                            }
                            AdHocStwDetailsPanel.this.editor.getModel().getNode().getChildNamed(FlightLight_.customer).setValue((Object)stwL.getCustomer(), 0L);
                            if (AdHocStwDetailsPanel.this.currentStowingList != null) {
                                ((SearchTextField2)AdHocStwDetailsPanel.this.aircraft.getElement()).getNode().setValue((Object)AdHocStwDetailsPanel.this.currentStowingList.getAircraft(), 0L);
                            }
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, Words.UNABLE_TO_LOAD, (Component)AdHocStwDetailsPanel.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = AdHocStwDetailsPanel.this.verticalBorder;
            h = (int)((double)h + AdHocStwDetailsPanel.this.stowingList.getPreferredSize().getHeight());
            h += AdHocStwDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + AdHocStwDetailsPanel.this.aircraft.getPreferredSize().getHeight());
            h += AdHocStwDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + AdHocStwDetailsPanel.this.legs.getPreferredSize().getHeight());
            return new Dimension(0, h += AdHocStwDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            AdHocStwDetailsPanel.this.stowingList.setLocation(AdHocStwDetailsPanel.this.horizontalBorder, AdHocStwDetailsPanel.this.verticalBorder);
            AdHocStwDetailsPanel.this.stowingList.setSize((int)((double)parent.getWidth() - ((double)(2 * AdHocStwDetailsPanel.this.horizontalBorder) + AdHocStwDetailsPanel.this.stowingMapping.getPreferredSize().getWidth() + 5.0)), (int)AdHocStwDetailsPanel.this.stowingList.getPreferredSize().getHeight());
            AdHocStwDetailsPanel.this.stowingMapping.setLocation(AdHocStwDetailsPanel.this.stowingList.getX() + AdHocStwDetailsPanel.this.stowingList.getWidth() + 5, (int)((double)(AdHocStwDetailsPanel.this.stowingList.getY() + AdHocStwDetailsPanel.this.stowingList.getHeight() - ((SearchTextField2)AdHocStwDetailsPanel.this.stowingList.getElement()).getHeight()) + ((double)((SearchTextField2)AdHocStwDetailsPanel.this.stowingList.getElement()).getHeight() - AdHocStwDetailsPanel.this.stowingMapping.getPreferredSize().getHeight()) / 2.0));
            AdHocStwDetailsPanel.this.stowingMapping.setSize(AdHocStwDetailsPanel.this.stowingMapping.getPreferredSize());
            AdHocStwDetailsPanel.this.aircraft.setLocation(AdHocStwDetailsPanel.this.horizontalBorder, AdHocStwDetailsPanel.this.stowingList.getY() + AdHocStwDetailsPanel.this.stowingList.getHeight() + AdHocStwDetailsPanel.this.inner_verticalBorder);
            AdHocStwDetailsPanel.this.aircraft.setSize((int)((double)parent.getWidth() - ((double)(2 * AdHocStwDetailsPanel.this.horizontalBorder + 5) + AdHocStwDetailsPanel.this.aircraftMapping.getPreferredSize().getWidth())), (int)AdHocStwDetailsPanel.this.aircraft.getPreferredSize().getHeight());
            AdHocStwDetailsPanel.this.aircraftMapping.setLocation(AdHocStwDetailsPanel.this.aircraft.getX() + AdHocStwDetailsPanel.this.aircraft.getWidth() + 5, (int)((double)(AdHocStwDetailsPanel.this.aircraft.getY() + AdHocStwDetailsPanel.this.aircraft.getHeight() - ((SearchTextField2)AdHocStwDetailsPanel.this.aircraft.getElement()).getHeight()) + ((double)((SearchTextField2)AdHocStwDetailsPanel.this.aircraft.getElement()).getHeight() - AdHocStwDetailsPanel.this.aircraftMapping.getPreferredSize().getHeight()) / 2.0));
            AdHocStwDetailsPanel.this.aircraftMapping.setSize(AdHocStwDetailsPanel.this.aircraftMapping.getPreferredSize());
            AdHocStwDetailsPanel.this.legs.setLocation(0, AdHocStwDetailsPanel.this.aircraft.getY() + AdHocStwDetailsPanel.this.aircraft.getHeight() + AdHocStwDetailsPanel.this.inner_verticalBorder);
            AdHocStwDetailsPanel.this.legs.setSize(parent.getWidth(), parent.getHeight() - AdHocStwDetailsPanel.this.legs.getY());
        }
    }
}

