/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flight.details;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.flightschedule.AdditionalOrderComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class EditSpecialPricePopupInsert
extends PopUpInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private Node<?> additionalOrderNode;
    private TitledItem<CheckBox> useSpecialPrice;
    private TitledItem<CheckBox> singleLabels;
    private TitledItem<InputComboBox> price;
    private boolean canEditPrice;
    private boolean canEditLabelOption;

    public EditSpecialPricePopupInsert(Node<?> node, boolean addLabelOptions, boolean canEditPrice, boolean canEditLabelOption) {
        this.additionalOrderNode = node;
        this.canEditLabelOption = canEditLabelOption;
        this.canEditPrice = canEditPrice;
        if (addLabelOptions) {
            this.singleLabels = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)node.getChildNamed(AdditionalOrderComplete_.printSingleLabels)), Words.PRINT_SEPARATE_LABELS, TitledItem.TitledItemOrientation.WEST);
            this.singleLabels.getElement().addButtonListener(this);
            this.add(this.singleLabels);
        }
        this.useSpecialPrice = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)node.getChildNamed(AdditionalOrderComplete_.hasSpecialPrice)), Words.USE_SPECIAL_PRICE, TitledItem.TitledItemOrientation.WEST);
        this.useSpecialPrice.getElement().addButtonListener(this);
        this.add(this.useSpecialPrice);
        Node specialPrice = this.additionalOrderNode.getChildNamed(AdditionalOrderComplete_.specialPrice);
        if (specialPrice.getValue() == null) {
            PriceComplete p = new PriceComplete();
            p.setPrice(Double.valueOf(0.0));
            p.setCurrency(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency());
            specialPrice.setValue((Object)p, 0L);
        } else {
            PriceComplete p = (PriceComplete)specialPrice.getValue();
            if (p.getCurrency() == null) {
                p.setCurrency(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency());
            }
            if (p.getPrice() == null) {
                p.setPrice(Double.valueOf(0.0));
            }
        }
        this.price = new TitledItem<InputComboBox>(new InputComboBox(specialPrice.getChildNamed(PriceComplete_.price), specialPrice.getChildNamed(PriceComplete_.currency), InputComboBox.InputComboBoxType.PRICE_DOUBLE), Words.NEW_PRICE, TitledItem.TitledItemOrientation.WEST);
        this.price.getElement().repaint(32L);
        this.add(this.price);
        this.setEnabled(true);
        this.setLayout(new Layout());
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean b = false;
        b = enabled && (Boolean)this.additionalOrderNode.getChildNamed(AdditionalOrderComplete_.hasSpecialPrice).getValue() != false;
        this.price.setEnabled(b && this.canEditPrice);
        this.useSpecialPrice.setEnabled(enabled && this.canEditPrice);
        if (this.singleLabels != null) {
            this.singleLabels.setEnabled(enabled && this.canEditLabelOption);
        }
        this.repaint(23L);
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<TitledItem<JPanelFadable>> a = new ArrayList<TitledItem<JPanelFadable>>();
        a.add(this.useSpecialPrice);
        if (this.price.isEnabled()) {
            a.add(this.price);
        }
        if (this.singleLabels != null && this.singleLabels.isEnabled()) {
            a.add(this.singleLabels);
        }
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.useSpecialPrice.getElement()) {
            this.setEnabled(true);
            this.additionalOrderNode.getChildNamed(AdditionalOrderComplete_.hasSpecialPrice).commit();
        }
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (isOK != PopupAction.CANCEL) {
            this.additionalOrderNode.getChildNamed(AdditionalOrderComplete_.specialPrice).commit();
            this.additionalOrderNode.getChildNamed(AdditionalOrderComplete_.hasSpecialPrice).commit();
            if (this.singleLabels != null) {
                this.additionalOrderNode.getChildNamed(AdditionalOrderComplete_.printSingleLabels).commit();
            }
        }
        super.enterPressed(isOK);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(((EditSpecialPricePopupInsert)EditSpecialPricePopupInsert.this).useSpecialPrice.getPreferredSize().width, ((EditSpecialPricePopupInsert)EditSpecialPricePopupInsert.this).price.getPreferredSize().height + ((EditSpecialPricePopupInsert)EditSpecialPricePopupInsert.this).useSpecialPrice.getPreferredSize().height + 30 + ((EditSpecialPricePopupInsert)EditSpecialPricePopupInsert.this).singleLabels.getPreferredSize().height + 30);
        }

        @Override
        public void layoutContainer(Container parent) {
            EditSpecialPricePopupInsert.this.useSpecialPrice.setLocation(10, 10);
            EditSpecialPricePopupInsert.this.useSpecialPrice.setSize(parent.getWidth() - 20, 20);
            EditSpecialPricePopupInsert.this.price.setLocation(10, 40);
            EditSpecialPricePopupInsert.this.price.setSize(parent.getWidth() - 20, 20);
            if (EditSpecialPricePopupInsert.this.singleLabels != null) {
                EditSpecialPricePopupInsert.this.singleLabels.setLocation(10, 70);
                EditSpecialPricePopupInsert.this.singleLabels.setSize(parent.getWidth() - 20, 20);
            }
        }
    }
}

