/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flight.details;

import ch.icit.pegasus.client.converter.CabinClassConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.flight.details.utils.FlightProviderRule;
import ch.icit.pegasus.client.gui.modules.flight.utils.FlightEditableChecker;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.StartEndLegComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.toolkits.LegToolkit;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.RegularOrderComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.RegularOrderComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class RegularOrderDetailsPanel
extends TableDetailsPanel<FlightLight>
implements LafListener {
    private static final long serialVersionUID = 1L;
    private Node<FlightComplete> root;
    private boolean isDeletable = true;
    private FlightEditableChecker checker = new FlightEditableChecker();
    private int currentIndex;

    public RegularOrderDetailsPanel(RowEditor<FlightLight> editor, RDProvider provider) {
        super(editor, provider, true, true, true, true);
        this.setTitleText(Words.REGURAL_ORDERS);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int index = 0;
        int delWidth = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo(Words.LEG, "", null, null, "", 180, 180, 180));
        ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        columns.add(new TableColumnInfo(Words.CLASS, "", null, null, "", 125, 125, 125));
        ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        columns.add(new TableColumnInfo(Words.COUNT, "", null, null, "", 60, 60, 60));
        ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        columns.add(new TableColumnInfo(Words.PAX_NAME, "", null, null, "", 0, 0, 0));
        ((TableColumnInfo)columns.get(index++)).setxExpand(0.5);
        columns.add(new TableColumnInfo(Words.PAX_REMARK, "", null, null, "", 0, 0, 0));
        ((TableColumnInfo)columns.get(index++)).setxExpand(0.5);
        columns.add(new TableColumnInfo(Words.SEAT_NUMBER, "", null, null, "", 100, 100, 100));
        ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        columns.add(new TableColumnInfo("", "", null, null, "", delWidth += 2 * this.table.getCellPadding(), delWidth, delWidth));
        ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setProvider(this.provider);
        table.setComparator(new Comparator<TableRowImpl>(){

            @Override
            public int compare(TableRowImpl o1, TableRowImpl o2) {
                FlightLegComplete l2;
                FlightLegComplete l1;
                int i;
                Node order1 = o1.getModel().getNode();
                Node order2 = o2.getModel().getNode();
                boolean firstWasNew = false;
                boolean secondWasNew = false;
                if (order1.getChildNamed(RegularOrderComplete.ID_).getValue() == null) {
                    firstWasNew = true;
                }
                if (order2.getChildNamed(RegularOrderComplete.ID_).getValue() == null) {
                    secondWasNew = true;
                }
                if (firstWasNew && secondWasNew) {
                    if (order1.getChildNamed(DtoFieldConstants.INSERT_INDEX) != null && order2.getChildNamed(DtoFieldConstants.INSERT_INDEX) != null) {
                        Integer t = (Integer)order1.getChildNamed(DtoFieldConstants.INSERT_INDEX).getValue();
                        Integer t2 = (Integer)order2.getChildNamed(DtoFieldConstants.INSERT_INDEX).getValue();
                        return t - t2;
                    }
                } else {
                    if (firstWasNew) {
                        return 1;
                    }
                    if (secondWasNew) {
                        return -1;
                    }
                }
                if (order1.getChildNamed(RegularOrderComplete_.legs).getChildCount() > 0 && order2.getChildNamed(RegularOrderComplete_.legs).getChildCount() > 0 && (i = (l1 = (FlightLegComplete)order1.getChildNamed(RegularOrderComplete_.legs).getChildAt(0).getValue()).compareTo((ALegComplete)(l2 = (FlightLegComplete)order2.getChildNamed(RegularOrderComplete_.legs).getChildAt(0).getValue()))) != 0) {
                    return i;
                }
                CabinClassComplete c1 = (CabinClassComplete)order1.getChildNamed(RegularOrderComplete_.cabinClass).getValue();
                CabinClassComplete c2 = (CabinClassComplete)order2.getChildNamed(RegularOrderComplete_.cabinClass).getValue();
                i = c1.compareTo(c2);
                return i;
            }
        });
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        RegularOrderComplete nDto = new RegularOrderComplete();
        nDto.setFlight((FlightReference)this.editor.getModel().getNode().getValue());
        if (this.table.getRowCount() > 0) {
            Table2RowModel m = this.table.getRows().get(this.table.getRowCount() - 1).getModel();
            if (m.getNode().getChildNamed(RegularOrderComplete_.count).getValue() != null) {
                nDto.setCount((Integer)m.getNode().getChildNamed(RegularOrderComplete_.count).getValue());
            } else {
                nDto.setCount(Integer.valueOf(1));
            }
            if (m.getNode().getChildNamed(RegularOrderComplete_.legs).getValue() != null) {
                Iterator it = m.getNode().getChildNamed(RegularOrderComplete_.legs).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    nDto.getLegs().add(n.getValue());
                }
            }
            nDto.setCabinClass((CabinClassComplete)m.getNode().getChildNamed(RegularOrderComplete_.cabinClass).getValue());
        } else {
            Node spmls;
            Node legNode;
            nDto.setCount(Integer.valueOf(1));
            Node legs = legNode = this.root.getChildNamed(FlightComplete_.legs);
            Node l = LegToolkit.getFlightLegsWithoutDSorNS((Node)legs);
            if (l.getChildCount() > 0) {
                nDto.getLegs().add((FlightLegComplete)l.getChildAt(0).getValue());
            }
            if ((spmls = NodeToolkit.getAffixNamed((String)"spmlCabinClasses")).getChildCount() > 0) {
                nDto.setCabinClass((CabinClassComplete)spmls.getChildAt(0).getValue());
            }
        }
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)nDto, true, false);
        Node insertIndex = new Node();
        insertIndex.setValue((Object)this.currentIndex++, 0L);
        insertIndex.setName(DtoFieldConstants.INSERT_INDEX);
        n.addChild(insertIndex, 0L);
        this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl rowPanel = new TableRowImpl(model);
        rowPanel.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return rowPanel;
    }

    private Node createPossibleCabinClassList() {
        return NodeToolkit.getAffixNamed((String)"spmlCabinClasses");
    }

    @Override
    public boolean hasExpandableContent() {
        if (this.table != null) {
            return !this.table.getRows().isEmpty();
        }
        return false;
    }

    @Override
    public void setNode(Node<?> node) {
        if (this.provider.getAdditionalRule() == null) {
            this.provider.setAdditionalRule(new FlightProviderRule((FlightComplete)node.getValue(FlightComplete.class)));
        }
        this.isDeletable = this.provider.isDeletable(FlightComplete_.regularOrders);
        this.root = node;
        if (this.root != null) {
            Node meals = this.root.getChildNamed(FlightComplete_.regularOrders);
            this.table.getModel().setNode(meals);
        } else {
            this.table.getModel().setNode(null);
        }
        super.setNode(node);
    }

    @Override
    public void setValid(boolean b) {
        this.table.enableAddButton(b);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean enabled = this.checker.canEditFlight(this.root, this.provider, isEnabled);
        super.setEnabled(enabled);
    }

    @Override
    public void lafAttributeChanged(String att) {
        super.lafAttributeChanged(att);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.table.isWritable()) {
            boolean isValid = true;
            boolean areLegValid = true;
            boolean isClassValid = true;
            for (Table2RowPanel p : this.table.getRows()) {
                TableRowImpl r = (TableRowImpl)p;
                if (!r.isContentValid()) {
                    isValid = false;
                }
                if (!r.areLegsValid()) {
                    areLegValid = false;
                }
                if (r.isClassValid()) continue;
                isClassValid = false;
            }
            if (!isValid) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.REVIEW_SPML_PAX_COUNT));
            }
            if (!areLegValid) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.REVIEW_SPML_LEGS));
            }
            if (!isClassValid) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.REVIEW_SPML_CABIN_CLASS));
            }
        }
        return validationObjects;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        for (Table2RowPanel rowPanel : this.table.getRows()) {
            TableRowImpl e = (TableRowImpl)rowPanel;
            if (!e.isInnerComponent(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements NodeListener,
    ButtonListener,
    LafListener {
        private static final long serialVersionUID = 1L;
        private StartEndLegComboBox legs;
        private RDComboBox cabinClass;
        private RDTextField count;
        private RDTextField paxName;
        private RDTextField paxRemark;
        private RDTextField seatNumber;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new TableRowEditorLayout());
            if (RegularOrderDetailsPanel.this.isDeletable) {
                this.delete = new DeleteButton();
                this.delete.addButtonListener(this);
                this.add(this.delete);
                this.delete.fadeIn();
            }
            m.getNode().addNodeListener((NodeListener)this);
            this.childAdded(m.getNode(), m.getNode().getChildNamed(RegularOrderComplete_.legs));
            this.childAdded(m.getNode(), m.getNode().getChildNamed(RegularOrderComplete_.count));
            this.childAdded(m.getNode(), m.getNode().getChildNamed(RegularOrderComplete_.cabinClass));
            this.childAdded(m.getNode(), m.getNode().getChildNamed(RegularOrderComplete_.paxName));
            this.childAdded(m.getNode(), m.getNode().getChildNamed(RegularOrderComplete_.paxRemark));
            this.childAdded(m.getNode(), m.getNode().getChildNamed(RegularOrderComplete_.seatNumber));
            this.lafAttributeChanged("All attribues changed");
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 1: {
                    return this.legs.createShownString((Node)null);
                }
                case 2: {
                    return this.cabinClass.getStringValue();
                }
                case 3: {
                    return this.count.getText();
                }
                case 4: {
                    return this.paxName.getText();
                }
                case 5: {
                    return this.paxRemark.getText();
                }
                case 6: {
                    return this.seatNumber.getText();
                }
            }
            return null;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.legs.requestFocusInWindowNow();
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.legs);
            CheckedListAdder.addToList(a, this.cabinClass);
            CheckedListAdder.addToList(a, this.count);
            CheckedListAdder.addToList(a, this.paxName);
            CheckedListAdder.addToList(a, this.paxRemark);
            CheckedListAdder.addToList(a, this.seatNumber);
            if (this.delete != null) {
                CheckedListAdder.addToList(a, this.delete);
            }
            return a;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.legs.setEnabled(isEnabled);
            this.cabinClass.setEnabled(isEnabled);
            this.count.setEnabled(isEnabled);
            this.paxName.setEnabled(isEnabled);
            this.paxRemark.setEnabled(isEnabled);
            this.seatNumber.setEnabled(isEnabled);
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.legs.kill();
            this.cabinClass.kill();
            this.count.kill();
            this.paxName.kill();
            this.paxRemark.kill();
            this.seatNumber.kill();
            if (this.delete != null) {
                this.delete.kill();
            }
            this.legs = null;
            this.count = null;
            this.cabinClass = null;
            this.paxName = null;
            this.paxRemark = null;
            this.seatNumber = null;
            this.delete = null;
        }

        public void childAdded(Node<?> source, Node<?> child) {
            if (child.getName().equals(RegularOrderComplete_.legs.getFieldName())) {
                Node<?> legNode = child;
                this.legs = new StartEndLegComboBox(legNode, RegularOrderDetailsPanel.this.editor.getModel().getNode().getChildNamed(FlightLight_.legs)){

                    @Override
                    public Node<?> createSelectableList() {
                        Node<?> n = super.createSelectableList();
                        return LegToolkit.getFlightLegsWithoutDSorNS(n);
                    }
                };
                this.add(this.legs);
                this.legs.fadeIn();
            } else if (child.getName().equals(RegularOrderComplete_.count.getFieldName())) {
                this.count = new RDTextField(RegularOrderDetailsPanel.this.provider, TextFieldType.INT);
                this.count.setNode(child);
                this.add(this.count);
                this.count.fadeIn();
            } else if (child.getName().equals(RegularOrderComplete_.cabinClass.getFieldName())) {
                Node<?> node = child;
                CabinClassConverter viewConverter = (CabinClassConverter)ConverterRegistry.getConverter(CabinClassConverter.class);
                this.cabinClass = new RDComboBox(RegularOrderDetailsPanel.this.provider, (Converter)viewConverter);
                this.cabinClass.refreshPossibleValues(RegularOrderDetailsPanel.this.createPossibleCabinClassList());
                if (node.getParent() != null) {
                    RegularOrderComplete o = (RegularOrderComplete)node.getParent().getValue();
                    Node<?> n = node;
                    n.setValueSilent((Object)o.getCabinClass(), true, 0L, null);
                }
                this.cabinClass.setNode(node);
                this.add(this.cabinClass);
                this.cabinClass.fadeIn();
            } else if (child.getName().equals(RegularOrderComplete_.paxName.getFieldName())) {
                this.paxName = new RDTextField(RegularOrderDetailsPanel.this.provider);
                this.paxName.setNode(child);
                this.add(this.paxName);
                this.paxName.fadeIn();
            } else if (child.getName().equals(RegularOrderComplete_.paxRemark.getFieldName())) {
                this.paxRemark = new RDTextField(RegularOrderDetailsPanel.this.provider);
                this.paxRemark.setNode(child);
                this.add(this.paxRemark);
                this.paxRemark.fadeIn();
            } else if (child.getName().equals(RegularOrderComplete_.seatNumber.getFieldName())) {
                this.seatNumber = new RDTextField(RegularOrderDetailsPanel.this.provider);
                this.seatNumber.setNode(child);
                this.add(this.seatNumber);
                this.seatNumber.fadeIn();
            }
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void valueChanged(Node<?> node) {
            this.setEnabled(this.isEnabled());
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            this.model.getParentModel().getNode().removeChild(this.model.getNode(), System.currentTimeMillis());
        }

        @Override
        public void lafAttributeChanged(String att) {
            Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
            if (this.count != null) {
                this.count.setFont(f);
            }
            if (this.paxName != null) {
                this.paxName.setFont(f);
            }
            if (this.paxRemark != null) {
                this.paxRemark.setFont(f);
            }
            if (this.seatNumber != null) {
                this.seatNumber.setFont(f);
            }
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isContentValid() {
            Integer i = (Integer)this.model.getNode().getChildNamed(RegularOrderComplete_.count).getValue();
            if (i != null && i > 0) {
                return true;
            }
            this.count.setInvalid();
            return false;
        }

        public boolean areLegsValid() {
            boolean b;
            boolean bl = b = this.model.getNode().getChildNamed(RegularOrderComplete_.legs).getChildCount() > 0;
            if (!b) {
                this.legs.setInvalid();
            }
            return b;
        }

        public boolean isClassValid() {
            CabinClassComplete cc = (CabinClassComplete)this.model.getNode().getChildNamed(RegularOrderComplete_.cabinClass).getValue(CabinClassComplete.class);
            if (cc == null) {
                this.cabinClass.setInvalid();
            }
            return cc != null;
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class TableRowEditorLayout
        extends DefaultLayout {
            private TableRowEditorLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int h = parent.getHeight();
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int index = 1;
                TableRowImpl.this.legs.setLocation(currentX + TableRowImpl.this.cellPadding, (int)(((double)h - TableRowImpl.this.legs.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.legs.setSize(w - 2 * TableRowImpl.this.cellPadding, (int)TableRowImpl.this.legs.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.cabinClass.setLocation(currentX + TableRowImpl.this.cellPadding, (int)(((double)h - TableRowImpl.this.cabinClass.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.cabinClass.setSize(w - 2 * TableRowImpl.this.cellPadding, (int)TableRowImpl.this.cabinClass.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.count.setLocation(currentX + TableRowImpl.this.cellPadding, (int)(((double)h - TableRowImpl.this.count.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.count.setSize(w - 2 * TableRowImpl.this.cellPadding, (int)TableRowImpl.this.count.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.paxName.setLocation(currentX + TableRowImpl.this.cellPadding, (int)(((double)h - TableRowImpl.this.paxName.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.paxName.setSize(w - 2 * TableRowImpl.this.cellPadding, (int)TableRowImpl.this.paxName.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.paxRemark.setLocation(currentX + TableRowImpl.this.cellPadding, (int)(((double)h - TableRowImpl.this.paxRemark.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.paxRemark.setSize(w - 2 * TableRowImpl.this.cellPadding, (int)TableRowImpl.this.paxRemark.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.seatNumber.setLocation(currentX + TableRowImpl.this.cellPadding, (int)(((double)h - TableRowImpl.this.seatNumber.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.seatNumber.setSize(w - 2 * TableRowImpl.this.cellPadding, (int)TableRowImpl.this.seatNumber.getPreferredSize().getHeight());
                TableRowImpl.this.setControlsX(currentX += w);
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation((int)((double)currentX + ((double)w - TableRowImpl.this.delete.getPreferredSize().getWidth()) / 2.0), (int)(((double)h - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(w - 2 * TableRowImpl.this.cellPadding, (int)TableRowImpl.this.delete.getPreferredSize().getHeight());
                }
                currentX += w;
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }
}

