/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flight.details;

import ch.icit.pegasus.client.converter.ColorConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.SealTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.flight.details.utils.PredefineEquipmentSealPopup;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.TextFieldListener;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.AbstractTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightAccess;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.tracking.EquipmentSealsComplete;
import ch.icit.pegasus.server.core.dtos.tracking.FlightSealsComplete;
import ch.icit.pegasus.server.core.dtos.tracking.SealComplete;
import ch.icit.pegasus.server.core.dtos.tracking.SealComplete_;
import ch.icit.pegasus.server.core.dtos.tracking.SealTypeE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SealDefinitionDetailsPanel
extends TableDetailsPanel<FlightLight> {
    private static final long serialVersionUID = 1L;
    private boolean isListEditable;

    public SealDefinitionDetailsPanel(RowEditor<FlightLight> editor, RDProvider provider) {
        super(editor, provider, true, true, true, true);
        this.setTitleText(Words.SEAL_DEFINITION_PANEL);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.SEAL_TYPE, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(WordsToolkit.toUpperCase((String)Words.COLOR), null, null, null, "", 120, 120, 120));
        columns.add(new TableColumnInfo(WordsToolkit.toUpperCase((String)Words.START), null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(WordsToolkit.toUpperCase((String)Words.COUNT), null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.END, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.EQ, null, null, null, "", 40, 40, 40));
        int tw = 2 * this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.16);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.17);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.17);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setOverrideName(FlightAccess.SEAL_DEFINITION);
        table.setUseWriteAccessRight(true);
        table.setProvider(this.provider);
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        ViewNode n = this.getNewEmptyLine();
        this.table.getModel().getNode().addChild((Node)n, 0L);
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl rowPanel = new TableRowImpl(model);
        rowPanel.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return rowPanel;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        FlightStateE flightState;
        FlightLight flight;
        boolean isPlanned = false;
        if (this.getEditor().getModel().getNode() != null && this.getEditor().getModel().getNode().getChildNamed(FlightComplete_.flightState) != null && (flight = (FlightLight)this.getEditor().getModel().getNode().getValue(FlightLight.class)) != null && (flightState = flight.getFlightState()) == FlightStateE.PLANNED) {
            isPlanned = true;
        }
        super.setEnabled(isEnabled && !isPlanned);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        List<ScreenValidationObject> validationObjects = super.validateParagraph();
        if (validationObjects == null) {
            validationObjects = new ArrayList<ScreenValidationObject>();
        }
        List<Table2RowPanel> rows = this.table.getRows();
        for (Table2RowPanel table2RowPanel : rows) {
            TableRowImpl tr = (TableRowImpl)table2RowPanel;
            SealTypeE origType = tr.getType();
            ColorComplete origColor = tr.getSealColor();
            for (Table2RowPanel table2RowPanel2 : rows) {
                TableRowImpl tr2;
                if (table2RowPanel == table2RowPanel2 || (tr2 = (TableRowImpl)table2RowPanel2).getSealColor() != origColor || tr2.getType() != origType || tr.getStartSealNo() >= tr2.getStartSealNo() + tr2.getSealCount() || tr.getStartSealNo() + tr.getSealCount() <= tr2.getStartSealNo()) continue;
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.TWO_OVERLAPPING_SEAL_RANGES));
            }
        }
        return validationObjects;
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        Node n = NodeToolkit.getAffixNamed((String)"SealedEQs");
        if (n != null) {
            if (Boolean.TRUE.equals(((CustomerLight)this.editor.getModel().getNode().getChildNamed(FlightLight_.customer).getValue()).getPredefineSealsForEquipments())) {
                FlightSealsComplete flightSeals = (FlightSealsComplete)n.getValue();
                ArrayList<Object> eqSeals = new ArrayList<Object>();
                for (Table2RowPanel p : this.table.getRows()) {
                    TableRowImpl rowImpl = (TableRowImpl)p;
                    Node rowNode = rowImpl.getModel().getNode();
                    Node type = rowNode.getChildNamed(DtoFieldConstants.TYPE);
                    Node color = rowNode.getChildNamed(DtoFieldConstants.COLOR);
                    Node eqs = rowNode.getChildNamed(DtoFieldConstants.EQS);
                    Iterator it = eqs.getChilds();
                    while (it.hasNext()) {
                        Node e = (Node)it.next();
                        if (!eqSeals.contains(e.getValue())) {
                            eqSeals.add(e.getValue());
                        }
                        Node door = e.getChildNamed(DtoFieldConstants.DOOR);
                        Node preSealNo = e.getChildNamed(DtoFieldConstants.PRE_SEAL_NO);
                        ArrayList<SealComplete> seals = (ArrayList<SealComplete>)((EquipmentSealsComplete)e.getValue()).getSeals().get(type.getValue());
                        if (seals == null) {
                            seals = new ArrayList<SealComplete>();
                            ((EquipmentSealsComplete)e.getValue()).getSeals().put(type.getValue(), seals);
                        }
                        SealComplete cs = null;
                        for (SealComplete s : seals) {
                            int d = -12;
                            if (door.getValue() != null) {
                                d = (Integer)door.getValue();
                            }
                            if (!s.getColor().equals(color.getValue()) || s.getSequenceNumber() != d) continue;
                            cs = s;
                        }
                        if (cs == null) {
                            cs = new SealComplete();
                        }
                        cs.setColor((ColorComplete)color.getValue());
                        cs.setPredefinedNumber((Integer)preSealNo.getValue());
                        cs.setSealNumber((Integer)preSealNo.getValue());
                        cs.setSequenceNumber((Integer)door.getValue());
                        cs.setIdentifier("" + door.getValue());
                        cs.setType((SealTypeE)type.getValue());
                        seals.remove(cs);
                        seals.add(cs);
                    }
                }
                flightSeals.setEquipments(eqSeals);
            } else {
                ArrayList<SealComplete> seals = new ArrayList<SealComplete>();
                for (Table2RowPanel p : this.table.getRows()) {
                    TableRowImpl rowImpl = (TableRowImpl)p;
                    SealTypeE type = rowImpl.getType();
                    ColorComplete color = rowImpl.getSealColor();
                    Integer startNo = rowImpl.getStartSealNo();
                    Integer sealsCount = rowImpl.getSealCount();
                    for (int i = startNo.intValue(); i < startNo + sealsCount; ++i) {
                        SealComplete seal = new SealComplete();
                        seal.setClientOId(Long.valueOf(ADTO.getNextId()));
                        seal.setColor(color);
                        seal.setPredefinedNumber(Integer.valueOf(i));
                        seal.setSealNumber(Integer.valueOf(i));
                        seal.setType(type);
                        seal.setSequenceNumber(Integer.valueOf(i - startNo));
                        seal.setIdentifier(null);
                        seals.add(seal);
                    }
                }
                FlightSealsComplete fsc = (FlightSealsComplete)n.getValue();
                fsc.setSeals(seals);
            }
        }
        return null;
    }

    @Override
    public boolean hasExpandableContent() {
        if (this.table != null) {
            return !this.table.getRows().isEmpty();
        }
        return false;
    }

    @Override
    public void setNode(Node<?> node) {
        Node n = NodeToolkit.getAffixNamed((String)"SealedEQs");
        this.table.getModel().setNode((Node)this.generateSealList((Node<FlightSealsComplete>)n));
        this.isListEditable = false;
        if (node != null && node.getValue(FlightLight.class) != null) {
            switch (((FlightLight)node.getValue(FlightLight.class)).getFlightState()) {
                case CANCELLED: 
                case CLOSED: {
                    this.isListEditable = false;
                    this.table.showAddButton(false);
                    break;
                }
                case DISPATCHED: 
                case EN_ROUTE: 
                case OPEN: {
                    this.isListEditable = true;
                    this.table.showAddButton(true);
                    break;
                }
                case PLANNED: {
                    break;
                }
            }
        }
        super.setNode(node);
        this.setEnabled(this.isEnabled());
    }

    private int getSealCount() {
        Node n = NodeToolkit.getAffixNamed((String)"SealedEQs");
        int i = 0;
        if (n != null && n.getValue() != null && ((FlightSealsComplete)n.getValue()).getEquipments() != null) {
            for (EquipmentSealsComplete eq : ((FlightSealsComplete)n.getValue()).getEquipments()) {
                i += eq.getEquipment().getEquipmentType().getNumberOfSeals().intValue();
            }
        }
        return i;
    }

    private ViewNode getNewEmptyLine() {
        ViewNode node = new ViewNode("");
        Node n = NodeToolkit.getAffixNamed((String)"SealedEQs");
        ViewNode equs = new ViewNode("eqs");
        if (((CustomerLight)this.editor.getModel().getNode().getChildNamed(FlightLight_.customer).getValue()).getPredefineSealsForEquipments().booleanValue()) {
            for (EquipmentSealsComplete s : ((FlightSealsComplete)n.getValue()).getEquipments()) {
                int sealOnEQ = s.getEquipment().getEquipmentType().getNumberOfSeals();
                for (int i = 0; i < sealOnEQ; ++i) {
                    ViewNode eq = new ViewNode("aEq");
                    eq.setValue((Object)s, 0L);
                    ViewNode doorNo = new ViewNode("door");
                    doorNo.setValue((Object)i, 0L);
                    ViewNode preSealNo = new ViewNode("preSealNo");
                    eq.addChild((Node)doorNo, 0L);
                    eq.addChild((Node)preSealNo, 0L);
                    equs.addChild((Node)eq, 0L);
                }
            }
        }
        node.addChild((Node)equs, 0L);
        Node min = new Node();
        min.setName(DtoFieldConstants.START_NO);
        min.setValue((Object)-1, 0L);
        node.addChild(min, 0L);
        Node max = new Node();
        max.setName(DtoFieldConstants.SEAL_COUNT);
        max.setValue((Object)this.getSealCount(), 0L);
        node.addChild(max, 0L);
        DTOProxyNode t = new DTOProxyNode();
        t.setName(DtoFieldConstants.sealType);
        t.setValue((Object)SealTypeE.INBOUND, 0L);
        DTOProxyNode c = new DTOProxyNode();
        c.setName(DtoFieldConstants.sealColor);
        node.addChild((Node)t, 0L);
        node.addChild((Node)c, 0L);
        return node;
    }

    /*
     * WARNING - void declaration
     */
    private void processSeals(List<SealComplete> seals, SealTypeE type, ViewNode node) {
        HashMap map = new HashMap();
        for (SealComplete sealComplete : seals) {
            if (!map.containsKey(sealComplete.getColor())) {
                map.put(sealComplete.getColor(), new HashMap());
            }
            HashMap typeList = (HashMap)map.get(sealComplete.getColor());
            if (sealComplete.getType() == null) continue;
            if (!typeList.containsKey(sealComplete.getType())) {
                typeList.put(sealComplete.getType(), new ArrayList());
            }
            ((List)typeList.get(sealComplete.getType())).add(sealComplete);
        }
        for (Map.Entry entry : map.entrySet()) {
            ColorComplete sealColor = (ColorComplete)entry.getKey();
            for (Map.Entry typeEntry : ((HashMap)entry.getValue()).entrySet()) {
                SealTypeE sealType = (SealTypeE)typeEntry.getKey();
                List sealsFiltered = (List)typeEntry.getValue();
                HashSet h = new HashSet(sealsFiltered);
                sealsFiltered.clear();
                sealsFiltered.addAll(h);
                Collections.sort(sealsFiltered, (o1, o2) -> {
                    Integer sealNo1 = o1.getPredefinedNumber() != null ? o1.getPredefinedNumber() : o1.getSealNumber();
                    Integer sealNo2 = o2.getPredefinedNumber() != null ? o2.getPredefinedNumber() : o2.getSealNumber();
                    if (sealNo1 == null) {
                        return -1;
                    }
                    if (sealNo2 == null) {
                        return 1;
                    }
                    if (sealNo1.equals(sealNo2)) {
                        return 0;
                    }
                    return sealNo1.compareTo(sealNo2);
                });
                ArrayList newLists = new ArrayList();
                ArrayList<SealComplete> a = new ArrayList<SealComplete>();
                newLists.add(a);
                Integer lastNo = null;
                for (SealComplete sealComplete : sealsFiltered) {
                    void var18_23;
                    if (sealComplete.getPredefinedNumber() != null) {
                        Integer n = sealComplete.getPredefinedNumber();
                    } else {
                        Integer n = sealComplete.getSealNumber();
                    }
                    if (lastNo != null && lastNo + 1 != var18_23.intValue()) {
                        a = new ArrayList();
                        newLists.add(a);
                    }
                    a.add(sealComplete);
                    lastNo = var18_23;
                }
                SealTypeE setType = null;
                setType = type == null ? sealType : type;
                for (List list : newLists) {
                    ViewNode view = new ViewNode("eqs");
                    DTOProxyNode t = new DTOProxyNode((Object)setType);
                    t.setName(SealComplete_.type);
                    DTOProxyNode c = new DTOProxyNode((Object)sealColor);
                    c.setName(SealComplete_.color);
                    view.addChild((Node)t, 0L);
                    view.addChild((Node)c, 0L);
                    node.addChild((Node)view, 0L);
                    for (SealComplete s : list) {
                        Node max;
                        int sealNo = Integer.MAX_VALUE;
                        sealNo = s.getPredefinedNumber() != null ? s.getPredefinedNumber().intValue() : s.getSealNumber().intValue();
                        Node min = view.getChildNamed(DtoFieldConstants.START_NO);
                        if (min == null) {
                            min = new Node();
                            min.setName(DtoFieldConstants.START_NO);
                            min.setValue((Object)sealNo, 0L);
                            view.addChild(min, 0L);
                        }
                        if ((Integer)min.getValue() > sealNo) {
                            min.setValue((Object)sealNo, 0L);
                        }
                        if ((max = view.getChildNamed(DtoFieldConstants.SEAL_COUNT)) == null) {
                            max = new Node();
                            max.setName(DtoFieldConstants.SEAL_COUNT);
                            max.setValue((Object)0, 0L);
                            view.addChild(max, 0L);
                        }
                        max.setValue((Object)((Integer)max.getValue() + 1), 0L);
                    }
                }
            }
        }
    }

    private ViewNode generateSealList(Node<FlightSealsComplete> n) {
        ViewNode node = new ViewNode("Predefined Seals");
        if (n != null) {
            for (EquipmentSealsComplete eqSeal : ((FlightSealsComplete)n.getValue()).getEquipments()) {
                if (Boolean.TRUE.equals(eqSeal.getEquipment().getSealIsMandatory())) continue;
                for (SealTypeE type : eqSeal.getSeals().keySet()) {
                    List seal = (List)eqSeal.getSeals().get(type);
                    this.processSeals(seal, type, node);
                }
            }
            this.processSeals(((FlightSealsComplete)n.getValue()).getSeals(), null, node);
        }
        return node;
    }

    public void updateSeals(Node<FlightLight> node) {
        this.setNode(node);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    TextFieldListener,
    ItemListener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private RDComboBox sealType;
        private RDComboBox colorChooser;
        private RDTextField startNo;
        private Component count;
        private TextLabel end;
        private EditButton edit;
        private DeleteButton delete;
        private boolean isUnbound;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.isUnbound = false;
            this.sealType = new RDComboBox(SealDefinitionDetailsPanel.this.provider, ConverterRegistry.getConverter(SealTypeConverter.class));
            this.sealType.refreshPossibleValues(NodeToolkit.getAffixList(SealTypeE.class));
            this.sealType.setOverrideName(FlightAccess.SEAL_DEFINITION);
            this.sealType.setNode(m.getNode().getChildNamed(DtoFieldConstants.TYPE));
            this.sealType.addItemListener(this);
            this.colorChooser = new RDComboBox(SealDefinitionDetailsPanel.this.provider, ConverterRegistry.getConverter(ColorConverter.class));
            this.colorChooser.setOverrideName(FlightAccess.SEAL_DEFINITION);
            this.colorChooser.refreshPossibleValues(NodeToolkit.getAffixList(ColorComplete.class));
            this.colorChooser.setNode(m.getNode().getChildNamed(DtoFieldConstants.COLOR));
            this.startNo = new RDTextField(SealDefinitionDetailsPanel.this.provider, TextFieldType.INT);
            this.startNo.setOverrideName(FlightAccess.SEAL_DEFINITION);
            this.startNo.setNode(m.getNode().getChildNamed(DtoFieldConstants.START_NO));
            this.startNo.addTextFieldListener(this);
            this.end = new TextLabel();
            this.edit = new EditButton();
            this.delete = new DeleteButton();
            if (this.sealType.getEditor() != null) {
                this.itemStateChanged(new ItemEvent((ItemSelectable)this.sealType.getEditor(), 0, this.sealType.getNode(), 1));
            } else {
                this.checkUnboundState();
            }
            this.model.getNode().getChildNamed(DtoFieldConstants.START_NO).addNodeListener((NodeListener)this);
            this.model.getNode().getChildNamed(DtoFieldConstants.SEAL_COUNT).addNodeListener((NodeListener)this);
            this.updateEndText();
            this.edit.addButtonListener(this);
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.sealType);
            this.add(this.colorChooser);
            this.add(this.startNo);
            this.add(this.count);
            this.add(this.end);
            this.add(this.edit);
            this.add(this.delete);
        }

        private void checkUnboundState() {
            boolean ub;
            boolean bl = ub = this.isUnbound || ((CustomerLight)SealDefinitionDetailsPanel.this.editor.getModel().getNode().getChildNamed(FlightLight_.customer).getValue()).getPredefineSealsForEquipments() == false;
            if (ub) {
                if (!(this.count instanceof RDTextField)) {
                    if (this.count != null) {
                        ((Killable)((Object)this.count)).kill();
                    }
                    this.count = new RDTextField(SealDefinitionDetailsPanel.this.provider, TextFieldType.INT);
                    ((RDTextField)this.count).setOverrideName(FlightAccess.SEAL_DEFINITION);
                    ((RDTextField)this.count).setNode(this.model.getNode().getChildNamed(DtoFieldConstants.SEAL_COUNT));
                    this.add(this.count);
                }
            } else if (!(this.count instanceof TextLabel)) {
                if (this.count != null) {
                    ((Killable)((Object)this.count)).kill();
                }
                this.count = new TextLabel(this.model.getNode().getChildNamed(DtoFieldConstants.SEAL_COUNT), ConverterRegistry.getConverter(IntegerConverter.class));
                this.add(this.count);
            }
            this.setEnabled(this.isEnabled());
            this.revalidate();
        }

        public SealTypeE getType() {
            if (this.sealType.getSelectedItem() instanceof SealTypeE) {
                return (SealTypeE)this.sealType.getSelectedItem();
            }
            if (this.sealType.getSelectedItem() instanceof Node) {
                return (SealTypeE)((Node)this.sealType.getSelectedItem()).getValue();
            }
            return null;
        }

        public ColorComplete getSealColor() {
            if (this.colorChooser.getSelectedItem() instanceof ColorComplete) {
                return (ColorComplete)this.colorChooser.getSelectedItem();
            }
            if (this.colorChooser.getSelectedItem() instanceof Node) {
                return (ColorComplete)((Node)this.colorChooser.getSelectedItem()).getValue();
            }
            return null;
        }

        public Integer getStartSealNo() {
            return (Integer)this.model.getNode().getChildNamed(DtoFieldConstants.START_NO).getValue();
        }

        public Integer getSealCount() {
            return (Integer)this.model.getNode().getChildNamed(DtoFieldConstants.SEAL_COUNT).getValue();
        }

        public ArrayList<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.sealType);
            CheckedListAdder.addToList(focusList, this.colorChooser);
            CheckedListAdder.addToList(focusList, this.startNo);
            if (this.count instanceof Focusable) {
                CheckedListAdder.addToList(focusList, (Focusable)((Object)this.count));
            }
            CheckedListAdder.addToList(focusList, this.edit);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            boolean enabled = isEnabled && SealDefinitionDetailsPanel.this.isListEditable;
            this.sealType.setEnabled(enabled);
            this.colorChooser.setEnabled(enabled);
            this.startNo.setEnabled(enabled);
            this.count.setEnabled(enabled);
            this.end.setEnabled(enabled);
            boolean b = false;
            if (SealDefinitionDetailsPanel.this.editor.getModel().getNode() != null && SealDefinitionDetailsPanel.this.editor.getModel().getNode().getChildNamed(FlightLight_.customer) != null) {
                b = this.isUnbound || ((CustomerLight)SealDefinitionDetailsPanel.this.editor.getModel().getNode().getChildNamed(FlightLight_.customer).getValue()).getPredefineSealsForEquipments() == false;
                b = !b;
            }
            this.edit.setEnabled(enabled && b);
            this.delete.setEnabled(enabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.sealType.kill();
            this.sealType = null;
            this.colorChooser.kill();
            this.colorChooser = null;
            this.startNo.kill();
            this.startNo = null;
            this.end.kill();
            this.end = null;
            if (this.count instanceof Killable) {
                ((Killable)((Object)this.count)).kill();
            }
            this.count = null;
            this.edit.kill();
            this.edit = null;
            this.delete.kill();
            this.delete = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                SealDefinitionDetailsPanel.this.table.getModel().getNode().removeChild(this.model.getNode(), 0L);
            } else if (source == this.edit) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(source, true, true, Words.EQUIPMENT_SEALS);
                popUp.setView(new PredefineEquipmentSealPopup(this.model.getNode().getChildNamed(DtoFieldConstants.EQS)));
                popUp.showPopUp(x, y, 450, 300, null, source, PopupType.NORMAL);
            }
        }

        @Override
        public void valueChanged(AbstractTextField field) {
            if (((CustomerLight)SealDefinitionDetailsPanel.this.editor.getModel().getNode().getChildNamed(FlightLight_.customer).getValue()).getPredefineSealsForEquipments().booleanValue()) {
                String t = field.getText();
                int i = 0;
                try {
                    int u;
                    i = u = Integer.valueOf(t).intValue();
                }
                catch (NumberFormatException e) {
                    i = 0;
                }
                Iterator it = this.model.getNode().getChildNamed(DtoFieldConstants.EQS).getChilds();
                while (it.hasNext()) {
                    Node eq = (Node)it.next();
                    eq.getChildNamed(DtoFieldConstants.PRE_SEAL_NO).setValue((Object)i, 0L);
                    ++i;
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == this.sealType.getEditor() && e.getStateChange() == 1) {
                this.isUnbound = ((Node)this.sealType.getSelectedItem()).getValue() == SealTypeE.RESERVE || ((Node)this.sealType.getSelectedItem()).getValue() == SealTypeE.TRUCK;
                this.checkUnboundState();
            }
        }

        private void updateEndText() {
            this.end.setText("" + (this.getStartSealNo() + this.getSealCount() - 1));
        }

        public void valueChanged(Node<?> node) {
            this.updateEndText();
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.sealType.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.sealType.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.sealType.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.sealType.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.colorChooser.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.colorChooser.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.colorChooser.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.colorChooser.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.startNo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.startNo.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.startNo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.startNo.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.count.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.count.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.count.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.count.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.end.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.end.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.end.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.end.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.edit.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.edit.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.edit.setSize(TableRowImpl.this.edit.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(6);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

