/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flight.details;

import ch.icit.pegasus.client.converter.AMenuTypeConverter;
import ch.icit.pegasus.client.converter.CabinClassConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.DeliverySpaceConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.flight.details.utils.FlightProviderRule;
import ch.icit.pegasus.client.gui.modules.flight.utils.FlightEditableChecker;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.StartEndLegComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.toolkits.LegToolkit;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.AlaCarteMealOrderComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.SpecialMealOrderComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SpecialMealOrderComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.AMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SpecialMenusDetailsPanel
extends TableDetailsPanel<FlightLight>
implements LafListener {
    private static final long serialVersionUID = 1L;
    private Node<FlightComplete> root;
    private boolean isDeletable = true;
    private FlightEditableChecker checker = new FlightEditableChecker();
    private int currentIndex;

    public SpecialMenusDetailsPanel(RowEditor<FlightLight> editor, RDProvider provider) {
        super(editor, provider, true, true, true, true);
        this.setTitleText(Words.SPECIAL_MEALS);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int index = 0;
        int delWidth = CheckBox.getPreferredWidth() + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(Words.PREDEFINED, "", null, null, "", delWidth, delWidth, delWidth));
        ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        delWidth = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo(Words.LEG, "", null, null, "", 180, 180, 180));
        ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        columns.add(new TableColumnInfo(Words.CLASS, "", null, null, "", 125, 125, 125));
        ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        columns.add(new TableColumnInfo(Words.MEAL_CODE, "", null, null, "", 120, 120, 120));
        ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        columns.add(new TableColumnInfo(Words.SPACE, "", null, null, "", 270, 270, 270));
        ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        columns.add(new TableColumnInfo(Words.COUNT, "", null, null, "", 60, 60, 60));
        ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        columns.add(new TableColumnInfo(Words.PAX_NAME, "", null, null, "", 0, 0, 0));
        ((TableColumnInfo)columns.get(index++)).setxExpand(0.5);
        columns.add(new TableColumnInfo(Words.PAX_REMARK, "", null, null, "", 0, 0, 0));
        ((TableColumnInfo)columns.get(index++)).setxExpand(0.5);
        columns.add(new TableColumnInfo(Words.SEAT_NUMBER, "", null, null, "", 100, 100, 100));
        ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        columns.add(new TableColumnInfo("", "", null, null, "", delWidth += 2 * this.table.getCellPadding(), delWidth, delWidth));
        ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setProvider(this.provider);
        table.setComparator(new Comparator<TableRowImpl>(){

            @Override
            public int compare(TableRowImpl o1, TableRowImpl o2) {
                CabinClassComplete c2;
                FlightLegComplete l2;
                FlightLegComplete l1;
                int i;
                Node order1 = o1.getModel().getNode();
                Node order2 = o2.getModel().getNode();
                boolean firstWasNew = false;
                boolean secondWasNew = false;
                if (order1.getChildNamed(SpecialMealOrderComplete.ID_).getValue() == null) {
                    firstWasNew = true;
                }
                if (order2.getChildNamed(SpecialMealOrderComplete.ID_).getValue() == null) {
                    secondWasNew = true;
                }
                if (firstWasNew && secondWasNew) {
                    if (order1.getChildNamed(DtoFieldConstants.INSERT_INDEX) != null && order2.getChildNamed(DtoFieldConstants.INSERT_INDEX) != null) {
                        Integer t = (Integer)order1.getChildNamed(DtoFieldConstants.INSERT_INDEX).getValue();
                        Integer t2 = (Integer)order2.getChildNamed(DtoFieldConstants.INSERT_INDEX).getValue();
                        return t - t2;
                    }
                } else {
                    if (firstWasNew) {
                        return 1;
                    }
                    if (secondWasNew) {
                        return -1;
                    }
                }
                if (order1.getChildNamed(SpecialMealOrderComplete_.legs).getChildCount() > 0 && order2.getChildNamed(SpecialMealOrderComplete_.legs).getChildCount() > 0 && (i = (l1 = (FlightLegComplete)order1.getChildNamed(SpecialMealOrderComplete_.legs).getChildAt(0).getValue()).compareTo((ALegComplete)(l2 = (FlightLegComplete)order2.getChildNamed(SpecialMealOrderComplete_.legs).getChildAt(0).getValue()))) != 0) {
                    return i;
                }
                CabinClassComplete c1 = (CabinClassComplete)order1.getChildNamed(SpecialMealOrderComplete_.cabinClass).getValue();
                i = c1.compareTo(c2 = (CabinClassComplete)order2.getChildNamed(SpecialMealOrderComplete_.cabinClass).getValue());
                if (i != 0) {
                    return i;
                }
                SpecialMenuTypeComplete t1 = (SpecialMenuTypeComplete)order1.getChildNamed(SpecialMealOrderComplete_.menuType).getValue();
                SpecialMenuTypeComplete t2 = (SpecialMenuTypeComplete)order2.getChildNamed(SpecialMealOrderComplete_.menuType).getValue();
                i = t1.compareTo((AMenuTypeComplete)t2);
                return i;
            }
        });
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        SpecialMealOrderComplete newSpecialMeal = new SpecialMealOrderComplete();
        if (this.table.getRowCount() > 0) {
            Table2RowModel m = this.table.getRows().get(this.table.getRowCount() - 1).getModel();
            if (m.getNode().getChildNamed(SpecialMealOrderComplete_.count).getValue() != null) {
                newSpecialMeal.setCount((Integer)m.getNode().getChildNamed(SpecialMealOrderComplete_.count).getValue());
            } else {
                newSpecialMeal.setCount(Integer.valueOf(1));
            }
            if (m.getNode().getChildNamed(SpecialMealOrderComplete_.legs).getValue() != null) {
                Iterator it = m.getNode().getChildNamed(SpecialMealOrderComplete_.legs).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    newSpecialMeal.getLegs().add(n.getValue());
                }
            }
            newSpecialMeal.setCabinClass((CabinClassComplete)m.getNode().getChildNamed(SpecialMealOrderComplete_.cabinClass).getValue());
            newSpecialMeal.setMenuType((SpecialMenuTypeComplete)m.getNode().getChildNamed(SpecialMealOrderComplete_.menuType).getValue());
        } else {
            Node spmls;
            Node legNode;
            newSpecialMeal.setCount(Integer.valueOf(1));
            Node legs = legNode = this.root.getChildNamed(FlightComplete_.legs);
            Node l = LegToolkit.getFlightLegsWithoutDSorNS((Node)legs);
            if (l.getChildCount() > 0) {
                newSpecialMeal.getLegs().add((FlightLegComplete)l.getChildAt(0).getValue());
            }
            if ((spmls = NodeToolkit.getAffixNamed((String)"spmlCabinClasses")).getChildCount() > 0) {
                newSpecialMeal.setCabinClass((CabinClassComplete)spmls.getChildAt(0).getValue());
            }
        }
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)newSpecialMeal, true, false);
        Node insertIndex = new Node();
        insertIndex.setValue((Object)this.currentIndex++, 0L);
        insertIndex.setName(DtoFieldConstants.INSERT_INDEX);
        n.addChild(insertIndex, 0L);
        this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl rowPanel = new TableRowImpl(model);
        rowPanel.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return rowPanel;
    }

    private Node createPossibleCabinClassList() {
        return NodeToolkit.getAffixNamed((String)"spmlCabinClasses");
    }

    private Node createPossibleMenuList(CabinClassComplete cabinClass) {
        Node n = NodeToolkit.getAffixNamed((String)"spmlMenuTypes");
        Map types = (Map)n.getValue();
        List t = (List)types.get(cabinClass);
        Node list = INodeCreator.getDefaultImpl().createNodes(t, false);
        if (list == null) {
            return new Node();
        }
        return list;
    }

    @Override
    public boolean hasExpandableContent() {
        if (this.table != null) {
            return !this.table.getRows().isEmpty();
        }
        return false;
    }

    @Override
    public void setNode(Node<?> node) {
        if (this.provider.getAdditionalRule() == null) {
            this.provider.setAdditionalRule(new FlightProviderRule((FlightComplete)node.getValue(FlightComplete.class)));
        }
        this.isDeletable = this.provider.isDeletable(FlightComplete_.spmlOrders);
        this.root = node;
        if (this.root != null) {
            Node meals = this.root.getChildNamed(FlightComplete_.spmlOrders);
            this.table.getModel().setNode(meals);
        } else {
            this.table.getModel().setNode(null);
        }
        super.setNode(node);
    }

    @Override
    public void setValid(boolean b) {
        this.table.enableAddButton(b);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean b = this.checker.canEditFlight(this.root, this.provider, isEnabled);
        super.setEnabled(b);
    }

    @Override
    public void lafAttributeChanged(String att) {
        super.lafAttributeChanged(att);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.table.isWritable()) {
            boolean isValid = true;
            boolean areLegValid = true;
            boolean isClassValid = true;
            boolean isMenuValid = true;
            for (Table2RowPanel p : this.table.getRows()) {
                TableRowImpl r = (TableRowImpl)p;
                if (!r.isContentValid()) {
                    isValid = false;
                }
                if (!r.areLegsValid()) {
                    areLegValid = false;
                }
                if (!r.isClassValid()) {
                    isClassValid = false;
                }
                if (r.isMenuValid()) continue;
                isMenuValid = false;
            }
            if (!isValid) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.REVIEW_SPML_PAX_COUNT));
            }
            if (!areLegValid) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.REVIEW_SPML_LEGS));
            }
            if (!isClassValid) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.REVIEW_SPML_CABIN_CLASS));
            }
            if (!isMenuValid) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure a alaCarte Menu Type is set"));
            }
        }
        return validationObjects;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    public void updateInserts() {
        for (Table2RowPanel rowPanel : this.table.getRows()) {
            TableRowImpl rowPanelImpl = (TableRowImpl)rowPanel;
            rowPanelImpl.updateInserts();
        }
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements NodeListener,
    ButtonListener,
    LafListener,
    ItemListener {
        private static final long serialVersionUID = 1L;
        private StartEndLegComboBox legs;
        private CheckBox predefinedSkin;
        private RDComboBox mealCode;
        private RDComboBox cabinClass;
        private RDComboBox space;
        private RDTextField count;
        private RDTextField paxName;
        private RDTextField paxRemark;
        private RDTextField seatNumber;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new TableRowEditorLayout());
            if (SpecialMenusDetailsPanel.this.isDeletable) {
                this.delete = new DeleteButton();
                this.delete.addButtonListener(this);
                this.add(this.delete);
                this.delete.fadeIn();
            }
            this.predefinedSkin = new CheckBox((Node<Boolean>)this.model.getNode().getChildNamed(SpecialMealOrderComplete_.predefined));
            this.add(this.predefinedSkin);
            m.getNode().addNodeListener((NodeListener)this);
            this.childAdded(m.getNode(), m.getNode().getChildNamed(SpecialMealOrderComplete_.legs));
            this.childAdded(m.getNode(), m.getNode().getChildNamed(SpecialMealOrderComplete_.menuType));
            this.childAdded(m.getNode(), m.getNode().getChildNamed(SpecialMealOrderComplete_.count));
            this.childAdded(m.getNode(), m.getNode().getChildNamed(SpecialMealOrderComplete_.cabinClass));
            this.childAdded(m.getNode(), m.getNode().getChildNamed(SpecialMealOrderComplete_.paxName));
            this.childAdded(m.getNode(), m.getNode().getChildNamed(SpecialMealOrderComplete_.paxRemark));
            this.childAdded(m.getNode(), m.getNode().getChildNamed(SpecialMealOrderComplete_.seatNumber));
            this.childAdded(m.getNode(), m.getNode().getChildNamed(SpecialMealOrderComplete_.stowingPosition));
            m.getNode().getChildNamed(SpecialMealOrderComplete_.menuType).addNodeListener((NodeListener)this);
            this.lafAttributeChanged("All attribues changed");
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 1: {
                    return this.legs.createShownString((Node)null);
                }
                case 2: {
                    return this.cabinClass.getStringValue();
                }
                case 3: {
                    return this.mealCode.getStringValue();
                }
                case 5: {
                    return this.count.getText();
                }
                case 6: {
                    return this.paxName.getText();
                }
                case 7: {
                    return this.paxRemark.getText();
                }
                case 8: {
                    return this.seatNumber.getText();
                }
            }
            return null;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.legs.requestFocusInWindowNow();
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.predefinedSkin);
            CheckedListAdder.addToList(a, this.legs);
            CheckedListAdder.addToList(a, this.cabinClass);
            CheckedListAdder.addToList(a, this.mealCode);
            CheckedListAdder.addToList(a, this.space);
            CheckedListAdder.addToList(a, this.count);
            CheckedListAdder.addToList(a, this.paxName);
            CheckedListAdder.addToList(a, this.paxRemark);
            CheckedListAdder.addToList(a, this.seatNumber);
            if (this.delete != null) {
                CheckedListAdder.addToList(a, this.delete);
            }
            return a;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            if (this.predefinedSkin != null) {
                this.predefinedSkin.setEnabled(false);
            }
            this.legs.setEnabled(isEnabled);
            this.cabinClass.setEnabled(isEnabled);
            this.mealCode.setEnabled(isEnabled);
            Node n = this.model.getNode().getChildNamed(SpecialMealOrderComplete_.menuType);
            boolean isAdditional = false;
            if (n != null && n.getValue() != null && ((SpecialMenuTypeComplete)n.getValue()).getAdditional().booleanValue()) {
                isAdditional = true;
            }
            this.space.setEnabled(isEnabled && isAdditional);
            this.count.setEnabled(isEnabled);
            this.paxName.setEnabled(isEnabled);
            this.paxRemark.setEnabled(isEnabled);
            this.seatNumber.setEnabled(isEnabled);
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.model.getNode().getChildNamed(SpecialMealOrderComplete_.menuType).removeNodeListener((NodeListener)this);
            if (this.predefinedSkin != null) {
                this.predefinedSkin.kill();
            }
            this.legs.kill();
            this.cabinClass.kill();
            this.mealCode.kill();
            this.space.kill();
            this.count.kill();
            this.paxName.kill();
            this.paxRemark.kill();
            this.seatNumber.kill();
            if (this.delete != null) {
                this.delete.kill();
            }
            this.legs = null;
            this.mealCode = null;
            this.count = null;
            this.cabinClass = null;
            this.space = null;
            this.paxName = null;
            this.paxRemark = null;
            this.seatNumber = null;
            this.delete = null;
            this.predefinedSkin = null;
        }

        public void childAdded(Node<?> source, Node<?> child) {
            if (child.getName().equals(SpecialMealOrderComplete_.legs.getFieldName())) {
                Node<?> legNode = child;
                this.legs = new StartEndLegComboBox(legNode, SpecialMenusDetailsPanel.this.editor.getModel().getNode().getChildNamed(FlightLight_.legs)){

                    @Override
                    public Node<?> createSelectableList() {
                        Node<?> n = super.createSelectableList();
                        return LegToolkit.getFlightLegsWithoutDSorNS(n);
                    }
                };
                this.add(this.legs);
                this.legs.fadeIn();
            } else if (child.getName().equals(SpecialMealOrderComplete_.menuType.getFieldName())) {
                CabinClassComplete c = (CabinClassComplete)this.model.getNode().getChildNamed(AlaCarteMealOrderComplete_.cabinClass).getValue();
                Node possibleValuesLogicNode = SpecialMenusDetailsPanel.this.createPossibleMenuList(c);
                Node<?> node = child;
                AMenuTypeConverter viewConverter = (AMenuTypeConverter)ConverterRegistry.getConverter(AMenuTypeConverter.class);
                if (node.getValue() == null && possibleValuesLogicNode.getChildCount() > 0) {
                    node.setValue(possibleValuesLogicNode.getChildAt(0).getValue(), 0L);
                }
                this.mealCode = new RDComboBox(SpecialMenusDetailsPanel.this.provider, (Converter)viewConverter);
                this.mealCode.refreshPossibleValues(possibleValuesLogicNode);
                this.mealCode.setNode(node);
                this.add(this.mealCode);
                this.mealCode.fadeIn();
            } else if (child.getName().equals(SpecialMealOrderComplete_.stowingPosition.getFieldName())) {
                Node possibleValuesLogicNode = NodeToolkit.getAffixNamed((String)((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getAffixNameForClass(SpecialMealOrderComplete.class));
                Node<?> node = child;
                DeliverySpaceConverter viewConverter = (DeliverySpaceConverter)ConverterRegistry.getConverter(DeliverySpaceConverter.class);
                this.space = new RDComboBox(SpecialMenusDetailsPanel.this.provider, (Converter)viewConverter);
                this.space.refreshPossibleValues(possibleValuesLogicNode);
                this.space.setNode(node);
                this.add(this.space);
                this.space.fadeIn();
            } else if (child.getName().equals(SpecialMealOrderComplete_.count.getFieldName())) {
                this.count = new RDTextField(SpecialMenusDetailsPanel.this.provider, TextFieldType.INT);
                this.count.setNode(child);
                this.add(this.count);
                this.count.fadeIn();
            } else if (child.getName().equals(SpecialMealOrderComplete_.cabinClass.getFieldName())) {
                Node<?> node = child;
                CabinClassConverter viewConverter = (CabinClassConverter)ConverterRegistry.getConverter(CabinClassConverter.class);
                this.cabinClass = new RDComboBox(SpecialMenusDetailsPanel.this.provider, (Converter)viewConverter);
                this.cabinClass.refreshPossibleValues(SpecialMenusDetailsPanel.this.createPossibleCabinClassList());
                if (node.getParent() != null) {
                    SpecialMealOrderComplete o = (SpecialMealOrderComplete)node.getParent().getValue();
                    Node<?> n = node;
                    n.setValueSilent((Object)o.getCabinClass(), true, 0L, null);
                }
                this.cabinClass.setNode(node);
                if (this.cabinClass.getEditor() != null) {
                    ((ComboBox)this.cabinClass.getEditor()).addItemListener(this);
                }
                this.add(this.cabinClass);
                this.cabinClass.fadeIn();
            } else if (child.getName().equals(SpecialMealOrderComplete_.paxName.getFieldName())) {
                this.paxName = new RDTextField(SpecialMenusDetailsPanel.this.provider);
                this.paxName.setNode(child);
                this.add(this.paxName);
                this.paxName.fadeIn();
            } else if (child.getName().equals(SpecialMealOrderComplete_.paxRemark.getFieldName())) {
                this.paxRemark = new RDTextField(SpecialMenusDetailsPanel.this.provider);
                this.paxRemark.setNode(child);
                this.add(this.paxRemark);
                this.paxRemark.fadeIn();
            } else if (child.getName().equals(SpecialMealOrderComplete_.seatNumber.getFieldName())) {
                this.seatNumber = new RDTextField(SpecialMenusDetailsPanel.this.provider);
                this.seatNumber.setNode(child);
                this.add(this.seatNumber);
                this.seatNumber.fadeIn();
            }
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void valueChanged(Node<?> node) {
            if (!this.isKilled()) {
                this.setEnabled(this.isEnabled());
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            this.model.getParentModel().getNode().removeChild(this.model.getNode(), System.currentTimeMillis());
        }

        @Override
        public void lafAttributeChanged(String att) {
            Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
            if (this.count != null) {
                this.count.setFont(f);
            }
            if (this.paxName != null) {
                this.paxName.setFont(f);
            }
            if (this.paxRemark != null) {
                this.paxRemark.setFont(f);
            }
            if (this.seatNumber != null) {
                this.seatNumber.setFont(f);
            }
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isContentValid() {
            Integer i = (Integer)this.model.getNode().getChildNamed(SpecialMealOrderComplete_.count).getValue();
            if (i != null && i > 0) {
                return true;
            }
            this.count.setInvalid();
            return false;
        }

        public boolean areLegsValid() {
            if (this.model.getNode() == null) {
                return false;
            }
            Node spmlLegs = this.model.getNode().getChildNamed(SpecialMealOrderComplete_.legs);
            if (spmlLegs == null) {
                return false;
            }
            Node flightLeg = SpecialMenusDetailsPanel.this.editor.getModel().getNode().getChildNamed(FlightLight_.legs);
            if (flightLeg == null) {
                return false;
            }
            boolean b = spmlLegs.getChildCount() > 0;
            Iterator it = spmlLegs.getFailSafeChildIterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                boolean foundLeg = false;
                Iterator it2 = flightLeg.getFailSafeChildIterator();
                while (it2.hasNext()) {
                    Node n2 = (Node)it2.next();
                    if (!((FlightLegComplete)n2.getValue()).equals(n.getValue())) continue;
                    foundLeg = true;
                }
                if (foundLeg) continue;
                b = false;
            }
            if (!b) {
                this.legs.setInvalid();
            }
            return b;
        }

        public boolean isClassValid() {
            CabinClassComplete cc = (CabinClassComplete)this.model.getNode().getChildNamed(SpecialMealOrderComplete_.cabinClass).getValue(CabinClassComplete.class);
            if (cc == null) {
                this.cabinClass.setInvalid();
            }
            return cc != null;
        }

        public boolean isMenuValid() {
            SpecialMenuTypeComplete menuType = (SpecialMenuTypeComplete)this.model.getNode().getChildNamed(SpecialMealOrderComplete_.menuType).getValue(SpecialMenuTypeComplete.class);
            if (menuType == null) {
                this.mealCode.setInvalid();
            }
            return menuType != null;
        }

        public boolean isSwingOnly() {
            return true;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1 && this.cabinClass.getEditor() != null && ((ComboBox)this.cabinClass.getEditor()).getSelectedItem() != null) {
                CabinClassComplete c = (CabinClassComplete)((Node)((ComboBox)this.cabinClass.getEditor()).getSelectedItem()).getValue();
                Node possibleValuesLogicNode = SpecialMenusDetailsPanel.this.createPossibleMenuList(c);
                this.mealCode.refreshPossibleValues(possibleValuesLogicNode);
            }
        }

        public void updateInserts() {
            if (this.space != null) {
                Node possibleValuesLogicNode = NodeToolkit.getAffixNamed((String)((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getAffixNameForClass(SpecialMealOrderComplete.class));
                this.space.refreshPossibleValues(possibleValuesLogicNode);
            }
        }

        private class TableRowEditorLayout
        extends DefaultLayout {
            private TableRowEditorLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int h = parent.getHeight();
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int index = 0;
                if (TableRowImpl.this.predefinedSkin != null) {
                    TableRowImpl.this.predefinedSkin.setLocation((int)(((double)w - TableRowImpl.this.predefinedSkin.getPreferredSize().getWidth()) / 2.0), (int)(((double)h - TableRowImpl.this.predefinedSkin.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.predefinedSkin.setSize(w - 2 * TableRowImpl.this.cellPadding, (int)TableRowImpl.this.predefinedSkin.getPreferredSize().getHeight());
                    index = 1;
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                } else {
                    currentX = 0;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                }
                TableRowImpl.this.legs.setLocation(currentX + TableRowImpl.this.cellPadding, (int)(((double)h - TableRowImpl.this.legs.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.legs.setSize(w - 2 * TableRowImpl.this.cellPadding, (int)TableRowImpl.this.legs.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.cabinClass.setLocation(currentX + TableRowImpl.this.cellPadding, (int)(((double)h - TableRowImpl.this.cabinClass.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.cabinClass.setSize(w - 2 * TableRowImpl.this.cellPadding, (int)TableRowImpl.this.cabinClass.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.mealCode.setLocation(currentX + TableRowImpl.this.cellPadding, (int)(((double)h - TableRowImpl.this.mealCode.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.mealCode.setSize(w - 2 * TableRowImpl.this.cellPadding, (int)TableRowImpl.this.mealCode.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.space.setLocation(currentX + TableRowImpl.this.cellPadding, (int)(((double)h - TableRowImpl.this.space.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.space.setSize(w - 2 * TableRowImpl.this.cellPadding, (int)TableRowImpl.this.space.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.count.setLocation(currentX + TableRowImpl.this.cellPadding, (int)(((double)h - TableRowImpl.this.count.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.count.setSize(w - 2 * TableRowImpl.this.cellPadding, (int)TableRowImpl.this.count.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.paxName.setLocation(currentX + TableRowImpl.this.cellPadding, (int)(((double)h - TableRowImpl.this.paxName.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.paxName.setSize(w - 2 * TableRowImpl.this.cellPadding, (int)TableRowImpl.this.paxName.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.paxRemark.setLocation(currentX + TableRowImpl.this.cellPadding, (int)(((double)h - TableRowImpl.this.paxRemark.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.paxRemark.setSize(w - 2 * TableRowImpl.this.cellPadding, (int)TableRowImpl.this.paxRemark.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.seatNumber.setLocation(currentX + TableRowImpl.this.cellPadding, (int)(((double)h - TableRowImpl.this.seatNumber.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.seatNumber.setSize(w - 2 * TableRowImpl.this.cellPadding, (int)TableRowImpl.this.seatNumber.getPreferredSize().getHeight());
                TableRowImpl.this.setControlsX(currentX += w);
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation((int)((double)currentX + ((double)w - TableRowImpl.this.delete.getPreferredSize().getWidth()) / 2.0), (int)(((double)h - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(w - 2 * TableRowImpl.this.cellPadding, (int)TableRowImpl.this.delete.getPreferredSize().getHeight());
                }
                currentX += w;
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }
}

