/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flight.details;

import ch.icit.pegasus.client.gui.modules.flight.details.utils.FlightProviderRule;
import ch.icit.pegasus.client.gui.modules.flight.utils.FlightEditableChecker;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextArea;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.restaurant.RestaurantComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemViewSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class TimeDetailsPanel
extends DefaultDetailsPanel<FlightLight> {
    private static final long serialVersionUID = 1L;
    private Node<FlightComplete> root;
    private final FlightEditableChecker checker = new FlightEditableChecker();
    private TitledItem<DateChooser> deliveryDate;
    private TitledItem<RDSearchTextField2<RestaurantComplete>> restaurantSearch;
    private TitledItem<RDTextArea> productionComment;
    private TitledItem<RDTextArea> invoiceComment;
    private TitledItem<RDCheckBox> useFlightDiscount;
    private TitledItem<RDTextField> flightDiscount;

    public TimeDetailsPanel(RowEditor<FlightLight> editor, RDProvider provider) {
        this(editor, provider, false, false);
    }

    public TimeDetailsPanel(RowEditor<FlightLight> editor, RDProvider provider, boolean showCrewComment, boolean showInvoiceComment) {
        super(editor, provider);
        SystemViewSettingsComplete settings;
        this.setTitleText(Words.DETAILS);
        this.deliveryDate = new TitledItem<DateChooser>(new DateChooser(null), Words.DELIVERY_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.restaurantSearch = new TitledItem(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.RESTAURANT), "Restaurant", TitledItem.TitledItemOrientation.NORTH);
        if (showCrewComment) {
            this.productionComment = new TitledItem<RDTextArea>(new RDTextArea(provider), "Comment", TitledItem.TitledItemOrientation.NORTH);
            this.productionComment.setIgnorePrefHeight(true);
        }
        if (showInvoiceComment) {
            this.invoiceComment = new TitledItem<RDTextArea>(new RDTextArea(provider), "Invoice Comment", TitledItem.TitledItemOrientation.NORTH);
            this.invoiceComment.setIgnorePrefHeight(true);
        }
        if (Boolean.TRUE.equals((settings = (SystemViewSettingsComplete)NodeToolkit.getAffixClass(SystemViewSettingsComplete.class).getValue()).getShowFlightDiscount())) {
            this.useFlightDiscount = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "Use Discount", TitledItem.TitledItemOrientation.NORTH);
            this.flightDiscount = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.DOUBLE), "Discount [%]", TitledItem.TitledItemOrientation.NORTH);
            this.useFlightDiscount.getElement().addButtonListener((source, x, y) -> this.setEnabled(this.isEnabled()));
        }
        this.setCustomLayouter(new Layout());
        this.addToView(this.restaurantSearch);
        this.addToView(this.deliveryDate);
        if (this.productionComment != null) {
            this.addToView(this.productionComment);
        }
        if (this.invoiceComment != null) {
            this.addToView(this.invoiceComment);
        }
        if (this.flightDiscount != null) {
            this.addToView(this.useFlightDiscount);
            this.addToView(this.flightDiscount);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        this.setEnabled(this.isEnabled());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean enabled = this.checker.canEditFlight(this.root, this.provider, isEnabled);
        super.setEnabled(enabled);
        this.deliveryDate.setEnabled(isEnabled);
        this.restaurantSearch.setEnabled(isEnabled);
        if (this.useFlightDiscount != null) {
            this.useFlightDiscount.setEnabled(enabled);
            this.flightDiscount.setEnabled(enabled && this.useFlightDiscount.getElement().isChecked());
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.deliveryDate.kill();
        this.deliveryDate = null;
        if (this.useFlightDiscount != null) {
            this.useFlightDiscount.kill();
            this.flightDiscount.kill();
        }
        this.restaurantSearch.kill();
        this.restaurantSearch = null;
        if (this.productionComment != null) {
            this.productionComment.kill();
        }
        if (this.invoiceComment != null) {
            this.invoiceComment.kill();
        }
        this.productionComment = null;
        this.invoiceComment = null;
        this.useFlightDiscount = null;
        this.flightDiscount = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.deliveryDate);
        CheckedListAdder.addToList(focusList, this.restaurantSearch);
        CheckedListAdder.addToList(focusList, this.useFlightDiscount);
        CheckedListAdder.addToList(focusList, this.flightDiscount);
        return focusList;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.root = node;
        FlightComplete flight = (FlightComplete)node.getValue(FlightComplete.class);
        if (this.provider.getAdditionalRule() == null) {
            this.provider.setAdditionalRule(new FlightProviderRule(flight));
        }
        if (node.getChildNamed(FlightComplete_.deliveryDate).getValue() == null) {
            node.getChildNamed(FlightComplete_.deliveryDate).setValue((Object)new Timestamp(flight.getStd().getTime()), 0L);
        }
        this.deliveryDate.getElement().setNode(node.getChildNamed(FlightComplete_.deliveryDate));
        this.restaurantSearch.getElement().setNode(node.getChildNamed(FlightComplete_.restaurant));
        this.productionComment.getElement().setNode(node.getChildNamed(FlightComplete_.crewRemark));
        this.invoiceComment.getElement().setNode(node.getChildNamed(FlightComplete_.invoiceRemark));
        if (this.useFlightDiscount != null) {
            this.useFlightDiscount.getElement().setNode(node.getChildNamed(FlightComplete_.useDiscount));
            this.flightDiscount.getElement().setNode(node.getChildNamed(FlightComplete_.discount));
        }
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        Timestamp stdD = CalendarUtil.getTimestamp((Node)this.deliveryDate.getElement().getNode());
        this.editor.getModel().getNode().getChildNamed(FlightComplete_.deliveryDate).setValue((Object)stdD, 0L);
        this.editor.getModel().getNode().getChildNamed(FlightComplete_.deliveryDate).commit();
        this.editor.getModel().getNode().getChildNamed(FlightComplete_.std).setValue((Object)stdD, 0L);
        this.editor.getModel().getNode().getChildNamed(FlightComplete_.std).commit();
        this.editor.getModel().getNode().getChildNamed(FlightComplete_.realstd).setValue((Object)stdD, 0L);
        this.editor.getModel().getNode().getChildNamed(FlightComplete_.realstd).commit();
        return super.commitParagraph();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = TimeDetailsPanel.this.verticalBorder;
            h += TimeDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + TimeDetailsPanel.this.deliveryDate.getPreferredSize().getHeight());
            h += TimeDetailsPanel.this.verticalBorder;
            h = (int)((double)h + TimeDetailsPanel.this.restaurantSearch.getPreferredSize().getHeight());
            h += TimeDetailsPanel.this.verticalBorder;
            if (TimeDetailsPanel.this.productionComment != null) {
                h += 100;
                h += TimeDetailsPanel.this.verticalBorder;
            }
            if (TimeDetailsPanel.this.invoiceComment != null) {
                h += 100;
                h += TimeDetailsPanel.this.verticalBorder;
            }
            if (TimeDetailsPanel.this.useFlightDiscount != null) {
                h = (int)((double)h + TimeDetailsPanel.this.flightDiscount.getPreferredSize().getHeight());
                h += TimeDetailsPanel.this.verticalBorder;
            }
            return new Dimension(200, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            TimeDetailsPanel.this.deliveryDate.setLocation(TimeDetailsPanel.this.horizontalBorder, TimeDetailsPanel.this.verticalBorder);
            TimeDetailsPanel.this.deliveryDate.setSize(TimeDetailsPanel.this.deliveryDate.getPreferredSize());
            TimeDetailsPanel.this.restaurantSearch.setLocation(TimeDetailsPanel.this.horizontalBorder, TimeDetailsPanel.this.deliveryDate.getY() + TimeDetailsPanel.this.deliveryDate.getHeight() + TimeDetailsPanel.this.verticalBorder);
            TimeDetailsPanel.this.restaurantSearch.setSize(parent.getWidth() - 2 * TimeDetailsPanel.this.horizontalBorder, (int)TimeDetailsPanel.this.restaurantSearch.getPreferredSize().getHeight());
            int cy = TimeDetailsPanel.this.restaurantSearch.getY() + TimeDetailsPanel.this.restaurantSearch.getHeight() + TimeDetailsPanel.this.verticalBorder;
            if (TimeDetailsPanel.this.productionComment != null) {
                TimeDetailsPanel.this.productionComment.setLocation(TimeDetailsPanel.this.horizontalBorder, cy);
                TimeDetailsPanel.this.productionComment.setSize(parent.getWidth() - 2 * TimeDetailsPanel.this.horizontalBorder, 100);
                cy = TimeDetailsPanel.this.productionComment.getY() + TimeDetailsPanel.this.productionComment.getHeight() + TimeDetailsPanel.this.verticalBorder;
            }
            if (TimeDetailsPanel.this.invoiceComment != null) {
                TimeDetailsPanel.this.invoiceComment.setLocation(TimeDetailsPanel.this.horizontalBorder, cy);
                TimeDetailsPanel.this.invoiceComment.setSize(parent.getWidth() - 2 * TimeDetailsPanel.this.horizontalBorder, 100);
                cy = TimeDetailsPanel.this.invoiceComment.getY() + TimeDetailsPanel.this.invoiceComment.getHeight() + TimeDetailsPanel.this.verticalBorder;
            }
            if (TimeDetailsPanel.this.useFlightDiscount != null) {
                TimeDetailsPanel.this.useFlightDiscount.setLocation(TimeDetailsPanel.this.horizontalBorder, (int)((double)parent.getHeight() - ((double)TimeDetailsPanel.this.verticalBorder + TimeDetailsPanel.this.flightDiscount.getPreferredSize().getHeight())));
                TimeDetailsPanel.this.useFlightDiscount.setSize(TimeDetailsPanel.this.useFlightDiscount.getPreferredSize());
                TimeDetailsPanel.this.flightDiscount.setLocation(TimeDetailsPanel.this.useFlightDiscount.getX() + TimeDetailsPanel.this.useFlightDiscount.getWidth() + TimeDetailsPanel.this.inner_horizontalBorder, TimeDetailsPanel.this.useFlightDiscount.getY());
                TimeDetailsPanel.this.flightDiscount.setSize(150, (int)TimeDetailsPanel.this.flightDiscount.getPreferredSize().getHeight());
            }
        }
    }
}

