/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flight.details.utils;

import ch.icit.pegasus.client.gui.modules.flightschedule.details.utils.HandlingCostTable;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.RemarkButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.toolkits.HandlingCostToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.handlingcost.FlightHandlingCostConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.FlightHandlingCostConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class FlightHandlingCostTable
extends HandlingCostTable<FlightComplete> {
    private static final long serialVersionUID = 1L;

    public FlightHandlingCostTable(RDProvider provider, boolean withTitle) {
        super(provider, withTitle, false, null);
    }

    @Override
    public DtoField[] getAttributeName() {
        return new DtoField[]{FlightComplete_.flightHandlingCostConfiguration};
    }

    @Override
    public Table2RowPanel getRowPanel(Table2RowModel model) {
        return new TableRowImpl(model);
    }

    @Override
    public List<ScreenValidationObject> validateTable(boolean withText) {
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        if (this.getTable().isWritable()) {
            boolean valid = true;
            HashSet<HandlingCostComplete> handlingCost = new HashSet<HandlingCostComplete>();
            for (Table2RowPanel p : this.getTable().getRows()) {
                TableRowImpl pp = (TableRowImpl)p;
                if (!pp.isElementSet()) {
                    valid = false;
                    pp.setInValid();
                }
                if (handlingCost.add((HandlingCostComplete)p.getModel().getNode().getChildNamed(FlightHandlingCostConfigurationComplete_.handlingCost).getValue())) continue;
                valid = false;
                pp.setInValid();
            }
            if (!valid && withText) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.REVIEW_HANDLING_COST_SET_AND_UNIQUE));
            }
        }
        return o;
    }

    @Override
    public void addButtonPressed() {
        FlightHandlingCostConfigurationComplete c = new FlightHandlingCostConfigurationComplete();
        c.setAmount(Integer.valueOf(1));
        c.setClientOId(Long.valueOf(ADTO.getNextId()));
        c.setFlight((FlightReference)this.node.getValue(FlightLight.class));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)c, true, false);
        this.node.getChildNamed(this.getAttributeName()).addChild(n, System.currentTimeMillis());
        this.revalidate();
        this.getParent().validate();
    }

    @Override
    public List<TableColumnInfo> getColumns() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.TYPE, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(WordsToolkit.toUpperCase((String)Words.COUNT), null, null, null, "", 120, 120, 120));
        int tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) * 3 + 2 * this.getTable().getInnerCellPadding() + 2 * this.getTable().getCellPadding();
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        return columns;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    NodeListener,
    InnerPopUpListener2 {
        private static final long serialVersionUID = 1L;
        private RDSearchComboBox name;
        private RDTextField count;
        private EditButton edit;
        private DeleteButton delete;
        private InfoButton infoButton;
        private final boolean isPriceEditable;
        private RemarkButton remarkButton;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.isPriceEditable = m.getParentModel().getTable().getProvider().isWritable("editHandlingPrice");
            this.name = new RDSearchComboBox(m.getParentModel().getTable().getProvider(), RDSearchComboBox.BoxSearchTypes.HANDLINGCOST);
            this.name.setOverrideName("flightHandlingCostConfiguration");
            this.name.setNode(m.getNode().getChildNamed(FlightHandlingCostConfigurationComplete_.handlingCost));
            if (this.name.getEditor() != null) {
                Object[] o = new Object[]{FlightHandlingCostTable.this.customer, false};
                ((SearchComboBox)this.name.getEditor()).setAdditionalSearchField(o);
            }
            this.name.setProgress(1.0f);
            this.infoButton = new InfoButton(Words.HANDLING_COST_INFO);
            this.infoButton.installStringViewer(HandlingCostToolkit.getHandlingCostInfoString((HandlingCostComplete)this.model.getNode().getChildNamed(FlightHandlingCostConfigurationComplete_.handlingCost).getValue(), (PriceComplete)this.model.getNode().getChildNamed(FlightHandlingCostConfigurationComplete_.specialPrice).getValue()));
            this.setLayout(new InnerLayout());
            if (m.getParentModel().getTable().getProvider() == null || m.getParentModel().getTable().getProvider().isDeletable("flightHandlingCostConfiguration")) {
                this.delete = new DeleteButton();
                this.delete.addButtonListener(this);
                this.add(this.delete);
            }
            this.remarkButton = new RemarkButton(false);
            this.remarkButton.addButtonListener(this);
            this.edit = new EditButton();
            if (this.isPriceEditable) {
                this.edit.addButtonListener(this);
            }
            this.add(this.edit);
            this.count = new RDTextField(m.getParentModel().getTable().getProvider(), TextFieldType.INT);
            this.count.setOverrideName("flightHandlingCostConfiguration");
            this.count.setNode(m.getNode().getChildNamed(FlightHandlingCostConfigurationComplete_.amount));
            this.model.getNode().getChildNamed(FlightHandlingCostConfigurationComplete_.handlingCost).addNodeListener((NodeListener)this);
            this.add(this.name);
            this.add(this.infoButton);
            this.add(this.count);
            this.add(this.remarkButton);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.name.getText();
                }
            }
            return null;
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.name != null) {
                this.name.requestFocusInWindowNow();
            }
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.name.setEnabled(isEnabled);
            this.count.setEnabled(isEnabled);
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled);
            }
            this.infoButton.setEnabled(isEnabled);
            boolean editable = this.model.getParentModel().getTable().getProvider().isWritable("flightHandlingCostConfiguration");
            this.edit.setEnabled(this.isPriceEditable && isEnabled);
            this.remarkButton.setEnabled(isEnabled && editable);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.name);
            CheckedListAdder.addToList(a, this.count);
            CheckedListAdder.addToList(a, this.edit);
            CheckedListAdder.addToList(a, this.remarkButton);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.name.kill();
            this.name = null;
            this.infoButton.kill();
            this.infoButton = null;
            this.count.kill();
            this.count = null;
            if (this.edit != null) {
                this.edit.kill();
            }
            this.edit = null;
            if (this.remarkButton != null) {
                this.remarkButton.kill();
            }
            this.remarkButton = null;
            if (this.delete != null) {
                this.delete.kill();
            }
            this.delete = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (this.delete == source) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            } else if (this.edit == source) {
                if (this.name.isItemSelected()) {
                    InnerPopUp2 innerPopUp2 = InnerPopupFactory.showSpecialPricePopup(source, this.model.getNode(), x, y, this, false, this.isPriceEditable, false);
                }
            } else if (this.remarkButton == source) {
                InnerPopupFactory.showEnterMessagePopup(Words.HANDLING_COST_REMARK, null, this.remarkButton, this.model.getNode().getChildNamed(FlightHandlingCostConfigurationComplete_.remark), x, y);
            }
        }

        public boolean isElementSet() {
            if (this.model.getNode() != null && this.model.getNode().getChildNamed(FlightHandlingCostConfigurationComplete_.handlingCost) != null) {
                return this.model.getNode().getChildNamed(FlightHandlingCostConfigurationComplete_.handlingCost).getValue() != null;
            }
            return false;
        }

        public void setInValid() {
            this.name.setInvalid();
        }

        public void valueChanged(Node<?> node) {
            if (this.infoButton != null) {
                this.infoButton.installStringViewer(HandlingCostToolkit.getHandlingCostInfoString((HandlingCostComplete)this.model.getNode().getChildNamed(FlightHandlingCostConfigurationComplete_.handlingCost).getValue(), (PriceComplete)this.model.getNode().getChildNamed(FlightHandlingCostConfigurationComplete_.specialPrice).getValue()));
            }
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        @Override
        public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
            this.valueChanged(null);
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize((int)((double)w - ((double)(3 * TableRowImpl.this.getCellPadding()) + TableRowImpl.this.infoButton.getPreferredSize().getWidth())), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                TableRowImpl.this.infoButton.setLocation(TableRowImpl.this.name.getX() + TableRowImpl.this.name.getWidth() + FlightHandlingCostTable.this.getTable().getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.infoButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.infoButton.setSize(TableRowImpl.this.infoButton.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                TableRowImpl.this.count.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.count.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.count.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.count.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(2);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.edit.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.edit.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.edit.setSize(TableRowImpl.this.edit.getPreferredSize());
                TableRowImpl.this.remarkButton.setLocation(TableRowImpl.this.edit.getX() + TableRowImpl.this.edit.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.remarkButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.remarkButton.setSize(TableRowImpl.this.remarkButton.getPreferredSize());
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation(TableRowImpl.this.remarkButton.getX() + TableRowImpl.this.remarkButton.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }
}

