/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flight.details.utils;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextFieldListener;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.AbstractTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.flightschedule.PaxFigureComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.PaxFigureComplete_;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class PaxField
extends DefaultPanel
implements Validatable,
TextFieldListener {
    private static final long serialVersionUID = 1L;
    private RDTextField field;
    private TextLabel max;
    private Node<PaxFigureComplete> paxFigure;

    public PaxField(Node<PaxFigureComplete> n, RDProvider provider) {
        this.paxFigure = n;
        this.field = new RDTextField(provider, TextFieldType.INT);
        this.field.setOverrideName("editpax");
        this.field.setNode(n.getChildNamed(PaxFigureComplete_.number));
        this.max = new TextLabel();
        this.field.addTextFieldListener(this);
        this.setLayout(new Layout());
        this.add(this.field);
        this.add(this.max);
    }

    public Node<PaxFigureComplete> getPaxFigure() {
        return this.paxFigure;
    }

    public int getPaxCount() {
        try {
            return Integer.valueOf(this.field.getText());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public Node getNode() {
        return this.field.getNode();
    }

    public Node<PaxFigureComplete> getFigureNode() {
        return this.paxFigure;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.field.setEnabled(isEnabled);
        this.max.setEnabled(isEnabled);
        if (this.field.getEditor() != null) {
            this.valueChanged((AbstractTextField)this.field.getEditor());
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.field.kill();
        this.max.kill();
        this.field = null;
        this.max = null;
    }

    public void setMaxPax(int i) {
        this.max.setText("/ " + i);
        if (this.field.getEditor() != null) {
            this.valueChanged((AbstractTextField)this.field.getEditor());
        }
        this.validate();
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.field.getFocusComponents();
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.field.setVisibleContainer(pane);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.field.requestFocusInWindowNow();
    }

    @Override
    public void setValid() {
        this.field.setValid();
    }

    @Override
    public void setInvalid() {
        this.field.setInvalid();
    }

    @Override
    public void setWarning() {
        this.field.setWarning();
    }

    public boolean isFieldValid() {
        int i = 0;
        int u = 0;
        try {
            i = Integer.valueOf(this.field.getText());
            u = Integer.valueOf(this.max.getText().substring(2, this.max.getText().length()));
        }
        catch (NumberFormatException e) {
            return true;
        }
        catch (Exception e) {
            return true;
        }
        boolean b = i <= u;
        b = b && i >= 0;
        return b;
    }

    public List<Component> getFocusComponent() {
        if (this.field.getEditor() != null) {
            return ((TextField)this.field.getEditor()).getFocusComponents();
        }
        return new ArrayList<Component>();
    }

    @Override
    public void valueChanged(AbstractTextField field) {
        if (this.isFieldValid()) {
            this.setValid();
        } else {
            this.setInvalid();
        }
    }

    @Override
    public void setPermanent(boolean isPermantent) {
        this.field.setPermanent(isPermantent);
    }

    public int getNumber() {
        try {
            Integer i = Integer.valueOf(this.field.getText());
            return i;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = (int)PaxField.this.field.getPreferredSize().getHeight();
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            PaxField.this.field.setLocation(0, (int)(((double)parent.getHeight() - PaxField.this.field.getPreferredSize().getHeight()) / 2.0));
            PaxField.this.field.setSize((w -= 5) / 2, (int)PaxField.this.field.getPreferredSize().getHeight());
            PaxField.this.max.setLocation(PaxField.this.field.getX() + PaxField.this.field.getWidth() + 5, (int)(((double)parent.getHeight() - PaxField.this.max.getPreferredSize().getHeight()) / 2.0));
            PaxField.this.max.setSize(w / 2, (int)PaxField.this.max.getPreferredSize().getHeight());
        }
    }
}

