/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flight.details.utils;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.CabinClassConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.gui.modules.flight.details.utils.FlightProviderRule;
import ch.icit.pegasus.client.gui.modules.flight.details.utils.LegColumnComparator;
import ch.icit.pegasus.client.gui.modules.flight.details.utils.LegComp;
import ch.icit.pegasus.client.gui.modules.flight.details.utils.PaxField;
import ch.icit.pegasus.client.gui.modules.flight.details.utils.PaxTableChangeListener;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.toolkits.LegToolkit;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.AlaCarteMealOrderComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.ILegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.PaxFigureComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.PaxFigureComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.SpecialMealOrderComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxFigureTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class PaxTable4
extends JPanelKillable
implements NodeListener,
Focusable {
    private static final long serialVersionUID = 1L;
    private final Table2 table;
    private Node<List<ALegComplete>> legs;
    private Node<FlightComplete> flightNode;
    private final List<Node> legsNodes = new ArrayList<Node>();
    private final List<Node> paxNodes = new ArrayList<Node>();
    private List<PaxTableChangeListener> paxTableListeners = new ArrayList<PaxTableChangeListener>();
    private MutableFocusContainerListener focusCycleCreator;
    private PaxFigureTypeComplete selectedPaxFigureType;
    private final RDProvider provider;
    private Container superPanel;

    public PaxTable4(RDProvider provider) {
        this.setOpaque(false);
        this.provider = provider;
        this.table = new Table2(false, "", false, false, "");
        this.table.setProvider(provider);
        this.table.setOverrideName("editpax");
        this.table.setDontUseScrollBar(15);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (!this.table.isKilled()) {
            this.table.setEnabled(isEnabled);
        }
    }

    public void setPaxMax(CabinClassComplete clazz, ILegComplete leg, int max) {
        TableRow effectedRow = this.getRow4Class(clazz, this.table.getRows());
        if (effectedRow != null) {
            effectedRow.setMaxPax(leg, max);
        }
    }

    public void setNode(Node node) {
        Node childNamed;
        if (this.provider != null && this.provider.getAdditionalRule() == null) {
            this.provider.setAdditionalRule(new FlightProviderRule((FlightComplete)node.getValue(FlightComplete.class)));
        }
        this.flightNode = node;
        this.legs = childNamed = this.flightNode.getChildNamed(FlightLight_.legs);
        this.table.resetTable();
        if (this.table.getModel() != null) {
            this.table.getModel().resetModel();
        }
        this.table.setComparator(new Comparator<TableRow>(){

            @Override
            public int compare(TableRow o1, TableRow o2) {
                return o1.selectedClass.getCode().compareTo(o2.selectedClass.getCode());
            }
        });
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        Iterator it = this.legs.getChilds();
        int legCount = 0;
        while (it.hasNext()) {
            Node leg = (Node)it.next();
            boolean useLeg = LegToolkit.showLegInPaxTable((ALegComplete)((ALegComplete)leg.getValue()), (SystemSettingsComplete)settings);
            if (!useLeg) continue;
            ++legCount;
        }
        double scale1 = 0.1;
        double scale2 = 0.9;
        if (legCount <= 2) {
            scale1 = 0.3;
            scale2 = 0.7;
        }
        columns.add(new TableColumnInfo(scale1, 0.0, Words.CLASS, null, null, null, "", 60, 60, 60));
        this.legs.sortChilds(ComparatorRegistry.getComparator(LegColumnComparator.class));
        double fx = scale2 / (double)legCount;
        legCount = 0;
        int nameCount = 0;
        it = this.legs.getChilds();
        while (it.hasNext()) {
            Node leg = (Node)it.next();
            boolean useLeg = LegToolkit.showLegInPaxTable((ALegComplete)((ALegComplete)leg.getValue()), (SystemSettingsComplete)settings);
            if (useLeg) {
                String cName = Words.LEG + " " + (nameCount + 1);
                cName = ((ALegComplete)leg.getValue()).getArrivalAirport().equals((Object)settings.getHomeBase()) ? cName + " (" + WordsToolkit.toLowerCase((String)Words.FROM) + " " + ((ALegComplete)leg.getValue()).getDepartureAirport().getCode() + ")" : (((ALegComplete)leg.getValue()).getDepartureAirport().equals((Object)settings.getHomeBase()) ? cName + " (" + WordsToolkit.toLowerCase((String)Words.TO) + " " + ((ALegComplete)leg.getValue()).getArrivalAirport().getCode() + ")" : cName + " (" + ((ALegComplete)leg.getValue()).getDepartureAirport().getCode() + " - " + ((ALegComplete)leg.getValue()).getArrivalAirport().getCode() + ")");
                columns.add(new TableColumnInfo(fx, 0.0, cName, null, null, null, "", 50, 50, 50));
                ++legCount;
            }
            ++nameCount;
        }
        this.table.setModel(new Table2Model(columns, model -> new TableRow(model, null)));
        this.legs.getAllChildAddEventsFor((NodeListener)this, new String[0]);
        this.table.setSortedColumn(0);
        this.table.setSortDirection(false);
        this.table.setSortable(false);
        if (this.focusCycleCreator != null) {
            this.focusCycleCreator.focusCycleChanged(null);
        }
        this.setLayout(new PaxTableLayout());
        this.table.getModel().updateColumnWiths();
        this.add((Component)this.table, 0);
    }

    public void addPaxTableListener(PaxTableChangeListener listener) {
        this.paxTableListeners.add(listener);
    }

    public void removePaxTableListener(PaxTableChangeListener listener) {
        this.paxTableListeners.remove(listener);
    }

    protected void firePaxTableChange(PaxFigureComplete figure, int number) {
        for (PaxTableChangeListener l : this.paxTableListeners) {
            l.paxChanged(figure, number);
        }
    }

    public void setValid(boolean b) {
        this.table.enableAddButton(b);
    }

    public Container getSuperPanel() {
        return this.superPanel;
    }

    public void setSuperPanel(Container superPanel) {
        this.superPanel = superPanel;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.table != null) {
            this.table.kill();
        }
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
        if (this.legs != null) {
            this.legs.removeAllListenersRecursivley();
        }
        if (this.flightNode != null) {
            this.flightNode.removeAllListenersRecursivley();
        }
        if (this.legsNodes != null) {
            for (Node n : this.legsNodes) {
                n.removeAllListenersRecursivley();
            }
            this.legsNodes.clear();
        }
        if (this.paxNodes != null) {
            for (Node n : this.paxNodes) {
                n.removeAllListenersRecursivley();
            }
            this.paxNodes.clear();
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
        if (source == this.legs) {
            ALegComplete leg = (ALegComplete)child.getValue();
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            boolean rejected = false;
            FlightLegComplete l = (FlightLegComplete)leg;
            if (l.getCateringLeg().booleanValue()) {
                this.legsNodes.add(child);
                this.childAdded(child, child.getChildNamed(FlightLegComplete_.paxFigures));
            } else {
                rejected = true;
            }
            if (rejected) {
                for (PaxFigureComplete pf : l.getPaxFigures()) {
                    pf.setNumber(Integer.valueOf(0));
                }
            }
        } else if (this.legsNodes.contains(source)) {
            if (child.getName().equals("paxFigures")) {
                this.paxNodes.add(child);
                child.addNodeListener((NodeListener)this);
                child.getAllChildAddEventsFor((NodeListener)this, new String[0]);
            }
        } else if (this.paxNodes.contains(source)) {
            Node currentPaxType = child.getChildNamed(PaxFigureComplete_.paxFigureType);
            if (this.selectedPaxFigureType != null ? !this.selectedPaxFigureType.equals(currentPaxType.getValue()) : currentPaxType != null && currentPaxType.getValue() != null) {
                return;
            }
            Node cc = child.getChildNamed(PaxFigureComplete_.cabinClass);
            if (cc != null && this.table != null) {
                TableRow r = this.getRow4Class((CabinClassComplete)cc.getValue(), this.table.getRows());
                if (r == null) {
                    Table2RowModel m = new Table2RowModel(child, this.table.getModel(), false);
                    PaxFigureComplete childValue = (PaxFigureComplete)child.getValue(PaxFigureComplete.class);
                    if (childValue != null) {
                        r = new TableRow(m, childValue.getCabinClass());
                        this.table.addRow(r);
                    }
                }
                if (r != null) {
                    r.addNode(child);
                }
                this.table.getModel().rowAddedFromOutside(null);
            }
        }
    }

    private TableRow getRow4Class(CabinClassComplete dto, List<Table2RowPanel> rows) {
        for (Table2RowPanel p : rows) {
            TableRow r = (TableRow)p;
            if (!r.isEffectedClass(dto)) continue;
            return r;
        }
        return null;
    }

    public void childRemoved(Node<?> source, Node<?> child) {
        TableRow r = (TableRow)this.table.getRowPanel4Node(child);
        if (r != null) {
            this.table.removeRow(r, true);
            this.table.getModel().rowRemovedFromOutside(null);
        }
        if (this.superPanel != null) {
            this.superPanel.validate();
        }
    }

    public void valueChanged(Node<?> node) {
    }

    private int getSpmlAndAlaCarteAmount(Node<PaxFigureComplete> figures) {
        Node l;
        Iterator it2;
        Node order;
        Iterator it;
        int mealCount = 0;
        Node cabinClass = figures.getChildNamed(PaxFigureComplete_.cabinClass);
        Node leg = figures.getChildNamed(PaxFigureComplete_.leg);
        try {
            it = this.flightNode.getChildNamed(FlightComplete_.spmlOrders).getFailSafeChildIterator();
            while (it.hasNext()) {
                block11: {
                    order = (Node)it.next();
                    try {
                        if (Boolean.TRUE.equals(order.getChildNamed(new DtoField[]{SpecialMealOrderComplete_.menuType, SpecialMenuTypeComplete_.additional}).getValue())) {
                        }
                        break block11;
                    }
                    catch (Error | Exception e) {}
                    continue;
                }
                if (order.getChildNamed(SpecialMealOrderComplete_.cabinClass).getValue() == null || !((CabinClassComplete)order.getChildNamed(SpecialMealOrderComplete_.cabinClass).getValue()).equals(cabinClass.getValue())) continue;
                it2 = order.getChildNamed(SpecialMealOrderComplete_.legs).getFailSafeChildIterator();
                while (it2.hasNext()) {
                    l = (Node)it2.next();
                    if (l.getValue() == null || !((FlightLegComplete)l.getValue()).equals(leg.getValue())) continue;
                    mealCount += ((Integer)order.getChildNamed(SpecialMealOrderComplete_.count).getValue()).intValue();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            it = this.flightNode.getChildNamed(FlightComplete_.alaCarteOrders).getFailSafeChildIterator();
            while (it.hasNext()) {
                order = (Node)it.next();
                if (order.getChildNamed(AlaCarteMealOrderComplete_.cabinClass).getValue() == null || !((CabinClassComplete)order.getChildNamed(AlaCarteMealOrderComplete_.cabinClass).getValue()).equals(cabinClass.getValue())) continue;
                it2 = order.getChildNamed(SpecialMealOrderComplete_.legs).getFailSafeChildIterator();
                while (it2.hasNext()) {
                    l = (Node)it2.next();
                    if (l.getValue() == null || !((FlightLegComplete)l.getValue()).equals(leg.getValue())) continue;
                    mealCount += ((Integer)order.getChildNamed(AlaCarteMealOrderComplete_.count).getValue()).intValue();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mealCount;
    }

    public List<ScreenValidationObject> isTableValid() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        if (this.table.isWritable()) {
            for (Table2RowPanel table2RowPanel : this.table.getRows()) {
                TableRow pp = (TableRow)table2RowPanel;
                if (pp.isRowValid()) continue;
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.REVIEW_FLIGHT_PAX));
            }
            ArrayList<Integer> legPaxCounts = new ArrayList<Integer>();
            for (Table2RowPanel p : this.table.getRows()) {
                TableRow row = (TableRow)p;
                int i = 0;
                for (PaxField cell : row.getFields()) {
                    PaxFigureTypeComplete type;
                    Integer legPaxCount;
                    int spmlMeals = this.getSpmlAndAlaCarteAmount(cell.getFigureNode());
                    if (i >= legPaxCounts.size()) {
                        legPaxCount = 0;
                        legPaxCounts.add(legPaxCount);
                    } else {
                        legPaxCount = (Integer)legPaxCounts.get(i);
                    }
                    legPaxCount = legPaxCount + cell.getPaxCount();
                    legPaxCounts.set(i, legPaxCount);
                    ++i;
                    if (cell.getPaxCount() - spmlMeals >= 0 || (type = (PaxFigureTypeComplete)cell.getFigureNode().getChildNamed(PaxFigureComplete_.paxFigureType).getValue()) != null) continue;
                    Node ccNode = cell.getFigureNode().getChildNamed(PaxFigureComplete_.cabinClass);
                    Node legNode = cell.getFigureNode().getChildNamed(PaxFigureComplete_.leg);
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Review Pax Count of " + ((CabinClassComplete)ccNode.getValue()).getCode() + " on leg " + legNode.getValue() + " (Pax Type = " + (type != null ? type.getCode() : "invoiced") + "): too many SPML and alaCarte Orders"));
                }
            }
            SystemSettingsComplete systemSettingsComplete = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            for (Integer legPaxCount : legPaxCounts) {
                if (legPaxCount <= systemSettingsComplete.getMaxNumPax()) continue;
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.TOO_MUCH_PAXES_ENTERED, (Object[])new Object[]{systemSettingsComplete.getMaxNumPax()})));
            }
        }
        return a;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        if (this.table.getModel() != null) {
            for (int i = 1; i < this.table.getModel().getColumnCount(); ++i) {
                for (Table2RowPanel p : this.table.getRows()) {
                    TableRow r = (TableRow)p;
                    List<Component> c = r.getComponentForLeg(i - 1);
                    if (c == null) continue;
                    a.addAll(c);
                }
            }
        }
        return a;
    }

    public Table2 getTable() {
        return this.table;
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.table.setVisibleContainer(pane);
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.table.requestFocusInWindowNow();
    }

    public boolean isSwingOnly() {
        return true;
    }

    public MutableFocusContainerListener getFocusCycleCreator() {
        return this.focusCycleCreator;
    }

    public void setFocusCycleCreator(MutableFocusContainerListener focusCycleCreator) {
        this.focusCycleCreator = focusCycleCreator;
    }

    public PaxFigureTypeComplete getSelectedPaxFigureType() {
        return this.selectedPaxFigureType;
    }

    public void setSelectedPaxFigureType(PaxFigureTypeComplete selectedPaxFigureType) {
        this.selectedPaxFigureType = selectedPaxFigureType;
    }

    public void updatePax(PaxFigureComplete paxFigure, int number) {
        TableRow row = this.getRow4Class(paxFigure.getCabinClass(), this.table.getRows());
        if (row != null) {
            row.updatePax(paxFigure, number);
        }
    }

    private class PaxTableLayout
    extends DefaultLayout {
        private PaxTableLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            PaxTable4.this.table.setLocation(0, 0);
            PaxTable4.this.table.setSize(parent.getWidth(), parent.getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return PaxTable4.this.table.getPreferredSize();
        }
    }

    private class TableRow
    extends Table2RowPanel
    implements NodeListener {
        private static final long serialVersionUID = 1L;
        private final CabinClassComplete selectedClass;
        private TextLabel className;
        private final List<PaxField> fields;
        private final ArrayList<Node<PaxFigureComplete>> nodes;

        public TableRow(Table2RowModel m, CabinClassComplete dto) {
            super(m);
            this.fields = new ArrayList<PaxField>();
            this.nodes = new ArrayList();
            this.selectedClass = dto;
            this.setLayout(new RowLayout());
            this.setProgress(1.0f);
            Node node = this.model.getNode().getChildNamed(PaxFigureComplete_.cabinClass);
            this.className = new TextLabel(node, (Converter)new CabinClassConverter());
            this.className.setProgress(1.0f);
            this.add(this.className);
        }

        public List<PaxField> getFields() {
            return this.fields;
        }

        public void setMaxPax(ILegComplete leg, int max) {
            for (PaxField f : this.fields) {
                f.setMaxPax(max);
            }
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    if (this.selectedClass != null && this.selectedClass.getSequenceNumber() != null) {
                        return this.selectedClass.getSequenceNumber();
                    }
                    return this.className.getText();
                }
            }
            return null;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            this.className.kill();
            this.nodes.clear();
            for (PaxField f : this.fields) {
                f.getNode().removeNodeListener((NodeListener)this);
                f.kill();
            }
            this.fields.clear();
            super.kill();
            this.className = null;
        }

        public void addNode(Node<PaxFigureComplete> node) {
            this.nodes.add(node);
            Node n = node.getChildNamed(PaxFigureComplete_.number);
            PaxField t = new PaxField(node, PaxTable4.this.provider);
            this.fields.add(t);
            this.add(t);
            if (n != null) {
                n.addNodeListener((NodeListener)this);
            }
            Collections.sort(this.fields, ComparatorRegistry.getComparator(LegComp.class));
            this.validate();
        }

        public boolean isEffectedClass(CabinClassComplete testObject) {
            return testObject.equals((Object)this.selectedClass);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            for (PaxField f : this.fields) {
                CheckedListAdder.addToList(a, f);
            }
            return a;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.className.setEnabled(isEnabled);
            for (PaxField f : this.fields) {
                f.setEnabled(isEnabled);
            }
        }

        @Override
        public boolean isRowValid() {
            boolean isValidate = true;
            for (PaxField f : this.fields) {
                if (f.isFieldValid()) continue;
                isValidate = false;
            }
            return isValidate;
        }

        public List<Component> getComponentForLeg(int i) {
            if (i >= 0 && i < this.fields.size()) {
                return this.fields.get(i).getFocusComponent();
            }
            return new ArrayList<Component>();
        }

        public void valueChanged(Node<?> node) {
            if (this.isEnabled() && node.getParent().getValue() instanceof PaxFigureComplete) {
                PaxFigureComplete value1 = (PaxFigureComplete)node.getParent().getValue();
                if (PaxTable4.this.selectedPaxFigureType != null && PaxTable4.this.selectedPaxFigureType.equals((Object)value1.getPaxFigureType()) || PaxTable4.this.selectedPaxFigureType == null && value1.getPaxFigureType() == null) {
                    Integer value = (Integer)node.getValue();
                    if (value == null) {
                        value = 0;
                    }
                    PaxTable4.this.firePaxTableChange((PaxFigureComplete)node.getParent().getValue(), value);
                }
            }
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        public void updatePax(PaxFigureComplete paxFigure, int number) {
            for (Node<PaxFigureComplete> f : this.nodes) {
                if (!((PaxFigureComplete)f.getValue()).getLeg().equals((Object)paxFigure.getLeg())) continue;
                f.getChildNamed(PaxFigureComplete_.number).setValueSilent((Object)number, false, 0L, new NodeListener[]{this});
                return;
            }
        }

        private class RowLayout
        extends DefaultLayout {
            private RowLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = parent.getWidth();
                int currentX = 0;
                w = TableRow.this.model.getParentModel().getColumnWidth(0);
                TableRow.this.className.setLocation(currentX + PaxTable4.this.table.getCellPadding(), (int)(((double)parent.getHeight() - TableRow.this.className.getPreferredSize().getHeight()) / 2.0));
                TableRow.this.className.setSize(w - 2 * PaxTable4.this.table.getCellPadding(), (int)TableRow.this.className.getPreferredSize().getHeight());
                currentX += w;
                int i = 1;
                for (PaxField f : TableRow.this.fields) {
                    w = TableRow.this.model.getParentModel().getColumnWidth(i);
                    f.setLocation(currentX + PaxTable4.this.table.getCellPadding(), (int)(((double)parent.getHeight() - f.getPreferredSize().getHeight()) / 2.0));
                    f.setSize(w - 2 * PaxTable4.this.table.getCellPadding(), (int)f.getPreferredSize().getHeight());
                    currentX += w;
                    ++i;
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRow.this.getDefaultRowHeight());
            }
        }
    }
}

