/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flight.utils;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.restaurant.RestaurantDeliverySettingsComplete;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.RestaurantSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class NewFlightCreatedUpdater {
    private Set<Long> processFlightIds = new HashSet<Long>();
    private MainFrame mainFrame;
    private Timer timerTask = new Timer();
    private volatile boolean running = false;

    public NewFlightCreatedUpdater(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void startChecker() {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (!CompanyUtil.isFPB((SystemSettingsComplete)settings)) {
            return;
        }
        this.running = true;
        this.timerTask.schedule(new TimerTask(){

            @Override
            public void run() {
                NewFlightCreatedUpdater.this.checkForNewFlights();
            }
        }, 10000L);
    }

    public void stopChecker() {
        this.running = false;
    }

    private void checkForNewFlights() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                FlightSearchConfiguration configuration = new FlightSearchConfiguration();
                RestaurantSearchConfiguration rConfig = new RestaurantSearchConfiguration();
                rConfig.setIsDeleted(Boolean.valueOf(false));
                rConfig.getLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                HashSet<FlightLight> newFights = new HashSet<FlightLight>();
                if (NodeToolkit.getAffixClass(RestaurantDeliverySettingsComplete.class) != null) {
                    RestaurantDeliverySettingsComplete restaurantSettings = (RestaurantDeliverySettingsComplete)NodeToolkit.getAffixClass(RestaurantDeliverySettingsComplete.class).getValue();
                    SearchResultIterator sri = new SearchResultIterator((ASearchConfiguration)rConfig);
                    while (sri.hasNext()) {
                        configuration.getPossibleRestaurants().add(sri.next());
                    }
                    configuration.setOnlyOpenFlights(Boolean.valueOf(true));
                    configuration.setFlightState(FlightStateE.OPEN);
                    configuration.setFlightOrderReceived(Boolean.valueOf(false));
                    configuration.setCustomer(restaurantSettings.getDefaultStowingList().getCustomer());
                    configuration.setDayPeriod(new PeriodComplete(DateUtil.getSQLDate((int)2020, (int)1, (int)1), DateUtil.getSQLInfinityDate()));
                    SearchResultIterator fsri = new SearchResultIterator((ASearchConfiguration)configuration);
                    while (fsri.hasNext()) {
                        FlightLight flight = (FlightLight)fsri.next();
                        if (NewFlightCreatedUpdater.this.processFlightIds == null || flight == null || NewFlightCreatedUpdater.this.processFlightIds.contains(flight.getId())) continue;
                        newFights.add(flight);
                        NewFlightCreatedUpdater.this.processFlightIds.add(flight.getId());
                    }
                }
                return INodeCreator.getDefaultImpl().createNodes(new ArrayList(newFights), true);
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        List value = (List)node.getValue();
                        if (!value.isEmpty()) {
                            InnerPopupFactory.showMessageDialogImportant("New Order from Restaurants detected", "Please refresh Flight Module to see the new orders.", NewFlightCreatedUpdater.this.mainFrame);
                        }
                        if (NewFlightCreatedUpdater.this.running) {
                            NewFlightCreatedUpdater.this.startChecker();
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        if (NewFlightCreatedUpdater.this.running) {
                            NewFlightCreatedUpdater.this.startChecker();
                        }
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.runInBackground(run);
    }
}

