/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flightschedule;

import ch.icit.pegasus.client.converter.CustomerCodeConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.DayTimeConverter;
import ch.icit.pegasus.client.converter.DefaultObject2ObjectConverter;
import ch.icit.pegasus.client.converter.FlightCategoryConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.LegInfoListConverter;
import ch.icit.pegasus.client.converter.OperationDaysFSConverter;
import ch.icit.pegasus.client.converter.StowingListConfigurationConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.flightschedule.FlightScheduleModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.flightschedule.details.DefaultUpliftDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flightschedule.details.FlightDataDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flightschedule.details.HandlingCostDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flightschedule.details.LegsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flightschedule.details.RemarkDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flightschedule.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flightschedule.details.StowingListDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flightschedule.details.TemplateDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.CombinedDetailsParagraph;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.fake.FakeSmartScreenTableRow;
import ch.icit.pegasus.client.gui.utils.RowTransferObject;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiHaulTypeSelectionComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiSelectionPanel;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledDayTimePeriodChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.FlightScheduleSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimePeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightScheduleAccess;
import ch.icit.pegasus.server.core.dtos.search.FlightScheduleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.sql.Time;
import java.util.ArrayList;
import java.util.List;

public class FlightScheduleModule
extends ScreenTableView<FlightScheduleLight, FlightScheduleSearchConfiguration.FLIGHT_SCHEDULE_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_OUTBOUND = "outbound";
    private static final String FILTER_AIRLINE = "airline";
    private static final String FILTER_DEPARTURE = "departure";
    private static final String FILTER_PERIOD = "period";
    private static final String FILTER_STATE = "state";
    private static final String FILTER_AUTO_CHECKOUT = "autoCheckout";
    private static final String FILTER_CATEGORY = "category";
    private static final String FILTER_HAUL_TYPE = "flightHaulType";
    private static final String FILTER_DELIVERY_AIRPORT = "DeliveryAirport";
    private String filterCriteria1 = null;
    private CustomerLight filterCriteria2 = null;
    private TitledDayTimePeriodChooser filterCriteria3 = null;
    private TitledPeriodEditor filterCriteria4 = null;
    private List<HaulTypeComplete> haulType;
    private Boolean haulTypeActivated = Boolean.FALSE;
    private TitledPeriodEditor periodChooser;
    private Boolean autoCheckout;
    private FlightCategoryComplete flightCategory;
    private MultiSelectionPanel<MultiHaulTypeSelectionComboBox> haulPanel;
    private ModificationStateE filterCriteria5;
    private TitledDayTimePeriodChooser timeChooser;
    private AirportComplete selectedDeliveryAirport;
    private ComboBox flightCats;

    public FlightScheduleModule() {
        super(FlightScheduleLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.periodChooser.kill();
        if (this.timeChooser != null) {
            this.timeChooser.kill();
        }
        this.haulPanel.kill();
        this.haulPanel = null;
        this.periodChooser = null;
        this.timeChooser = null;
        this.flightCats.kill();
        this.flightCats = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return FlightScheduleAccess.MODULE_FLIGHT_SCHEDULE;
    }

    @Override
    public ASearchConfiguration<FlightScheduleLight, FlightScheduleSearchConfiguration.FLIGHT_SCHEDULE_COLUMN> getEmptySearchConfiguration() {
        return this.getSearchParameters(null, null, false, true, this.filterChain);
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", FlightScheduleSearchConfiguration.FLIGHT_SCHEDULE_COLUMN.OUTBOUND_CODE + "<>" + true);
        c.addProperty(FILTER_DEPARTURE, "<>00:00><23:59");
        c.addProperty(FILTER_PERIOD, FilterChainConfiguration.getDefaultSearchPeriodString());
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.filterChain.overrideDefaultSearchBoxWidth(120);
        this.filterChain.overrideDefaultSearchField2Width(150);
        this.filterChain.overrideDefaultComboBoxWidth(100);
        this.filterChain.addSearchField(FILTER_OUTBOUND, Words.NUMBER_OR_NAME, "");
        this.filterChain.addCustomerSearchField(FILTER_AIRLINE);
        this.timeChooser = this.filterChain.addTimePeriodSelection(FILTER_DEPARTURE, Words.DEPARTURE, new Time(System.currentTimeMillis()), new Time(System.currentTimeMillis()));
        PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
        this.periodChooser = this.filterChain.addPeriodSelection(FILTER_PERIOD, p.getStartDate(), p.getEndDate(), Words.PERIOD, false);
        this.periodChooser.setCheckBoxEnabled();
        this.periodChooser.setCommitOnFocusLost(true);
        ComboBox b = ComboBoxFactory.getModificationStateComboBox(true);
        this.filterChain.addSelectionComboBox(b, 90, FILTER_STATE, Words.STATE, Words.ALL);
        if (Boolean.TRUE.equals(settings.getAutoCheckout())) {
            b = ComboBoxFactory.getYesNoComboBox(true);
            this.filterChain.addSelectionComboBox(b, 110, FILTER_AUTO_CHECKOUT, Words.AUTO_CHECKOUT, Words.ALL);
        }
        this.flightCats = new ComboBox(null, null, ConverterRegistry.getConverter(FlightCategoryConverter.class));
        this.filterChain.addSelectionComboBox(this.flightCats, 120, FILTER_CATEGORY, Words.CATEGORY, Words.ALL);
        MultiHaulTypeSelectionComboBox haulCombo = new MultiHaulTypeSelectionComboBox(INodeCreator.getDefaultImpl().createNodes(new ArrayList(), false));
        this.haulPanel = new MultiSelectionPanel<MultiHaulTypeSelectionComboBox>(haulCombo);
        this.haulPanel.setShouldPersist(true);
        this.filterChain.addMultiSelection(this.haulPanel, FILTER_HAUL_TYPE, Words.HAUL_TYPE);
        if (CompanyUtil.isSCK((SystemSettingsComplete)settings)) {
            this.filterChain.addAirportSearchField(FILTER_DELIVERY_AIRPORT);
        }
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<FlightScheduleLight, FlightScheduleSearchConfiguration.FLIGHT_SCHEDULE_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        Object[] p;
        if (isReset) {
            this.filterCriteria1 = null;
            this.filterCriteria2 = null;
            this.filterCriteria3 = null;
            this.filterCriteria4 = null;
            this.filterCriteria5 = null;
            this.autoCheckout = null;
            this.haulTypeActivated = Boolean.FALSE;
            this.flightCategory = null;
            this.selectedDeliveryAirport = null;
        } else if (name == FILTER_OUTBOUND) {
            this.filterCriteria1 = (String)value;
        } else if (name == FILTER_AIRLINE) {
            this.filterCriteria2 = value instanceof CustomerLight ? (CustomerLight)value : null;
        } else if (name == FILTER_DEPARTURE) {
            p = (TitledDayTimePeriodChooser)value;
            this.filterCriteria3 = p;
        } else if (name == FILTER_PERIOD) {
            p = (TitledPeriodEditor)value;
            this.filterCriteria4 = p;
        } else if (name == FILTER_STATE) {
            this.filterCriteria5 = value instanceof ModificationStateE ? (ModificationStateE)value : null;
        } else if (name == FILTER_AUTO_CHECKOUT) {
            if (value instanceof String) {
                this.autoCheckout = value.equals(Words.YES) ? Boolean.valueOf(true) : (value.equals(Words.NO_ANSWER) ? Boolean.valueOf(false) : null);
            }
        } else if (name == FILTER_CATEGORY) {
            this.flightCategory = value instanceof FlightCategoryComplete ? (FlightCategoryComplete)value : (value instanceof Node ? (FlightCategoryComplete)((Node)value).getValue() : null);
        } else if (name == FILTER_HAUL_TYPE) {
            if (value instanceof Object[]) {
                this.haulType = new ArrayList<HaulTypeComplete>();
                for (Object a : (Object[])value) {
                    this.haulType.add((HaulTypeComplete)a);
                }
            } else if (value instanceof Boolean) {
                this.haulTypeActivated = (Boolean)value;
            } else {
                this.haulType = null;
            }
        } else if (name == FILTER_DELIVERY_AIRPORT) {
            this.selectedDeliveryAirport = value instanceof AirportComplete ? (AirportComplete)value : (value instanceof Node ? (AirportComplete)((Node)value).getValue() : null);
        }
        FlightScheduleSearchConfiguration c = new FlightScheduleSearchConfiguration();
        c.setCustomer(this.filterCriteria2);
        c.setHaulTypeList(this.haulType);
        c.setShowNullHaulTypes(this.haulTypeActivated);
        if (this.filterCriteria3 != null) {
            TimePeriodComplete tp = new TimePeriodComplete((Time)this.filterCriteria3.getTimeStartNode().getValue(), (Time)this.filterCriteria3.getTimeEndNode().getValue());
            c.setDeparture(tp);
        }
        if (this.filterCriteria4 != null) {
            PeriodComplete p2 = new PeriodComplete(this.filterCriteria4.getStartDate(), this.filterCriteria4.getEndDate());
            c.setFlightPeriod(p2);
        }
        c.setFlightNumber(this.filterCriteria1);
        try {
            int i = Integer.valueOf(this.filterCriteria1);
            c.setNumber(Integer.valueOf(i));
        }
        catch (Exception e) {
            c.setNumber(null);
        }
        c.setState(this.filterCriteria5);
        c.setNumResults(this.numberOfShownResults);
        c.setAutoCheckout(this.autoCheckout);
        c.setCategory(this.flightCategory);
        c.setDeliveryAirport(this.selectedDeliveryAirport);
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        this.flightCats.refreshPossibleValues(NodeToolkit.getAffixList(FlightCategoryComplete.class));
        this.flightCats.addItem(Words.ALL);
        this.flightCats.setSelectedItem(Words.ALL);
    }

    @Override
    public SearchAlgorithm<FlightScheduleLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(FlightScheduleSearchAlgorithm.class);
    }

    @Override
    public RowTransferObject<FlightScheduleLight> getRowAttributes(RowModel<FlightScheduleLight> model) {
        return new RowTransferObject<FlightScheduleLight>(model.getDTO(FlightScheduleLight.class), new FakeSmartScreenTableRow<FlightScheduleLight>(model), model.getParentModel().getDataHandler(), false, model, this);
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<FlightScheduleLight> model) {
        if (screen.getInvokingName().toLowerCase().equals(FlightScheduleAccess.TOOL_FLIGHT_SCHEDULE_MEAL_PLAN_SPECIFICATION.getIdentifier())) {
            if (model != null) {
                try {
                    FlightScheduleLight fs = (FlightScheduleLight)model.getNode().getValue();
                    if (fs.getDefaultStowingList() != null && fs.getDefaultStowingList().getStowingList().getCurrentVariant().getMealplan() != null) {
                        return true;
                    }
                }
                catch (Exception fs) {}
            }
        } else if (model != null) {
            if (screen.getInvokingName().toLowerCase().equals(FlightScheduleAccess.INFO_FLIGHT_SCHEDULE_CHANGELOG.getIdentifier())) {
                return model != null;
            }
            Object n = model.getNode().getValueForNamed(FlightScheduleLight_.defaultStowingList);
            if (n != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isDeletable(RowModel<FlightScheduleLight> model) {
        return super.isDeletable(model) && model.getDTO(FlightScheduleLight.class).getState() == ModificationStateE.DRAFT;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<FlightScheduleLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<FlightScheduleLight> rowEditor = new MessageProvidedRowEditor<FlightScheduleLight>(model, "");
            TemplateDetailsPanel d1 = null;
            CombinedDetailsParagraph c2 = new CombinedDetailsParagraph();
            StowingListDetailsPanel<FlightScheduleLight> detail4 = null;
            HandlingCostDetailsPanel<FlightScheduleLight> detail5 = null;
            RDProvider p = this.createProvider(model.isAddRow());
            p.addAccessRightToUseItAnyway(FlightScheduleComplete_.autoCheckout.getFieldName());
            if (!model.isAddRow()) {
                detail4 = new StowingListDetailsPanel<FlightScheduleLight>(rowEditor, p, FlightScheduleComplete_.defaultStowingList, false, null, null, null, null, null);
                detail5 = new HandlingCostDetailsPanel<FlightScheduleLight>(rowEditor, p, true, false);
            } else {
                d1 = new TemplateDetailsPanel((RowEditor<FlightScheduleLight>)rowEditor, p);
            }
            CombinedDetailsParagraph c1 = new CombinedDetailsParagraph();
            SpecificationDetailsPanel detail1 = new SpecificationDetailsPanel((RowEditor<FlightScheduleLight>)rowEditor, p);
            FlightDataDetailsPanel details2 = new FlightDataDetailsPanel((RowEditor<FlightScheduleLight>)rowEditor, p);
            LegsDetailsPanel details3 = new LegsDetailsPanel(rowEditor, p, null);
            RemarkDetailsPanel details4 = new RemarkDetailsPanel((RowEditor<FlightScheduleLight>)rowEditor, p);
            DefaultUpliftDetailsPanel details6 = new DefaultUpliftDetailsPanel((RowEditor<FlightScheduleLight>)rowEditor, p);
            int index = 0;
            if (model.isAddRow()) {
                index = 1;
                rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
            }
            c1.add((Component)detail1, new TableLayoutConstraint(0, 0, 0.0, 1.0));
            c1.add((Component)details2, new TableLayoutConstraint(1, 0, 0.0, 1.0));
            c1.add((Component)details3, new TableLayoutConstraint(2, 0, 1.0, 1.0));
            rowEditor.add(c1, (Object)new TableLayoutConstraint(0, index, 1.0, 1.0));
            if (!model.isAddRow()) {
                c2.add(detail4, new TableLayoutConstraint(0, 0, 0.5, 1.0));
                c2.add(detail5, new TableLayoutConstraint(1, 0, 0.5, 1.0));
                rowEditor.add(c2, (Object)new TableLayoutConstraint(0, index + 1, 1.0, 1.0));
                ++index;
            }
            rowEditor.add(details6, (Object)new TableLayoutConstraint(0, index + 1, 1.0, 1.0));
            rowEditor.add(details4, (Object)new TableLayoutConstraint(0, index + 2, 1.0, 1.0));
            if (model.isAddRow()) {
                rowEditor.addToFocusQueue(d1);
            }
            rowEditor.addToFocusQueue(detail1);
            rowEditor.addToFocusQueue(details2);
            rowEditor.addToFocusQueue(details3);
            if (!model.isAddRow()) {
                rowEditor.addToFocusQueue(detail4);
                rowEditor.addToFocusQueue(detail5);
            }
            rowEditor.addToFocusQueue(details6);
            rowEditor.addToFocusQueue(details4);
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new FlightScheduleModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> infos = new ArrayList<TableColumnInfo>();
        infos.add(new TableColumnInfo(Words.NO_NUMBER, "", (Class)IntegerConverter.class, (Enum<?>)FlightScheduleSearchConfiguration.FLIGHT_SCHEDULE_COLUMN.NUMBER, FlightScheduleLight_.number, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth));
        infos.add(new TableColumnInfo("", "", (Class)DefaultObject2ObjectConverter.class, (Enum<?>)FlightScheduleSearchConfiguration.FLIGHT_SCHEDULE_COLUMN.STATE, FlightScheduleLight_.state, TableColumnInfo.state2, TableColumnInfo.state2, TableColumnInfo.state2));
        infos.add(new TableColumnInfo(Words.CUSTOMER, "", (Class)CustomerCodeConverter.class, (Enum<?>)FlightScheduleSearchConfiguration.FLIGHT_SCHEDULE_COLUMN.AIRLINE, FlightScheduleLight_.customer, TableColumnInfo.customerCodeWidth, TableColumnInfo.customerCodeWidth, TableColumnInfo.customerCodeWidth));
        SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        boolean isSCK = CompanyUtil.isSCK((SystemSettingsComplete)s);
        if (isSCK) {
            infos.add(new TableColumnInfo(Words.INBOUND, "", (Class)StringConverter.class, (Enum<?>)FlightScheduleSearchConfiguration.FLIGHT_SCHEDULE_COLUMN.INBOUND_CODE, FlightScheduleLight_.inboundCode, 55, 80, 55));
            infos.add(new TableColumnInfo(Words.STA, "", (Class)DayTimeConverter.class, (Enum<?>)FlightScheduleSearchConfiguration.FLIGHT_SCHEDULE_COLUMN.STA, FlightScheduleLight_.sta, TableColumnInfo.timeColumnWidth, TableColumnInfo.timeColumnWidth, TableColumnInfo.timeColumnWidth));
            infos.add(new TableColumnInfo(Words.OUTBOUND, "", (Class)StringConverter.class, (Enum<?>)FlightScheduleSearchConfiguration.FLIGHT_SCHEDULE_COLUMN.OUTBOUND_CODE, FlightScheduleLight_.outboundCode, 55, 80, 55));
            infos.add(new TableColumnInfo(Words.STD, "", (Class)DayTimeConverter.class, (Enum<?>)FlightScheduleSearchConfiguration.FLIGHT_SCHEDULE_COLUMN.STD, FlightScheduleLight_.std, TableColumnInfo.timeColumnWidth, TableColumnInfo.timeColumnWidth, TableColumnInfo.timeColumnWidth));
        } else {
            infos.add(new TableColumnInfo(Words.OUTBOUND, "", (Class)StringConverter.class, (Enum<?>)FlightScheduleSearchConfiguration.FLIGHT_SCHEDULE_COLUMN.OUTBOUND_CODE, FlightScheduleLight_.outboundCode, 55, 80, 55));
            infos.add(new TableColumnInfo(Words.STD, "", (Class)DayTimeConverter.class, (Enum<?>)FlightScheduleSearchConfiguration.FLIGHT_SCHEDULE_COLUMN.STD, FlightScheduleLight_.std, TableColumnInfo.timeColumnWidth, TableColumnInfo.timeColumnWidth, TableColumnInfo.timeColumnWidth));
            infos.add(new TableColumnInfo(Words.INBOUND, "", (Class)StringConverter.class, (Enum<?>)FlightScheduleSearchConfiguration.FLIGHT_SCHEDULE_COLUMN.INBOUND_CODE, FlightScheduleLight_.inboundCode, 55, 80, 55));
            infos.add(new TableColumnInfo(Words.STA, "", (Class)DayTimeConverter.class, (Enum<?>)FlightScheduleSearchConfiguration.FLIGHT_SCHEDULE_COLUMN.STA, FlightScheduleLight_.sta, TableColumnInfo.timeColumnWidth, TableColumnInfo.timeColumnWidth, TableColumnInfo.timeColumnWidth));
        }
        infos.add(new TableColumnInfo(Words.OPERATION_PERIOD, "", (Class)DateConverter.class, (Enum<?>)FlightScheduleSearchConfiguration.FLIGHT_SCHEDULE_COLUMN.PERIOD, "period-startDate&period-endDate", TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth));
        infos.add(new TableColumnInfo(Words.LEGS, "", LegInfoListConverter.class, null, FlightScheduleLight_.legs, 75, Integer.MAX_VALUE, 150));
        infos.add(new TableColumnInfo(Words.STOWING, "", (Class)StowingListConfigurationConverter.class, (Enum<?>)FlightScheduleSearchConfiguration.FLIGHT_SCHEDULE_COLUMN.STOWING_LIST, FlightScheduleLight_.defaultStowingList, 32, Integer.MAX_VALUE, 65));
        infos.add(new TableColumnInfo(Words.OPERATION, "", (Class)OperationDaysFSConverter.class, (Enum<?>)FlightScheduleSearchConfiguration.FLIGHT_SCHEDULE_COLUMN.OPDAYS, FlightScheduleLight_.daysOfWeek, 40, Integer.MAX_VALUE, 80));
        return infos;
    }
}

