/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flightschedule.details;

import ch.icit.pegasus.client.converter.FlightCategoryConverter;
import ch.icit.pegasus.client.converter.FlightTypesConverter;
import ch.icit.pegasus.client.converter.HaulTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDNumericStepper;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.restaurant.RestaurantComplete;
import ch.icit.pegasus.server.core.dtos.restaurant.RestaurantDeliverySettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class FlightDataDetailsPanel
extends StateDependantDetailsPanel<FlightScheduleLight>
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDComboBox> flightType;
    private TitledItem<RDTextField> inbound;
    private TitledItem<RDTextField> inSTA;
    private HorizontalSeparator sep1;
    private TitledItem<RDTextField> outbound;
    private TitledItem<RDTextField> outSTD;
    private HorizontalSeparator sep2;
    private TitledItem<RDTextField> returnCode;
    private TitledItem<RDTextField> returnSTA;
    private TitledItem<RDNumericStepper> returnDays;
    private TextLabel days;
    private TitledItem<RDTextField> kitchenReadyTime;
    private TitledItem<RDSearchComboBox> labelSearch;
    private TitledItem<RDSearchComboBox> sealLabelSearch;
    private TitledItem<RDSearchComboBox> spmlLabelSearch;
    private TitledItem<RDSearchComboBox> deliverySlipSearch;
    private TitledItem<RDTextField> defaultGate;
    private TitledItem<RDComboBox> haulType;
    private TitledItem<RDComboBox> category;
    private TitledItem<RDSearchTextField2<RestaurantComplete>> restaurant;
    private TitledItem<RDTextField> shortCode;
    private FlightTypeE currentType = null;

    public FlightDataDetailsPanel(RowEditor<FlightScheduleLight> rowEditor, RDProvider provider) {
        super(rowEditor, provider);
        RestaurantDeliverySettingsComplete restaurantSetting = (RestaurantDeliverySettingsComplete)NodeToolkit.getAffixClass(RestaurantDeliverySettingsComplete.class).getValue();
        this.setCustomLayouter(new FlightScheduleDetailsLayout());
        this.flightType = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(FlightTypesConverter.class)), "", TitledItem.TitledItemOrientation.EAST);
        this.flightType.setIgnorePrefWidth(true);
        this.inbound = new TitledItem<RDTextField>(new RDTextField(provider), "", TitledItem.TitledItemOrientation.NORTH);
        this.inSTA = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.DAYTIME), "", TitledItem.TitledItemOrientation.NORTH);
        this.sep1 = new HorizontalSeparator();
        this.outbound = new TitledItem<RDTextField>(new RDTextField(provider), "", TitledItem.TitledItemOrientation.NORTH);
        this.outSTD = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.DAYTIME), "", TitledItem.TitledItemOrientation.NORTH);
        this.sep2 = new HorizontalSeparator();
        this.returnCode = new TitledItem<RDTextField>(new RDTextField(provider), "", TitledItem.TitledItemOrientation.NORTH);
        this.returnSTA = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.DAYTIME), "", TitledItem.TitledItemOrientation.NORTH);
        this.kitchenReadyTime = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.DAYTIME), Words.KITCHEN_READY_TIME, TitledItem.TitledItemOrientation.NORTH);
        this.returnDays = new TitledItem<RDNumericStepper>(new RDNumericStepper(provider, 3), "", TitledItem.TitledItemOrientation.NORTH);
        this.returnDays.getElement().setMinValue(0);
        this.days = new TextLabel(Words.DAYS);
        this.defaultGate = new TitledItem<RDTextField>(new RDTextField(provider), Words.GATE, TitledItem.TitledItemOrientation.NORTH);
        this.shortCode = new TitledItem<RDTextField>(new RDTextField(provider), Words.SHORT_CODE, TitledItem.TitledItemOrientation.NORTH);
        this.deliverySlipSearch = new TitledItem<RDSearchComboBox>(new RDSearchComboBox(provider, RDSearchComboBox.BoxSearchTypes.DELIVERYSLIP), Words.DELIVERY_SLIP_LAYOUT, TitledItem.TitledItemOrientation.NORTH);
        this.labelSearch = new TitledItem<RDSearchComboBox>(new RDSearchComboBox(provider, RDSearchComboBox.BoxSearchTypes.LABELLAYOUT), Words.LABEL_LAYOUT, TitledItem.TitledItemOrientation.NORTH);
        this.sealLabelSearch = new TitledItem<RDSearchComboBox>(new RDSearchComboBox(provider, RDSearchComboBox.BoxSearchTypes.LABELLAYOUT), Words.SEAL_LABEL_LAYOUT, TitledItem.TitledItemOrientation.NORTH);
        this.spmlLabelSearch = new TitledItem<RDSearchComboBox>(new RDSearchComboBox(provider, RDSearchComboBox.BoxSearchTypes.SPMLLABELLAYOUT), Words.SPML_LABEL_LAYOUT, TitledItem.TitledItemOrientation.NORTH);
        this.haulType = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(HaulTypeConverter.class), true), Words.HAUL_TYPE, TitledItem.TitledItemOrientation.NORTH);
        this.category = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(FlightCategoryConverter.class), true), Words.CATEGORY, TitledItem.TitledItemOrientation.NORTH);
        if (restaurantSetting != null && Boolean.TRUE.equals(restaurantSetting.getUseRestaurantDelivery())) {
            this.restaurant = new TitledItem(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.RESTAURANT, true), Words.RESTAURANT, TitledItem.TitledItemOrientation.NORTH);
        }
        this.inbound.setTitleText(Words.INBOUND);
        this.inSTA.setTitleText(Words.STA);
        this.outbound.setTitleText(Words.OUTBOUND);
        this.outSTD.setTitleText(Words.STD);
        this.returnCode.setTitleText(Words.INBOUND);
        this.returnSTA.setTitleText(Words.STA);
        this.returnDays.setTitleText(Words.DAYS);
        this.setTitleText(Words.FLIGHT_DETAILS);
        this.inbound.getFader().setPermanent(true);
        this.inSTA.getFader().setPermanent(true);
        this.returnCode.getFader().setPermanent(true);
        this.returnSTA.getFader().setPermanent(true);
        this.returnDays.getFader().setPermanent(true);
        this.days.getFader().setPermanent(true);
        this.kitchenReadyTime.getFader().setPermanent(true);
        this.inbound.setProgress(0.0f);
        this.inSTA.setProgress(0.0f);
        this.returnCode.setProgress(0.0f);
        this.returnDays.setProgress(0.0f);
        this.returnSTA.setProgress(0.0f);
        this.days.setProgress(0.0f);
        this.defaultGate.setProgress(1.0f);
        this.kitchenReadyTime.setProgress(1.0f);
        this.addToView(this.flightType);
        this.addToView(this.inbound);
        this.addToView(this.inSTA);
        this.addToView(this.sep1);
        this.addToView(this.outbound);
        this.addToView(this.outSTD);
        this.addToView(this.sep2);
        this.addToView(this.returnCode);
        this.addToView(this.returnSTA);
        this.addToView(this.returnDays);
        this.addToView(this.days);
        this.addToView(this.shape);
        this.addToView(this.defaultGate);
        this.addToView(this.deliverySlipSearch);
        this.addToView(this.labelSearch);
        this.addToView(this.sealLabelSearch);
        this.addToView(this.spmlLabelSearch);
        this.addToView(this.haulType);
        this.addToView(this.category);
        this.addToView(this.shortCode);
        this.addToView(this.kitchenReadyTime);
        if (this.restaurant != null) {
            this.addToView(this.restaurant);
        }
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return FlightScheduleComplete_.state;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.node = node;
        this.isNodeInit = true;
        if (node.getChildNamed(FlightScheduleComplete_.flightType).getValue() == null) {
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            node.getChildNamed(FlightScheduleComplete_.flightType).setValue((Object)settings.getDefaultFlightScheduleType(), 0L);
        }
        this.inbound.getElement().setNode(node.getChildNamed(FlightScheduleLight_.inboundCode));
        this.inSTA.getElement().setNode(node.getChildNamed(FlightScheduleLight_.sta));
        this.outbound.getElement().setNode(node.getChildNamed(FlightScheduleLight_.outboundCode));
        this.outSTD.getElement().setNode(node.getChildNamed(FlightScheduleLight_.std));
        this.returnCode.getElement().setNode(node.getChildNamed(FlightScheduleLight_.inboundCode));
        this.returnSTA.getElement().setNode(node.getChildNamed(FlightScheduleLight_.sta));
        this.returnDays.getElement().setNode(node.getChildNamed(FlightScheduleComplete_.returnDay));
        this.deliverySlipSearch.getElement().setNode(node.getChildNamed(FlightScheduleComplete_.deliverySlipSheet));
        this.labelSearch.getElement().setNode(node.getChildNamed(FlightScheduleComplete_.labelLayout));
        this.sealLabelSearch.getElement().setNode(node.getChildNamed(FlightScheduleComplete_.sealLabelLayout));
        this.spmlLabelSearch.getElement().setNode(node.getChildNamed(FlightScheduleComplete_.specialMealLayout));
        this.flightType.getElement().refreshPossibleValues(NodeToolkit.getAffixList(FlightTypeE.class));
        this.flightType.getElement().setNode(node.getChildNamed(FlightScheduleLight_.flightType));
        this.defaultGate.getElement().setNode(node.getChildNamed(FlightScheduleComplete_.defaultGate));
        this.category.getElement().refreshPossibleValues(NodeToolkit.getAffixClass(FlightCategoryComplete.class));
        this.category.getElement().setNode(node.getChildNamed(FlightScheduleLight_.category));
        this.haulType.getElement().refreshPossibleValues(NodeToolkit.getAffixList(HaulTypeComplete.class));
        this.haulType.getElement().setNode(node.getChildNamed(FlightScheduleComplete_.haulType));
        node.getChildNamed(FlightScheduleLight_.flightType).addNodeListener((NodeListener)this);
        this.shortCode.getElement().setNode(node.getChildNamed(FlightScheduleLight_.shortFlightCode));
        this.showType((FlightTypeE)node.getChildNamed(FlightScheduleLight_.flightType).getValue());
        this.kitchenReadyTime.getElement().setNode(node.getChildNamed(FlightScheduleLight_.kitchenReadyTime));
        if (this.restaurant != null) {
            this.restaurant.getElement().setNode(node.getChildNamed(FlightScheduleComplete_.restaurant));
        }
        this.isNodeInit = false;
    }

    private void showType(FlightTypeE nT) {
        if (nT != this.currentType && nT != null) {
            switch (nT) {
                case TRANSIT: {
                    this.inbound.fadeIn();
                    this.inSTA.fadeIn();
                    this.returnCode.fadeOut(false);
                    this.returnDays.fadeOut(false);
                    this.days.fadeOut(false);
                    this.returnSTA.fadeOut(false);
                    this.node.getChildNamed(FlightScheduleComplete_.returnDay).setValue((Object)0, 0L);
                    break;
                }
                case RETURN: {
                    this.returnCode.fadeIn();
                    this.returnDays.fadeIn();
                    this.days.fadeIn();
                    this.returnSTA.fadeIn();
                    this.inbound.fadeOut(false);
                    this.inSTA.fadeOut(false);
                }
            }
            this.currentType = nT;
            if (!this.isNodeInit) {
                this.editor.focusCycleChanged(null);
            }
        }
        this.editor.validate();
    }

    @Override
    public void resetParagraph() {
        Node dto = this.editor.getModel().getNode();
        this.inbound.getElement().setNode(dto.getChildNamed(FlightScheduleComplete_.inboundCode));
        this.inSTA.getElement().setNode(dto.getChildNamed(FlightScheduleComplete_.sta));
        this.outbound.getElement().setNode(dto.getChildNamed(FlightScheduleComplete_.outboundCode));
        this.outSTD.getElement().setNode(dto.getChildNamed(FlightScheduleComplete_.std));
        this.returnCode.getElement().setNode(dto.getChildNamed(FlightScheduleComplete_.outboundCode));
        this.returnSTA.getElement().setNode(dto.getChildNamed(FlightScheduleComplete_.sta));
        this.returnDays.getElement().setNode(dto.getChildNamed(FlightScheduleComplete_.returnDay));
        this.defaultGate.getElement().setNode(dto.getChildNamed(FlightScheduleComplete_.defaultGate));
        this.labelSearch.getElement().setNode(dto.getChildNamed(FlightScheduleComplete_.labelLayout));
        this.sealLabelSearch.getElement().setNode(dto.getChildNamed(FlightScheduleComplete_.sealLabelLayout));
        this.spmlLabelSearch.getElement().setNode(dto.getChildNamed(FlightScheduleComplete_.specialMealLayout));
        this.deliverySlipSearch.getElement().setNode(dto.getChildNamed(FlightScheduleComplete_.deliverySlipSheet));
        this.kitchenReadyTime.getElement().setNode(dto.getChildNamed(FlightScheduleLight_.kitchenReadyTime));
        if (this.restaurant != null) {
            this.restaurant.getElement().setNode(dto.getChildNamed(FlightScheduleComplete_.restaurant));
        }
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (this.currentType == null) {
            this.currentType = FlightTypeE.RETURN;
        }
        switch (this.currentType) {
            case TRANSIT: {
                if (this.inbound.getElement().isWritable() && this.inbound.getElement().isFieldValid() && (this.inbound.getElement().getNode().getValue() == null || this.inbound.getElement().getNode().getValue().equals(""))) {
                    this.inbound.getElement().setInvalid();
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_INBOUND_CODE));
                }
                if (this.inbound.getElement().isWritable() && this.inbound.getElement().isFieldValid() && (this.inbound.getElement().getNode().getValue() == null || !this.inbound.getElement().getNode().getValue().toString().equals(this.inbound.getElement().getNode().getValue().toString().trim()))) {
                    String string = this.inbound.getElement().getNode().getValue() != null ? this.inbound.getElement().getNode().getValue().toString().trim() : "";
                    this.inbound.getElement().getNode().setValue((Object)string, 0L);
                }
                if (this.inSTA.getElement().isWritable() && this.inSTA.getElement().getNode().getValue() == null) {
                    this.inSTA.getElement().setInvalid();
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_STA));
                }
                if (this.outbound.getElement().isWritable() && (this.outbound.getElement().getNode().getValue() == null || this.outbound.getElement().getNode().getValue().equals(""))) {
                    this.outbound.getElement().setInvalid();
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_OUTBOUND_CODE));
                }
                if (this.outbound.getElement().isWritable() && this.outbound.getElement().isFieldValid() && this.outbound.getElement().getNode() != null && (this.outbound.getElement().getNode().getValue() == null || !this.outbound.getElement().getNode().getValue().toString().equals(this.outbound.getElement().getNode().getValue().toString().trim()))) {
                    this.outbound.getElement().getNode().setValue((Object)this.outbound.getElement().getNode().getValue().toString().trim(), 0L);
                }
                if (!this.outSTD.getElement().isWritable() || this.outSTD.getElement().getNode().getValue() != null) break;
                this.outSTD.getElement().setInvalid();
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_STD));
                break;
            }
            case RETURN: {
                Object value;
                if (this.inbound.getElement().isWritable() && this.inbound.getElement().isFieldValid() && (this.inbound.getElement().getNode().getValue() == null || !this.inbound.getElement().getNode().getValue().toString().equals(this.inbound.getElement().getNode().getValue().toString().trim())) && (value = this.inbound.getElement().getNode().getValue()) != null) {
                    this.inbound.getElement().getNode().setValue((Object)value.toString().trim(), 0L);
                }
                if (this.outbound.getElement().isWritable() && (this.outbound.getElement().getNode().getValue() == null || this.outbound.getElement().getNode().getValue().equals(""))) {
                    this.outbound.getElement().setInvalid();
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_OUTBOUND_CODE));
                }
                if (this.outbound.getElement().isWritable() && this.outbound.getElement().isFieldValid() && (this.outbound.getElement().getNode().getValue() == null || !this.outbound.getElement().getNode().getValue().toString().equals(this.outbound.getElement().getNode().getValue().toString().trim()))) {
                    if (this.outbound.getElement().getNode().getValue() == null) {
                        this.outbound.getElement().getNode().setValue((Object)"", 0L);
                    } else {
                        this.outbound.getElement().getNode().setValue((Object)this.outbound.getElement().getNode().getValue().toString().trim(), 0L);
                    }
                }
                if (this.outSTD.getElement().isWritable() && this.outSTD.getElement().getNode().getValue() == null) {
                    this.outSTD.getElement().setInvalid();
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_STD));
                }
                if (this.returnCode.getElement().isWritable() && (this.returnCode.getElement().getNode().getValue() == null || this.returnCode.getElement().getNode().getValue().equals(""))) {
                    this.returnCode.getElement().setInvalid();
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_RETURN_CODE));
                }
                if (!this.returnSTA.getElement().isWritable() || this.returnSTA.getElement().getNode().getValue() != null) break;
                this.returnSTA.getElement().setInvalid();
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_STA));
            }
        }
        if (this.node.getChildNamed(FlightScheduleComplete_.haulType).getValue() == null && settings.getForceHaulType().booleanValue()) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_HAULTYPE));
            this.haulType.getElement().setInvalid();
        }
        if (this.node.getChildNamed(FlightScheduleComplete_.category).getValue() == null && settings.getForceFlightCategory().booleanValue()) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_CATEGORY));
            this.category.getElement().setInvalid();
        }
        return validationObjects;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.flightType);
        if (this.currentType != null) {
            switch (this.currentType) {
                case TRANSIT: {
                    CheckedListAdder.addToList(focusList, this.inbound);
                    CheckedListAdder.addToList(focusList, this.inSTA);
                    CheckedListAdder.addToList(focusList, this.outbound);
                    CheckedListAdder.addToList(focusList, this.outSTD);
                    break;
                }
                case RETURN: {
                    CheckedListAdder.addToList(focusList, this.outbound);
                    CheckedListAdder.addToList(focusList, this.outSTD);
                    CheckedListAdder.addToList(focusList, this.returnCode);
                    CheckedListAdder.addToList(focusList, this.returnSTA);
                    CheckedListAdder.addToList(focusList, this.returnDays);
                }
            }
        }
        CheckedListAdder.addToList(focusList, this.kitchenReadyTime);
        CheckedListAdder.addToList(focusList, this.shortCode);
        CheckedListAdder.addToList(focusList, this.defaultGate);
        CheckedListAdder.addToList(focusList, this.labelSearch);
        CheckedListAdder.addToList(focusList, this.sealLabelSearch);
        CheckedListAdder.addToList(focusList, this.spmlLabelSearch);
        CheckedListAdder.addToList(focusList, this.deliverySlipSearch);
        CheckedListAdder.addToList(focusList, this.haulType);
        CheckedListAdder.addToList(focusList, this.category);
        CheckedListAdder.addToList(focusList, this.restaurant);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.node != null && this.node.getChildNamed(FlightScheduleLight_.flightType) != null) {
            this.node.getChildNamed(FlightScheduleLight_.flightType).removeNodeListener((NodeListener)this);
        }
        this.flightType.kill();
        this.inbound.kill();
        this.inSTA.kill();
        this.sep1.kill();
        this.outbound.kill();
        this.outSTD.kill();
        this.sep2.kill();
        this.returnCode.kill();
        this.returnSTA.kill();
        this.returnDays.kill();
        this.days.kill();
        this.defaultGate.kill();
        this.shortCode.kill();
        this.kitchenReadyTime.kill();
        this.labelSearch.kill();
        this.sealLabelSearch.kill();
        this.spmlLabelSearch.kill();
        this.deliverySlipSearch.kill();
        this.category.kill();
        this.haulType.kill();
        if (this.restaurant != null) {
            this.restaurant.kill();
            this.restaurant = null;
        }
        this.kitchenReadyTime = null;
        this.labelSearch = null;
        this.sealLabelSearch = null;
        this.spmlLabelSearch = null;
        this.deliverySlipSearch = null;
        this.flightType = null;
        this.inbound = null;
        this.inSTA = null;
        this.sep1 = null;
        this.outbound = null;
        this.outSTD = null;
        this.sep2 = null;
        this.returnCode = null;
        this.shortCode = null;
        this.returnSTA = null;
        this.returnDays = null;
        this.days = null;
        this.defaultGate = null;
        this.haulType = null;
        this.category = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isDraft = this.isStateDraft();
        boolean enabled = isEnabled && isDraft;
        super.setEnabled(enabled);
        this.flightType.setEnabled(enabled);
        this.inbound.setEnabled(enabled);
        this.inSTA.setEnabled(enabled);
        this.outbound.setEnabled(enabled);
        this.outSTD.setEnabled(enabled);
        this.returnCode.setEnabled(enabled);
        this.returnSTA.setEnabled(enabled);
        this.returnDays.setEnabled(enabled);
        this.days.setEnabled(enabled);
        this.sep1.setEnabled(enabled);
        this.sep2.setEnabled(enabled);
        this.defaultGate.setEnabled(enabled);
        this.labelSearch.setEnabled(enabled);
        this.sealLabelSearch.setEnabled(enabled);
        this.spmlLabelSearch.setEnabled(enabled);
        this.deliverySlipSearch.setEnabled(enabled);
        this.haulType.setEnabled(enabled);
        this.category.setEnabled(enabled);
        this.shortCode.setEnabled(enabled);
        this.kitchenReadyTime.setEnabled(enabled);
        if (this.restaurant != null) {
            this.restaurant.setEnabled(enabled);
        }
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void childAdded(Node<?> source, Node<?> child) {
    }

    @Override
    public void childRemoved(Node<?> source, Node<?> child) {
    }

    @Override
    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public void valueChanged(Node<?> node) {
        if (node.getName().equals(FlightScheduleLight_.flightType.getFieldName())) {
            this.showType((FlightTypeE)node.getValue());
        }
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public boolean isSwingOnly() {
        return true;
    }

    private class FlightScheduleDetailsLayout
    extends DefaultLayout {
        private FlightScheduleDetailsLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            int cy = 0;
            FlightDataDetailsPanel.this.flightType.setLocation(FlightDataDetailsPanel.this.horizontalBorder, FlightDataDetailsPanel.this.verticalBorder);
            FlightDataDetailsPanel.this.flightType.setSize(w - 2 * FlightDataDetailsPanel.this.horizontalBorder, (int)FlightDataDetailsPanel.this.flightType.getPreferredSize().getHeight());
            if (FlightDataDetailsPanel.this.currentType != null) {
                switch (FlightDataDetailsPanel.this.currentType) {
                    case TRANSIT: {
                        FlightDataDetailsPanel.this.inbound.setLocation(FlightDataDetailsPanel.this.horizontalBorder, FlightDataDetailsPanel.this.flightType.getY() + FlightDataDetailsPanel.this.flightType.getHeight() + FlightDataDetailsPanel.this.inner_verticalBorder);
                        FlightDataDetailsPanel.this.inbound.setSize((w - (2 * FlightDataDetailsPanel.this.horizontalBorder + FlightDataDetailsPanel.this.inner_horizontalBorder)) / 2, (int)FlightDataDetailsPanel.this.inbound.getPreferredSize().getHeight());
                        FlightDataDetailsPanel.this.inSTA.setLocation(FlightDataDetailsPanel.this.inbound.getX() + FlightDataDetailsPanel.this.inbound.getWidth() + FlightDataDetailsPanel.this.inner_horizontalBorder, FlightDataDetailsPanel.this.inbound.getY());
                        FlightDataDetailsPanel.this.inSTA.setSize((int)FlightDataDetailsPanel.this.inSTA.getPreferredSize().getWidth(), (int)FlightDataDetailsPanel.this.inSTA.getPreferredSize().getHeight());
                        FlightDataDetailsPanel.this.sep1.setLocation(0, FlightDataDetailsPanel.this.inSTA.getY() + FlightDataDetailsPanel.this.inSTA.getHeight() + FlightDataDetailsPanel.this.inner_verticalBorder);
                        FlightDataDetailsPanel.this.sep1.setSize(w, (int)FlightDataDetailsPanel.this.sep1.getPreferredSize().getHeight());
                        FlightDataDetailsPanel.this.outbound.setLocation(FlightDataDetailsPanel.this.horizontalBorder, FlightDataDetailsPanel.this.sep1.getY() + FlightDataDetailsPanel.this.sep1.getHeight() + FlightDataDetailsPanel.this.inner_verticalBorder);
                        FlightDataDetailsPanel.this.outbound.setSize(FlightDataDetailsPanel.this.inbound.getSize());
                        FlightDataDetailsPanel.this.outSTD.setLocation(FlightDataDetailsPanel.this.inSTA.getX(), FlightDataDetailsPanel.this.outbound.getY());
                        FlightDataDetailsPanel.this.outSTD.setSize((int)FlightDataDetailsPanel.this.outSTD.getPreferredSize().getWidth(), (int)FlightDataDetailsPanel.this.outSTD.getPreferredSize().getHeight());
                        cy = FlightDataDetailsPanel.this.outSTD.getY() + FlightDataDetailsPanel.this.outSTD.getHeight() + FlightDataDetailsPanel.this.inner_verticalBorder;
                        break;
                    }
                    case RETURN: {
                        FlightDataDetailsPanel.this.outbound.setLocation(FlightDataDetailsPanel.this.horizontalBorder, FlightDataDetailsPanel.this.flightType.getY() + FlightDataDetailsPanel.this.flightType.getHeight() + FlightDataDetailsPanel.this.inner_verticalBorder);
                        FlightDataDetailsPanel.this.outbound.setSize((w - (2 * FlightDataDetailsPanel.this.horizontalBorder + FlightDataDetailsPanel.this.inner_horizontalBorder)) / 2, (int)FlightDataDetailsPanel.this.outbound.getPreferredSize().getHeight());
                        FlightDataDetailsPanel.this.outSTD.setLocation(FlightDataDetailsPanel.this.outbound.getX() + FlightDataDetailsPanel.this.outbound.getWidth() + FlightDataDetailsPanel.this.inner_horizontalBorder, FlightDataDetailsPanel.this.outbound.getY());
                        FlightDataDetailsPanel.this.outSTD.setSize((int)FlightDataDetailsPanel.this.outSTD.getPreferredSize().getWidth(), (int)FlightDataDetailsPanel.this.outSTD.getPreferredSize().getHeight());
                        FlightDataDetailsPanel.this.sep1.setLocation(0, FlightDataDetailsPanel.this.outSTD.getY() + FlightDataDetailsPanel.this.outSTD.getHeight() + FlightDataDetailsPanel.this.inner_verticalBorder);
                        FlightDataDetailsPanel.this.sep1.setSize(w, (int)FlightDataDetailsPanel.this.sep1.getPreferredSize().getHeight());
                        FlightDataDetailsPanel.this.returnCode.setLocation(FlightDataDetailsPanel.this.outbound.getX(), FlightDataDetailsPanel.this.sep1.getY() + FlightDataDetailsPanel.this.sep1.getHeight() + FlightDataDetailsPanel.this.inner_verticalBorder);
                        FlightDataDetailsPanel.this.returnCode.setSize(FlightDataDetailsPanel.this.outbound.getSize());
                        FlightDataDetailsPanel.this.returnSTA.setLocation(FlightDataDetailsPanel.this.outSTD.getX(), FlightDataDetailsPanel.this.returnCode.getY());
                        FlightDataDetailsPanel.this.returnSTA.setSize((int)FlightDataDetailsPanel.this.returnSTA.getPreferredSize().getWidth(), (int)FlightDataDetailsPanel.this.returnSTA.getPreferredSize().getHeight());
                        FlightDataDetailsPanel.this.returnDays.setLocation(FlightDataDetailsPanel.this.returnCode.getX(), FlightDataDetailsPanel.this.returnCode.getY() + FlightDataDetailsPanel.this.returnCode.getHeight() + FlightDataDetailsPanel.this.inner_verticalBorder);
                        FlightDataDetailsPanel.this.returnDays.setSize(FlightDataDetailsPanel.this.outbound.getSize());
                        FlightDataDetailsPanel.this.days.setLocation(FlightDataDetailsPanel.this.returnDays.getX() + FlightDataDetailsPanel.this.returnDays.getWidth() + FlightDataDetailsPanel.this.inner_horizontalBorder / 4, (int)((double)(FlightDataDetailsPanel.this.returnDays.getY() + FlightDataDetailsPanel.this.returnDays.getHeight()) - FlightDataDetailsPanel.this.days.getPreferredSize().getHeight()));
                        FlightDataDetailsPanel.this.days.setSize(FlightDataDetailsPanel.this.days.getPreferredSize());
                        cy = FlightDataDetailsPanel.this.returnDays.getY() + FlightDataDetailsPanel.this.returnDays.getHeight() + FlightDataDetailsPanel.this.inner_verticalBorder;
                    }
                }
            }
            FlightDataDetailsPanel.this.kitchenReadyTime.setLocation(FlightDataDetailsPanel.this.horizontalBorder, cy + FlightDataDetailsPanel.this.verticalBorder);
            FlightDataDetailsPanel.this.kitchenReadyTime.setSize(FlightDataDetailsPanel.this.kitchenReadyTime.getPreferredSize());
            FlightDataDetailsPanel.this.sep2.setLocation(0, FlightDataDetailsPanel.this.kitchenReadyTime.getY() + FlightDataDetailsPanel.this.kitchenReadyTime.getHeight() + FlightDataDetailsPanel.this.inner_verticalBorder);
            FlightDataDetailsPanel.this.sep2.setSize(parent.getWidth(), (int)FlightDataDetailsPanel.this.sep2.getPreferredSize().getHeight());
            FlightDataDetailsPanel.this.shortCode.setLocation(FlightDataDetailsPanel.this.horizontalBorder, FlightDataDetailsPanel.this.sep2.getY() + FlightDataDetailsPanel.this.sep2.getHeight() + FlightDataDetailsPanel.this.verticalBorder);
            FlightDataDetailsPanel.this.shortCode.setSize(parent.getWidth() - 2 * FlightDataDetailsPanel.this.horizontalBorder, (int)FlightDataDetailsPanel.this.shortCode.getPreferredSize().getHeight());
            FlightDataDetailsPanel.this.defaultGate.setLocation(FlightDataDetailsPanel.this.horizontalBorder, FlightDataDetailsPanel.this.shortCode.getY() + FlightDataDetailsPanel.this.shortCode.getHeight() + FlightDataDetailsPanel.this.verticalBorder);
            FlightDataDetailsPanel.this.defaultGate.setSize(parent.getWidth() - 2 * FlightDataDetailsPanel.this.horizontalBorder, (int)FlightDataDetailsPanel.this.defaultGate.getPreferredSize().getHeight());
            FlightDataDetailsPanel.this.labelSearch.setLocation(FlightDataDetailsPanel.this.horizontalBorder, FlightDataDetailsPanel.this.defaultGate.getY() + FlightDataDetailsPanel.this.defaultGate.getHeight() + FlightDataDetailsPanel.this.verticalBorder);
            FlightDataDetailsPanel.this.labelSearch.setSize(parent.getWidth() - 2 * FlightDataDetailsPanel.this.horizontalBorder, (int)FlightDataDetailsPanel.this.labelSearch.getPreferredSize().getHeight());
            FlightDataDetailsPanel.this.sealLabelSearch.setLocation(FlightDataDetailsPanel.this.horizontalBorder, FlightDataDetailsPanel.this.labelSearch.getY() + FlightDataDetailsPanel.this.labelSearch.getHeight() + FlightDataDetailsPanel.this.verticalBorder);
            FlightDataDetailsPanel.this.sealLabelSearch.setSize(parent.getWidth() - 2 * FlightDataDetailsPanel.this.horizontalBorder, (int)FlightDataDetailsPanel.this.sealLabelSearch.getPreferredSize().getHeight());
            FlightDataDetailsPanel.this.spmlLabelSearch.setLocation(FlightDataDetailsPanel.this.horizontalBorder, FlightDataDetailsPanel.this.sealLabelSearch.getY() + FlightDataDetailsPanel.this.sealLabelSearch.getHeight() + FlightDataDetailsPanel.this.verticalBorder);
            FlightDataDetailsPanel.this.spmlLabelSearch.setSize(parent.getWidth() - 2 * FlightDataDetailsPanel.this.horizontalBorder, (int)FlightDataDetailsPanel.this.spmlLabelSearch.getPreferredSize().getHeight());
            FlightDataDetailsPanel.this.deliverySlipSearch.setLocation(FlightDataDetailsPanel.this.horizontalBorder, FlightDataDetailsPanel.this.spmlLabelSearch.getY() + FlightDataDetailsPanel.this.spmlLabelSearch.getHeight() + FlightDataDetailsPanel.this.verticalBorder);
            FlightDataDetailsPanel.this.deliverySlipSearch.setSize(parent.getWidth() - 2 * FlightDataDetailsPanel.this.horizontalBorder, (int)FlightDataDetailsPanel.this.deliverySlipSearch.getPreferredSize().getHeight());
            FlightDataDetailsPanel.this.haulType.setLocation(FlightDataDetailsPanel.this.horizontalBorder, FlightDataDetailsPanel.this.deliverySlipSearch.getY() + FlightDataDetailsPanel.this.deliverySlipSearch.getHeight() + FlightDataDetailsPanel.this.verticalBorder);
            FlightDataDetailsPanel.this.haulType.setSize(parent.getWidth() - 2 * FlightDataDetailsPanel.this.horizontalBorder, (int)FlightDataDetailsPanel.this.haulType.getPreferredSize().getHeight());
            FlightDataDetailsPanel.this.category.setLocation(FlightDataDetailsPanel.this.horizontalBorder, FlightDataDetailsPanel.this.haulType.getY() + FlightDataDetailsPanel.this.haulType.getHeight() + FlightDataDetailsPanel.this.verticalBorder);
            FlightDataDetailsPanel.this.category.setSize(parent.getWidth() - 2 * FlightDataDetailsPanel.this.horizontalBorder, (int)FlightDataDetailsPanel.this.category.getPreferredSize().getHeight());
            if (FlightDataDetailsPanel.this.restaurant != null) {
                FlightDataDetailsPanel.this.restaurant.setLocation(FlightDataDetailsPanel.this.horizontalBorder, FlightDataDetailsPanel.this.category.getY() + FlightDataDetailsPanel.this.category.getHeight() + FlightDataDetailsPanel.this.verticalBorder);
                FlightDataDetailsPanel.this.restaurant.setSize(parent.getWidth() - 2 * FlightDataDetailsPanel.this.horizontalBorder, (int)FlightDataDetailsPanel.this.restaurant.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int currentX = 200;
            int currentY = FlightDataDetailsPanel.this.getTitleHeight();
            currentY += FlightDataDetailsPanel.this.verticalBorder;
            currentY = (int)((double)currentY + FlightDataDetailsPanel.this.flightType.getPreferredSize().getHeight());
            currentY += FlightDataDetailsPanel.this.inner_verticalBorder;
            FlightTypeE usedType = FlightDataDetailsPanel.this.currentType;
            if (usedType == null) {
                usedType = FlightTypeE.RETURN;
            }
            switch (usedType) {
                case TRANSIT: {
                    currentY = (int)((double)currentY + FlightDataDetailsPanel.this.inbound.getPreferredSize().getHeight());
                    currentY += FlightDataDetailsPanel.this.inner_verticalBorder;
                    currentY = (int)((double)currentY + FlightDataDetailsPanel.this.sep1.getPreferredSize().getHeight());
                    currentY += FlightDataDetailsPanel.this.inner_verticalBorder;
                    currentY = (int)((double)currentY + FlightDataDetailsPanel.this.outbound.getPreferredSize().getHeight());
                    currentY += FlightDataDetailsPanel.this.inner_verticalBorder;
                    break;
                }
                case RETURN: {
                    currentY = (int)((double)currentY + FlightDataDetailsPanel.this.outbound.getPreferredSize().getHeight());
                    currentY += FlightDataDetailsPanel.this.inner_verticalBorder;
                    currentY = (int)((double)currentY + FlightDataDetailsPanel.this.sep1.getPreferredSize().getHeight());
                    currentY += FlightDataDetailsPanel.this.inner_verticalBorder;
                    currentY = (int)((double)currentY + FlightDataDetailsPanel.this.returnCode.getPreferredSize().getHeight());
                    currentY += FlightDataDetailsPanel.this.inner_verticalBorder;
                    currentY = (int)((double)currentY + FlightDataDetailsPanel.this.returnDays.getPreferredSize().getHeight());
                    currentY += FlightDataDetailsPanel.this.inner_verticalBorder;
                }
            }
            currentY = (int)((double)currentY + FlightDataDetailsPanel.this.kitchenReadyTime.getPreferredSize().getHeight());
            currentY += FlightDataDetailsPanel.this.inner_verticalBorder;
            currentY = (int)((double)currentY + FlightDataDetailsPanel.this.sep2.getPreferredSize().getHeight());
            currentY += FlightDataDetailsPanel.this.verticalBorder;
            currentY = (int)((double)currentY + FlightDataDetailsPanel.this.shortCode.getPreferredSize().getHeight());
            currentY += FlightDataDetailsPanel.this.verticalBorder;
            currentY = (int)((double)currentY + FlightDataDetailsPanel.this.defaultGate.getPreferredSize().getHeight());
            currentY += FlightDataDetailsPanel.this.verticalBorder;
            currentY = (int)((double)currentY + FlightDataDetailsPanel.this.labelSearch.getPreferredSize().getHeight());
            currentY += FlightDataDetailsPanel.this.verticalBorder;
            currentX = (int)((double)currentX + FlightDataDetailsPanel.this.sealLabelSearch.getPreferredSize().getHeight());
            currentY += FlightDataDetailsPanel.this.verticalBorder;
            currentY = (int)((double)currentY + FlightDataDetailsPanel.this.spmlLabelSearch.getPreferredSize().getHeight());
            currentY += FlightDataDetailsPanel.this.verticalBorder;
            currentY = (int)((double)currentY + FlightDataDetailsPanel.this.deliverySlipSearch.getPreferredSize().getHeight());
            currentY += FlightDataDetailsPanel.this.verticalBorder;
            currentY = (int)((double)currentY + FlightDataDetailsPanel.this.haulType.getPreferredSize().getHeight());
            currentY += FlightDataDetailsPanel.this.verticalBorder;
            currentY = (int)((double)currentY + FlightDataDetailsPanel.this.category.getPreferredSize().getHeight());
            currentY += FlightDataDetailsPanel.this.verticalBorder;
            if (FlightDataDetailsPanel.this.restaurant != null) {
                currentY = (int)((double)currentY + FlightDataDetailsPanel.this.restaurant.getPreferredSize().getHeight());
                currentY += FlightDataDetailsPanel.this.verticalBorder;
            }
            currentY += FlightDataDetailsPanel.this.inner_verticalBorder;
            currentY += FlightDataDetailsPanel.this.verticalBorder;
            currentY += FlightDataDetailsPanel.this.verticalBorder;
            return new Dimension(currentX, currentY += FlightDataDetailsPanel.this.verticalBorder);
        }
    }
}

