/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flightschedule.details.utils;

import ch.icit.pegasus.client.converter.AMenuTypeConverter;
import ch.icit.pegasus.client.converter.PriceConverter1;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDInputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.SPMLFixPriceComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.SPMLFixPriceComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SPMLFixPricePopupInsert
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    private RDProvider provider;
    private Table2 table;
    private boolean isDeletable;
    private boolean isEditable;

    public SPMLFixPricePopupInsert(Node spmls, RDProvider provider, boolean isEditable) {
        this.provider = provider;
        this.isDeletable = provider.isWritable("spmls");
        this.isEditable = isEditable;
        this.table = new Table2(true, Words.ADD, false, false);
        this.table.setProvider(provider);
        this.table.setUseWriteAccessRight(true);
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                SPMLFixPricePopupInsert.this.validate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                SPMLFixPriceComplete p = new SPMLFixPriceComplete();
                p.setClientOId(Long.valueOf(ADTO.getNextId()));
                PriceComplete pc = new PriceComplete();
                pc.setClientOId(Long.valueOf(pc.getNextId()));
                pc.setPrice(Double.valueOf(0.0));
                pc.setCurrency(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency());
                p.setPrice(pc);
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, true, false);
                SPMLFixPricePopupInsert.this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
                SPMLFixPricePopupInsert.this.validate();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.SPML, null, null, null, "", 40, 40, 40));
        int tw = 2 * this.table.getCellPadding() + InputComboBox.getPreferredWidth(this, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE) + this.table.getInnerCellPadding() + CheckBox.getPreferredWidth();
        columns.add(new TableColumnInfo(Words.COST, null, null, null, "", tw, tw, tw));
        tw = 2 * this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.table.getModel().setNode(spmls);
        this.table.setEditable(isEditable);
        this.setLayout(new Layout());
        this.add(this.table);
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.table.getFocusComponents();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isInnerComponent(Component c) {
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            if (!pp.isInnerComponent(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.table.kill();
        this.table = null;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private RDComboBox spml;
        private RDInputComboBox price;
        private RDCheckBox checkBox;
        private TextLabel defaultPrice;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            if (SPMLFixPricePopupInsert.this.isDeletable) {
                this.delete = new DeleteButton();
                this.delete.addButtonListener(this);
            }
            this.spml = new RDComboBox(SPMLFixPricePopupInsert.this.provider, ConverterRegistry.getConverter(AMenuTypeConverter.class));
            this.spml.setOverrideName("spmls");
            this.spml.refreshPossibleValues(NodeToolkit.getAffixList(SpecialMenuTypeComplete.class));
            this.spml.setNode(m.getNode().getChildNamed(SPMLFixPriceComplete_.code));
            this.checkBox = new RDCheckBox(SPMLFixPricePopupInsert.this.provider);
            this.checkBox.setOverrideName("spmls");
            this.checkBox.setNode(this.model.getNode().getChildNamed(SPMLFixPriceComplete_.overridePrice));
            this.model.getNode().getChildNamed(SPMLFixPriceComplete_.overridePrice).addNodeListener((NodeListener)this);
            this.setLayout(new Layout());
            this.add(this.spml);
            this.add(this.checkBox);
            if (this.delete != null) {
                this.add(this.delete);
            }
            this.ensureCheckState();
        }

        private void ensureCheckState() {
            boolean checked = (Boolean)this.model.getNode().getChildNamed(SPMLFixPriceComplete_.overridePrice).getValue();
            if (checked) {
                if (this.defaultPrice != null) {
                    this.defaultPrice.fadeOut(true);
                    this.defaultPrice = null;
                }
                if (this.price == null) {
                    this.price = new RDInputComboBox(SPMLFixPricePopupInsert.this.provider, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
                    this.price.setOverrideName("spmls");
                    this.price.setNode(this.model.getNode().getChildNamed(SPMLFixPriceComplete_.price));
                    this.price.setProgress(0.0f);
                    this.add(this.price);
                }
                this.price.fadeIn();
            } else {
                if (this.price != null) {
                    this.price.fadeOut(true);
                    this.price = null;
                }
                if (this.defaultPrice == null) {
                    this.defaultPrice = new TextLabel(this.model.getNode().getParent().getParent().getChildNamed(SPMLFixPriceComplete_.price), ConverterRegistry.getConverter(PriceConverter1.class));
                    this.defaultPrice.setProgress(0.0f);
                    this.add(this.defaultPrice);
                }
                this.defaultPrice.fadeIn();
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.model.getNode().getChildNamed(SPMLFixPriceComplete_.overridePrice).removeNodeListener((NodeListener)this);
            this.spml.kill();
            this.spml = null;
            if (this.price != null) {
                this.price.kill();
            }
            this.price = null;
            if (this.defaultPrice != null) {
                this.defaultPrice.kill();
            }
            this.defaultPrice = null;
            this.checkBox.kill();
            this.checkBox = null;
            if (this.delete != null) {
                this.delete.kill();
            }
            this.delete = null;
        }

        @Override
        public boolean isInnerComponent(Component c) {
            if (this.spml.getEditor() != null) {
                if (((ComboBox)this.spml.getEditor()).getCurrentPopUp() != null) {
                    for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                        if (!currentC.equals(((ComboBox)this.spml.getEditor()).getCurrentPopUp())) continue;
                        return true;
                    }
                }
            } else {
                if (c == this.spml) {
                    return true;
                }
                if (c == this.price) {
                    return true;
                }
                if (c == this.defaultPrice) {
                    return true;
                }
                if (c == this.checkBox) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.spml);
            CheckedListAdder.addToList(a, this.checkBox);
            CheckedListAdder.addToList(a, this.price);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new DtoField[]{SPMLFixPriceComplete_.code, SpecialMenuTypeComplete_.code}).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(new DtoField[]{SPMLFixPriceComplete_.price, PriceComplete_.price}).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled && SPMLFixPricePopupInsert.this.isEditable;
            super.setEnabled(b);
            this.spml.setEnabled(b);
            if (this.price != null) {
                this.price.setEnabled(b);
            }
            if (this.defaultPrice != null) {
                this.defaultPrice.setEnabled(b);
            }
            this.checkBox.setEnabled(b);
            if (this.delete != null) {
                this.delete.setEnabled(b);
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        public void valueChanged(Node<?> node) {
            this.ensureCheckState();
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.spml.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.spml.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.spml.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.spml.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.checkBox.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.checkBox.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.checkBox.setSize(TableRowImpl.this.checkBox.getPreferredSize());
                if (TableRowImpl.this.price != null) {
                    TableRowImpl.this.price.setLocation(TableRowImpl.this.checkBox.getX() + TableRowImpl.this.checkBox.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.price.setSize(w - (2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding() + TableRowImpl.this.checkBox.getWidth()), (int)TableRowImpl.this.price.getPreferredSize().getHeight());
                }
                if (TableRowImpl.this.defaultPrice != null) {
                    TableRowImpl.this.defaultPrice.setLocation(TableRowImpl.this.checkBox.getX() + TableRowImpl.this.checkBox.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.defaultPrice.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.defaultPrice.setSize(w - (2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding() + TableRowImpl.this.checkBox.getWidth()), (int)TableRowImpl.this.defaultPrice.getPreferredSize().getHeight());
                }
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.setControlsX(currentX);
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, (int)SPMLFixPricePopupInsert.this.table.getPreferredSize().getHeight());
        }

        @Override
        public void layoutContainer(Container parent) {
            SPMLFixPricePopupInsert.this.table.setLocation(0, 0);
            SPMLFixPricePopupInsert.this.table.setSize(parent.getWidth(), parent.getHeight());
        }
    }
}

