/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.gudd.pickup.utils;

import ch.icit.pegasus.client.gui.modules.gudd.pickup.utils.CustomerOrderItem;
import ch.icit.pegasus.client.gui.modules.gudd.pickup.utils.PickUpPanel;
import ch.icit.pegasus.client.gui.modules.gudd.pickup.utils.PickUpStatePanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.server.core.dtos.jimdo.JimdoOrderImportComplete;
import ch.icit.pegasus.server.core.dtos.jimdo.JimdoOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;

public class CustomerOrderPanel
extends PickUpStatePanel {
    private final JimdoOrderImportComplete order;
    private final Color innerBackground;
    private List<CustomerOrderItem> items = new ArrayList<CustomerOrderItem>();
    private JPanel innerPanel;

    public CustomerOrderPanel(PickUpPanel panel, JimdoOrderImportComplete order) {
        super(panel);
        this.order = order;
        this.setLayout(new Layout());
        this.innerBackground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_background_color"));
        this.innerPanel = new JPanel(){

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(CustomerOrderPanel.this.innerBackground);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                Dimension preferredSize = this.getPreferredSize();
                Dimension layoutArea = CustomerOrderPanel.this.getLayoutArea();
                float wScale = (float)(layoutArea.getWidth() / preferredSize.getWidth());
                float hScale = (float)(layoutArea.getHeight() / preferredSize.getHeight());
                float usedScale = wScale <= hScale ? wScale : hScale;
                g2.scale(usedScale, usedScale);
                this.paintChildren(g2);
                g2.scale(-usedScale, -usedScale);
            }
        };
        this.innerPanel.setLayout(new InnerLayout());
        for (JimdoOrderPositionComplete position : order.getOrderPositions()) {
            DefaultSkins skin = this.getSkin(position);
            CustomerOrderItem item = new CustomerOrderItem(position, skin);
            this.innerPanel.add(item);
            this.items.add(item);
        }
        Collections.sort(this.items, (o1, o2) -> {
            JimdoOrderPositionComplete p1 = o1.getOrderPosition();
            JimdoOrderPositionComplete p2 = o2.getOrderPosition();
            return this.getSkinType(p1) - this.getSkinType(p2);
        });
        this.add(this.innerPanel);
    }

    private Dimension getLayoutArea() {
        return this.getSize();
    }

    private DefaultSkins getSkin(JimdoOrderPositionComplete position) {
        ProductVariantLight variant = position.getResolvedProduct().getCurrentVariant();
        if (variant.getProductType() == null) {
            return DefaultSkins.PickUpMealCold;
        }
        if (variant.getProductType().getCode().equals("Meal")) {
            if (position.getVariantType().equals("hot")) {
                return DefaultSkins.PickUpMealHot;
            }
            return DefaultSkins.PickUpMealCold;
        }
        if (variant.getProductType().getCode().equals("Beverage")) {
            return DefaultSkins.PickUpBeverage;
        }
        if (variant.getProductType().getCode().equals("Cutlery")) {
            return DefaultSkins.PickUpCutlery;
        }
        return DefaultSkins.PickUpMealCold;
    }

    private int getSkinType(JimdoOrderPositionComplete position) {
        ProductVariantLight variant = position.getResolvedProduct().getCurrentVariant();
        if (variant.getProductType() == null) {
            return 2;
        }
        if (variant.getProductType().getCode().equals("Meal")) {
            if (position.getVariantType().equals("hot")) {
                return 1;
            }
            return 2;
        }
        if (variant.getProductType().getCode().equals("Beverage")) {
            return 3;
        }
        if (variant.getProductType().getCode().equals("Cutlery")) {
            return 4;
        }
        return 2;
    }

    @Override
    public List<Component> getFocusComponents() {
        return new ArrayList<Component>();
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    private class InnerLayout
    extends DefaultLayout {
        private InnerLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int rowHeight = 150;
            int columnWidth = 600;
            int border = 20;
            int itemCount = CustomerOrderPanel.this.items.size();
            int columns = (int)Math.floor(Math.sqrt(itemCount));
            if (columns * columns < CustomerOrderPanel.this.items.size()) {
                ++columns;
            }
            int currentItem = 0;
            int currentY = 0;
            int currentX = 0;
            int maxHeight = 0;
            int maxWidth = 0;
            for (CustomerOrderItem item : CustomerOrderPanel.this.items) {
                ++currentItem;
                if ((currentY += rowHeight) > maxHeight) {
                    maxHeight = currentY;
                }
                currentY += border;
                if (currentX + columnWidth > maxWidth) {
                    maxWidth = currentX + columnWidth;
                }
                if (currentItem < columns) continue;
                currentY = 0;
                currentX += columnWidth + border;
                currentItem = 0;
            }
            return new Dimension(maxWidth, maxHeight);
        }

        @Override
        public void layoutContainer(Container parent) {
            int rowHeight = 150;
            int columnWidth = 600;
            int border = 20;
            int itemCount = CustomerOrderPanel.this.items.size();
            int columns = (int)Math.floor(Math.sqrt(itemCount));
            if (columns * columns < CustomerOrderPanel.this.items.size()) {
                ++columns;
            }
            int currentItem = 0;
            int currentY = 0;
            int currentX = 0;
            for (CustomerOrderItem item : CustomerOrderPanel.this.items) {
                item.setLocation(currentX, currentY);
                item.setSize(columnWidth, rowHeight);
                currentY += rowHeight;
                currentY += border;
                if (++currentItem < columns) continue;
                currentY = 0;
                currentX += columnWidth + border;
                currentItem = 0;
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            float hScale;
            Dimension preferredSize = CustomerOrderPanel.this.innerPanel.getPreferredSize();
            Dimension layoutArea = parent.getSize();
            float wScale = (float)(layoutArea.getWidth() / preferredSize.getWidth());
            float usedScale = wScale <= (hScale = (float)(layoutArea.getHeight() / preferredSize.getHeight())) ? wScale : hScale;
            int w = (int)(preferredSize.getWidth() * (double)usedScale);
            int h = (int)(preferredSize.getHeight() * (double)usedScale);
            CustomerOrderPanel.this.innerPanel.setSize(w, h);
            CustomerOrderPanel.this.innerPanel.setLocation((parent.getWidth() - w) / 2, (parent.getHeight() - h) / 2);
        }
    }
}

