/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.gudd.pickup.utils;

import ch.icit.pegasus.client.gui.modules.gudd.pickup.utils.PickUpPanel;
import ch.icit.pegasus.client.gui.modules.gudd.pickup.utils.SimpleMessagePanel;
import ch.icit.pegasus.client.gui.utils.animators.AlphaFader;
import ch.icit.pegasus.client.gui.utils.animators.PulseFader;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.jimdo.JimdoOrderImportComplete;
import ch.icit.pegasus.server.core.util.StringUtil;
import java.awt.Component;
import java.util.Map;

public class LoadingPanel
extends SimpleMessagePanel
implements RemoteLoader {
    private final PickUpPanel panel;
    private final PickUpPanel.PickUpPanelState nextState;
    private final PickUpPanel.PickUpPanelState errorState;
    private JimdoOrderImportComplete order;

    public LoadingPanel(PickUpPanel panel, String text, PickUpPanel.PickUpPanelState nextState, PickUpPanel.PickUpPanelState errorState, JimdoOrderImportComplete order) {
        super(panel, DefaultSkins.PickUpLoad, text);
        this.panel = panel;
        this.nextState = nextState;
        this.errorState = errorState;
        this.order = order;
    }

    @Override
    public AlphaFader<JPanelFadable> createAlphaFader() {
        return new PulseFader<JPanelFadable>(this);
    }

    public void remoteObjectLoaded(Node<?> node) {
        Map value = (Map)node.getValue();
        Map.Entry next = value.entrySet().iterator().next();
        JimdoOrderImportComplete newOrder = (JimdoOrderImportComplete)next.getKey();
        String message = (String)next.getValue();
        if (newOrder != null) {
            this.order = newOrder;
        }
        if (StringUtil.isBlank((String)message)) {
            this.panel.stateChanged(this.nextState, this.order);
        } else {
            this.panel.showQuestion(this.nextState, this.order, message, this.errorState);
        }
    }

    public void errorOccurred(ClientException exception) {
        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)this);
        this.switchTargetState(this.errorState);
    }

    private void switchTargetState(PickUpPanel.PickUpPanelState errorState) {
        this.panel.stateChanged(errorState, this.order);
    }
}

