/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.gudd.pickup.utils;

import ch.icit.pegasus.client.gui.modules.gudd.pickup.GuddPickUpModule;
import ch.icit.pegasus.client.gui.modules.gudd.pickup.utils.CustomerOrderPanel;
import ch.icit.pegasus.client.gui.modules.gudd.pickup.utils.GoodByePanel;
import ch.icit.pegasus.client.gui.modules.gudd.pickup.utils.LoadingPanel;
import ch.icit.pegasus.client.gui.modules.gudd.pickup.utils.PickUpStatePanel;
import ch.icit.pegasus.client.gui.modules.gudd.pickup.utils.QuestionPanel;
import ch.icit.pegasus.client.gui.modules.gudd.pickup.utils.ScanmePanel;
import ch.icit.pegasus.client.gui.modules.gudd.pickup.utils.ScannerField;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.JimdoServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.server.core.dtos.jimdo.JimdoOrderImportComplete;
import ch.icit.pegasus.server.core.dtos.jimdo.JimdoOrderImportReference;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.utils.BarcodeType;
import java.awt.Component;
import java.awt.Container;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import javax.swing.Timer;

public class PickUpPanel {
    private final GuddPickUpModule module;
    private TextButton cancel;
    private TextButton delivered;
    private ScannerField scannerField;
    private TextLabel selectedOrder;
    private JimdoOrderImportComplete currentOrder;
    private long animationTime = -1L;
    private PickUpStatePanel currentPanel;
    private PickUpPanelState state;
    private Timer timer;
    private long minLoadingTime = 2000L;

    public PickUpPanel(GuddPickUpModule module) {
        this.module = module;
        this.cancel = new TextButton("Cancel");
        this.cancel.addButtonListener((source, x, y) -> this.stateChanged(PickUpPanelState.SCAN_CUSTOMER, null));
        this.delivered = new TextButton("Delivered");
        this.delivered.addButtonListener((source, x, y) -> this.markOrderAsDelivered(this.currentOrder));
        this.scannerField = new ScannerField(this);
        this.selectedOrder = new TextLabel();
        this.selectedOrder.setNormalFont(this.selectedOrder.getFont().deriveFont(52.0f));
        this.showHud(false);
        this.cancel.getFader().setPermanent(true);
        this.delivered.getFader().setPermanent(true);
        this.selectedOrder.getFader().setPermanent(true);
        this.cancel.getFader().setProgress(0.0f);
        this.delivered.getFader().setProgress(0.0f);
        this.selectedOrder.getFader().setProgress(0.0f);
        module.add(this.selectedOrder);
        module.add(this.scannerField);
        module.add(this.cancel);
        module.add(this.delivered);
    }

    public void showHud(boolean show) {
        if (show) {
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
        } else if (this.timer == null) {
            this.timer = new Timer(200, e -> this.scannerField.requestFocusInWindowNow());
            this.timer.setRepeats(true);
            this.timer.start();
        }
    }

    public void setEnabled(boolean isEnabled) {
        if (this.currentPanel != null) {
            this.currentPanel.setEnabled(isEnabled);
        }
        if (this.cancel != null) {
            this.cancel.setEnabled(isEnabled);
        }
        if (this.delivered != null) {
            this.delivered.setEnabled(isEnabled);
        }
        if (this.scannerField != null) {
            this.scannerField.setEnabled(isEnabled);
        }
        if (this.selectedOrder != null) {
            this.selectedOrder.setEnabled(isEnabled);
        }
    }

    public void kill() {
        if (this.currentPanel != null) {
            this.currentPanel.kill();
            this.currentPanel = null;
        }
        if (this.cancel != null) {
            this.cancel.kill();
            this.cancel = null;
        }
        if (this.delivered != null) {
            this.delivered.kill();
            this.delivered = null;
        }
        if (this.scannerField != null) {
            this.scannerField.kill();
            this.scannerField = null;
        }
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        if (this.selectedOrder != null) {
            this.selectedOrder.kill();
            this.selectedOrder = null;
        }
    }

    public void showQuestion(PickUpPanelState nextState, JimdoOrderImportComplete order, String message, PickUpPanelState errorState) {
        QuestionPanel questionPanel = new QuestionPanel(this, message, nextState, errorState, order);
        this.stateChanged(PickUpPanelState.QUESTION, order, questionPanel);
    }

    public void doDeliverAnyway(JimdoOrderImportComplete order, PickUpPanelState nextState, PickUpPanelState errorState) {
        final LoadingPanel loadingPanel = new LoadingPanel(this, "", nextState, errorState, this.currentOrder);
        this.stateChanged(PickUpPanelState.LOADING, this.currentOrder, loadingPanel);
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                long startTime = System.currentTimeMillis();
                JimdoOrderImportComplete order = (JimdoOrderImportComplete)((JimdoServiceManager)ServiceManagerRegistry.getService(JimdoServiceManager.class)).moveOrderToToday(new JimdoOrderImportReference(PickUpPanel.this.currentOrder.getId())).getValue();
                while (System.currentTimeMillis() - startTime < PickUpPanel.this.minLoadingTime) {
                    Thread.sleep(PickUpPanel.this.minLoadingTime / 4L);
                }
                HashMap<JimdoOrderImportComplete, String> map = new HashMap<JimdoOrderImportComplete, String>();
                map.put(order, "");
                ViewNode n = new ViewNode("index");
                n.setValue(map, 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return loadingPanel;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void markOrderAsDelivered(final JimdoOrderImportComplete currentOrder) {
        final LoadingPanel loadingPanel = new LoadingPanel(this, "", PickUpPanelState.SHOW_GOOD_BYE, PickUpPanelState.SHOW_CUSTOMER_ORDER, currentOrder);
        this.stateChanged(PickUpPanelState.LOADING, currentOrder, loadingPanel);
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                long startTime = System.currentTimeMillis();
                JimdoOrderImportComplete order = (JimdoOrderImportComplete)((JimdoServiceManager)ServiceManagerRegistry.getService(JimdoServiceManager.class)).orderDelivered(new JimdoOrderImportReference(currentOrder.getId())).getValue();
                while (System.currentTimeMillis() - startTime < PickUpPanel.this.minLoadingTime) {
                    Thread.sleep(PickUpPanel.this.minLoadingTime / 4L);
                }
                HashMap<JimdoOrderImportComplete, String> map = new HashMap<JimdoOrderImportComplete, String>();
                map.put(order, "");
                ViewNode n = new ViewNode("index");
                n.setValue(map, 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return loadingPanel;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void barcodeReady(BarcodeType barcodeType, final String barcode) {
        this.scannerField.resetText();
        switch (this.state) {
            case QUESTION: {
                QuestionPanel questionPanel = (QuestionPanel)this.currentPanel;
                if (barcode.equals("www.gudd.ch do it")) {
                    questionPanel.answerYes();
                    break;
                }
                if (barcode.equals("www.gudd.ch dont do it")) {
                    questionPanel.answerNo();
                    break;
                }
                InnerPopupFactory.showErrorDialog("Please scan YES/NO QR Code", (Component)this.scannerField);
                break;
            }
            case SCAN_CUSTOMER: 
            case SHOW_GOOD_BYE: {
                final LoadingPanel loadingPanel = new LoadingPanel(this, "", PickUpPanelState.SHOW_CUSTOMER_ORDER, PickUpPanelState.SCAN_CUSTOMER, null);
                this.stateChanged(PickUpPanelState.LOADING, null, loadingPanel);
                ThreadSafeExecutable run = new ThreadSafeExecutable(){

                    @Override
                    public Node<?> loadData() throws Exception {
                        long startTime = System.currentTimeMillis();
                        JimdoOrderImportComplete qrCode = (JimdoOrderImportComplete)((JimdoServiceManager)ServiceManagerRegistry.getService(JimdoServiceManager.class)).getOrderForQRCode(barcode).getValue();
                        while (System.currentTimeMillis() - startTime < PickUpPanel.this.minLoadingTime) {
                            Thread.sleep(PickUpPanel.this.minLoadingTime / 4L);
                        }
                        if (Boolean.TRUE.equals(qrCode.getDelivered())) {
                            throw new ClientGetFromServerException("Order " + qrCode.getExternalOrderNumber() + " is already picked up");
                        }
                        PeriodComplete today = new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()));
                        if (!today.within(qrCode.getDeliveryDate()).booleanValue()) {
                            if (today.getStartDate().after(qrCode.getDeliveryDate())) {
                                SimpleDateFormat format = new SimpleDateFormat("dd.MM.YYYY");
                                throw new ClientGetFromServerException("Order " + qrCode.getExternalOrderNumber() + " has expired at " + format.format(qrCode.getDeliveryDate()));
                            }
                            SimpleDateFormat format = new SimpleDateFormat("dd.MM.YYYY");
                            String message = "Order " + qrCode.getExternalOrderNumber() + " is for " + format.format(qrCode.getDeliveryDate()) + "<br/>Deliver anyway?";
                            HashMap<JimdoOrderImportComplete, String> map = new HashMap<JimdoOrderImportComplete, String>();
                            map.put(qrCode, message);
                            ViewNode n = new ViewNode("index");
                            n.setValue(map, 0L);
                            return n;
                        }
                        HashMap<JimdoOrderImportComplete, String> map = new HashMap<JimdoOrderImportComplete, String>();
                        map.put(qrCode, "");
                        ViewNode n = new ViewNode("index");
                        n.setValue(map, 0L);
                        return n;
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return loadingPanel;
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
                break;
            }
            case SHOW_CUSTOMER_ORDER: {
                if (!"www.gudd.ch delivered".equals(barcode)) break;
                this.markOrderAsDelivered(this.currentOrder);
            }
        }
    }

    public PickUpStatePanel stateChanged(PickUpPanelState newState, JimdoOrderImportComplete newOrder) {
        return this.stateChanged(newState, newOrder, null);
    }

    public PickUpStatePanel stateChanged(PickUpPanelState newState, JimdoOrderImportComplete newOrder, PickUpStatePanel loadingPanel) {
        if (this.state == newState) {
            return this.currentPanel;
        }
        if (this.currentPanel != null) {
            this.currentPanel.deregister();
            this.currentPanel.fadeOut(true, this.animationTime);
        }
        long usedAnimationTime = this.animationTime;
        this.currentOrder = newOrder;
        this.state = newState;
        switch (newState) {
            case SCAN_CUSTOMER: {
                this.currentPanel = new ScanmePanel(this);
                if (this.cancel.getFader().isFaded()) {
                    this.cancel.fadeOut(false, this.animationTime);
                }
                if (this.delivered.getFader().isFaded()) {
                    this.delivered.fadeOut(false, this.animationTime);
                }
                if (this.selectedOrder.getFader().isFaded()) {
                    this.selectedOrder.fadeOut(false, this.animationTime);
                }
                this.selectedOrder.setText("");
                break;
            }
            case SHOW_CUSTOMER_ORDER: {
                this.currentPanel = new CustomerOrderPanel(this, newOrder);
                if (!this.cancel.getFader().isFaded()) {
                    this.cancel.fadeIn(this.animationTime);
                }
                if (!this.delivered.getFader().isFaded()) {
                    this.delivered.fadeIn(this.animationTime);
                }
                if (!this.selectedOrder.getFader().isFaded()) {
                    this.selectedOrder.fadeIn(this.animationTime);
                }
                this.selectedOrder.setText("Order Number " + this.currentOrder.getExternalOrderNumber());
                break;
            }
            case SHOW_GOOD_BYE: {
                this.currentPanel = new GoodByePanel(this);
                if (this.cancel.getFader().isFaded()) {
                    this.cancel.fadeOut(false, this.animationTime);
                }
                if (this.delivered.getFader().isFaded()) {
                    this.delivered.fadeOut(false, this.animationTime);
                }
                if (this.selectedOrder.getFader().isFaded()) {
                    this.selectedOrder.fadeOut(false, this.animationTime);
                }
                this.selectedOrder.setText("");
                break;
            }
            case LOADING: {
                this.currentPanel = loadingPanel;
                usedAnimationTime = 750L;
                if (this.cancel.getFader().isFaded()) {
                    this.cancel.fadeOut(false, this.animationTime);
                }
                if (this.delivered.getFader().isFaded()) {
                    this.delivered.fadeOut(false, this.animationTime);
                }
                if (this.selectedOrder.getFader().isFaded()) {
                    this.selectedOrder.fadeOut(false, this.animationTime);
                }
                this.selectedOrder.setText("");
                break;
            }
            case QUESTION: {
                this.currentPanel = loadingPanel;
                usedAnimationTime = 750L;
                if (this.cancel.getFader().isFaded()) {
                    this.cancel.fadeOut(false, this.animationTime);
                }
                if (this.delivered.getFader().isFaded()) {
                    this.delivered.fadeOut(false, this.animationTime);
                }
                if (!this.selectedOrder.getFader().isFaded()) break;
                this.selectedOrder.fadeOut(false, this.animationTime);
            }
        }
        this.module.add(this.currentPanel);
        this.module.invalidate();
        this.module.revalidate();
        this.currentPanel.fadeIn(usedAnimationTime);
        return this.currentPanel;
    }

    public void layoutContainer(Container parent) {
        this.selectedOrder.setLocation(20, 20);
        this.selectedOrder.setSize(this.selectedOrder.getPreferredSize());
        if (this.currentPanel != null) {
            this.currentPanel.setLocation(0, this.selectedOrder.getY() + this.selectedOrder.getHeight());
            this.currentPanel.setSize(parent.getWidth(), (int)((double)parent.getHeight() - (20.0 + this.cancel.getPreferredSize().getHeight() + (double)this.currentPanel.getY())));
        }
        this.cancel.setLocation(10, (int)((double)parent.getHeight() - (10.0 + this.cancel.getPreferredSize().getHeight())));
        this.cancel.setSize(this.cancel.getPreferredSize());
        this.delivered.setLocation((int)((double)parent.getWidth() - (10.0 + this.delivered.getPreferredSize().getWidth())), (int)((double)parent.getHeight() - (20.0 + this.delivered.getPreferredSize().getHeight())));
        this.delivered.setSize(this.delivered.getPreferredSize());
        this.scannerField.setLocation(this.cancel.getX() + this.cancel.getWidth() + 10, this.cancel.getY());
        this.scannerField.setSize(parent.getWidth() - (this.scannerField.getX() + 10 + 10 + this.delivered.getWidth()), (int)this.scannerField.getPreferredSize().getHeight());
    }

    public static enum PickUpPanelState {
        SCAN_CUSTOMER,
        SHOW_CUSTOMER_ORDER,
        SHOW_GOOD_BYE,
        LOADING,
        QUESTION;

    }
}

