/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.handlingcosts.details;

import ch.icit.pegasus.client.converter.AbsolutPriceConverter;
import ch.icit.pegasus.client.converter.ModificationStateEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.product.details.utils.CopyHandlingVariantPopup;
import ch.icit.pegasus.client.gui.screentemplates.details.AVariantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.AddButton;
import ch.icit.pegasus.client.gui.utils.buttons.ArrowButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.validator.ValidationUtil;
import ch.icit.pegasus.server.core.dtos.ADTO_;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete_;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostVariantComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostVariantComplete_;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostVariantReference;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.HandlingCostAccess;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class VariantDetailsPanel
extends AVariantDetailsPanel<HandlingCostComplete> {
    private static final long serialVersionUID = 1L;

    public VariantDetailsPanel(RowEditor<HandlingCostComplete> editor, RDProvider provider) {
        super((RowEditor)editor, provider);
    }

    @Override
    public Class getCommittingClass(Node<?> node) {
        if (node.getValue(HandlingCostVariantComplete.class) != null) {
            return HandlingCostVariantComplete.class;
        }
        throw new RuntimeException(Phrase.getPhrase((String)Phrase.CURRENT_VARIANT_TYPE_IS_NOT_SUPPORTED, (Object[])new Object[]{node.getValue()}));
    }

    @Override
    public List<TableColumnInfo> getColumns() {
        boolean isSolarCompany = Boolean.TRUE.equals(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCompany().getSolarCompanyType());
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int tw = 2 * this.table.getCellPadding() + DateChooser.getPreferredWidth(this, false);
        int tw2 = 2 * this.table.getCellPadding() + DateChooser.getPreferredWidth(this, true);
        columns.add(new TableColumnInfo(Words.FROM, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.TO, null, null, null, "", tw2, tw2, tw2));
        columns.add(new TableColumnInfo(Words.STATE, null, null, null, "", 5, 5, 5));
        if (isSolarCompany) {
            columns.add(new TableColumnInfo(Words.PRICE, null, null, null, "", 5, 5, 5));
        }
        tw = 3 * this.table.getCellPadding() + ArrowButton.getPreferredWidth() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        if (isSolarCompany) {
            ((TableColumnInfo)columns.get(2)).setxExpand(0.5);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.5);
            ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        } else {
            ((TableColumnInfo)columns.get(2)).setxExpand(1.0);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        }
        return columns;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        this.table.updateOrder();
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        boolean isSolarCompany = Boolean.TRUE.equals(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCompany().getSolarCompanyType());
        if (isSolarCompany) {
            long lastDate = -1L;
            long firstDate = -1L;
            boolean b = false;
            for (Table2RowPanel p : this.table.getRows()) {
                o.addAll(((TableRowImpl)p).validateRow());
                HandlingCostVariantComplete v = (HandlingCostVariantComplete)p.getModel().getNode().getValue(HandlingCostVariantComplete.class);
                Date s = (Date)p.getModel().getNode().getChildNamed(new DtoField[]{HandlingCostVariantComplete_.validityPeriod, PeriodComplete_.startDate}).getValue();
                Date e = (Date)p.getModel().getNode().getChildNamed(new DtoField[]{HandlingCostVariantComplete_.validityPeriod, PeriodComplete_.endDate}).getValue();
                PeriodComplete pc = new PeriodComplete(s, e);
                Date d = pc.getStartDate();
                if (lastDate != -1L) {
                    if (lastDate + 1L != d.getTime()) {
                        b = true;
                    }
                } else {
                    firstDate = d.getTime();
                }
                d = pc.getEndDate();
                lastDate = d.getTime();
            }
            if (b) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_THE_GIVEN_VARIANTS_AREN_T_OVERLAPPING_AVOID_GABS));
            }
            if (this.table.getRowCount() == 0) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ATLEAST_ONE_VARIANT_IS_NEEDED));
            }
            if (o.isEmpty()) {
                this.editor.getModel().getNode().getChildNamed(HandlingCostComplete_.period).setValue((Object)new PeriodComplete(new Date(firstDate), new Date(lastDate)), 0L);
            }
            return o;
        }
        Date t = new PeriodComplete((Date)this.editor.getModel().getNode().getChildNamed(new DtoField[]{HandlingCostComplete_.period, PeriodComplete_.startDate}).getValue(), null).getStartDate();
        long toDay = new PeriodComplete(null, new Date(System.currentTimeMillis())).getEndDate().getTime();
        long lastDate = t.getTime();
        --lastDate;
        boolean b = false;
        for (Table2RowPanel p : this.table.getRows()) {
            PeriodComplete pc;
            Date d;
            o.addAll(((TableRowImpl)p).validateRow());
            HandlingCostVariantComplete v = (HandlingCostVariantComplete)p.getModel().getNode().getValue(HandlingCostVariantComplete.class);
            Date s = (Date)p.getModel().getNode().getChildNamed(new DtoField[]{HandlingCostVariantComplete_.validityPeriod, PeriodComplete_.startDate}).getValue();
            Date e = (Date)p.getModel().getNode().getChildNamed(new DtoField[]{HandlingCostVariantComplete_.validityPeriod, PeriodComplete_.endDate}).getValue();
            if (v.getValidityPeriod().getEndDate().getTime() > toDay && e.getTime() < toDay && p.getModel().getNode().getChildNamed(RecipeVariantLight_.state).getValue() == ModificationStateE.ACCEPTED && !this.provider.isWritable(HandlingCostAccess.EDIT_OLD_VARIANT)) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.THE_END_DATE_ACCEPTED_VARIANT_MUST_BE_AFTER_TODAY));
            }
            if (lastDate + 1L != (d = (pc = new PeriodComplete(s, e)).getStartDate()).getTime()) {
                b = true;
            }
            d = pc.getEndDate();
            lastDate = d.getTime();
        }
        Date d = (Date)this.editor.getModel().getNode().getChildNamed(new DtoField[]{HandlingCostComplete_.period, PeriodComplete_.endDate}).getValue();
        long endDate = new PeriodComplete(null, d).getEndDate().getTime();
        if (lastDate != endDate) {
            b = true;
        }
        if (b) {
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_THE_GIVEN_VARIANTS_AREN_T_OVERLAPPING_AVOID_GABS));
        }
        if (this.table.getRowCount() == 0) {
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ATLEAST_ONE_VARIANT_IS_NEEDED));
        }
        return o;
    }

    @Override
    public Table2RowPanel getTableRow(Table2RowModel model) {
        return new TableRowImpl(model);
    }

    @Override
    public boolean isVariantParent(Node<?> node) {
        return node.getValue() instanceof HandlingCostComplete;
    }

    @Override
    public void reloadVariant(final Node n, final Table2RowPanel panel) {
        this.editor.showCommittingAnimation(Words.REFRESH_DATA);
        this.editor.setEnabled(false);
        HandlingCostVariantComplete c = (HandlingCostVariantComplete)n.getValue(HandlingCostVariantComplete.class);
        if (c == null) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    Node node = n;
                    SystemSettingsComplete s = (SystemSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached().getValue();
                    HandlingCostVariantComplete cc = (HandlingCostVariantComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getHandlingCostVariant(new HandlingCostVariantReference(((HandlingCostVariantComplete)n.getValue(HandlingCostVariantComplete.class)).getId())).getValue();
                    n.removeExistingValues();
                    n.setValue((Object)cc, 0L);
                    return n;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            VariantDetailsPanel.this.updatePanels(node, panel);
                            VariantDetailsPanel.this.editor.createFocusCycle();
                        }

                        public void errorOccurred(ClientException exception) {
                            VariantDetailsPanel.this.errorOccurred(exception);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            HandlingCostVariantComplete variant = (HandlingCostVariantComplete)n.getValue(HandlingCostVariantComplete.class);
            n.removeExistingValues();
            n.setValue((Object)variant, 0L);
            n.updateNode();
            this.updatePanels(n, panel);
        }
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private RDDateChooser startDate;
        private RDDateChooser endDate;
        private TextLabel state;
        private TextLabel price;
        private AddButton cloneButton;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setSelectable(true);
            boolean isSolarCompany = Boolean.TRUE.equals(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCompany().getSolarCompanyType());
            boolean isAccepted = m.getNode().getChildNamed(HandlingCostVariantComplete_.state).getValue() == ModificationStateE.ACCEPTED;
            this.startDate = new RDDateChooser(VariantDetailsPanel.this.provider);
            this.startDate.setOverrideName(HandlingCostAccess.EDIT_VARIANT);
            this.startDate.setNode(m.getNode().getChildNamed(new DtoField[]{HandlingCostVariantComplete_.validityPeriod, PeriodComplete_.startDate}));
            this.endDate = new RDDateChooser(VariantDetailsPanel.this.provider);
            this.endDate.setOverrideName(HandlingCostAccess.EDIT_VARIANT);
            this.endDate.setCheckBoxEnabled();
            this.endDate.setNode(m.getNode().getChildNamed(new DtoField[]{HandlingCostVariantComplete_.validityPeriod, PeriodComplete_.endDate}));
            this.state = new TextLabel(m.getNode().getChildNamed(HandlingCostVariantComplete_.state), ConverterRegistry.getConverter(ModificationStateEConverter.class));
            if (isSolarCompany) {
                this.price = new TextLabel(m.getNode().getChildNamed(HandlingCostVariantComplete_.quantity), ConverterRegistry.getConverter(AbsolutPriceConverter.class));
            }
            boolean isDeletable = VariantDetailsPanel.this.provider.isWritable(HandlingCostAccess.REMOVE_VARIANT) && m.getNode().getChildNamed(HandlingCostVariantComplete_.state).getValue() != ModificationStateE.ACCEPTED;
            boolean isAddable = VariantDetailsPanel.this.provider.isWritable(HandlingCostAccess.ADD_VARIANT);
            if (isDeletable && !isAccepted) {
                this.delete = new DeleteButton();
            }
            if (isAddable && m.getNode().getChildNamed(ADTO_.id).getValue() != null) {
                this.cloneButton = new AddButton();
            }
            if (this.delete != null) {
                this.delete.addButtonListener(this);
            }
            if (this.cloneButton != null) {
                this.cloneButton.addButtonListener(this);
            }
            this.setLayout(new Layout());
            this.add(this.startDate);
            this.add(this.endDate);
            this.add(this.state);
            if (this.cloneButton != null) {
                this.add(this.cloneButton);
            }
            if (this.delete != null) {
                this.add(this.delete);
            }
            if (this.price != null) {
                this.add(this.price);
            }
        }

        @Override
        public Color getRowColor(Table2RowPanel p) {
            boolean isNew = this.model.getNode().getChildNamed(DtoFieldConstants.NEW_ONE) != null;
            Color background = null;
            if (isNew) {
                background = new Color(100, 100, 100);
                return background;
            }
            return this.model.getParentModel().getTable().getColor4Index(this.colorIndex);
        }

        @Override
        public void updateRow(Node<?> node) {
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.startDate.kill();
            this.endDate.kill();
            this.state.kill();
            if (this.delete != null) {
                this.delete.kill();
            }
            if (this.cloneButton != null) {
                this.cloneButton.kill();
            }
            if (this.price != null) {
                this.price.kill();
            }
            this.price = null;
            this.startDate = null;
            this.endDate = null;
            this.delete = null;
            this.cloneButton = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.startDate);
            CheckedListAdder.addToList(a, this.endDate);
            CheckedListAdder.addToList(a, this.cloneButton);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return this.startDate.getNode().getValue();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.startDate.setEnabled(isEnabled);
            this.endDate.setEnabled(isEnabled);
            this.state.setEnabled(isEnabled);
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled);
            }
            if (this.cloneButton != null) {
                this.cloneButton.setEnabled(isEnabled);
            }
            if (this.price != null) {
                this.price.setEnabled(isEnabled);
            }
        }

        protected List<ScreenValidationObject> validateRow() {
            return ValidationUtil.validatePeriod((Node<Date>)this.getModel().getNode().getChildNamed(new DtoField[]{HandlingCostVariantComplete_.validityPeriod, PeriodComplete_.startDate}), (Node<Date>)this.getModel().getNode().getChildNamed(new DtoField[]{HandlingCostVariantComplete_.validityPeriod, PeriodComplete_.endDate}), this.startDate, this.endDate);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            } else if (source == this.cloneButton) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(this.cloneButton, true, true, Words.COPY_VARIANT);
                popUp.setView(new CopyHandlingVariantPopup(this.model.getNode()));
                popUp.showPopUp(x, y, -1, -1, new InnerPopUpListener2(){

                    @Override
                    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                        if (xargs == null) {
                            return;
                        }
                        Node nNode = (Node)xargs[0];
                        VariantDetailsPanel.this.table.getModel().getNode().addChild(nNode, 0L);
                        for (Table2RowPanel p : VariantDetailsPanel.this.table.getRows()) {
                            TableRowImpl i = (TableRowImpl)p;
                            i.enableVariantEdit();
                        }
                    }
                }, this.cloneButton);
            }
        }

        protected void enableVariantEdit() {
            this.startDate.showEditorAnyWay();
            this.endDate.showEditorAnyWay();
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.startDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.startDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.startDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.startDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.endDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.endDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.endDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.endDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.state.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.state.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.state.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.state.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                if (TableRowImpl.this.price != null) {
                    TableRowImpl.this.price.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.price.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.price.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                }
                TableRowImpl.this.setControlsX(currentX);
                int ax = currentX + TableRowImpl.this.getCellPadding();
                if (TableRowImpl.this.cloneButton != null) {
                    TableRowImpl.this.cloneButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cloneButton.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.cloneButton.setSize(TableRowImpl.this.cloneButton.getPreferredSize());
                    ax = TableRowImpl.this.cloneButton.getX() + TableRowImpl.this.cloneButton.getWidth() + TableRowImpl.this.getCellPadding();
                }
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation(ax, (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }
        }
    }
}

