/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.handlingcosts.details.utils;

import ch.icit.pegasus.client.converter.QuantityTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.enums.QuantityTypeE;
import ch.icit.pegasus.client.gui.modules.handlingcosts.details.utils.StepPricePopupInsert;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDInputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.AbsolutePriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.ArticleDeliverablePriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostVariantComplete_;
import ch.icit.pegasus.server.core.dtos.handlingcost.LinearPriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.PriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MultiArticleHandlingComponent
extends Table2 {
    private static final long serialVersionUID = 1L;

    public MultiArticleHandlingComponent(RDProvider provider) {
        super(true, Words.ADD, true, false, "");
        this.setProvider(provider);
        this.setOverrideName("article");
        this.setUseWriteAccessRight(true);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                MultiArticleHandlingComponent.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                ArticleDeliverablePriceCalculationComplete art = new ArticleDeliverablePriceCalculationComplete();
                art.setClientOId(Long.valueOf(ADTO.getNextId()));
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)art, true, false);
                MultiArticleHandlingComponent.this.getModel().getNode().addChild(n, 0L);
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.ARTICLE, 80, 80, 80));
        columns.add(new TableColumnInfo(Words.CALC, 80, 80, 80));
        int ti = InputComboBox.getPreferredWidth(this, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE) * 2 + 3 * this.getCellPadding();
        columns.add(new TableColumnInfo(Words.PRICE, ti, ti, ti));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    ItemListener,
    SearchTextField2Listener {
        private static final long serialVersionUID = 1L;
        private RDSearchTextField2<BasicArticleLight> articleSearch;
        private RDComboBox calcType;
        private RDInputComboBox price;
        private RDInputComboBox quantity;
        private TextButton steps;
        private DeleteButton deleteButton;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.setLayout(new RowLayout());
            this.articleSearch = new RDSearchTextField2(MultiArticleHandlingComponent.this.getProvider(), RDSearchTextField2.SearchTypes.ARTICLE);
            this.articleSearch.setOverrideName("deliverable");
            this.articleSearch.addSearchTextFieldListener(this);
            this.calcType = new RDComboBox(MultiArticleHandlingComponent.this.getProvider(), ConverterRegistry.getConverter(QuantityTypeConverter.class));
            this.calcType.refreshPossibleValues(NodeToolkit.getAffixList(QuantityTypeE.class));
            this.calcType.setOverrideName("quantity");
            this.calcType.setNode(null);
            this.price = new RDInputComboBox(MultiArticleHandlingComponent.this.getProvider(), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
            this.price.setOverrideName("quantity");
            this.price.setMaxKommaStellen(3);
            this.quantity = new RDInputComboBox(MultiArticleHandlingComponent.this.getProvider(), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
            this.quantity.setOverrideName("quantity");
            this.quantity.setMaxKommaStellen(3);
            this.steps = new TextButton();
            this.steps.setText("Edit");
            this.steps.addButtonListener(this);
            this.deleteButton = new DeleteButton();
            this.deleteButton.addButtonListener(this);
            this.articleSearch.setNode(m.getNode().getChildNamed(new String[]{"article"}));
            PriceCalculationComplete c = (PriceCalculationComplete)m.getNode().getChildNamed(new String[]{"priceCalculation"}).getValue();
            QuantityTypeE toSelect = QuantityTypeE.ABSOLUT;
            if (c instanceof AbsolutePriceCalculationComplete) {
                toSelect = QuantityTypeE.ABSOLUT;
            } else if (c instanceof LinearPriceCalculationComplete) {
                toSelect = QuantityTypeE.LINEAR;
            } else if (c instanceof StepPriceCalculationComplete) {
                toSelect = QuantityTypeE.STEP;
            }
            Iterator it = NodeToolkit.getAffixList(QuantityTypeE.class).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                if (n.getValue() != toSelect || toSelect.equals(this.calcType.getSelectedItem())) continue;
                this.calcType.setSelectedItem(n);
            }
            this.revalidateItems(toSelect, true);
            this.calcType.addItemListener(this);
            this.price.getFader().setPermanent(true);
            this.quantity.getFader().setPermanent(true);
            this.steps.getFader().setPermanent(true);
            this.add(this.articleSearch);
            this.add(this.calcType);
            this.add(this.price);
            this.add(this.quantity);
            this.add(this.steps);
            this.add(this.deleteButton);
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            boolean b = isEnabled && this.articleSearch.isItemSelected();
            this.articleSearch.setEnabled(isEnabled);
            this.calcType.setEnabled(b);
            this.price.setEnabled(b);
            this.quantity.setEnabled(b);
            this.steps.setEnabled(b);
            this.deleteButton.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.articleSearch.kill();
            this.articleSearch = null;
            this.calcType.kill();
            this.calcType = null;
            this.price.kill();
            this.price = null;
            this.quantity.kill();
            this.quantity = null;
            this.steps.kill();
            this.steps = null;
            this.deleteButton.kill();
            this.deleteButton = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton) {
                this.getModel().getNode().getParent().removeChild(this.getModel().getNode(), 0L);
            } else if (source == this.steps) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(source, true, true, Words.EDIT_STEPS);
                popUp.setView(new StepPricePopupInsert(false, (ListNode)this.getModel().getNode().getChildNamed(new String[]{"priceCalculation-steps"}), this.geList1(), NodeToolkit.getAffixList(CurrencyComplete.class), this.getModel().getParentModel().getTable().getProvider(), HandlingCostVariantComplete_.quantity));
                popUp.showPopUp(x, y, -1, -1, null, source, PopupType.FRAMELESS);
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.articleSearch);
            CheckedListAdder.addToList(a, this.calcType);
            CheckedListAdder.addToList(a, this.quantity);
            CheckedListAdder.addToList(a, this.price);
            CheckedListAdder.addToList(a, this.steps);
            CheckedListAdder.addToList(a, this.deleteButton);
            return a;
        }

        private void revalidateItems(QuantityTypeE type, boolean isInit) {
            if (!isInit || this.getModel().getNode().getChildNamed(new String[]{"priceCalculation"}).getValue() == null) {
                BasicArticleComplete artC = (BasicArticleComplete)this.getModel().getNode().getChildNamed(new String[]{"article"}).getValue(BasicArticleComplete.class);
                AbsolutePriceCalculationComplete pc = null;
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                switch (type) {
                    case ABSOLUT: {
                        pc = new AbsolutePriceCalculationComplete();
                        pc.setPrice(Double.valueOf(0.0));
                        pc.setCurrency(settings.getCurrency());
                        break;
                    }
                    case LINEAR: {
                        pc = new LinearPriceCalculationComplete();
                        ((LinearPriceCalculationComplete)pc).setPrice(new PriceComplete(settings.getCurrency(), Double.valueOf(0.0)));
                        ((LinearPriceCalculationComplete)pc).setQuantity(new QuantityComplete(Double.valueOf(0.0), artC.getBaseUnit()));
                        break;
                    }
                    case STEP: {
                        pc = new StepPriceCalculationComplete();
                        ((StepPriceCalculationComplete)pc).setSteps(new ArrayList());
                        break;
                    }
                }
                if (pc != null) {
                    pc.setClientOId(Long.valueOf(ADTO.getNextId()));
                }
                this.getModel().getNode().getChildNamed(new String[]{"priceCalculation"}).removeExistingValues();
                this.getModel().getNode().getChildNamed(new String[]{"priceCalculation"}).setValue((Object)pc, 0L);
                this.getModel().getNode().getChildNamed(new String[]{"priceCalculation"}).removeAllChilds();
                this.getModel().getNode().getChildNamed(new String[]{"priceCalculation"}).updateNode();
            }
            switch (type) {
                case ABSOLUT: {
                    Node abs = this.getModel().getNode().getChildNamed(new String[]{"priceCalculation"});
                    this.quantity.fadeOut(false);
                    this.steps.fadeOut(false);
                    this.price.fadeIn();
                    this.price.setNode(abs.getChildNamed(new String[]{"price"}), abs.getChildNamed(new String[]{"currency"}));
                    break;
                }
                case LINEAR: {
                    Node lin = this.getModel().getNode().getChildNamed(new String[]{"priceCalculation"});
                    this.steps.fadeOut(false);
                    this.quantity.fadeIn();
                    this.price.fadeIn();
                    this.quantity.setNode(lin.getChildNamed(new String[]{"quantity"}));
                    this.price.setNode(lin.getChildNamed(new String[]{"price"}));
                    Node artUnits = this.getArticleUnitsNode();
                    this.quantity.setPossibleUnits(artUnits);
                    break;
                }
                case STEP: {
                    Node step = this.getModel().getNode().getChildNamed(new String[]{"priceCalculation"});
                    this.quantity.fadeOut(false);
                    this.price.fadeOut(false);
                    this.steps.fadeIn();
                    break;
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1 && e.getSource() == this.calcType.getEditor()) {
                Node n = (Node)this.calcType.getSelectedItem();
                this.revalidateItems((QuantityTypeE)n.getValue(), false);
            }
        }

        public ViewNode getUnits() {
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
            Node article = this.getModel().getNode().getChildNamed(new String[]{"article"});
            BasicArticleComplete artC = (BasicArticleComplete)article.getValue(BasicArticleComplete.class);
            List possibleUnits = StoreToolkit.getPossibleUnits((BasicArticleLight)artC, null, (Timestamp)new Timestamp(System.currentTimeMillis()), (TransactionType)TransactionType.IN_HANDLING, (UserComplete)currentUser, null, null, (SystemSettingsComplete)settings);
            return UnitConversionToolkitNodeBased.getUnitList(possibleUnits);
        }

        public List<Node> geList1() {
            Node article = this.getModel().getNode().getChildNamed(new String[]{"article"});
            ArrayList<Node> prodList = new ArrayList<Node>();
            if (article.getValue() != null) {
                for (Node pak = article.getChildNamed(new String[]{"packingQuantity"}); pak != null && pak.getValue() != null; pak = pak.getChildNamed(new String[]{"convertedQuantity"})) {
                    Node unit = pak.getChildNamed(new String[]{"unit"});
                    List<Node<UnitComplete>> list = UnitToolkit.generateUnitView((Node<UnitComplete>)unit, null, null, true);
                    prodList.addAll(list);
                }
            }
            return prodList;
        }

        private Node getArticleUnitsNode() {
            return this.getUnits();
        }

        public void newValueSelected(SearchTextField2 source, final Node n) throws ClientServerCallException {
            if (n.getValue(BasicArticleComplete.class) == null) {
                ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                    @Override
                    public Node<?> loadData() throws Exception {
                        BasicArticleLight artL = (BasicArticleLight)n.getValue();
                        BasicArticleComplete artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(artL.getId())).getValue();
                        n.removeExistingValues();
                        n.setValue((Object)artC, 0L);
                        n.updateNode();
                        if (TableRowImpl.this.quantity.getNode() != null) {
                            Node artUnits = TableRowImpl.this.getArticleUnitsNode();
                            TableRowImpl.this.quantity.getNode().getChildNamed(new String[]{"unit"}).setValue((Object)artC.getBaseUnit(), 0L);
                            TableRowImpl.this.quantity.setPossibleUnits(artUnits);
                        }
                        return n;
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return new RemoteLoader(){

                            public void remoteObjectLoaded(Node<?> node) {
                                TableRowImpl.this.setEnabled(TableRowImpl.this.isEnabled());
                            }

                            public void errorOccurred(ClientException exception) {
                                InnerPopupFactory.showErrorDialog((Exception)exception, (Component)TableRowImpl.this);
                            }
                        };
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
            } else {
                BasicArticleComplete artC = (BasicArticleComplete)n.getValue(BasicArticleComplete.class);
                if (this.quantity.getNode() != null) {
                    Node artUnits = this.getArticleUnitsNode();
                    this.quantity.getNode().getChildNamed(new String[]{"unit"}).setValue((Object)artC.getBaseUnit(), 0L);
                    this.quantity.setPossibleUnits(artUnits);
                }
                this.setEnabled(this.isEnabled());
            }
        }

        private class RowLayout
        extends DefaultLayout {
            private RowLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                TableRowImpl.this.articleSearch.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.articleSearch.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.articleSearch.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.articleSearch.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                TableRowImpl.this.calcType.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.calcType.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.calcType.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.calcType.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(2);
                if (TableRowImpl.this.getModel().getNode().getChildNamed(new String[]{"priceCalculation"}).getValue() instanceof AbsolutePriceCalculationComplete) {
                    TableRowImpl.this.price.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.price.setSize(TableRowImpl.this.price.getPreferredSize());
                } else if (TableRowImpl.this.getModel().getNode().getChildNamed(new String[]{"priceCalculation"}).getValue() instanceof LinearPriceCalculationComplete) {
                    TableRowImpl.this.quantity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.quantity.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.quantity.setSize(TableRowImpl.this.quantity.getPreferredSize());
                    TableRowImpl.this.price.setLocation(TableRowImpl.this.quantity.getX() + TableRowImpl.this.quantity.getWidth() + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.price.setSize(TableRowImpl.this.price.getPreferredSize());
                } else if (TableRowImpl.this.getModel().getNode().getChildNamed(new String[]{"priceCalculation"}).getValue() instanceof StepPriceCalculationComplete) {
                    TableRowImpl.this.steps.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.steps.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.steps.setSize(120, (int)TableRowImpl.this.steps.getPreferredSize().getHeight());
                }
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(3);
                TableRowImpl.this.deleteButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.deleteButton.setSize(TableRowImpl.this.deleteButton.getPreferredSize());
            }
        }
    }
}

