/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.importer;

import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.toolkits.FlightToolkit;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.PaxFigureComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxFigureTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelToolkit;
import ch.icit.utils.ExcelToolkitException;
import java.io.File;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class FlightForecastImporter {
    public List<ScreenValidationObject> importFlightForecast(File f, LoadingAnimation animation, boolean ignoreEnRouteRestriction) throws ExcelToolkitException {
        if (animation != null) {
            animation.stateChanged(Words.LOAD_DATA);
        }
        ArrayList<ScreenValidationObject> warnigns = new ArrayList<ScreenValidationObject>();
        PaxFigureTypeComplete paxType = null;
        List paxTypes = (List)NodeToolkit.getAffixList(PaxFigureTypeComplete.class).getValue();
        for (PaxFigureTypeComplete pf : paxTypes) {
            if (!pf.getPredefined().booleanValue()) continue;
            paxType = pf;
        }
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        List rows = ExcelToolkit.readRows((File)f);
        block7: for (ExcelRow r : rows) {
            Object flightDate = r.getCellValue(0);
            Object flightNo = r.getCellValue(1);
            Object paxF = r.getCellValue(2);
            Object paxB = r.getCellValue(3);
            Object paxE = r.getCellValue(4);
            Object paxJC = r.getCellValue(5);
            Object paxJP = r.getCellValue(6);
            Object paxJ = r.getCellValue(7);
            Integer iF = this.getIntValue(paxF);
            Integer iB = this.getIntValue(paxB);
            Integer iE = this.getIntValue(paxE);
            Integer iJC = this.getIntValue(paxJC);
            Integer iJP = this.getIntValue(paxJP);
            Integer iJ = this.getIntValue(paxJ);
            if (flightDate == null || flightNo == null || iF == null && iB == null && iE == null && iJC == null && iJP == null && iJ == null) continue;
            try {
                FlightComplete fc = this.getFlight((java.util.Date)flightDate, (String)flightNo, warnigns);
                if (fc == null) continue;
                switch (fc.getFlightState()) {
                    case CANCELLED: 
                    case CLOSED: 
                    case DELETED: 
                    case DISPATCHED: 
                    case EN_ROUTE: {
                        if (ignoreEnRouteRestriction) break;
                        continue block7;
                    }
                    case OPEN: 
                    case PLANNED: {
                        break;
                    }
                }
                FlightToolkit.ensurePaxFigureTypesInserted((FlightLight)fc);
                this.updatePax(fc, iF, iB, iE, iJC, iJP, iJ, settings);
                fc.setSelectedPaxType(paxType);
                if (fc.getId() == null) {
                    fc.setFlightState(FlightStateE.OPEN);
                    ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).create(fc, new ListWrapper(), "");
                    continue;
                }
                ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).update(fc, new ListWrapper(), false, false, false, false);
            }
            catch (Exception e) {
                warnigns.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Unable to update Flight " + flightNo + " @ " + flightDate));
            }
        }
        return warnigns;
    }

    private Integer getIntValue(Object o) {
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Long) {
            return ((Long)o).intValue();
        }
        if (o instanceof Double) {
            return ((Double)o).intValue();
        }
        if (o instanceof Float) {
            return ((Float)o).intValue();
        }
        return null;
    }

    private void updatePax(FlightComplete flight, Integer pf, Integer pb, Integer pe, Integer pjc, Integer pjp, Integer pj, SystemSettingsComplete settings) {
        for (FlightLegComplete l : flight.getLegs()) {
            if (l.getCateringLeg().booleanValue() && l.getDepartureAirport().equals((Object)settings.getHomeBase())) {
                for (PaxFigureComplete f : l.getPaxFigures()) {
                    if (f.getCabinClass().getCode().equals("C")) {
                        if (pb != null) {
                            f.setNumber(pb);
                            continue;
                        }
                        f.setNumber(Integer.valueOf(0));
                        continue;
                    }
                    if (f.getCabinClass().getCode().equals("E")) {
                        if (pe != null) {
                            f.setNumber(pe);
                            continue;
                        }
                        f.setNumber(Integer.valueOf(0));
                        continue;
                    }
                    if (f.getCabinClass().getCode().equals("F")) {
                        if (pf != null) {
                            f.setNumber(pf);
                            continue;
                        }
                        f.setNumber(Integer.valueOf(0));
                        continue;
                    }
                    if (f.getCabinClass().getCode().equals("JC")) {
                        if (pjc != null) {
                            f.setNumber(pjc);
                            continue;
                        }
                        f.setNumber(Integer.valueOf(0));
                        continue;
                    }
                    if (f.getCabinClass().getCode().equals("JP")) {
                        if (pjp != null) {
                            f.setNumber(pjp);
                            continue;
                        }
                        f.setNumber(Integer.valueOf(0));
                        continue;
                    }
                    if (f.getCabinClass().getCode().equals("J")) {
                        if (pj != null) {
                            f.setNumber(pj);
                            continue;
                        }
                        f.setNumber(Integer.valueOf(0));
                        continue;
                    }
                    if (flight.getId() != null) continue;
                    f.setNumber(Integer.valueOf(0));
                }
                continue;
            }
            for (PaxFigureComplete f : l.getPaxFigures()) {
                if (flight.getId() != null) continue;
                f.setNumber(Integer.valueOf(0));
            }
        }
    }

    private FlightComplete getFlight(java.util.Date flightDate, String flightNo, List<ScreenValidationObject> warnings) throws ServiceException {
        FlightSearchConfiguration fsc = new FlightSearchConfiguration();
        fsc.setFlightNumber(flightNo);
        fsc.setFlightStdSta(FlightSearchConfiguration.FLIGHT_STD_STA.staStd);
        fsc.setDayPeriod(new PeriodComplete(new Date(flightDate.getTime()), new Date(flightDate.getTime())));
        SearchResultIterator sri = new SearchResultIterator((ASearchConfiguration)fsc);
        if (sri.hasNext()) {
            FlightLight fl = (FlightLight)sri.next();
            FlightComplete fc = null;
            fc = fl.getId() == null ? (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getPlannedFlightComplete(fl).getValue() : (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(fl.getId())).getValue();
            return fc;
        }
        return null;
    }
}

