/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.importer;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.importer.utils.ImporterItemGroupGroupView;
import ch.icit.pegasus.client.gui.modules.importer.utils.ImporterItemGroupView;
import ch.icit.pegasus.client.gui.modules.importer.utils.ImporterItemViewBuilder;
import ch.icit.pegasus.client.gui.screentemplates.TitledScreenInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.panels.ScrollableBackground;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ImporterAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.utils.ImportType;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ImporterModule
extends TitledScreenInsert
implements InnerPopUpListener2,
Module {
    private static final long serialVersionUID = 1L;
    private JPanelKillable viewPort;
    private ScrollableBackground scrollPane;
    private List<ImporterItemGroupGroupView> views = new ArrayList<ImporterItemGroupGroupView>();

    public ImporterModule() {
        this.viewPort = new JPanelKillable();
        this.viewPort.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
        this.scrollPane = new ScrollableBackground(true);
        this.scrollPane.getScrollPane().setViewportView(this.viewPort);
        this.viewPort.setLayout(new Layout2());
        this.createDataImportItems();
        this.setLayout(new Layout());
        this.setOpaque(false);
        this.add(this.scrollPane);
        this.setEnabled(true);
    }

    private void addView(ImporterItemGroupGroupView view) {
        this.views.add(view);
        this.viewPort.add(view);
    }

    private void createDataImportItems() {
        RDProvider p = new RDProvider(HUDToolkit.getCurrentAccessRight(ImporterAccess.MODULE_IMPORTER, ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser()), false);
        ImporterItemViewBuilder builder = new ImporterItemViewBuilder(this);
        ImporterItemGroupGroupView replacement = builder.createGroup("Replacements");
        ImporterItemGroupView productReplacement = builder.createSubGroup(replacement, "Product Import");
        builder.createItem(p, productReplacement, ImportType.PRODUCT_REPLACE_ARTICLE_BY_ARTICLE, "Replace Article by Article");
        builder.createItem(p, productReplacement, ImportType.PRODUCT_REPLACE_ARTICLE_BY_RECIPE, "Replace Article by Recipe");
        builder.createItem(p, productReplacement, ImportType.PRODUCT_REPLACE_RECIPE_BY_ARTICLE, "Replace Recipe by Article");
        builder.createItem(p, productReplacement, ImportType.PRODUCT_REPLACE_RECIPE_BY_RECIPE, "Replace Recipe by Recipe");
        builder.createItem(p, productReplacement, ImportType.PRODUCT_ADD_ARTICLE, "Add Article");
        builder.createItem(p, productReplacement, ImportType.PRODUCT_ADD_RECIPE, "Add Recipe");
        ImporterItemGroupView recipeReplacement = builder.createSubGroup(replacement, "Recipe Import");
        builder.createItem(p, recipeReplacement, ImportType.RECIPE_REPLACE_ARTICLE_BY_ARTICLE, "Replace Article by Article");
        builder.createItem(p, recipeReplacement, ImportType.RECIPE_REPLACE_ARTICLE_BY_RECIPE, "Replace Article by Recipe");
        builder.createItem(p, recipeReplacement, ImportType.RECIPE_REPLACE_RECIPE_BY_ARTICLE, "Replace Recipe by Article");
        builder.createItem(p, recipeReplacement, ImportType.RECIPE_REPLACE_RECIPE_BY_RECIPE, "Replace Recipe by Recipe");
        ImporterItemGroupGroupView dataImport = builder.createGroup("Data Import");
        ImporterItemGroupView articleImport = builder.createSubGroup(dataImport, "Article Import");
        builder.createItem(p, articleImport, ImportType.ARTICLE_COMMODITY_NUMBER, "Import Commodity Number");
        builder.createItem(p, articleImport, ImportType.ARTICLE_DELETE_STATE, "Import Delete");
        builder.createItem(p, articleImport, ImportType.ARTICLE_CHARGE_PRICE, "Import Charge Price");
        builder.createItem(p, articleImport, ImportType.ARTICLE_CHARGE_CONVERSION, "Import Charge Conversion");
        builder.createItem(p, articleImport, ImportType.ARTICLE_IN_USE_AND_DELETED_STATE, "Import InUse and Deleted State");
        builder.createItem(p, articleImport, ImportType.ARTICLE_ORIGIN_COUNTRY, "Import Default Origin Country");
        builder.createItem(p, articleImport, ImportType.ARTICLE_COMMENTS, "Import Comment");
        builder.createItem(p, articleImport, ImportType.ARTICLE_CHILLED, "Import Chilled");
        builder.createItem(p, articleImport, ImportType.ARTICLE_FROZEN, "Import Frozen");
        builder.createItem(p, articleImport, ImportType.ARTICLE_STORE_CONDITION, "Import Stores");
        builder.createItem(p, articleImport, ImportType.ARTICLE_HALAL, "Import Halal");
        builder.createItem(p, articleImport, ImportType.ARTICLE_NO_EXPIRY, "Import No Expiry");
        builder.createItem(p, articleImport, ImportType.ARTICLE_PURCHASE_CHARGE, "Import Purchase Charge mandatory");
        builder.createItem(p, articleImport, ImportType.ARTICLE_CONVERSION, "Import Packaging Conversion");
        builder.createItem(p, articleImport, ImportType.ARTICLE_BONDED_STATE, "Import Bonded State");
        builder.createItem(p, articleImport, ImportType.ARTICLE_NAMES, "Import Names");
        builder.createItem(p, articleImport, ImportType.ARTICLE_STD_PRICE, "Import Std Price");
        builder.createItem(p, articleImport, ImportType.ARTICLE_INVOICE_COMMISSION, "Import Invoice Commission");
        builder.createItem(p, articleImport, ImportType.ARTICLE_SUPPLIER_CONDITION_DELIVERY_TIME, "Import Supplier Delivery Time");
        builder.createItem(p, articleImport, ImportType.ARTICLE_REQUISITION_ORDER_UNIT, "Import Requisition Order Unit");
        builder.createItem(p, articleImport, ImportType.ARTICLE_STATE, "Import State");
        builder.createItem(p, articleImport, ImportType.ARTICLE_CUSTOMS_TARIFF, "Import Customs Tariff");
        builder.createItem(p, articleImport, ImportType.ARTICLE_SAP_NUMBER, "Import SAP Number");
        builder.createItem(p, articleImport, ImportType.ARTICLE_NOTIFY_PURCHASE_PRICE_CHANGE, "Import Notify Purchase Price Change");
        builder.createItem(p, articleImport, ImportType.ARTICLE_NOMINATED, "Import Nominated Stated");
        builder.createItem(p, articleImport, ImportType.ARTICLE_CATEGORY, "Import Category");
        builder.createItem(p, articleImport, ImportType.ARTICLE_RETAIL_IN_MOTION, "Import Retail inMotion relevant");
        builder.createItem(p, articleImport, ImportType.ARTICLE_DEPARTMENT, "Import Department");
        builder.createItem(p, articleImport, ImportType.ARTICLE_PRODUCTION_DEPTH, "Import Production Depth");
        builder.createItem(p, articleImport, ImportType.ARTICLE_GRAMMAGE, "Import Grammage");
        builder.createItem(p, articleImport, ImportType.ARTICLE_AUTO_CHECKOUT_STATE, "Import Auto Checkout State");
        builder.createItem(p, articleImport, ImportType.ARTICLE_ALCOHOL_LEVEL, "Import Alcohol Level");
        builder.createItem(p, articleImport, ImportType.ARTICLE_INVENTORY_TRANSITION_COMMENT, "Import Inventory Transition Comments");
        builder.createItem(p, articleImport, ImportType.ARTICLE_WASTE, "Import Waste");
        builder.createItem(p, articleImport, ImportType.ARTICLE_GMC_CODE, "Import GMC Codes");
        builder.createItem(p, articleImport, ImportType.ARTICLE_REQUEST_ALLERGEN_UPDATE, "Import Allergen Update Request");
        builder.createItem(p, articleImport, ImportType.ARTICLE_SUPPLIER_CONDITION_ARTICLE_NUMBER, "Import Supplier Article Number");
        builder.createItem(p, articleImport, ImportType.ARTICLE_INCLUDE_FOR_INVOICE_COMMISSION, "Import Include for Invoice Commission");
        builder.createItem(p, articleImport, ImportType.ARTICLE_UNIT, "Import Unit");
        builder.createItem(p, articleImport, ImportType.ARTICLE_TYPE, "Import Type");
        builder.createItem(p, articleImport, ImportType.ARTICLE_MIN_AND_OPTIMAL_STOCK, "Import Min and Optimal Stock");
        builder.createItem(p, articleImport, ImportType.ARTICLE_RETURNS_RATE, "Import Returns Rate");
        builder.createItem(p, articleImport, ImportType.ARTICLE_CREATE, "Import Create new Article");
        builder.createItem(p, articleImport, ImportType.ARTICLE_HALAL_CERTIFICATION, "Import Halal Certification");
        builder.createItem(p, articleImport, ImportType.ARTICLE_HAS_EXPIRY, "Import Has Expiry Date");
        builder.createItem(p, articleImport, ImportType.ARTICLE_CONTRACT_QUANTITY, "Import Contract Quantity");
        builder.createItem(p, articleImport, ImportType.ARTICLE_REPORT_PURCHASE_PDF, "Import Report Purchase PDF");
        builder.createItem(p, articleImport, ImportType.ARTICLE_KONTER_PROBE, "Import Konter Probe");
        builder.createItem(p, articleImport, ImportType.ARTICLE_EXCLUDE_FROM_CALCULATION, "Import Exclude From Calculation");
        builder.createItem(p, articleImport, ImportType.ARTICLE_EAN_CODE, "Import EAN Code");
        builder.createItem(p, articleImport, ImportType.ARTICLE_CUSTOMS_DEADLINE, "Import Customs Deadline");
        builder.createItem(p, articleImport, ImportType.ARTICLE_SYNC_NO_PRO, "Import NoPro Sync");
        builder.createItem(p, articleImport, ImportType.ARTICLE_X_RAY_NEEDED, "Import X Ray needed");
        Collections.sort(articleImport.getItems());
        ImporterItemGroupView recipeImport = builder.createSubGroup(dataImport, "Recipe Import");
        builder.createItem(p, recipeImport, ImportType.RECIPE_PRODUCT_GROUP, "Import Recipe Product Group");
        builder.createItem(p, recipeImport, ImportType.RECIPE_PREPARATION_GROUP, "Import Recipe Preparation Group");
        builder.createItem(p, recipeImport, ImportType.RECIPE_DEPARTMENT, "Import Recipe Department");
        builder.createItem(p, recipeImport, ImportType.RECIPE_STATE, "Import Recipe State");
        builder.createItem(p, recipeImport, ImportType.RECIPE_EAN_CODE, "Import Recipe Ean Code");
        builder.createItem(p, recipeImport, ImportType.RECIPE_NAME, "Import Recipe Name/English Name");
        builder.createItem(p, recipeImport, ImportType.RECIPE_MAN_MINUTE, "Import Recipe Man Minutes");
        builder.createItem(p, recipeImport, ImportType.RECIPE_SERVICE_FLAG, "Import Recipe Service Item Flag");
        builder.createItem(p, recipeImport, ImportType.RECIPE_USE_DEFAULT_DEPARTMENT_FOR_CCP2, "Import Recipe 'use default department for CCP2'");
        builder.createItem(p, recipeImport, ImportType.RECIPE_USE_RESERVE, "Import Recipe 'use reserve'");
        builder.createItem(p, recipeImport, ImportType.RECIPE_ALWAYS_ON_OPRP05, "Import Recipe 'always on OPRP05'");
        builder.createItem(p, recipeImport, ImportType.RECIPE_EXCLUDE_FROM_KONTER_PROBE, "Import Recipe 'exclude from Konter Probe'");
        builder.createItem(p, recipeImport, ImportType.RECIPE_CLEAR_MAH_HOURS, "Import Recipe Clear Man Hours");
        builder.createItem(p, recipeImport, ImportType.RECIPE_DELETE, "Import Recipe Delete");
        Collections.sort(recipeImport.getItems());
        ImporterItemGroupView productImport = builder.createSubGroup(dataImport, "Product Import");
        builder.createItem(p, productImport, ImportType.PRODUCT_PACK_SIZE, "Import Pack Size");
        builder.createItem(p, productImport, ImportType.PRODUCT_PRICE_FACTORS, "Import Price Factors");
        builder.createItem(p, productImport, ImportType.PRODUCT_CREATE_FROM_ARTICLE, "Import Product create from Article");
        builder.createItem(p, productImport, ImportType.PRODUCT_DELIVERY_UNIT, "Import Delivery Unit");
        builder.createItem(p, productImport, ImportType.PRODUCT_BAR_CODE, "Import Bar Code");
        builder.createItem(p, productImport, ImportType.PRODUCT_COMMISSION, "Import Commission");
        builder.createItem(p, productImport, ImportType.PRODUCT_LOCATION, "Import Location");
        builder.createItem(p, productImport, ImportType.PRODUCT_PRICE_FOR_CUSTOMER, "Import Price for Customer");
        builder.createItem(p, productImport, ImportType.PRODUCT_COMPONENT_COMMENT, "Import Component Comment (within Specification)");
        builder.createItem(p, productImport, ImportType.PRODUCT_DELETE, "Import Delete State");
        builder.createItem(p, productImport, ImportType.PRODUCT_VARIANT_COMMENT, "Import Internal Variant Comment");
        builder.createItem(p, productImport, ImportType.PRODUCT_COPY_TENDER_TO_PRODUCTIVE, "Import Copy Tender to Productive");
        builder.createItem(p, productImport, ImportType.PRODUCT_COPY_TO_NEW_CUSTOMER, "Import Copy Product To new Customer");
        builder.createItem(p, productImport, ImportType.PRODUCT_GROUP_COMPONENT_DEPARTMENT, "Import Group Component Department");
        builder.createItem(p, productImport, ImportType.PRODUCT_CREATE_RETAILINMOTION_TRANSACTIONS, "Import Create Retail inMotion Transactions");
        builder.createItem(p, productImport, ImportType.PRODUCT_SAP_NUMBER, "Import Sap Number");
        builder.createItem(p, productImport, ImportType.PRODUCT_GROUP_MANMINUTES, "Import Group Man Hours");
        builder.createItem(p, productImport, ImportType.PRODUCT_GROUP_COMPONENT_MAN_MINUTES, "Import Group Component Man Hours");
        builder.createItem(p, productImport, ImportType.PRODUCT_MANMINUTES, "Import Man Hours");
        builder.createItem(p, productImport, ImportType.PRODUCT_STATE, "Import State");
        builder.createItem(p, productImport, ImportType.PRODUCT_SOB_PRICE, "Import Sob Price");
        builder.createItem(p, productImport, ImportType.PRODUCT_GROUP_NAME, "Import Product Group Name");
        builder.createItem(p, productImport, ImportType.PRODUCT_GROUP_PRODUCTION_NAME, "Import Product Group Production Name");
        builder.createItem(p, productImport, ImportType.PRODUCT_TYPE, "Import Type");
        builder.createItem(p, productImport, ImportType.PRODUCT_COMPONENT_TYPE, "Import Component Type (Article/Recipe)");
        builder.createItem(p, productImport, ImportType.PRODUCT_DISCOUNTS, "Import Discounts by Customer");
        builder.createItem(p, productImport, ImportType.PRODUCT_NOMINATED, "Import Nominated");
        builder.createItem(p, productImport, ImportType.PRODUCT_SERVICE_TYPE, "Import Service Type");
        builder.createItem(p, productImport, ImportType.PRODUCT_EAN_CODE, "Import Ean Codes");
        builder.createItem(p, productImport, ImportType.PRODUCT_HINT, "Import Hint");
        builder.createItem(p, productImport, ImportType.PRODUCT_HAUL_TYPE, "Import Hault Type");
        builder.createItem(p, productImport, ImportType.PRODUCT_CABIN_CLASS, "Import Cabin Class");
        builder.createItem(p, productImport, ImportType.PRODUCT_BOUND_DIRECTION, "Import Bound Direction");
        builder.createItem(p, productImport, ImportType.PRODUCT_CYCLE, "Import Cycle");
        builder.createItem(p, productImport, ImportType.PRODUCT_SPML_TYPE, "Import SPML Type");
        builder.createItem(p, productImport, ImportType.PRODUCT_MERGE_GROUPS, "Import Merge Groups");
        builder.createItem(p, productImport, ImportType.PRODUCT_MEAL_TYPE, "Import Meal Type");
        builder.createItem(p, productImport, ImportType.PRODUCT_CATEGORY, "Import Category");
        builder.createItem(p, productImport, ImportType.PRODUCT_DEPARTMENT, "Import Department");
        builder.createItem(p, productImport, ImportType.PRODUCT_CREATE_TENDER, "Import Create Tender");
        builder.createItem(p, productImport, ImportType.PRODUCT_NAME, "Import Name");
        builder.createItem(p, productImport, ImportType.PRODUCT_LABEL_NAME, "Import Label Name");
        builder.createItem(p, productImport, ImportType.PRODUCT_AIS_NAME, "Import AIS Name");
        builder.createItem(p, productImport, ImportType.PRODUCT_CUSTOMER_NO, "Import Customer Number");
        builder.createItem(p, productImport, ImportType.PRODUCT_COMMENT, "Import Comment shown in Catalog");
        builder.createItem(p, productImport, ImportType.PRODUCT_PERIOD_CUT, "Import Period Cut");
        builder.createItem(p, productImport, ImportType.PRODUCT_CUSTOMER, "Import Customer");
        builder.createItem(p, productImport, ImportType.PRODUCT_RC_STATE, "Import Returns Count Type");
        builder.createItem(p, productImport, ImportType.PRODUCT_SOB_STATE, "Import Sales On Board Type");
        builder.createItem(p, productImport, ImportType.PRODUCT_BONDED_STATE, "Import Bonded State");
        builder.createItem(p, productImport, ImportType.PRODUCT_SHOW_ON_KITCHEN_OPS, "Import Show on Kitchen Sheet");
        builder.createItem(p, productImport, ImportType.PRODUCT_AUTO_CHECKOUT, "Import Auto Checkout State");
        builder.createItem(p, productImport, ImportType.PRODUCT_CHANGE_FROM_SIMPLE_TO_COMPLEX, "Import Change from Simple to Complex");
        builder.createItem(p, productImport, ImportType.PRODUCT_COPY_PRODUCTIVE_TO_TENDER, "Import Copy Productive to Tender");
        builder.createItem(p, productImport, ImportType.PRODUCT_CLEAN_AND_CREATE_PRODUCT_GROUP_COMPONENT, "Import Clean and Create Product Group and Component");
        builder.createItem(p, productImport, ImportType.PRODUCT_TAXES, "Import Taxes by Customer");
        builder.createItem(p, productImport, ImportType.PRODUCT_DEFAULT_LABEL_COLOR, "Import Default Label Color");
        builder.createItem(p, productImport, ImportType.PRODUCT_FLIGHT_CHECKER_NAME, "Import Flight Checker Name");
        builder.createItem(p, productImport, ImportType.PRODUCT_CREATE, "Import Create new Product");
        builder.createItem(p, productImport, ImportType.PRODUCT_CLEAR_CATERING_POINTS, "Import Product clear Catering Points");
        builder.createItem(p, productImport, ImportType.PRODUCT_USE_MASTER_DATA_FOR_GROUP_NAME, "Import Product Use Master Data For Group Names");
        builder.createItem(p, productImport, ImportType.PRODUCT_KONTER_PROBE, "Import Product Take Konter Probe");
        Collections.sort(productImport.getItems());
        ImporterItemGroupView handlingCostImport = builder.createSubGroup(dataImport, "Handling Import");
        builder.createItem(p, handlingCostImport, ImportType.HANDLING_COST_DELETE, "Import Delete Handling Cost");
        builder.createItem(p, handlingCostImport, ImportType.HANDLING_CLEAR_MAN_HOURS, "Import Clear Man Hours");
        Collections.sort(handlingCostImport.getItems());
        ImporterItemGroupView divImport = builder.createSubGroup(dataImport, "Diverse Import");
        builder.createItem(p, divImport, ImportType.CATEGORY_CUSTOMS_TARIFF, "Import Category Customs Tariff");
        builder.createItem(p, divImport, ImportType.CATEGORY_WASTES, "Import Category Wastes");
        builder.createItem(p, divImport, ImportType.CATEGORY_TENDER_WASTES, "Import Category Tender Wastes");
        builder.createItem(p, divImport, ImportType.SUPPLIER_KNOWN_SUPPLIER_FLAG, "Import Supplier's 'known Supplier' Flag");
        builder.createItem(p, divImport, ImportType.SUPPLIER_CUSTOMS_RELEVANCE_FLAG, "Import Supplier's 'Customs Relevance' Flag");
        builder.createItem(p, divImport, ImportType.SUPPLIER_DELIVERY_WINDOW, "Import Supplier's Default Delivery Window");
        builder.createItem(p, divImport, ImportType.CHARGE_DOCUMENTS, "Import Charge Documents");
        builder.createItem(p, divImport, ImportType.DEPARTMENT_MAIL_ADDRESS, "Import Department Mail Addresses");
        builder.createItem(p, divImport, ImportType.SAGE_ACCOUNT_TYPE, "Import Sage Account Types");
        builder.createItem(p, divImport, ImportType.KNIFES, "Import Knifes");
        builder.createItem(p, divImport, ImportType.AIRPORT, "Import Airport");
        builder.createItem(p, divImport, ImportType.MIGROS_STORE, "Import Migros Store");
        builder.createItem(p, divImport, ImportType.AIRPORT_COUNTRY, "Import Airport Country");
        builder.createItem(p, divImport, ImportType.CUSTOMER_GLOBAL_LOCATION_NUMBER, "Import Customer Global Location Number");
        builder.createItem(p, divImport, ImportType.CUSTOMER_PICK_N_PAY_FLAG, "Import Customer Pick n Pay Flag");
        builder.createItem(p, divImport, ImportType.SUPPLIER_NAME, "Import Supplier Name");
        builder.createItem(p, divImport, ImportType.SUPPLIER_INVOICE_REFERENCE, "Import Supplier Invoice Reference");
        builder.createItem(p, divImport, ImportType.SUPPLIER_VENDOR_TYPE, "Import Supplier Vendor Type");
        builder.createItem(p, divImport, ImportType.STORE_CONFIGURATION, "Import Store Configuration");
        builder.createItem(p, divImport, ImportType.STORE_BARCODE, "Import Store Barcode");
        builder.createItem(p, divImport, ImportType.STORE_POSITION_BARCODE, "Import Store Position Barcode");
        Collections.sort(divImport.getItems());
        ImporterItemGroupView flightImport = builder.createSubGroup(dataImport, "Flight/Flight Schedule Import");
        builder.createItem(p, flightImport, ImportType.FLIGHT_HAUL_TYPE, "Import Flight Hault Type");
        builder.createItem(p, flightImport, ImportType.FLIGHT_SCHEDULE_HAUL_TYPE, "Import Flight Schedule Hault Type");
        builder.createItem(p, flightImport, ImportType.FLIGHT_CATEGORY, "Import Flight Category");
        builder.createItem(p, flightImport, ImportType.FLIGHT_SCHEDULE_CATEGORY, "Import Flight Schedule Category");
        builder.createItem(p, flightImport, ImportType.FLIGHT_SCHEDULE_SHORT_CODE, "Import Flight Schedule Short Code");
        builder.createItem(p, flightImport, ImportType.FLIGHT_SCHEDULE_TRANSIT_RELEVANT, "Import Flight Schedule Transit Relevant");
        builder.createItem(p, flightImport, ImportType.FLIGHT_SCHEDULE_KITCHEN_READY_TIME, "Import Flight Schedule Kitchen Ready Time");
        Collections.sort(flightImport.getItems());
        ImporterItemGroupView stwImport = builder.createSubGroup(dataImport, "Stowing List Import");
        builder.createItem(p, stwImport, ImportType.STOWING_LIST_DEPARTMENT, "Stowing List Department");
        builder.createItem(p, stwImport, ImportType.STOWING_LIST_INTERNAL_COMMENT, "Stowing List Internal Comment");
        builder.createItem(p, stwImport, ImportType.STOWING_LIST_NAMES, "Stowing List Names");
        builder.createItem(p, stwImport, ImportType.STOWING_LIST_HANDLING_COST, "Stowing List Handling Costs");
        builder.createItem(p, stwImport, ImportType.STOWING_LIST_SCAN_LABEL, "Stowing List Scan Label");
        builder.createItem(p, stwImport, ImportType.STOWING_LIST_DIRECTION, "Stowing List Direction");
        builder.createItem(p, stwImport, ImportType.STOWING_LIST_DELETE, "Stowing List Delete");
        builder.createItem(p, stwImport, ImportType.STOWING_LIST_FLIGHT_LEVEL, "Stowing List Flight Level");
        builder.createItem(p, stwImport, ImportType.STOWING_LIST_LABEL_LAYOUT, "Stowing List Label Import (no new variant is generated)");
        builder.createItem(p, stwImport, ImportType.STOWING_LIST_ADD_VARIANT, "Stowing List Add Variant Import");
        builder.createItem(p, stwImport, ImportType.STOWING_LIST_LABEL_COLOR, "Stowing List Label Color Import");
        builder.createItem(p, stwImport, ImportType.STOWING_LIST_PRODUCT_REPLACE, "Stowing List Product Replace Import");
        builder.createItem(p, stwImport, ImportType.STOWING_LIST_GALLEY_NAMES, "Stowing List Galley Names Import");
        Collections.sort(stwImport.getItems());
        this.addView(replacement);
        this.addView(dataImport);
    }

    @Override
    public void setMainFrame(MainFrame main) {
        super.setMainFrame(main);
        this.setEnabled(true);
    }

    @Override
    public ModuleAccessRightComplete getCurrentAccessRight(AccessDefinitionComplete accessDef) {
        for (ModuleAccessRightComplete r : ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser().getModules()) {
            if (!r.getModule().getInvokingName().equals(accessDef.getIdentifier())) continue;
            return r;
        }
        return null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.viewPort.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.viewPort.kill();
        this.viewPort = null;
    }

    public void undo() {
    }

    public void redo() {
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    @Override
    public void stopAnimationsImmediately() {
    }

    @Override
    public void escapeKeyPressed() {
    }

    @Override
    public void saveKeyPressed() {
    }

    @Override
    public void screenSet() {
        this.getMainFrame().getTitleBar().setHUDButtonsEnabled(true, 19635);
    }

    @Override
    public String getScreenTitle() {
        return ImporterAccess.MODULE_IMPORTER.getDisplayName();
    }

    private class Layout2
    extends DefaultLayout {
        private Layout2() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            ImporterModule o = (ImporterModule)ImporterModule.this.scrollPane.getParent();
            int border = 5;
            int h = border * 2;
            for (ImporterItemGroupGroupView v : ImporterModule.this.views) {
                h = (int)((double)h + v.getPreferredSize().getHeight());
                h += border;
            }
            return new Dimension(0, h += border);
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 5;
            int cy = border * 2;
            for (ImporterItemGroupGroupView v : ImporterModule.this.views) {
                v.setLocation(border, cy);
                v.setSize(parent.getWidth() - 2 * border, (int)v.getPreferredSize().getHeight());
                cy += v.getHeight() + border;
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ImporterModule t = (ImporterModule)parent;
            int y = t.layoutTitle(parent);
            t.scrollPane.setLocation(0, y + AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("screen_vertical_border_to_tabletitle")));
            t.scrollPane.setSize(parent.getWidth(), parent.getHeight() - (t.scrollPane.getY() + 10));
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

