/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.incidentlog.details;

import ch.icit.pegasus.client.converter.CabinClassConverter;
import ch.icit.pegasus.client.converter.IncidentDecisionEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateTimeChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextArea;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentDecisionE;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentLogComplete_;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentLogLight;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentStateE;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.IncidentLogAccess;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class FACDetailsPanel
extends StateDependantDetailsPanel<IncidentLogLight> {
    private TitledItem<RDSearchTextField2<FlightLight>> facFlight;
    private TitledItem<RDDateTimeChooser> facFlightDate;
    private TitledItem<RDComboBox> facCabinClass;
    private TitledItem<RDSearchTextField2<ProductComplete>> facProduct;
    private TitledItem<RDSearchTextField2<RecipeComplete>> facRecipe;
    private TitledItem<RDSearchTextField2<BasicArticleLight>> facArticle;
    private TitledItem<RDSearchTextField2<CustomerLight>> facCustomer;
    private TitledItem<RDComboBox> decision;
    private TitledItem<RDTextArea> response;
    private TitledItem<RDTextField> facReportNumber;
    private TitledItem<RDCheckBox> productRelated;

    public FACDetailsPanel(RowEditor<IncidentLogLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.FAC);
        this.facFlight = new TitledItem(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.FLIGHT, true), "Flight", TitledItem.TitledItemOrientation.NORTH);
        this.facFlightDate = new TitledItem<RDDateTimeChooser>(new RDDateTimeChooser(provider), "Flight Date", TitledItem.TitledItemOrientation.NORTH);
        this.facCabinClass = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(CabinClassConverter.class), true), "Cabin Class", TitledItem.TitledItemOrientation.NORTH);
        this.facProduct = new TitledItem(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.PRODUCT, true), "Product", TitledItem.TitledItemOrientation.NORTH);
        this.facRecipe = new TitledItem(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.RECIPE, true), "Recipe", TitledItem.TitledItemOrientation.NORTH);
        this.facArticle = new TitledItem(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.ARTICLE, true), "Article", TitledItem.TitledItemOrientation.NORTH);
        this.decision = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(IncidentDecisionEConverter.class)), "Decision", TitledItem.TitledItemOrientation.NORTH);
        this.response = new TitledItem<RDTextArea>(new RDTextArea(provider), "Response to Customer", TitledItem.TitledItemOrientation.NORTH);
        this.response.setIgnorePrefHeight(true);
        this.response.getElement().setMaxStringLength(Integer.MAX_VALUE);
        this.facFlightDate.getElement().addDateChooserListener((source, timestamp) -> this.updateSearchConfig());
        this.facFlight.getElement().addSearchTextFieldListener((source, n) -> {
            FlightLight flight = (FlightLight)n.getValue();
            if (flight != null) {
                this.facFlightDate.getElement().getNode().setValue((Object)new Timestamp(flight.getStd().getTime()), 0L);
            }
        });
        this.facReportNumber = new TitledItem<RDTextField>(new RDTextField(provider), "FAC Report Number", TitledItem.TitledItemOrientation.NORTH);
        this.productRelated = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "Product related", TitledItem.TitledItemOrientation.EAST);
        this.productRelated.getElement().addButtonListener((source, x, y) -> this.setEnabled(this.isEnabled()));
        this.facCustomer = new TitledItem(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.CUSTOMER, true), "Customer", TitledItem.TitledItemOrientation.NORTH);
        this.setCustomLayouter(new Layout());
        this.addToView(this.facFlight);
        this.addToView(this.facCustomer);
        this.addToView(this.facFlightDate);
        this.addToView(this.facCabinClass);
        this.addToView(this.facProduct);
        this.addToView(this.facRecipe);
        this.addToView(this.facArticle);
        this.addToView(this.decision);
        this.addToView(this.response);
        this.addToView(this.facReportNumber);
        this.addToView(this.productRelated);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isSupervisor = this.provider.isWritable(IncidentLogAccess.INCIDENT_LOG_SUPERVISOR);
        boolean editable = false;
        IncidentStateE currentState = (IncidentStateE)this.node.getChildNamed(IncidentLogComplete_.state).getValue();
        if (currentState == IncidentStateE.CLOSED) {
            if (isSupervisor) {
                editable = true;
            }
        } else {
            editable = true;
        }
        boolean e = isEnabled && editable;
        super.setEnabled(e);
        Boolean related = (Boolean)this.node.getChildNamed(IncidentLogComplete_.productRelated).getValue();
        this.facFlight.setEnabled(e);
        this.facFlightDate.setEnabled(e);
        this.facCabinClass.setEnabled(e);
        this.facProduct.setEnabled(e && Boolean.TRUE.equals(related));
        this.facRecipe.setEnabled(e && Boolean.TRUE.equals(related));
        this.facArticle.setEnabled(e && Boolean.TRUE.equals(related));
        this.decision.setEnabled(e);
        this.response.setEnabled(e);
        this.facReportNumber.setEnabled(e);
        this.productRelated.setEnabled(e);
        this.facCustomer.setEnabled(e);
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.facFlight.getElement().setNode(node.getChildNamed(IncidentLogComplete_.facFlight));
        this.facFlightDate.getElement().setNode(node.getChildNamed(IncidentLogComplete_.facFlightDate));
        this.facCabinClass.getElement().refreshPossibleValues(NodeToolkit.getAffixList(CabinClassComplete.class));
        this.facCabinClass.getElement().setNode(node.getChildNamed(IncidentLogComplete_.facCabinClass));
        this.facProduct.getElement().setNode(node.getChildNamed(IncidentLogComplete_.facProduct));
        this.facRecipe.getElement().setNode(node.getChildNamed(IncidentLogComplete_.facRecipe));
        this.facArticle.getElement().setNode(node.getChildNamed(IncidentLogComplete_.facArticle));
        Node affixList = NodeToolkit.getAffixList(IncidentDecisionE.class);
        this.decision.getElement().refreshPossibleValues(affixList);
        this.decision.getElement().setNode(node.getChildNamed(IncidentLogComplete_.decision));
        this.response.getElement().setNode(node.getChildNamed(IncidentLogComplete_.response));
        this.facReportNumber.getElement().setNode(node.getChildNamed(IncidentLogComplete_.incidentFACNumber));
        this.productRelated.getElement().setNode(node.getChildNamed(IncidentLogComplete_.productRelated));
        this.facCustomer.getElement().setNode(node.getChildNamed(IncidentLogComplete_.facCustomer));
        this.updateSearchConfig();
        this.setEnabled(this.isEnabled());
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        IncidentTypeE incidentTypeE = (IncidentTypeE)this.node.getChildNamed(IncidentLogComplete_.type).getValue();
        if (incidentTypeE == IncidentTypeE.EXTERNAL && Boolean.TRUE.equals(this.node.getChildNamed(IncidentLogComplete_.productRelated).getValue()) && this.node.getChildNamed(IncidentLogComplete_.facProduct).getValue() == null && this.node.getChildNamed(IncidentLogComplete_.facRecipe).getValue() == null && this.node.getChildNamed(IncidentLogComplete_.facArticle).getValue() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "FAC: Select Product, Recipe or Article"));
            this.facProduct.getElement().setInvalid();
            this.facRecipe.getElement().setInvalid();
            this.facArticle.getElement().setInvalid();
        }
        return validationObjects;
    }

    private void updateSearchConfig() {
        Timestamp flightDate = (Timestamp)this.editor.getModel().getNode().getChildNamed(IncidentLogComplete_.facFlightDate).getValue();
        SearchTextField2 searchComp = (SearchTextField2)this.facFlight.getElement().getEditor();
        if (searchComp != null) {
            Object[] additional = new Object[]{INodeCreator.getDefaultImpl().getNode4DTO((Object)flightDate, false, false), true};
            searchComp.setAdditionalSearchField(additional);
        }
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.facReportNumber);
        CheckedListAdder.addToList(focusList, this.facFlightDate);
        CheckedListAdder.addToList(focusList, this.facCabinClass);
        CheckedListAdder.addToList(focusList, this.facFlight);
        CheckedListAdder.addToList(focusList, this.facCustomer);
        CheckedListAdder.addToList(focusList, this.productRelated);
        CheckedListAdder.addToList(focusList, this.facProduct);
        CheckedListAdder.addToList(focusList, this.facRecipe);
        CheckedListAdder.addToList(focusList, this.facArticle);
        CheckedListAdder.addToList(focusList, this.decision);
        CheckedListAdder.addToList(focusList, this.response);
        return focusList;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = FACDetailsPanel.this.verticalBorder;
            h = (int)((double)h + (FACDetailsPanel.this.facReportNumber.getPreferredSize().getHeight() + (double)FACDetailsPanel.this.verticalBorder));
            h = (int)((double)h + (FACDetailsPanel.this.facFlight.getPreferredSize().getHeight() + (double)(FACDetailsPanel.this.verticalBorder * 2)));
            h = (int)((double)h + FACDetailsPanel.this.productRelated.getPreferredSize().getHeight());
            h = (int)((double)h + (FACDetailsPanel.this.facProduct.getPreferredSize().getHeight() + (double)FACDetailsPanel.this.verticalBorder));
            h += 200 + FACDetailsPanel.this.verticalBorder;
            h = (int)((double)h + (FACDetailsPanel.this.decision.getPreferredSize().getHeight() + (double)FACDetailsPanel.this.verticalBorder));
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            FACDetailsPanel.this.facReportNumber.setLocation(FACDetailsPanel.this.horizontalBorder, FACDetailsPanel.this.verticalBorder);
            FACDetailsPanel.this.facReportNumber.setSize(150, (int)FACDetailsPanel.this.facReportNumber.getPreferredSize().getHeight());
            FACDetailsPanel.this.facCustomer.setLocation(FACDetailsPanel.this.horizontalBorder, FACDetailsPanel.this.facReportNumber.getY() + FACDetailsPanel.this.facReportNumber.getHeight() + FACDetailsPanel.this.verticalBorder);
            FACDetailsPanel.this.facCustomer.setSize(150, (int)FACDetailsPanel.this.facCustomer.getPreferredSize().getHeight());
            FACDetailsPanel.this.facFlight.setLocation(FACDetailsPanel.this.facCustomer.getX() + FACDetailsPanel.this.facCustomer.getWidth() + FACDetailsPanel.this.horizontalBorder, FACDetailsPanel.this.facReportNumber.getY() + FACDetailsPanel.this.facReportNumber.getHeight() + FACDetailsPanel.this.verticalBorder);
            FACDetailsPanel.this.facFlight.setSize(150, (int)FACDetailsPanel.this.facFlight.getPreferredSize().getHeight());
            FACDetailsPanel.this.facFlightDate.setLocation(FACDetailsPanel.this.facCustomer.getX() + FACDetailsPanel.this.facCustomer.getWidth() + FACDetailsPanel.this.horizontalBorder, FACDetailsPanel.this.verticalBorder);
            FACDetailsPanel.this.facFlightDate.setSize(FACDetailsPanel.this.facFlightDate.getPreferredSize());
            FACDetailsPanel.this.facCabinClass.setLocation(FACDetailsPanel.this.facFlightDate.getX() + FACDetailsPanel.this.facFlightDate.getWidth() + FACDetailsPanel.this.horizontalBorder, FACDetailsPanel.this.verticalBorder);
            FACDetailsPanel.this.facCabinClass.setSize(200, (int)FACDetailsPanel.this.facCabinClass.getPreferredSize().getHeight());
            FACDetailsPanel.this.productRelated.setLocation(FACDetailsPanel.this.horizontalBorder, FACDetailsPanel.this.facFlight.getY() + FACDetailsPanel.this.facFlight.getHeight() + FACDetailsPanel.this.verticalBorder * 2);
            FACDetailsPanel.this.productRelated.setSize(FACDetailsPanel.this.productRelated.getPreferredSize());
            FACDetailsPanel.this.facProduct.setLocation(FACDetailsPanel.this.horizontalBorder, FACDetailsPanel.this.productRelated.getY() + FACDetailsPanel.this.productRelated.getHeight());
            FACDetailsPanel.this.facProduct.setSize(200, (int)FACDetailsPanel.this.facProduct.getPreferredSize().getHeight());
            FACDetailsPanel.this.facRecipe.setLocation(FACDetailsPanel.this.facProduct.getX() + FACDetailsPanel.this.facProduct.getWidth() + FACDetailsPanel.this.horizontalBorder, FACDetailsPanel.this.productRelated.getY() + FACDetailsPanel.this.productRelated.getHeight());
            FACDetailsPanel.this.facRecipe.setSize(200, (int)FACDetailsPanel.this.facRecipe.getPreferredSize().getHeight());
            FACDetailsPanel.this.facArticle.setLocation(FACDetailsPanel.this.facRecipe.getX() + FACDetailsPanel.this.facRecipe.getWidth() + FACDetailsPanel.this.horizontalBorder, FACDetailsPanel.this.productRelated.getY() + FACDetailsPanel.this.productRelated.getHeight());
            FACDetailsPanel.this.facArticle.setSize(200, (int)FACDetailsPanel.this.facArticle.getPreferredSize().getHeight());
            FACDetailsPanel.this.response.setLocation(FACDetailsPanel.this.horizontalBorder, FACDetailsPanel.this.facArticle.getY() + FACDetailsPanel.this.facArticle.getHeight() + FACDetailsPanel.this.verticalBorder);
            FACDetailsPanel.this.response.setSize(parent.getWidth() - 2 * FACDetailsPanel.this.horizontalBorder, 200);
            FACDetailsPanel.this.decision.setLocation(FACDetailsPanel.this.horizontalBorder, FACDetailsPanel.this.response.getY() + FACDetailsPanel.this.response.getHeight() + FACDetailsPanel.this.verticalBorder);
            FACDetailsPanel.this.decision.setSize(200, (int)FACDetailsPanel.this.decision.getPreferredSize().getHeight());
        }
    }
}

