/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.internalconsumption.details;

import ch.icit.pegasus.client.gui.modules.importer.utils.ImporterItemView;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.buttons.ViewButton;
import ch.icit.pegasus.client.gui.utils.file.FileChooserPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionComplete;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionComplete_;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionLight;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionMovementComplete;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class ImportDetailsPanel
extends DefaultDetailsPanel<InternalConsumptionLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<FileChooserPanel> fileChooser;
    private TextButton loadButton;
    private ViewButton loadTemplate;

    public ImportDetailsPanel(RowEditor<InternalConsumptionLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.IMPORT);
        this.setCustomLayouter(new Layout());
        this.fileChooser = new TitledItem<FileChooserPanel>(new FileChooserPanel(false), "Upload File", TitledItem.TitledItemOrientation.NORTH);
        this.fileChooser.getElement().setFileType("xlsx");
        this.loadButton = new TextButton("Load data");
        this.loadButton.addButtonListener((source, x, y) -> this.loadDataFromFile());
        this.loadTemplate = new ViewButton();
        this.loadTemplate.addButtonListener((source, x, y) -> this.showTemplate());
        this.addToView(this.fileChooser);
        this.addToView(this.loadButton);
        this.addToView(this.loadTemplate);
    }

    private void showTemplate() {
        this.editor.setEnabled(false);
        this.editor.showCommittingAnimation("Load Template");
        try {
            File f = this.downloadFile();
            if (f == null) {
                InnerPopupFactory.showErrorDialog("No template ready. Please contact support.", (Component)this);
            }
            Desktop.getDesktop().open(f);
        }
        catch (IOException e) {
            InnerPopupFactory.showErrorDialog(e, (Component)this);
        }
        this.editor.setEnabled(true);
        this.editor.hideCommittingAnimation();
    }

    private File downloadFile() throws IOException {
        File tempFile = File.createTempFile("ImporterFile_", ".xlsx");
        URL url = this.createURL();
        if (url == null) {
            return null;
        }
        FileUtils.copyURLToFile((URL)url, (File)tempFile);
        return tempFile;
    }

    private URL createURL() throws MalformedURLException {
        return ImporterItemView.class.getResource("/importtemplates/InternalConsumptionImporter.xlsx");
    }

    private void loadDataFromFile() {
        PegasusFileComplete file = (PegasusFileComplete)this.editor.getModel().getNode().getChildNamed(InternalConsumptionComplete_.importFile).getValue();
        if (file == null || file.getLocalFile() == null) {
            InnerPopupFactory.showErrorDialog("No file selected", (Component)this);
            return;
        }
        final PegasusFileComplete sFile = file;
        sFile.setCategory(FileCategoryE.IMPORT);
        this.editor.setEnabled(false);
        this.editor.showCommittingAnimation("Load Components");
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                PegasusFileComplete file = FileTransferUtil.upload((PegasusFileComplete)sFile, (FileTransferListener[])new FileTransferListener[0]);
                InternalConsumptionComplete generated = (InternalConsumptionComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).generateInternalConsumption(file).getValue();
                Node node = ImportDetailsPanel.this.editor.getModel().getNode();
                node.commit(InternalConsumptionComplete.class);
                InternalConsumptionComplete old = (InternalConsumptionComplete)node.getValue();
                InternalConsumptionComplete consumption = (InternalConsumptionComplete)node.getValue(InternalConsumptionComplete.class);
                consumption.setCustomer(old.getCustomer());
                consumption.setCount(old.getCount());
                consumption.setDescription(old.getDescription());
                consumption.setSalesPrice(new PriceComplete(old.getSalesPrice()));
                consumption.setTransactionState(old.getTransactionState());
                consumption.setImportFile(file);
                consumption.setMovementDetailInformation(generated.getMovementDetailInformation());
                consumption.setMovementInformations(generated.getMovementInformations());
                consumption.setConsumptionDate(new Date(generated.getConsumptionDate().getTime()));
                for (InternalConsumptionMovementComplete move : consumption.getMovementInformations()) {
                    if (move.getArticle() == null) continue;
                    move.setArticle((BasicArticleLight)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(move.getArticle().getId())).getValue());
                }
                node.setValue((Object)consumption, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        ImportDetailsPanel.this.editor.setEnabled(true);
                        ImportDetailsPanel.this.editor.hideCommittingAnimation();
                    }

                    public void errorOccurred(ClientException exception) {
                        ImportDetailsPanel.this.editor.setEnabled(true);
                        ImportDetailsPanel.this.editor.hideCommittingAnimation();
                        InnerPopupFactory.showErrorDialog(exception.getMessage(), (Component)ImportDetailsPanel.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.fileChooser.requestFocusInWindowNow();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.fileChooser);
        CheckedListAdder.addToList(focusList, this.loadButton);
        CheckedListAdder.addToList(focusList, this.loadTemplate);
        return focusList;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.fileChooser.setEnabled(isEnabled);
        this.loadButton.setEnabled(isEnabled);
        this.loadTemplate.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.fileChooser.kill();
        this.fileChooser = null;
        this.loadButton.kill();
        this.loadButton = null;
        this.loadTemplate.kill();
        this.loadTemplate = null;
    }

    @Override
    public void setNode(Node<?> node) {
        this.fileChooser.getElement().setNode(node.getChildNamed(InternalConsumptionComplete_.importFile));
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container arg0) {
            ImportDetailsPanel.this.fileChooser.setLocation(ImportDetailsPanel.this.horizontalBorder, ImportDetailsPanel.this.verticalBorder);
            ImportDetailsPanel.this.fileChooser.setSize(360, (int)ImportDetailsPanel.this.fileChooser.getPreferredSize().getHeight());
            ImportDetailsPanel.this.loadButton.setLocation(ImportDetailsPanel.this.fileChooser.getX() + ImportDetailsPanel.this.fileChooser.getWidth() + ImportDetailsPanel.this.inner_horizontalBorder, ImportDetailsPanel.this.verticalBorder + ImportDetailsPanel.this.fileChooser.getHeight() - ((FileChooserPanel)ImportDetailsPanel.this.fileChooser.getElement()).getHeight());
            ImportDetailsPanel.this.loadButton.setSize(ImportDetailsPanel.this.loadButton.getPreferredSize());
            ImportDetailsPanel.this.loadTemplate.setLocation(ImportDetailsPanel.this.loadButton.getX() + ImportDetailsPanel.this.loadButton.getWidth() + ImportDetailsPanel.this.inner_horizontalBorder, ImportDetailsPanel.this.verticalBorder + ImportDetailsPanel.this.fileChooser.getHeight() - ((FileChooserPanel)ImportDetailsPanel.this.fileChooser.getElement()).getHeight());
            ImportDetailsPanel.this.loadTemplate.setSize(ImportDetailsPanel.this.loadTemplate.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension(0, (int)(ImportDetailsPanel.this.fileChooser.getPreferredSize().getHeight() + (double)(2 * ImportDetailsPanel.this.verticalBorder)));
        }
    }
}

