/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.internalconsumption.details;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDInputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionLight;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionLight_;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.NoProExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends DefaultDetailsPanel<InternalConsumptionLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> number;
    private TitledItem<RDTextField> description;
    private TitledItem<RDDateChooser> consumptionDate;
    private TitledItem<RDSearchTextField2> customer;
    private TitledItem<RDComboBox> department;
    private TitledItem<RDTextField> count;
    private TitledItem<RDInputComboBox> salesPrice;
    private boolean isNoPro;

    public SpecificationDetailsPanel(RowEditor<InternalConsumptionLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        this.setCustomLayouter(new Layout());
        this.isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)this.settings);
        this.number = new TitledItem<TextLabel>(new TextLabel(), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.description = new TitledItem<RDTextField>(new RDTextField(provider), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
        this.consumptionDate = new TitledItem<RDDateChooser>(new RDDateChooser(provider), this.isNoPro ? Words.DELIVERY_DATE : Words.CONSUMPTION_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.customer = new TitledItem<RDSearchTextField2<RDSearchTextField2>>(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.CUSTOMER), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setReadOnlyTextField(true);
        if (!this.isNoPro) {
            this.department = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(CostCenterConverter.class), true), Words.DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
            this.count = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.INT), Words.COUNT, TitledItem.TitledItemOrientation.NORTH);
            this.salesPrice = new TitledItem<RDInputComboBox>(new RDInputComboBox(provider, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE), Words.SALES_UP, TitledItem.TitledItemOrientation.NORTH);
        }
        this.addToView(this.number);
        this.addToView(this.description);
        this.addToView(this.consumptionDate);
        this.addToView(this.customer);
        if (!this.isNoPro) {
            this.addToView(this.department);
            this.addToView(this.count);
            this.addToView(this.salesPrice);
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.description.requestFocusInWindowNow();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.description);
        CheckedListAdder.addToList(focusList, this.customer);
        CheckedListAdder.addToList(focusList, this.consumptionDate);
        CheckedListAdder.addToList(focusList, this.department);
        CheckedListAdder.addToList(focusList, this.count);
        CheckedListAdder.addToList(focusList, this.salesPrice);
        return focusList;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.description.getElement().getNode().getValue() == null || ((String)this.description.getElement().getNode().getValue()).isEmpty()) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_DESCRIPTION_IS_SET));
        }
        if (this.isNoPro && (this.customer.getElement().getNode() == null || this.customer.getElement().getNode().getValue() == null)) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.CUSTOMER_MUST_BE_SET));
        }
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.number.setEnabled(isEnabled);
        this.description.setEnabled(isEnabled);
        this.consumptionDate.setEnabled(isEnabled);
        if (!this.isNoPro) {
            this.customer.setEnabled(isEnabled);
            this.department.setEnabled(isEnabled);
            this.count.setEnabled(isEnabled);
            this.salesPrice.setEnabled(isEnabled);
        } else {
            this.customer.setEnabled(false);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.number.kill();
        this.number = null;
        this.description.kill();
        this.description = null;
        this.consumptionDate.kill();
        this.consumptionDate = null;
        this.customer.kill();
        this.customer = null;
        if (!this.isNoPro) {
            this.department.kill();
            this.department = null;
            this.count.kill();
            this.count = null;
            this.salesPrice.kill();
            this.salesPrice = null;
        }
    }

    @Override
    public void setNode(Node<?> node) {
        Node date = node.getChildNamed(InternalConsumptionLight_.consumptionDate);
        if (date.getValue() == null) {
            date.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        }
        this.number.getElement().setNode(node.getChildNamed(InternalConsumptionLight_.number));
        this.description.getElement().setNode(node.getChildNamed(InternalConsumptionLight_.description));
        this.consumptionDate.getElement().setNode(node.getChildNamed(InternalConsumptionLight_.consumptionDate));
        this.customer.getElement().setNode(node.getChildNamed(InternalConsumptionLight_.customer));
        if (!this.isNoPro) {
            Node s;
            this.department.getElement().refreshPossibleValues(NodeToolkit.getAffixList(InternalCostCenterComplete.class));
            this.department.getElement().setNode(node.getChildNamed(InternalConsumptionLight_.department));
            Node c = node.getChildNamed(InternalConsumptionLight_.count);
            if (c.getValue() == null) {
                c.setValue((Object)0, 0L);
            }
            if ((s = node.getChildNamed(InternalConsumptionLight_.salesPrice)).getValue() == null) {
                s.setValue((Object)new PriceComplete(), 0L);
            }
            if (((PriceComplete)s.getValue()).getPrice() == null) {
                ((PriceComplete)s.getValue()).setPrice(Double.valueOf(0.0));
            }
            if (((PriceComplete)s.getValue()).getCurrency() == null) {
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                ((PriceComplete)s.getValue()).setCurrency(settings.getCurrency());
            }
            s.updateNode();
            this.count.getElement().setNode(c);
            this.salesPrice.getElement().setNode(s);
        } else if (node.getChildNamed(InternalConsumptionLight_.customer).getValue() == null) {
            NoProExchangeSettingsComplete noProSettings = (NoProExchangeSettingsComplete)NodeToolkit.getAffixClass(NoProExchangeSettingsComplete.class).getValue();
            node.getChildNamed(InternalConsumptionLight_.customer).setValue((Object)noProSettings.getNoProAsCustomer(), 0L);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container arg0) {
            SpecificationDetailsPanel.this.number.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.number.setSize(120, (int)SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.description.setLocation(SpecificationDetailsPanel.this.number.getX() + SpecificationDetailsPanel.this.number.getWidth() + SpecificationDetailsPanel.this.inner_horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.description.setSize(240, (int)SpecificationDetailsPanel.this.description.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.customer.setLocation(SpecificationDetailsPanel.this.description.getX() + SpecificationDetailsPanel.this.description.getWidth() + SpecificationDetailsPanel.this.inner_horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.customer.setSize(120, (int)SpecificationDetailsPanel.this.customer.getPreferredSize().getHeight());
            int currentX = SpecificationDetailsPanel.this.customer.getX() + SpecificationDetailsPanel.this.customer.getWidth();
            if (!SpecificationDetailsPanel.this.isNoPro) {
                SpecificationDetailsPanel.this.department.setLocation(SpecificationDetailsPanel.this.customer.getX() + SpecificationDetailsPanel.this.customer.getWidth() + SpecificationDetailsPanel.this.inner_horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
                SpecificationDetailsPanel.this.department.setSize(120, (int)SpecificationDetailsPanel.this.department.getPreferredSize().getHeight());
                currentX = SpecificationDetailsPanel.this.department.getX() + SpecificationDetailsPanel.this.department.getWidth();
            }
            SpecificationDetailsPanel.this.consumptionDate.setLocation(currentX + SpecificationDetailsPanel.this.inner_horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.consumptionDate.setSize(SpecificationDetailsPanel.this.consumptionDate.getPreferredSize());
            if (!SpecificationDetailsPanel.this.isNoPro) {
                SpecificationDetailsPanel.this.count.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.consumptionDate.getY() + SpecificationDetailsPanel.this.consumptionDate.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
                SpecificationDetailsPanel.this.count.setSize(80, (int)SpecificationDetailsPanel.this.count.getPreferredSize().getHeight());
                SpecificationDetailsPanel.this.salesPrice.setLocation(SpecificationDetailsPanel.this.count.getX() + SpecificationDetailsPanel.this.count.getWidth() + SpecificationDetailsPanel.this.inner_horizontalBorder, SpecificationDetailsPanel.this.count.getY());
                SpecificationDetailsPanel.this.salesPrice.setSize(SpecificationDetailsPanel.this.salesPrice.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension(0, (int)(SpecificationDetailsPanel.this.consumptionDate.getPreferredSize().getHeight() + (!SpecificationDetailsPanel.this.isNoPro ? (double)SpecificationDetailsPanel.this.inner_verticalBorder + SpecificationDetailsPanel.this.salesPrice.getPreferredSize().getHeight() : 0.0) + (double)(2 * SpecificationDetailsPanel.this.verticalBorder)));
        }
    }
}

