/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.inventory.details;

import ch.icit.pegasus.client.gui.modules.inventory.details.StoreDetailsPanel;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextButton;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.InventoryServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryComplete_;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.InventoryStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.InventoryAccess;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ActionDetailsPanel
extends DefaultDetailsPanel<InventoryLight>
implements ButtonListener,
NodeListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDTextButton> startInventory;
    private TitledItem<RDTextButton> closeInventory;
    private TitledItem<RDTextButton> startAllInventory;
    private TitledItem<RDTextButton> approveInventory;
    private UserReference user;
    private StoreDetailsPanel stores;

    public ActionDetailsPanel(RowEditor<InventoryLight> editor, RDProvider provider, UserReference user, StoreDetailsPanel stores) {
        super(editor, provider);
        this.user = user;
        this.stores = stores;
        this.setTitleText(Words.ACTIONS);
        this.startInventory = new TitledItem<RDTextButton>(new RDTextButton(provider), Words.START_INVENTORY, TitledItem.TitledItemOrientation.EAST);
        this.startInventory.getElement().setText(Words.START);
        this.startInventory.getElement().setOverrideName(InventoryAccess.START);
        this.startAllInventory = new TitledItem<RDTextButton>(new RDTextButton(provider), Words.START_AND_BLOCK_STORE, TitledItem.TitledItemOrientation.EAST);
        this.startAllInventory.getElement().setText(Words.START);
        this.startAllInventory.getElement().setOverrideName(InventoryAccess.START);
        this.closeInventory = new TitledItem<RDTextButton>(new RDTextButton(provider), Words.FINISH_INVENTORY_COUNT, TitledItem.TitledItemOrientation.EAST);
        this.closeInventory.getElement().setText(Words.COUNTED);
        this.closeInventory.getElement().setOverrideName(InventoryAccess.STOP);
        this.approveInventory = new TitledItem<RDTextButton>(new RDTextButton(provider), Words.FINISH_INVENTORY, TitledItem.TitledItemOrientation.EAST);
        this.approveInventory.getElement().setText(Words.APPROVE);
        this.approveInventory.getElement().setOverrideName(InventoryAccess.APPROVE);
        this.startInventory.getElement().setNode(null);
        this.startAllInventory.getElement().setNode(null);
        this.closeInventory.getElement().setNode(null);
        this.approveInventory.getElement().setNode(null);
        this.startInventory.getElement().addButtonListener(this);
        this.startAllInventory.getElement().addButtonListener(this);
        this.closeInventory.getElement().addButtonListener(this);
        this.approveInventory.getElement().addButtonListener(this);
        this.startInventory.setProgress(1.0f);
        this.startAllInventory.setProgress(1.0f);
        this.closeInventory.setProgress(1.0f);
        this.approveInventory.setProgress(1.0f);
        this.setCustomLayouter(new Layout());
        this.addToView(this.startInventory);
        this.addToView(this.startAllInventory);
        this.addToView(this.closeInventory);
        this.addToView(this.approveInventory);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.startInventory);
        CheckedListAdder.addToList(focusList, this.startAllInventory);
        CheckedListAdder.addToList(focusList, this.closeInventory);
        CheckedListAdder.addToList(focusList, this.approveInventory);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.ensureInventoryState(node.getChildNamed(InventoryLight_.state));
        node.getChildNamed(InventoryLight_.state).addNodeListener((NodeListener)this);
    }

    private void ensureInventoryState(Node<?> node) {
        InventoryStateE e = (InventoryStateE)node.getValue();
        if (e == null) {
            e = InventoryStateE.COUNTED;
        }
        switch (e) {
            case APPROVED: {
                this.startAllInventory.setEnabled(false);
                this.startInventory.setEnabled(false);
                this.closeInventory.setEnabled(false);
                this.approveInventory.setEnabled(false);
                break;
            }
            case COUNTED: {
                this.approveInventory.setEnabled(this.approveInventory.isEnabled());
                this.closeInventory.getElement().setEnabled(false);
                this.startAllInventory.setEnabled(false);
                this.startInventory.setEnabled(false);
                break;
            }
            case STARTED: {
                this.approveInventory.setEnabled(false);
                this.closeInventory.setEnabled(this.closeInventory.isEnabled());
                this.startInventory.getElement().setEnabled(false);
                this.startAllInventory.getElement().setEnabled(false);
                break;
            }
            case PLANNED: {
                this.startInventory.getElement().setEnabled(this.startInventory.isEnabled());
                this.startAllInventory.getElement().setEnabled(this.startAllInventory.isEnabled());
                this.closeInventory.getElement().setEnabled(false);
                this.approveInventory.getElement().setEnabled(false);
            }
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.editor.getModel().getNode().getChildNamed(InventoryLight_.state) != null) {
            InventoryStateE e = (InventoryStateE)this.editor.getModel().getNode().getChildNamed(InventoryLight_.state).getValue();
            if (e == null) {
                e = InventoryStateE.PLANNED;
                this.editor.getModel().getNode().getChildNamed(InventoryLight_.state).setValue((Object)e, System.currentTimeMillis());
            }
            switch (e) {
                case APPROVED: {
                    this.startInventory.setEnabled(false);
                    this.startAllInventory.setEnabled(false);
                    this.closeInventory.setEnabled(false);
                    this.approveInventory.setEnabled(false);
                    break;
                }
                case COUNTED: {
                    this.startInventory.setEnabled(false);
                    this.startAllInventory.setEnabled(false);
                    this.closeInventory.setEnabled(false);
                    this.approveInventory.setEnabled(true);
                    break;
                }
                case PLANNED: {
                    this.startInventory.setEnabled(isEnabled);
                    this.startAllInventory.setEnabled(isEnabled);
                    this.closeInventory.setEnabled(false);
                    this.approveInventory.setEnabled(false);
                    break;
                }
                case STARTED: {
                    this.startInventory.setEnabled(false);
                    this.startAllInventory.setEnabled(false);
                    this.closeInventory.setEnabled(isEnabled);
                    this.approveInventory.setEnabled(false);
                }
            }
        } else {
            this.startInventory.setEnabled(false);
            this.startAllInventory.setEnabled(false);
            this.closeInventory.setEnabled(false);
            this.approveInventory.setEnabled(false);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.editor.getModel().getNode().getChildNamed(InventoryLight_.state) != null) {
            this.editor.getModel().getNode().getChildNamed(InventoryLight_.state).removeNodeListener((NodeListener)this);
        }
        this.startInventory.kill();
        this.startAllInventory.kill();
        this.closeInventory.kill();
        this.approveInventory.kill();
        this.startInventory = null;
        this.startAllInventory = null;
        this.closeInventory = null;
        this.approveInventory = null;
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.startInventory.isEnabled()) {
            this.startInventory.requestFocusInWindowNow();
        } else if (this.closeInventory.isEnabled()) {
            this.closeInventory.requestFocusInWindowNow();
        } else if (this.startAllInventory.isEnabled()) {
            this.startAllInventory.requestFocusInWindowNow();
        } else if (this.approveInventory.isEnabled()) {
            this.approveInventory.requestFocusInWindowNow();
        }
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.startInventory.getElement().getEditor()) {
            this.editor.setEnabled(false);
            this.editor.showCommittingAnimation(Words.START_INVENTORY);
            this.editor.getModel().getNode().commitThis(InventoryComplete.class);
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    ActionDetailsPanel.this.editor.getModel().getNode().commit(InventoryComplete.class);
                    InventoryComplete i = (InventoryComplete)ActionDetailsPanel.this.editor.getModel().getNode().getValue(InventoryComplete.class);
                    i = (InventoryComplete)((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).updateInventory(i).getValue();
                    InventoryComplete inventory = (InventoryComplete)((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).startInventory((InventoryLight)i).getValue();
                    ActionDetailsPanel.this.editor.getModel().getNode().removeExistingValues();
                    ActionDetailsPanel.this.editor.getModel().getNode().setValue((Object)inventory, 0L);
                    ActionDetailsPanel.this.editor.getModel().getNode().updateNode();
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return ActionDetailsPanel.this;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else if (this.startAllInventory.getElement().getEditor() == source) {
            this.editor.setEnabled(false);
            this.editor.showCommittingAnimation(Words.START_INVENTORY);
            this.editor.getModel().getNode().commitThis(InventoryComplete.class);
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    ActionDetailsPanel.this.editor.getModel().getNode().commit(InventoryComplete.class);
                    InventoryComplete i = (InventoryComplete)ActionDetailsPanel.this.editor.getModel().getNode().getValue(InventoryComplete.class);
                    i = (InventoryComplete)((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).updateInventory(i).getValue();
                    InventoryComplete inventory = (InventoryComplete)((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).startFullInventory((InventoryLight)i).getValue();
                    ActionDetailsPanel.this.editor.getModel().getNode().removeExistingValues();
                    ActionDetailsPanel.this.editor.getModel().getNode().setValue((Object)inventory, 0L);
                    ActionDetailsPanel.this.editor.getModel().getNode().updateNode();
                    Iterator it = ActionDetailsPanel.this.editor.getModel().getNode().getChildNamed(InventoryComplete_.stores).getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node node = (Node)it.next();
                        node.updateNode();
                    }
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return ActionDetailsPanel.this;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else if (source == this.closeInventory.getElement().getEditor()) {
            InnerPopupFactory.showDesicionPopup(Words.FINISH_COUNT, this.getPopupText(), source, new InnerPopUpListener2(){

                @Override
                public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                    if (xargs == null) {
                        return;
                    }
                    ActionDetailsPanel.this.editor.setEnabled(false);
                    ActionDetailsPanel.this.editor.showCommittingAnimation(Words.FINISH_INVENTORY_COUNT);
                    ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                        @Override
                        public Node<?> loadData() throws Exception {
                            InventoryComplete i = (InventoryComplete)ActionDetailsPanel.this.editor.getModel().getNode().getValue(InventoryComplete.class);
                            try {
                                i = (InventoryComplete)((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).updateInventory(i).getValue();
                                InventoryLight inventory = (InventoryLight)((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).closeFullInventory((InventoryLight)i).getValue();
                                ActionDetailsPanel.this.editor.getModel().getNode().removeExistingValues();
                                ActionDetailsPanel.this.editor.getModel().getNode().setValue((Object)inventory, 0L);
                                ActionDetailsPanel.this.editor.getModel().getNode().updateNode();
                            }
                            catch (ClientServerCallException e) {
                                ViewNode r = new ViewNode("Error");
                                r.setValue((Object)e, 0L);
                                return r;
                            }
                            return null;
                        }

                        @Override
                        public RemoteLoader getInvoker() {
                            return ActionDetailsPanel.this;
                        }

                        @Override
                        public long getID() {
                            return 0L;
                        }
                    };
                    ThreadSafeLoader.run(run);
                }
            }, 350, -1);
        } else if (source == this.approveInventory.getElement().getEditor()) {
            InnerPopupFactory.showDesicionPopup(Words.APPROVE_INVENTORY, Words.ARE_YOU_SURE_TO_APPROVE_INVENTORY, source, new InnerPopUpListener2(){

                @Override
                public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                    if (xargs == null) {
                        return;
                    }
                    ActionDetailsPanel.this.editor.setEnabled(false);
                    ActionDetailsPanel.this.editor.showCommittingAnimation(Words.APPROVE_INVENTORY);
                    ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                        @Override
                        public Node<?> loadData() throws Exception {
                            InventoryComplete i = (InventoryComplete)ActionDetailsPanel.this.editor.getModel().getNode().getValue(InventoryComplete.class);
                            i.setState(InventoryStateE.APPROVED);
                            try {
                                i = (InventoryComplete)((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).updateInventory(i).getValue();
                                ActionDetailsPanel.this.editor.getModel().getNode().removeExistingValues();
                                ActionDetailsPanel.this.editor.getModel().getNode().setValue((Object)i, 0L);
                                ActionDetailsPanel.this.editor.getModel().getNode().updateNode();
                            }
                            catch (ClientSaveOnServerException e) {
                                ViewNode r = new ViewNode("Error");
                                r.setValue((Object)e, 0L);
                                return r;
                            }
                            return null;
                        }

                        @Override
                        public RemoteLoader getInvoker() {
                            return ActionDetailsPanel.this;
                        }

                        @Override
                        public long getID() {
                            return 0L;
                        }
                    };
                    ThreadSafeLoader.run(run);
                }
            }, 350, -1);
        }
    }

    private String getPopupText() {
        Node i = this.editor.getModel().getNode().getChildNamed(new String[]{"partly"});
        if (i != null && i.getValue() != null && ((Boolean)i.getValue()).booleanValue()) {
            return Words.STYLED_FINISH_INVENTORY_COUNT_PARTLY;
        }
        return Words.STYLED_FINISH_INVENTORY_COUNT;
    }

    public void valueChanged(Node<?> node) {
        this.ensureInventoryState(node);
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.stores.resetTable();
        this.editor.hideCommittingAnimation();
        this.editor.setEnabled(true);
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ActionDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ActionDetailsPanel.this.startInventory.getPreferredSize().getHeight());
            h += ActionDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ActionDetailsPanel.this.startAllInventory.getPreferredSize().getHeight());
            h += ActionDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ActionDetailsPanel.this.closeInventory.getPreferredSize().getHeight());
            h += ActionDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ActionDetailsPanel.this.approveInventory.getPreferredSize().getHeight());
            return new Dimension(0, h += ActionDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            ActionDetailsPanel.this.startInventory.setLocation(ActionDetailsPanel.this.horizontalBorder, ActionDetailsPanel.this.verticalBorder);
            ActionDetailsPanel.this.startInventory.setSize(parent.getWidth() - 2 * ActionDetailsPanel.this.horizontalBorder, (int)ActionDetailsPanel.this.startInventory.getPreferredSize().getHeight());
            ActionDetailsPanel.this.startAllInventory.setLocation(ActionDetailsPanel.this.horizontalBorder, ActionDetailsPanel.this.startInventory.getY() + ActionDetailsPanel.this.startInventory.getHeight() + ActionDetailsPanel.this.verticalBorder);
            ActionDetailsPanel.this.startAllInventory.setSize(parent.getWidth() - 2 * ActionDetailsPanel.this.horizontalBorder, (int)ActionDetailsPanel.this.closeInventory.getPreferredSize().getHeight());
            ActionDetailsPanel.this.closeInventory.setLocation(ActionDetailsPanel.this.horizontalBorder, ActionDetailsPanel.this.startAllInventory.getY() + ActionDetailsPanel.this.startAllInventory.getHeight() + ActionDetailsPanel.this.verticalBorder);
            ActionDetailsPanel.this.closeInventory.setSize(parent.getWidth() - 2 * ActionDetailsPanel.this.horizontalBorder, (int)ActionDetailsPanel.this.closeInventory.getPreferredSize().getHeight());
            ActionDetailsPanel.this.approveInventory.setLocation(ActionDetailsPanel.this.horizontalBorder, ActionDetailsPanel.this.closeInventory.getY() + ActionDetailsPanel.this.closeInventory.getHeight() + ActionDetailsPanel.this.verticalBorder);
            ActionDetailsPanel.this.approveInventory.setSize(parent.getWidth() - 2 * ActionDetailsPanel.this.horizontalBorder, (int)ActionDetailsPanel.this.approveInventory.getPreferredSize().getHeight());
        }
    }
}

