/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.inventory.details;

import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextArea;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryComplete_;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.InventoryStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class AdditionalInfoDetailsPanel
extends DefaultDetailsPanel<InventoryLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDTextArea> description;

    public AdditionalInfoDetailsPanel(RowEditor<InventoryLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.ADDITIONAL_INFO);
        this.description = new TitledItem<RDTextArea>(new RDTextArea(provider), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
        this.description.setProgress(1.0f);
        this.description.setIgnorePrefHeight(true);
        this.setCustomLayouter(new Layout());
        this.addToView(this.description);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.description);
        return focusList;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        InventoryStateE e = (InventoryStateE)this.editor.getModel().getNode().getChildNamed(InventoryLight_.state).getValue();
        this.description.setEnabled(isEnabled && e != InventoryStateE.APPROVED);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.description.kill();
        this.description = null;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.description.getElement().setNode(node.getChildNamed(InventoryComplete_.description));
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 200);
        }

        @Override
        public void layoutContainer(Container parent) {
            AdditionalInfoDetailsPanel.this.description.setLocation(AdditionalInfoDetailsPanel.this.horizontalBorder, AdditionalInfoDetailsPanel.this.verticalBorder);
            AdditionalInfoDetailsPanel.this.description.setSize(parent.getWidth() - 2 * AdditionalInfoDetailsPanel.this.horizontalBorder, parent.getHeight() - 2 * AdditionalInfoDetailsPanel.this.verticalBorder);
        }
    }
}

