/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.inventory.details;

import ch.icit.pegasus.client.converter.ArticleChargePriceConverter;
import ch.icit.pegasus.client.converter.ArticleStdPriceConverter;
import ch.icit.pegasus.client.converter.BasicArticleNameConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.QuantityConverter0Decimal;
import ch.icit.pegasus.client.converter.StorePositionShortNameConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.InternationalizedDateTimeConverter;
import ch.icit.pegasus.client.gui.modules.inventory.details.utils.ChangeArticleChargePriceAndUnit;
import ch.icit.pegasus.client.gui.modules.inventory.details.utils.InventoryArticleCountedAmountChangingPopup;
import ch.icit.pegasus.client.gui.submodules.tool.store.article.inventorynew.AddBatchPanelNEW;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.PageableTable2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.ArticleInfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.ArticleProductInfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.StockTransactionSearchAlgorithm;
import ch.icit.pegasus.client.searcher.searchfieldimpls.BasicArticleSearchFieldRemoteSearchAlgorithmForInventory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryCheckinComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight_;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.masterdata.InventoryStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.InventoryAccess;
import ch.icit.pegasus.server.core.dtos.search.StockTransactionSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight_;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.store.transaction.IStockInventoryComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockInventoryComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockInventoryComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.InUseStateE;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import ch.icit.utils.builder.BarcodeBuilder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class InventoryDataDetailsPanel
extends DefaultDetailsPanel<InventoryLight> {
    private static final long serialVersionUID = 1L;
    private PageableTable2 table;
    private static final String ARTICLE_ID = "artilce";
    private static final String STORE_ID = "store";
    private SearchTextField2 articleSearch;
    private SearchTextField2 storeSearch;
    private BasicArticleReference searchCriteria1;
    private StoreReference searchCriteria2;
    boolean isQuantityEditable = false;
    boolean isPriceEditable = false;

    public InventoryDataDetailsPanel(RowEditor<InventoryLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.INVENTORY_DATA);
        this.isQuantityEditable = provider.isWritable(InventoryAccess.EDIT_QUANTITY);
        this.isPriceEditable = provider.isWritable(InventoryAccess.EDIT_PRICE);
        this.table = new PageableTable2(){
            private static final long serialVersionUID = 1L;

            @Override
            public SearchAlgorithm getSearchAlgorithm() {
                return SearchAlgorithmRegistry.getSearchAlgorithm(StockTransactionSearchAlgorithm.class);
            }

            @Override
            public ASearchConfiguration<? extends ADTO, ? extends Enum<?>> filterValueChanged(String id, Object value) {
                if (id == null) {
                    InventoryDataDetailsPanel.this.searchCriteria1 = null;
                    InventoryDataDetailsPanel.this.searchCriteria2 = null;
                } else if (id.equals(InventoryDataDetailsPanel.STORE_ID)) {
                    if (value instanceof StoreLight) {
                        InventoryDataDetailsPanel.this.searchCriteria2 = new StoreReference(((StoreLight)value).getId());
                    } else if (value instanceof Node) {
                        InventoryDataDetailsPanel.this.searchCriteria2 = new StoreReference(((StoreLight)((Node)value).getValue()).getId());
                    } else {
                        InventoryDataDetailsPanel.this.searchCriteria2 = null;
                    }
                } else if (id.equals(InventoryDataDetailsPanel.ARTICLE_ID)) {
                    if (value instanceof BasicArticleLight) {
                        InventoryDataDetailsPanel.this.searchCriteria1 = new BasicArticleReference(((BasicArticleLight)value).getId());
                    } else if (value instanceof Node) {
                        InventoryDataDetailsPanel.this.searchCriteria1 = new BasicArticleReference(((BasicArticleLight)((Node)value).getValue()).getId());
                    } else {
                        InventoryDataDetailsPanel.this.searchCriteria1 = null;
                    }
                }
                StockTransactionSearchConfiguration c = new StockTransactionSearchConfiguration();
                c.setNumResults(this.numberOfShownResults);
                c.setInventory((InventoryReference)InventoryDataDetailsPanel.this.editor.getModel().getNode().getValue());
                c.setArticle(InventoryDataDetailsPanel.this.searchCriteria1);
                c.setStore(InventoryDataDetailsPanel.this.searchCriteria2);
                c.setPageNumber(this.pagination.getCurrentPage() - 1);
                if (c.getPageNumber() < 0) {
                    c.setPageNumber(0);
                }
                return c;
            }

            @Override
            public void fillFilterChain() {
                InventoryDataDetailsPanel.this.articleSearch = this.filterChain.addArticleSearchField(InventoryDataDetailsPanel.ARTICLE_ID, WordsToolkit.toUpperCase((String)Words.ARTICLE));
                Object[] o = new Object[5];
                o[4] = InUseStateE.ALL;
                InventoryDataDetailsPanel.this.articleSearch.setAdditionalSearchField(o);
                InventoryDataDetailsPanel.this.articleSearch.setSearchAlgorithm(new BasicArticleSearchFieldRemoteSearchAlgorithmForInventory());
                this.filterChain.addStoreSearch(InventoryDataDetailsPanel.STORE_ID, WordsToolkit.toUpperCase((String)Words.STORE), true);
            }
        };
        this.table.setFooterPanel(new AddBatchPanelNEW(this));
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, null, null, null, "", 60, 60, 60));
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 40, 40, 40));
        int tw = TableColumnInfo.dateTimeColumnWidth + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(Words.DATE, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.POSITION, null, null, null, "", 180, 180, 180));
        columns.add(new TableColumnInfo(Words.CHARGE, null, null, null, "", 80, 80, 80));
        int cp = 120 + this.table.getInnerCellPadding() + EditButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo(Words.CHARGE_PRICE, null, null, null, "", cp, cp, cp));
        columns.add(new TableColumnInfo(Words.STD_PRICE, null, null, null, "", 120, 120, 120));
        columns.add(new TableColumnInfo(Words.AMOUNT, null, null, null, "", 80, 80, 80));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(7)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.table.getModel().setNode((Node)new ViewNode("CountedNodes"));
        this.table.setSortedColumn(0);
        this.setCustomLayouter(new Layout());
        this.addToView(this.table);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusComponents = new ArrayList<Component>();
        CheckedListAdder.addToList(focusComponents, this.table);
        return this.table.getFocusComponents();
    }

    @Override
    public void requestFocusInWindowNow() {
        this.table.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
        this.table.getFootablePanel().setEnabled(this.isQuantityEditable && isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.table.kill();
        this.table = null;
    }

    @Override
    public void setNode(Node<?> node) {
        if (node.getChildNamed(InventoryLight_.state).getValue() == InventoryStateE.APPROVED) {
            this.isQuantityEditable = false;
        }
        this.table.invokeDefaultSearch();
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel no;
        private TextLabel article;
        private TextLabel date;
        private TextLabel position;
        private TextLabel charge;
        private TextLabel chargePrice;
        private EditButton editChargePrice;
        private TextLabel stdPrice;
        private TextLabel quantity;
        private EditButton editButton;
        private ArticleProductInfoButton infoButton;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.no = new TextLabel(m.getNode().getChildNamed(new DtoField[]{StockInventoryComplete_.article, BasicArticleLight_.number}), ConverterRegistry.getConverter(IntegerConverter.class));
            this.article = new TextLabel(m.getNode().getChildNamed(StockInventoryComplete_.article), ConverterRegistry.getConverter(BasicArticleNameConverter.class));
            this.date = new TextLabel(m.getNode().getChildNamed(StockInventoryComplete_.date), ConverterRegistry.getConverter(InternationalizedDateTimeConverter.class));
            this.position = new TextLabel(m.getNode().getChildNamed(StockInventoryComplete_.storePosition), ConverterRegistry.getConverter(StorePositionShortNameConverter.class));
            if (CompanyUtil.isNoPro((SystemSettingsComplete)InventoryDataDetailsPanel.this.settings)) {
                String barcode = (String)m.getNode().getChildNamed(new DtoField[]{StockInventoryComplete_.charge, ArticleChargeLight_.remoteBarcode}).getValue();
                try {
                    String content = BarcodeBuilder.getBuilder().getBarcodeBuilderEAN13().readBarcodeContentOfEAN13(barcode);
                    this.charge = new TextLabel(content);
                }
                catch (Exception e) {
                    this.charge = new TextLabel(m.getNode().getChildNamed(new DtoField[]{StockInventoryComplete_.charge, ArticleChargeLight_.number}), ConverterRegistry.getConverter(StringConverter.class));
                }
            } else {
                this.charge = new TextLabel(m.getNode().getChildNamed(new DtoField[]{StockInventoryComplete_.charge, ArticleChargeLight_.number}), ConverterRegistry.getConverter(IntegerConverter.class));
            }
            this.chargePrice = new TextLabel(m.getNode().getChildNamed(StockInventoryComplete_.charge), ConverterRegistry.getConverter(ArticleChargePriceConverter.class));
            this.stdPrice = new TextLabel(m.getNode().getChildNamed(StockInventoryComplete_.article), ConverterRegistry.getConverter(ArticleStdPriceConverter.class));
            this.quantity = new TextLabel(m.getNode().getChildNamed(StockInventoryComplete_.amount), ConverterRegistry.getConverter(QuantityConverter0Decimal.class));
            Timestamp date = (Timestamp)m.getNode().getChildNamed(new DtoField[]{StockInventoryComplete_.charge, ArticleChargeLight_.creationDate}).getValue();
            Node validityNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(date.getTime()), false, false);
            this.infoButton = new ArticleInfoButton((Node<BasicArticleReference>)m.getNode().getChildNamed(StockInventoryComplete_.article), (Node<Date>)validityNode, 1001);
            boolean allowed = false;
            UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            if (m.getNode().getValue() instanceof InventoryCheckinComplete) {
                InventoryCheckinComplete checkin = (InventoryCheckinComplete)m.getNode().getValue();
                allowed = StoreToolkit.isAllowed((StoreLight)checkin.getStorePosition().getStore(), (TransactionType)TransactionType.INVENTORY, (UserComplete)currentUser, (SystemSettingsComplete)settings);
            } else if (m.getNode().getValue() instanceof StockInventoryComplete) {
                StockInventoryComplete inv = (StockInventoryComplete)m.getNode().getValue();
                allowed = StoreToolkit.isAllowed((StoreLight)inv.getStorePosition().getStore(), (TransactionType)TransactionType.INVENTORY, (UserComplete)currentUser, (SystemSettingsComplete)settings);
            }
            if (InventoryDataDetailsPanel.this.isQuantityEditable && allowed) {
                this.editButton = new EditButton();
                this.editButton.addButtonListener(this);
            }
            if (InventoryDataDetailsPanel.this.isPriceEditable && allowed) {
                this.editChargePrice = new EditButton();
                this.editChargePrice.addButtonListener(this);
            }
            this.setLayout(new Layout());
            this.add(this.no);
            this.add(this.article);
            this.add(this.date);
            this.add(this.charge);
            this.add(this.chargePrice);
            this.add(this.stdPrice);
            this.add(this.position);
            this.add(this.quantity);
            if (InventoryDataDetailsPanel.this.isQuantityEditable && allowed) {
                this.add(this.editButton);
            }
            if (InventoryDataDetailsPanel.this.isPriceEditable && allowed) {
                this.add(this.editChargePrice);
            }
            this.add(this.infoButton);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.no.kill();
            this.date.kill();
            this.article.kill();
            this.position.kill();
            this.charge.kill();
            this.chargePrice.kill();
            this.stdPrice.kill();
            this.quantity.kill();
            if (InventoryDataDetailsPanel.this.isQuantityEditable && this.editButton != null) {
                this.editButton.kill();
            }
            if (InventoryDataDetailsPanel.this.isPriceEditable && this.editChargePrice != null) {
                this.editChargePrice.kill();
            }
            this.infoButton.kill();
            this.date = null;
            this.no = null;
            this.article = null;
            this.position = null;
            this.charge = null;
            this.chargePrice = null;
            this.stdPrice = null;
            this.quantity = null;
            this.editButton = null;
            this.editChargePrice = null;
            this.infoButton = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    Node a;
                    if (this.model.getNode() == null || (a = this.model.getNode().getChildNamed(StockInventoryComplete_.article)) == null || a.getValue() == null || a.getChildNamed(BasicArticleLight_.number) == null || a.getChildNamed(BasicArticleLight_.number).getValue() == null) break;
                    return a.getChildNamed(BasicArticleLight_.number).getValue();
                }
                case 1: {
                    Node a;
                    if (this.model.getNode() == null || (a = this.model.getNode().getChildNamed(StockInventoryComplete_.article)) == null || a.getValue() == null || a.getChildNamed(BasicArticleLight_.name) == null || a.getChildNamed(BasicArticleLight_.name).getValue() == null) break;
                    return a.getChildNamed(BasicArticleLight_.name).getValue();
                }
                case 3: {
                    return this.model.getNode().getChildNamed(new DtoField[]{StockInventoryComplete_.charge, ArticleChargeLight_.number}).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            InventoryStateE e = (InventoryStateE)InventoryDataDetailsPanel.this.editor.getModel().getNode().getChildNamed(InventoryLight_.state).getValue();
            boolean b = e != InventoryStateE.APPROVED;
            this.date.setEnabled(b);
            this.article.setEnabled(isEnabled && b);
            this.position.setEnabled(isEnabled && b);
            this.quantity.setEnabled(isEnabled && b);
            if (InventoryDataDetailsPanel.this.isQuantityEditable && this.editButton != null) {
                this.editButton.setEnabled(isEnabled && b);
            }
            if (InventoryDataDetailsPanel.this.isPriceEditable && this.editChargePrice != null) {
                this.editChargePrice.setEnabled(isEnabled && b);
            }
            this.infoButton.setEnabled(isEnabled);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            IStockInventoryComplete checkIn = (IStockInventoryComplete)this.model.getNode().getValue();
            StoreLight store = null;
            store = this.model.getNode().getValue() instanceof InventoryCheckinComplete ? ((InventoryCheckinComplete)this.model.getNode().getValue()).getStorePosition().getStore() : ((StockInventoryComplete)this.model.getNode().getValue()).getStorePosition().getStore();
            if (source == this.editButton) {
                Node articleCharge = this.model.getNode().getChildNamed(StockInventoryComplete_.charge);
                Node oldAmount = this.model.getNode().getChildNamed(StockInventoryComplete_.amount);
                Node newAmount = this.model.getNode().getChildNamed(DtoFieldConstants.NEW_AMOUNT);
                Node artC = this.model.getNode().getChildNamed(StockInventoryComplete_.article);
                Node changeStore = this.model.getNode().getChildNamed(DtoFieldConstants.CHANGE_STORE);
                Node remark = this.model.getNode().getChildNamed(DtoFieldConstants.NREMARK);
                if (newAmount == null) {
                    StoreQuantityComplete q = new StoreQuantityComplete();
                    q.setClientOId(Long.valueOf(q.getNextId()));
                    StoreQuantityComplete oq = (StoreQuantityComplete)oldAmount.getValue();
                    q.setAmount(oq.getAmount());
                    q.setUnit(oq.getUnit());
                    newAmount = INodeCreator.getDefaultImpl().getNode4DTO((Object)q, false, false);
                    newAmount.setName(DtoFieldConstants.NEW_AMOUNT);
                    this.model.getNode().addChild(newAmount, 0L);
                }
                if (changeStore == null) {
                    changeStore = new Node();
                    changeStore.setValue((Object)false, 0L);
                    changeStore.setName(DtoFieldConstants.CHANGE_STORE);
                    this.model.getNode().addChild(changeStore, 0L);
                }
                if (remark == null) {
                    remark = new Node();
                    remark.setName(DtoFieldConstants.NREMARK);
                    this.model.getNode().addChild(remark, 0L);
                }
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(this.editButton, true, true, Words.CHANGE_COUNTED_AMOUNT);
                popUp.setView(new InventoryArticleCountedAmountChangingPopup((Node<ArticleChargeLight>)articleCharge, (Node<StoreQuantityComplete>)newAmount, (Node<StoreQuantityComplete>)oldAmount, (Node<Boolean>)changeStore, remark, (Node<BasicArticleLight>)artC, store));
                popUp.showPopUp(x, y, 200, 180, (source1, xargs) -> {
                    if (xargs == null) {
                        this.model.getNode().removeChild(this.model.getNode().getChildNamed(DtoFieldConstants.NEW_AMOUNT), 0L);
                    } else {
                        this.quantity.setLeftUpperCornerPainting(true, AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("productionplanner_stocksetted_color")));
                        Node c = InventoryDataDetailsPanel.this.editor.getModel().getNode().getChildNamed(DtoFieldConstants.CHANGED_COUNTS);
                        if (c == null) {
                            c = new Node();
                            c.setName(DtoFieldConstants.CHANGED_COUNTS);
                            InventoryDataDetailsPanel.this.editor.getModel().getNode().addChild(c, 0L);
                        }
                        Iterator it = c.getChilds();
                        boolean alreadyAdded = false;
                        while (it.hasNext()) {
                            Node nn = (Node)it.next();
                            if (!nn.getValue().equals(checkIn)) continue;
                            alreadyAdded = true;
                        }
                        if (!alreadyAdded) {
                            c.addChild(this.model.getNode(), 0L);
                        }
                    }
                }, this.editButton);
            } else if (this.editChargePrice == source) {
                Node articleCharge = this.model.getNode().getChildNamed(StockInventoryComplete_.charge);
                Node oldPrice = this.model.getNode().getChildNamed(new DtoField[]{StockInventoryComplete_.charge, ArticleChargeLight_.price});
                Node newPrice = this.model.getNode().getChildNamed(DtoFieldConstants.NEW_PRICE);
                Node oldPriceUnit = this.model.getNode().getChildNamed(new DtoField[]{StockInventoryComplete_.charge, ArticleChargeLight_.priceUnit});
                Node newPriceUnit = this.model.getNode().getChildNamed(DtoFieldConstants.NEW_PRICE_UNIT);
                Node changeOrder = this.model.getNode().getChildNamed(DtoFieldConstants.CHANGE_ORDER);
                Node artC = this.model.getNode().getChildNamed(StockInventoryComplete_.article);
                if (newPrice == null) {
                    PriceComplete q = new PriceComplete();
                    q.setClientOId(Long.valueOf(q.getNextId()));
                    PriceComplete oq = (PriceComplete)oldPrice.getValue();
                    q.setCurrency(oq.getCurrency());
                    q.setPrice(oq.getPrice());
                    newPrice = INodeCreator.getDefaultImpl().getNode4DTO((Object)q, false, false);
                    newPrice.setName(DtoFieldConstants.NEW_PRICE);
                    this.model.getNode().addChild(newPrice, 0L);
                }
                if (newPriceUnit == null) {
                    newPriceUnit = new DTOProxyNode(oldPriceUnit.getValue());
                    newPriceUnit.setName(DtoFieldConstants.NEW_PRICE_UNIT);
                    this.model.getNode().addChild(newPriceUnit, 0L);
                }
                if (changeOrder == null) {
                    changeOrder = new Node();
                    changeOrder.setName(DtoFieldConstants.CHANGE_ORDER);
                    this.model.getNode().addChild(changeOrder, 0L);
                }
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(this.editButton, true, true, Words.CHANGE_CHARGE_PRICE);
                popUp.setView(new ChangeArticleChargePriceAndUnit((Node<ArticleChargeLight>)articleCharge, (Node<PriceComplete>)newPrice, (Node<PriceComplete>)oldPrice, (Node<Boolean>)changeOrder, (Node<UnitComplete>)oldPriceUnit, (Node<UnitComplete>)newPriceUnit, (Node<BasicArticleLight>)artC));
                popUp.showPopUp(x, y, 200, 180, (source12, xargs) -> {
                    if (xargs == null) {
                        this.model.getNode().removeChild(this.model.getNode().getChildNamed(DtoFieldConstants.NEW_PRICE), 0L);
                        this.model.getNode().removeChild(this.model.getNode().getChildNamed(DtoFieldConstants.NEW_PRICE_UNIT), 0L);
                        this.model.getNode().removeChild(this.model.getNode().getChildNamed(DtoFieldConstants.CHANGE_ORDER), 0L);
                    } else {
                        this.chargePrice.setLeftUpperCornerPainting(true, AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("productionplanner_stocksetted_color")));
                        Node c = InventoryDataDetailsPanel.this.editor.getModel().getNode().getChildNamed(DtoFieldConstants.CHANGED_PRICES);
                        if (c == null) {
                            c = new Node();
                            c.setName(DtoFieldConstants.CHANGED_PRICES);
                            InventoryDataDetailsPanel.this.editor.getModel().getNode().addChild(c, 0L);
                        }
                        Iterator it = c.getChilds();
                        boolean alreadyAdded = false;
                        while (it.hasNext()) {
                            Node nn = (Node)it.next();
                            if (!nn.getValue().equals(checkIn)) continue;
                            alreadyAdded = true;
                        }
                        if (!alreadyAdded) {
                            c.addChild(this.model.getNode(), 0L);
                        }
                    }
                }, this.editChargePrice);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.no.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.no.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.no.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.no.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.article.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.article.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.article.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.infoButton.getPreferredSize().getWidth())), (int)TableRowImpl.this.article.getPreferredSize().getHeight());
                TableRowImpl.this.infoButton.setLocation(TableRowImpl.this.article.getX() + TableRowImpl.this.article.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.infoButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.infoButton.setSize(TableRowImpl.this.infoButton.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.date.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.date.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.date.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.date.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.position.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.position.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.position.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.position.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.charge.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.charge.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.charge.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.charge.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                int a = 0;
                if (InventoryDataDetailsPanel.this.isPriceEditable && TableRowImpl.this.editChargePrice != null) {
                    a = (int)((double)a + ((double)TableRowImpl.this.getInnerCellPadding() + TableRowImpl.this.editChargePrice.getPreferredSize().getWidth()));
                }
                TableRowImpl.this.chargePrice.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.chargePrice.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.chargePrice.setSize((int)TableRowImpl.this.chargePrice.getPreferredSize().getWidth(), (int)TableRowImpl.this.chargePrice.getPreferredSize().getHeight());
                if (InventoryDataDetailsPanel.this.isPriceEditable && TableRowImpl.this.editChargePrice != null) {
                    TableRowImpl.this.editChargePrice.setLocation(currentX + w - (TableRowImpl.this.getCellPadding() + EditButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL)), (int)(((double)parent.getHeight() - TableRowImpl.this.editChargePrice.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.editChargePrice.setSize(TableRowImpl.this.editChargePrice.getPreferredSize());
                }
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(6);
                TableRowImpl.this.stdPrice.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.stdPrice.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.stdPrice.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.stdPrice.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(7);
                a = 0;
                if (InventoryDataDetailsPanel.this.isQuantityEditable && TableRowImpl.this.editButton != null) {
                    a = (int)((double)a + ((double)TableRowImpl.this.getInnerCellPadding() + TableRowImpl.this.editButton.getPreferredSize().getWidth()));
                }
                TableRowImpl.this.quantity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.quantity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.quantity.setSize(w - (2 * TableRowImpl.this.getCellPadding() + a), (int)TableRowImpl.this.quantity.getPreferredSize().getHeight());
                if (InventoryDataDetailsPanel.this.isQuantityEditable && TableRowImpl.this.editButton != null) {
                    TableRowImpl.this.editButton.setLocation(TableRowImpl.this.quantity.getWidth() + TableRowImpl.this.quantity.getX() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.editButton.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.editButton.setSize(TableRowImpl.this.editButton.getPreferredSize());
                }
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 450);
        }

        @Override
        public void layoutContainer(Container parent) {
            InventoryDataDetailsPanel.this.table.setLocation(0, 0);
            InventoryDataDetailsPanel.this.table.setSize(parent.getSize());
        }
    }
}

