/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.inventory.details;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.StoreTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.hud.externopentool.DtoSmartExternOpenTool;
import ch.icit.pegasus.client.gui.modules.inventory.details.utils.PrintAllWorksheetsPopup;
import ch.icit.pegasus.client.gui.modules.inventory.details.utils.PrintRemainsPopupInsert;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.submodules.print.store.inventory.PrintInventoryWorksheetComponent;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.CursorController;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.LockButton;
import ch.icit.pegasus.client.gui.utils.buttons.PrintInventoryWorksheetButton;
import ch.icit.pegasus.client.gui.utils.buttons.PrintRemainingChargesButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextButton;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.ProxyNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.InventoryServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryComplete_;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight_;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryStoreComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryStoreComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.InventoryStateE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.InventoryAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.StoreAccess;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StoreSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreLight_;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.store.StoreTypeE;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class StoreDetailsPanel
extends TableDetailsPanel<InventoryLight>
implements NodeListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private boolean isAddRow;
    private InventoryStateE inventoryState;
    private boolean isDeletable;
    private RDComboBox storeType;
    private RDTextButton addAll;
    private TextButton printAllWorkSheets;

    public StoreDetailsPanel(RowEditor<InventoryLight> editor, RDProvider provider, boolean isAddRow) {
        super(editor, provider, true);
        this.isAddRow = isAddRow;
        this.isDeletable = provider.isDeletable(InventoryComplete_.stores);
        this.setTitleText(Words.STORES);
        this.storeType = new RDComboBox(provider, ConverterRegistry.getConverter(StoreTypeConverter.class));
        this.storeType.setOverrideName(InventoryComplete_.stores);
        this.storeType.setNode(null);
        this.storeType.addItem(Words.ALL);
        this.storeType.addItem(StoreTypeE.CIRCULATION);
        this.storeType.addItem(StoreTypeE.CONSUMPTION);
        this.storeType.addItem(StoreTypeE.NORMAL);
        this.storeType.addItem(StoreTypeE.WASTE_WITH_CONSUMPTION);
        this.storeType.addItem(StoreTypeE.WASTE_WITHOUT_CONSUMPTION);
        this.addAll = new RDTextButton(provider);
        this.addAll.setOverrideName(InventoryComplete_.stores);
        this.addAll.setNode(null);
        this.addAll.setText(Words.ADD_ALL);
        this.addAll.addButtonListener(this);
        this.printAllWorkSheets = new TextButton(Words.PRINT_ALL_WORKSHEETS);
        this.printAllWorkSheets.addButtonListener(this);
        this.addToView(this.storeType);
        this.addToView(this.addAll);
        this.addToView(this.printAllWorkSheets);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.CODE, null, null, null, "", 40, 40, 40));
        if (!this.isAddRow) {
            columns.add(new TableColumnInfo(Words.OPTIONS, null, null, null, "", 200, 200, 200));
        }
        int tw = 2 * this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        if (!this.isAddRow) {
            ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        }
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setProvider(this.provider);
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        InventoryStoreComplete s = new InventoryStoreComplete();
        s.setClientOId(Long.valueOf(ADTO.getNextId()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)s, true, false);
        this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl rowPanel = new TableRowImpl(model);
        rowPanel.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return rowPanel;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.table);
        CheckedListAdder.addToList(focusList, this.storeType);
        CheckedListAdder.addToList(focusList, this.addAll);
        CheckedListAdder.addToList(focusList, this.printAllWorkSheets);
        return focusList;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.addAll.getEditor()) {
            final StoreSearchConfiguration sc = new StoreSearchConfiguration();
            sc.setIsDeleted(Boolean.valueOf(false));
            if (this.storeType.getSelectedItem() != Words.ALL) {
                sc.setStoreType((StoreTypeE)this.storeType.getSelectedItem());
            }
            sc.setNumResults(Integer.MAX_VALUE);
            this.editor.setEnabled(false);
            this.editor.showCommittingAnimation(Words.LOAD_STORES);
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    SearchResult r = null;
                    r = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)sc);
                    Node n = new Node();
                    n.setValue((Object)r, 0L);
                    return n;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            if (node.getValue() instanceof SearchResult) {
                                SearchResult r = (SearchResult)node.getValue();
                                for (StoreLight l : r.getResults()) {
                                    if (this.isStoreContaining(l)) continue;
                                    InventoryStoreComplete rr = new InventoryStoreComplete();
                                    rr.setClientOId(Long.valueOf(ADTO.getNextId()));
                                    rr.setSequence(Integer.valueOf(StoreDetailsPanel.this.table.getRowCount()));
                                    rr.setStore((StoreReference)l);
                                    Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)rr, true, false);
                                    StoreDetailsPanel.this.table.getModel().getNode().addChild(n, 0L);
                                }
                                StoreDetailsPanel.this.editor.hideCommittingAnimation();
                                StoreDetailsPanel.this.editor.setEnabled(true);
                            }
                        }

                        private boolean isStoreContaining(StoreLight l) {
                            for (Table2RowPanel p : StoreDetailsPanel.this.table.getRows()) {
                                if (!l.equals(p.getModel().getNode().getChildNamed(InventoryStoreComplete_.store).getValue())) continue;
                                return true;
                            }
                            return false;
                        }

                        public void errorOccurred(ClientException exception) {
                            StoreDetailsPanel.this.errorOccurred(exception);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else if (this.printAllWorkSheets == source) {
            InnerPopUp2 pop = InnerPopUp2.getInnerPopUp();
            pop.setAttributes(this, true, true, StoreAccess.PRINT_INVENTORY_WORKSHEET_NEW.getDisplayName());
            PrintAllWorksheetsPopup r = new PrintAllWorksheetsPopup((Node<InventoryLight>)this.editor.getModel().getNode());
            pop.setView(r);
            pop.showPopUpWithinScreenMiddle(DtoSmartExternOpenTool.preferredSmartScreenPopupSize.width, DtoSmartExternOpenTool.preferredSmartScreenPopupSize.height, this, this);
            r.loadReportTypes();
        }
    }

    private void setPartlyFlag(StoreLight store) {
        if (store != null) {
            this.editor.getModel().getNode().getChildNamed(InventoryLight_.partly).setValue((Object)Boolean.TRUE.equals(store.getPartlyStore()), 0L);
        }
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.table.isWritable()) {
            boolean isValid = true;
            boolean partlyValid = true;
            Boolean partly = null;
            ArrayList<StoreLight> s = new ArrayList<StoreLight>();
            for (Table2RowPanel p : this.table.getRows()) {
                TableRowImpl pp = (TableRowImpl)p;
                StoreLight l = pp.getSelectedStore();
                if (l == null) continue;
                if (!s.contains(l)) {
                    s.add(l);
                } else {
                    isValid = false;
                }
                if (partly == null) {
                    partly = l.getPartlyStore();
                    continue;
                }
                if (partly.equals(l.getPartlyStore())) continue;
                partlyValid = false;
            }
            if (!isValid) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_DUPLICATED_STORE));
            }
            if (!partlyValid) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Mixed Partly/noPartly Inventories are not allowed"));
            }
            if (s.size() == 0) {
                switch (this.inventoryState) {
                    case COUNTED: {
                        break;
                    }
                    case PLANNED: {
                        validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ATLEAST_ONE_STORE));
                        break;
                    }
                    case STARTED: {
                        break;
                    }
                }
            }
        }
        return validationObjects;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.table.requestFocusInWindowNow();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        InventoryStateE e = (InventoryStateE)this.editor.getModel().getNode().getChildNamed(InventoryLight_.state).getValue();
        this.table.setEnabled(isEnabled && e != InventoryStateE.APPROVED);
        if (this.table.getAddButton() != null) {
            this.table.getAddButton().setEnabled(isEnabled && e == InventoryStateE.PLANNED);
        }
        this.storeType.setEnabled(this.table.isEnabled() && e == InventoryStateE.PLANNED);
        this.addAll.setEnabled(this.storeType.isEnabled() && e == InventoryStateE.PLANNED);
        this.printAllWorkSheets.setEnabled(isEnabled && e != InventoryStateE.APPROVED && !this.editor.getModel().isAddRow());
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        try {
            if (this.editor.getModel().getNode().getChildNamed(InventoryLight_.state) != null) {
                this.editor.getModel().getNode().getChildNamed(InventoryLight_.state).removeNodeListener((NodeListener)this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.storeType.kill();
        this.storeType = null;
        this.addAll.kill();
        this.addAll = null;
        this.printAllWorkSheets.kill();
        this.printAllWorkSheets = null;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        try {
            this.inventoryState = (InventoryStateE)node.getChildNamed(InventoryLight_.state).getValue();
        }
        catch (Exception e) {
            this.inventoryState = null;
        }
        try {
            if (this.inventoryState == null) {
                this.inventoryState = InventoryStateE.PLANNED;
                node.getChildNamed(InventoryLight_.state).setValue((Object)this.inventoryState, System.currentTimeMillis());
            }
        }
        catch (Exception e) {
            this.inventoryState = InventoryStateE.PLANNED;
        }
        switch (this.inventoryState) {
            case COUNTED: 
            case STARTED: {
                this.table.enableAddButton(false);
                break;
            }
            case PLANNED: {
                this.table.enableAddButton(true);
                break;
            }
        }
        node.getChildNamed(InventoryLight_.state).addNodeListener((NodeListener)this);
        this.table.getModel().setNode(node.getChildNamed(InventoryComplete_.stores));
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void layoutContainer(Container parent) {
        this.table.setLocation(0, 0);
        this.table.setSize(parent.getWidth(), (int)((double)parent.getHeight() - ((double)(3 * this.verticalBorder) + this.printAllWorkSheets.getPreferredSize().getHeight() + this.storeType.getPreferredSize().getHeight())));
        this.storeType.setLocation(this.horizontalBorder, this.table.getY() + this.table.getHeight() + this.verticalBorder);
        this.storeType.setSize(150, (int)this.storeType.getPreferredSize().getHeight());
        this.addAll.setLocation(this.storeType.getX() + this.storeType.getWidth() + this.horizontalBorder, this.storeType.getY());
        this.addAll.setSize(this.addAll.getPreferredSize());
        this.printAllWorkSheets.setLocation(this.horizontalBorder, this.addAll.getY() + this.addAll.getHeight() + this.verticalBorder);
        this.printAllWorkSheets.setSize(this.printAllWorkSheets.getPreferredSize());
    }

    @Override
    public Dimension calculateContainerPreferredSize() {
        return new Dimension(0, 250);
    }

    public void valueChanged(Node<?> node) {
        this.inventoryState = (InventoryStateE)node.getValue();
        switch (this.inventoryState) {
            case COUNTED: 
            case STARTED: {
                this.table.enableAddButton(false);
                break;
            }
            case PLANNED: {
                this.table.enableAddButton(true);
                break;
            }
        }
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            pp.ensureInventoryState();
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public void resetTable() {
        this.table.getModel().setNode(this.table.getModel().getNode());
    }

    public boolean isSwingOnly() {
        return true;
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    InnerPopUpListener2 {
        private static final long serialVersionUID = 1L;
        private RDSearchComboBox storeSearch;
        private Button delete;
        private Button workSheet;
        private Button remaining;
        private TextLabel infoText;
        private int currentPopup;
        private final boolean canPrintSheet;
        private final boolean canPrintRemains;
        private boolean isInventory;
        private NodeListener listener;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.listener = new NodeListener(){

                public void valueChanged(Node<?> node) {
                    ((LockButton)TableRowImpl.this.delete).setChecked((Boolean)node.getValue());
                }

                public void childAdded(Node<?> source, Node<?> child) {
                }

                public void childRemoved(Node<?> source, Node<?> child) {
                }

                public void childrenAdded(Node<?> source, Node<?> ... nodes) {
                }

                public boolean isSwingOnly() {
                    return false;
                }
            };
            this.canPrintRemains = StoreDetailsPanel.this.provider.isWritable(InventoryAccess.REMAIN_ARTICLES);
            this.canPrintSheet = StoreDetailsPanel.this.provider.isWritable(InventoryAccess.SHEET);
            this.setLayout(new RowLayout());
            this.storeSearch = new RDSearchComboBox(StoreDetailsPanel.this.provider, RDSearchComboBox.BoxSearchTypes.STORESEARCH);
            this.storeSearch.addSearchTextFieldListener(new SearchTextField2Listener(){

                @Override
                public void newValueSelected(SearchTextField2 source, Node<?> n) throws ClientServerCallException {
                    StoreDetailsPanel.this.setPartlyFlag((StoreLight)n.getValue(StoreLight.class));
                }
            });
            this.storeSearch.setNode(m.getNode().getChildNamed(InventoryStoreComplete_.store));
            if (!StoreDetailsPanel.this.isAddRow) {
                if (this.canPrintSheet) {
                    this.workSheet = new PrintInventoryWorksheetButton();
                    this.workSheet.addButtonListener(this);
                    this.workSheet.setProgress(1.0f);
                    this.add(this.workSheet);
                }
                if (this.canPrintRemains) {
                    this.remaining = new PrintRemainingChargesButton();
                    this.remaining.addButtonListener(this);
                    this.remaining.setProgress(1.0f);
                    this.add(this.remaining);
                }
                if (StoreDetailsPanel.this.isDeletable) {
                    switch (StoreDetailsPanel.this.inventoryState) {
                        case COUNTED: {
                            this.delete = new DeleteButton();
                            this.delete.addButtonListener(this);
                            this.add(this.delete);
                            break;
                        }
                        case PLANNED: {
                            this.delete = new DeleteButton();
                            this.delete.addButtonListener(this);
                            this.add(this.delete);
                            break;
                        }
                        case STARTED: {
                            this.delete = new LockButton();
                            StoreLight store = (StoreLight)m.getNode().getChildNamed(InventoryStoreComplete_.store).getValue(StoreLight.class);
                            m.getNode().getChildNamed(InventoryStoreComplete_.store).getChildNamed(StoreLight_.blockedByInventory).addNodeListener(this.listener);
                            ((LockButton)this.delete).setChecked(store.getBlockedByInventory());
                            this.delete.addButtonListener(this);
                            this.add(this.delete);
                            break;
                        }
                    }
                }
            } else if (StoreDetailsPanel.this.isDeletable) {
                this.delete = new DeleteButton();
                this.delete.addButtonListener(this);
                this.add(this.delete);
            }
            this.infoText = new TextLabel(m.getNode().getChildNamed(InventoryStoreComplete_.blockTime), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.infoText.setProgress(1.0f);
            this.add(this.storeSearch);
            this.add(this.infoText);
            this.ensureInventoryState();
        }

        public StoreLight getSelectedStore() {
            if (this.storeSearch.isItemSelected()) {
                return (StoreLight)this.storeSearch.getNode().getValue();
            }
            return null;
        }

        protected void ensureInventoryState() {
            boolean isClosed;
            switch (StoreDetailsPanel.this.inventoryState) {
                case COUNTED: 
                case STARTED: {
                    this.isInventory = true;
                    break;
                }
                case PLANNED: {
                    this.isInventory = false;
                    break;
                }
            }
            boolean bl = isClosed = StoreDetailsPanel.this.inventoryState != InventoryStateE.COUNTED;
            if (this.delete != null) {
                this.delete.setEnabled(isClosed);
            }
            this.storeSearch.setEnabled(!this.isInventory);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            try {
                this.model.getNode().getChildNamed(InventoryStoreComplete_.store).getChildNamed(StoreLight_.blockedByInventory).removeNodeListener(this.listener);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.storeSearch.kill();
            if (!StoreDetailsPanel.this.isAddRow) {
                if (this.workSheet != null) {
                    this.workSheet.kill();
                }
                if (this.remaining != null) {
                    this.remaining.kill();
                }
            }
            if (this.delete != null) {
                this.delete.kill();
            }
            this.infoText.kill();
            this.infoText = null;
            this.storeSearch = null;
            this.delete = null;
            this.workSheet = null;
            this.remaining = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.storeSearch);
            if (!StoreDetailsPanel.this.isAddRow) {
                if (this.workSheet != null) {
                    CheckedListAdder.addToList(focusList, this.workSheet);
                }
                if (this.remaining != null) {
                    CheckedListAdder.addToList(focusList, this.remaining);
                }
            }
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.storeSearch.requestFocusInWindowNow();
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.storeSearch.getText();
                }
                case 1: {
                    return "";
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean isClosed;
            this.storeSearch.setEnabled(isEnabled && !this.isInventory);
            if (!StoreDetailsPanel.this.isAddRow) {
                if (this.workSheet != null) {
                    this.workSheet.setEnabled(isEnabled);
                }
                if (this.remaining != null) {
                    this.remaining.setEnabled(isEnabled);
                }
            }
            boolean bl = isClosed = StoreDetailsPanel.this.inventoryState != InventoryStateE.COUNTED;
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled && isClosed);
            }
            this.infoText.setEnabled(isEnabled);
        }

        private void toggleStoreState() {
            CursorController.showCursor(StoreDetailsPanel.this.editor, true);
            StoreDetailsPanel.this.editor.setEnabled(false);
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    InventoryComplete p = (InventoryComplete)StoreDetailsPanel.this.editor.getModel().getNode().getValue(InventoryComplete.class);
                    StoreLight store = (StoreLight)TableRowImpl.this.model.getNode().getChildNamed(InventoryStoreComplete_.store).getValue(StoreLight.class);
                    InventoryStoreComplete inventoryStore = (InventoryStoreComplete)TableRowImpl.this.model.getNode().getValue();
                    StoreLight s = store;
                    if (!s.getBlockedByInventory().booleanValue()) {
                        StoreLight l = (StoreLight)((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).startStoreInventory((InventoryReference)p, (StoreReference)s).getValue();
                        inventoryStore.setStore((StoreReference)l);
                        TableRowImpl.this.model.getNode().setValue((Object)inventoryStore, 0L);
                        TableRowImpl.this.model.getNode().updateNode();
                        Node storeNode = TableRowImpl.this.model.getNode().getChildNamed(InventoryStoreComplete_.store);
                        if (storeNode instanceof ProxyNode) {
                            ((ProxyNode)storeNode).setSource((Object)l);
                            storeNode = ((ProxyNode)storeNode).getRefNode();
                        }
                        storeNode.removeExistingValues();
                        storeNode.setValue((Object)l, 0L);
                        storeNode.updateNode();
                    } else {
                        StoreLight l = (StoreLight)((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).closeStoreInventory((InventoryLight)p, s).getValue();
                        inventoryStore.setStore((StoreReference)l);
                        TableRowImpl.this.model.getNode().setValue((Object)inventoryStore, 0L);
                        TableRowImpl.this.model.getNode().updateNode();
                        Node storeNode = TableRowImpl.this.model.getNode().getChildNamed(InventoryStoreComplete_.store);
                        if (storeNode instanceof ProxyNode) {
                            ((ProxyNode)storeNode).setSource((Object)l);
                            storeNode = ((ProxyNode)storeNode).getRefNode();
                        }
                        storeNode.removeExistingValues();
                        storeNode.setValue((Object)l, 0L);
                        storeNode.updateNode();
                    }
                    return TableRowImpl.this.model.getNode();
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            if (node != null) {
                                if (node.getValue() instanceof ClientServerCallException) {
                                    InnerPopupFactory.showErrorDialog((Exception)((Object)((ClientServerCallException)((Object)node.getValue()))), (Component)TableRowImpl.this);
                                } else if (TableRowImpl.this.delete instanceof LockButton) {
                                    ((LockButton)TableRowImpl.this.delete).setChecked(((StoreLight)node.getChildNamed(InventoryStoreComplete_.store).getValue(StoreLight.class)).getBlockedByInventory());
                                }
                            }
                            CursorController.showCursor(StoreDetailsPanel.this.editor, false);
                            StoreDetailsPanel.this.editor.setEnabled(true);
                        }

                        public void errorOccurred(ClientException exception) {
                            StoreDetailsPanel.this.errorOccurred(exception);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }

        private String getPopupText() {
            Node i = StoreDetailsPanel.this.editor.getModel().getNode().getChildNamed(InventoryLight_.partly);
            if (i != null && i.getValue() != null && ((Boolean)i.getValue()).booleanValue()) {
                return Words.STYLED_CLOSE_CURRENT_INVENTORY_STORE_PARTLY;
            }
            return Words.STYLED_CLOSE_CURRENT_INVENTORY_STORE;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                if (source instanceof DeleteButton) {
                    this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
                } else {
                    StoreLight store;
                    StoreLight s = store = (StoreLight)this.model.getNode().getChildNamed(InventoryStoreComplete_.store).getValue(StoreLight.class);
                    String t = "";
                    if (s.getBlockedByInventory().booleanValue()) {
                        t = this.getPopupText();
                        InnerPopupFactory.showDesicionPopup(Words.CLOSE_CURRENT_INVENTORY, t, source, new InnerPopUpListener2(){

                            @Override
                            public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                                if (xargs == null) {
                                    return;
                                }
                                TableRowImpl.this.toggleStoreState();
                            }
                        }, 250, -1);
                    } else {
                        this.toggleStoreState();
                    }
                }
            } else if (source == this.workSheet) {
                if (!this.storeSearch.isItemSelected()) {
                    return;
                }
                this.currentPopup = 1;
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(this.workSheet, true, true, Words.PRINT_INVENTORY_WORKSHEET);
                PrintInventoryWorksheetComponent p = new PrintInventoryWorksheetComponent((Node<StoreLight>)this.model.getNode().getChildNamed(new String[]{"store"}));
                popUp.setView(p);
                popUp.showPopUp(x, y, DtoSmartExternOpenTool.preferredSmartScreenPopupSize.width, DtoSmartExternOpenTool.preferredSmartScreenPopupSize.height, this, this.workSheet);
                p.loadReportTypes();
            } else if (source == this.remaining) {
                if (!this.storeSearch.isItemSelected()) {
                    return;
                }
                this.currentPopup = 2;
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(this.remaining, true, true, Words.PRINT_REMAINING_CHARGES);
                popUp.setView(new PrintRemainsPopupInsert(this.model.getNode(), (InventoryReference)StoreDetailsPanel.this.editor.getModel().getNode().getValue()));
                popUp.showPopUp(x, y, DtoSmartExternOpenTool.preferredSmartScreenPopupSize.width, DtoSmartExternOpenTool.preferredSmartScreenPopupSize.height, this, this.remaining);
            }
        }

        @Override
        public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
            if (xargs == null) {
                return;
            }
        }

        private class RowLayout
        extends DefaultLayout {
            private RowLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.storeSearch.setLocation(TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.storeSearch.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.storeSearch.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.storeSearch.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                if (!StoreDetailsPanel.this.isAddRow) {
                    int cw = currentX + TableRowImpl.this.getCellPadding();
                    int iw = 0;
                    if (TableRowImpl.this.workSheet != null) {
                        TableRowImpl.this.workSheet.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.workSheet.getPreferredSize().getHeight()) / 2.0));
                        TableRowImpl.this.workSheet.setSize((int)TableRowImpl.this.workSheet.getPreferredSize().getWidth(), (int)TableRowImpl.this.workSheet.getPreferredSize().getHeight());
                        cw = TableRowImpl.this.workSheet.getX() + TableRowImpl.this.workSheet.getWidth();
                        iw += TableRowImpl.this.getCellPadding() + TableRowImpl.this.workSheet.getWidth();
                    }
                    if (TableRowImpl.this.remaining != null) {
                        TableRowImpl.this.remaining.setLocation(cw + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.remaining.getPreferredSize().getHeight()) / 2.0));
                        TableRowImpl.this.remaining.setSize((int)TableRowImpl.this.remaining.getPreferredSize().getWidth(), (int)TableRowImpl.this.remaining.getPreferredSize().getHeight());
                        cw = TableRowImpl.this.remaining.getX() + TableRowImpl.this.remaining.getWidth();
                        iw += TableRowImpl.this.getInnerCellPadding() + TableRowImpl.this.remaining.getWidth();
                    }
                    TableRowImpl.this.infoText.setLocation(cw + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.storeSearch.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.infoText.setSize(w - (iw + TableRowImpl.this.getCellPadding()), (int)TableRowImpl.this.infoText.getPreferredSize().getHeight());
                }
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(2);
                TableRowImpl.this.setControlsX(currentX);
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }
        }
    }
}

