/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.inventory.details.utils;

import ch.icit.pegasus.client.gui.modules.inventory.details.RecipeChargeCountDetailsPanel;
import ch.icit.pegasus.client.gui.table2.FootablePanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.VerticalSeparator;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBox;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBoxListener;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.BackgroundFadeSkin;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.weeklyplan.WeeklyPlanServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.toolkits.TransactionToolkit;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryComplete_;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.RecipeCountTransactionComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.InventoryAccess;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Collections;
import java.util.List;

public class AddRecipeBatchPanelNEW
extends FootablePanel
implements ButtonListener,
SearchTextField2Listener,
RemoteLoader,
InnerPopUpListener2,
NodeListener,
StorePositionSearchBoxListener {
    private static final long serialVersionUID = 1L;
    private final RDProvider provider;
    private TextLabel title;
    private SearchTextField2 recipeSearch;
    private SearchTextField2 storePositionSearch;
    private StorePositionSearchBox box;
    private InputComboBox2 counted;
    private TextButton addButton;
    private VerticalSeparator sep1;
    private Node inventoryDate;
    private TitledItem<CheckBox> updateStock;
    private BackgroundFadeSkin skin;
    private RecipeChargeCountDetailsPanel inventoryS;
    private boolean canAddNewOne;
    SystemSettingsComplete settings;

    public AddRecipeBatchPanelNEW(RDProvider provider, RecipeChargeCountDetailsPanel detailsPanel) {
        this.inventoryS = detailsPanel;
        this.provider = provider;
        this.canAddNewOne = provider.isWritable(InventoryAccess.ADD_NEW_CHARGE_TO_INVENTORY);
        this.init();
    }

    private void init() {
        this.setOpaque(false);
        this.settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.title = new TextLabel(Words.ADD_NEW_POINT);
        this.recipeSearch = SearchTextField2Factory.getRecipeSearchField(false, new DTOProxyNode());
        this.recipeSearch.addSearchTextFieldListener(this);
        this.skin = SkinRegistry.getSkin(BackgroundFadeSkin.class);
        this.box = new StorePositionSearchBox();
        this.box.setNode((Node<StorePositionLight>)new DTOProxyNode());
        this.box.setFilter(TransactionType.INVENTORY);
        this.box.addSearchListener(this);
        this.inventoryDate = null;
        if (this.inventoryS != null) {
            this.inventoryDate = this.inventoryS.getEditor().getModel().getTypeSafeNode().getChildNamed(InventoryComplete_.inventoryDate);
        }
        if (this.inventoryDate != null) {
            this.inventoryDate.addNodeListener((NodeListener)this);
        }
        EmbeddedDTONode q = new EmbeddedDTONode();
        q.setValue((Object)new StoreQuantityComplete(), 0L);
        this.counted = new InputComboBox2(null, null, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
        this.counted.setNode((Node)q);
        this.counted.getEnterField().addActionListener(e -> this.addButton.requestFocusInWindowNow());
        this.addButton = new TextButton(Words.ADD);
        this.addButton.addButtonListener(this);
        this.updateStock = new TitledItem<CheckBox>(new CheckBox(), Words.UPDATE_STOCK, TitledItem.TitledItemOrientation.WEST);
        this.sep1 = new VerticalSeparator();
        if (this.storePositionSearch != null) {
            this.storePositionSearch.setEnabled(false);
        } else {
            this.box.setEnabled(false);
        }
        this.counted.setEnabled(false);
        this.addButton.setEnabled(false);
        if (this.updateStock != null) {
            this.updateStock.setEnabled(false);
        }
        this.setLayout(new Layout());
        this.add(this.title);
        this.add(this.recipeSearch);
        if (this.storePositionSearch != null) {
            this.add(this.storePositionSearch);
        } else {
            this.add(this.box);
        }
        this.add(this.counted);
        this.add(this.addButton);
        this.add(this.updateStock);
        this.add(this.sep1);
    }

    private void updateUnits(RecipeComplete recipe) {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        UnitComplete selectedUnit = recipe != null ? recipe.getCurrentVariant().getYield().getUnit() : settings.getDefaultRecipeUnit();
        this.counted.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(Collections.singletonList(selectedUnit)));
        this.counted.setSelectedUnit(selectedUnit);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        this.skin.paint(g2, 0, this.getHeight() - this.skin.getImage(11).getHeight(), this.getWidth(), 11);
        g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_textfield_selected_text_color")));
        g2.drawLine(0, 0, this.getWidth(), 0);
        this.paintChildren(g2);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.title.kill();
        this.recipeSearch.kill();
        if (this.storePositionSearch != null) {
            this.storePositionSearch.kill();
        }
        if (this.box != null) {
            this.box.kill();
        }
        this.counted.kill();
        this.addButton.kill();
        if (this.updateStock != null) {
            this.updateStock.kill();
        }
        this.sep1.kill();
        this.title = null;
        this.updateStock = null;
        this.recipeSearch = null;
        this.storePositionSearch = null;
        this.box = null;
        this.counted = null;
        this.addButton = null;
        this.sep1 = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean enable = isEnabled && this.canAddNewOne;
        this.recipeSearch.setEnabled(enable);
        if (this.box != null) {
            this.box.setEnabled(this.recipeSearch.isItemSelected() && enable);
        } else {
            this.storePositionSearch.setEnabled(this.recipeSearch.isItemSelected() && enable);
        }
        this.counted.setEnabled(this.recipeSearch.isItemSelected() && enable);
        this.addButton.setEnabled(this.recipeSearch.isItemSelected() && enable);
        this.sep1.setEnabled(enable);
        if (this.updateStock != null) {
            this.updateStock.setEnabled(this.recipeSearch.isItemSelected() && enable);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = this.recipeSearch.getFocusComponents();
        if (this.recipeSearch.isItemSelected()) {
            if (this.storePositionSearch != null) {
                CheckedListAdder.addToList(focusList, this.storePositionSearch);
            } else {
                CheckedListAdder.addToList(focusList, this.box);
            }
            CheckedListAdder.addToList(focusList, this.counted);
            CheckedListAdder.addToList(focusList, this.addButton);
        }
        return focusList;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.recipeSearch.setVisibleContainer(pane);
        if (this.storePositionSearch != null) {
            this.storePositionSearch.setVisibleContainer(pane);
        } else {
            this.box.setVisibleContainer(pane);
        }
        this.counted.setVisibleContainer(pane);
        this.addButton.setVisibleContainer(pane);
        if (this.updateStock != null) {
            this.updateStock.setVisibleContainer(pane);
        }
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.recipeSearch.requestFocusInWindowNow();
    }

    public void valueChanged(Node<?> node) {
        this.updateUnits((RecipeComplete)node.getValue(RecipeComplete.class));
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?>[] nodes) {
    }

    public boolean isSwingOnly() {
        return false;
    }

    @Override
    public void selectionChanged(SearchComboBox storeSearch, SearchTextField2 position) {
        if (storeSearch.getNode().getValue() != null && position.getNode().getValue() != null) {
            this.updateUnits((RecipeComplete)this.recipeSearch.getNode().getValue(RecipeComplete.class));
        }
        if (this.inventoryS != null) {
            this.inventoryS.getEditor().createFocusCycle();
        }
    }

    private void clearRow() {
        this.recipeSearch.getNode().setValue(null, 0L);
        if (this.storePositionSearch != null) {
            this.storePositionSearch.getNode().setValue(null, 0L);
        } else {
            this.box.getNode().setValue(null, 0L);
        }
        StoreQuantityComplete q = new StoreQuantityComplete();
        q.setAmount(Long.valueOf(0L));
        q.setUnit(this.settings.getDefaultRecipeUnit());
        Node nq = INodeCreator.getDefaultImpl().getNode4DTO((Object)q, false, false);
        this.counted.setNode(nq);
        this.setEnabled(true);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.addButton) {
            if (!this.validateLine()) {
                return;
            }
            RecipeComplete recipe = (RecipeComplete)this.recipeSearch.getNode().getValue(RecipeComplete.class);
            final RecipeCountTransactionComplete checkin = new RecipeCountTransactionComplete();
            checkin.setClientOId(Long.valueOf(ADTO.getNextId()));
            this.counted.getValueNode().getParent().commitThis(StoreQuantityComplete.class);
            checkin.setQuantity((StoreQuantityComplete)this.counted.getValueNode().getParent().getValue(StoreQuantityComplete.class));
            checkin.setRecipe(recipe);
            checkin.setUpdateStock(Boolean.valueOf(this.updateStock.getElement().isChecked()));
            InventoryComplete ic = (InventoryComplete)this.inventoryS.getEditor().getModel().getNode().getValue(InventoryComplete.class);
            checkin.setInventory(new InventoryReference(ic.getId()));
            checkin.setOriginStore((StorePositionLight)this.box.getNode().getValue(StorePositionLight.class));
            this.inventoryS.getEditor().showCommittingAnimation("Add Recipe");
            this.inventoryS.getEditor().setEnabled(false);
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    ((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).countRecipePositionBased(checkin);
                    ViewNode n = new ViewNode("");
                    AddRecipeBatchPanelNEW.this.inventoryS.getEditor().remoteObjectLoaded(null);
                    AddRecipeBatchPanelNEW.this.box.getStoreNode().setValue(null, 0L);
                    AddRecipeBatchPanelNEW.this.box.getPositionNode().setValue(null, 0L);
                    return n;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            AddRecipeBatchPanelNEW.this.popUpClosed(null, new Object[0]);
                            if (AddRecipeBatchPanelNEW.this.inventoryS != null) {
                                AddRecipeBatchPanelNEW.this.inventoryS.getEditor().createFocusCycle();
                            }
                            AddRecipeBatchPanelNEW.this.recipeSearch.requestFocusInWindowNow();
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog((Exception)exception, (Component)AddRecipeBatchPanelNEW.this);
                            AddRecipeBatchPanelNEW.this.popUpClosed(null, new Object[0]);
                            if (AddRecipeBatchPanelNEW.this.inventoryS != null) {
                                AddRecipeBatchPanelNEW.this.inventoryS.getEditor().createFocusCycle();
                            }
                            AddRecipeBatchPanelNEW.this.recipeSearch.requestFocusInWindowNow();
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
            this.clearRow();
        }
    }

    private boolean validateLine() {
        boolean isValid = true;
        if (this.storePositionSearch != null && !this.storePositionSearch.isItemSelected()) {
            isValid = false;
            this.storePositionSearch.setInValid();
        } else if (this.box != null && this.box.getNode().getValue() == null) {
            isValid = false;
            this.box.setInValid();
        }
        if (TransactionToolkit.getLongValue(this.counted.getValueNode()) <= 0L) {
            isValid = false;
            this.counted.setInvalid();
        }
        return isValid;
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) {
        ProductComplete product = (ProductComplete)n.getValue(ProductComplete.class);
        this.remoteObjectLoaded(n);
    }

    public void remoteObjectLoaded(Node<?> node) {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        StoreQuantityComplete q = new StoreQuantityComplete(Long.valueOf(0L), settings.getPieceUnit());
        q.setClientOId(Long.valueOf(q.getNextId()));
        this.counted.setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)q, false, false));
        this.updateUnits((RecipeComplete)this.recipeSearch.getNode().getValue(RecipeComplete.class));
        if (this.storePositionSearch != null) {
            this.storePositionSearch.setEnabled(true);
        } else {
            this.box.setEnabled(true);
        }
        this.counted.setEnabled(true);
        if (this.updateStock != null) {
            this.updateStock.setEnabled(true);
        }
        this.addButton.setEnabled(true);
        if (this.inventoryS != null) {
            this.inventoryS.getEditor().createFocusCycle();
        }
        if (this.storePositionSearch != null) {
            this.storePositionSearch.requestFocusInWindowNow();
        } else {
            this.box.requestFocusInWindowNow();
        }
    }

    public void errorOccurred(ClientException exception) {
        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)this);
        this.inventoryS.getEditor().hideCommittingAnimation();
        this.inventoryS.getEditor().setEnabled(true);
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        this.inventoryS.getEditor().hideCommittingAnimation();
        this.inventoryS.getEditor().setEnabled(true);
    }

    @Override
    public void setNode(Node<?> node) {
    }

    @Override
    public Node<?> getNode() {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, AddRecipeBatchPanelNEW.this.skin.getImage(11).getHeight());
        }

        @Override
        public void layoutContainer(Container parent) {
            int ipw = (int)AddRecipeBatchPanelNEW.this.counted.getPreferredSize().getWidth();
            ipw += 85;
            ipw = (int)((double)ipw + AddRecipeBatchPanelNEW.this.addButton.getPreferredSize().getWidth());
            ipw = (int)((double)ipw + AddRecipeBatchPanelNEW.this.title.getPreferredSize().getWidth());
            ipw = (int)((double)ipw + (AddRecipeBatchPanelNEW.this.updateStock.getPreferredSize().getWidth() + 5.0));
            ipw += 10;
            ipw = (int)((double)ipw + AddRecipeBatchPanelNEW.this.sep1.getPreferredSize().getWidth());
            ipw = parent.getWidth() - ipw;
            if ((ipw /= 2) > 250) {
                ipw = 250;
            }
            AddRecipeBatchPanelNEW.this.title.setLocation(10, (int)((double)parent.getHeight() - AddRecipeBatchPanelNEW.this.title.getPreferredSize().getHeight()) / 2);
            AddRecipeBatchPanelNEW.this.title.setSize(AddRecipeBatchPanelNEW.this.title.getPreferredSize());
            AddRecipeBatchPanelNEW.this.recipeSearch.setLocation(AddRecipeBatchPanelNEW.this.title.getX() + AddRecipeBatchPanelNEW.this.title.getWidth() + 10, (int)(((double)parent.getHeight() - AddRecipeBatchPanelNEW.this.recipeSearch.getPreferredSize().getHeight()) / 2.0));
            AddRecipeBatchPanelNEW.this.recipeSearch.setSize(ipw, (int)AddRecipeBatchPanelNEW.this.recipeSearch.getPreferredSize().getHeight());
            int cx = 0;
            if (AddRecipeBatchPanelNEW.this.storePositionSearch != null) {
                AddRecipeBatchPanelNEW.this.storePositionSearch.setLocation(AddRecipeBatchPanelNEW.this.recipeSearch.getX() + AddRecipeBatchPanelNEW.this.recipeSearch.getWidth() + 10, (int)(((double)parent.getHeight() - AddRecipeBatchPanelNEW.this.storePositionSearch.getPreferredSize().getHeight()) / 2.0));
                AddRecipeBatchPanelNEW.this.storePositionSearch.setSize(ipw, (int)AddRecipeBatchPanelNEW.this.storePositionSearch.getPreferredSize().getHeight());
                cx = AddRecipeBatchPanelNEW.this.storePositionSearch.getX() + AddRecipeBatchPanelNEW.this.storePositionSearch.getWidth();
            } else {
                AddRecipeBatchPanelNEW.this.box.setLocation(AddRecipeBatchPanelNEW.this.recipeSearch.getX() + AddRecipeBatchPanelNEW.this.recipeSearch.getWidth() + 10, (int)(((double)parent.getHeight() - AddRecipeBatchPanelNEW.this.box.getPreferredSize().getHeight()) / 2.0));
                AddRecipeBatchPanelNEW.this.box.setSize(ipw, (int)AddRecipeBatchPanelNEW.this.box.getPreferredSize().getHeight());
                cx = AddRecipeBatchPanelNEW.this.box.getX() + AddRecipeBatchPanelNEW.this.box.getWidth();
            }
            AddRecipeBatchPanelNEW.this.counted.setLocation(cx + 10, (int)(((double)parent.getHeight() - AddRecipeBatchPanelNEW.this.counted.getPreferredSize().getHeight()) / 2.0));
            AddRecipeBatchPanelNEW.this.counted.setSize(AddRecipeBatchPanelNEW.this.counted.getPreferredSize());
            AddRecipeBatchPanelNEW.this.addButton.setLocation(AddRecipeBatchPanelNEW.this.counted.getX() + AddRecipeBatchPanelNEW.this.counted.getWidth() + 20, (int)(((double)parent.getHeight() - AddRecipeBatchPanelNEW.this.addButton.getPreferredSize().getHeight()) / 2.0));
            AddRecipeBatchPanelNEW.this.addButton.setSize(AddRecipeBatchPanelNEW.this.addButton.getPreferredSize());
            AddRecipeBatchPanelNEW.this.sep1.setLocation(AddRecipeBatchPanelNEW.this.addButton.getX() + AddRecipeBatchPanelNEW.this.addButton.getWidth() + 5, 1);
            AddRecipeBatchPanelNEW.this.sep1.setSize((int)AddRecipeBatchPanelNEW.this.sep1.getPreferredSize().getWidth(), parent.getHeight() - 2);
            AddRecipeBatchPanelNEW.this.updateStock.setLocation((int)((double)parent.getWidth() - (10.0 + AddRecipeBatchPanelNEW.this.updateStock.getPreferredSize().getWidth())), (int)(((double)parent.getHeight() - AddRecipeBatchPanelNEW.this.updateStock.getPreferredSize().getHeight()) / 2.0));
            AddRecipeBatchPanelNEW.this.updateStock.setSize(AddRecipeBatchPanelNEW.this.updateStock.getPreferredSize());
        }
    }
}

