/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.inventorytransition.details;

import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.DayTimeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.inventorytransition.details.utils.FlightChooserPopup;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateTimeChooser;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.loaders.InventoryLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionEntryComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionEntryComplete_;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionFlightComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionLight;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BoundsDetailsPanel
extends TableDetailsPanel<InventoryTransitionLight> {
    private static final long serialVersionUID = 1L;
    private DtoField attributeName;

    public BoundsDetailsPanel(RowEditor<InventoryTransitionLight> editor, RDProvider provider, DtoField attributeName, String title) {
        super(editor, provider, true, true, false, true);
        this.attributeName = attributeName;
        this.setTitleText(title);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.INVENTORY, "", null, null, "", 20, 20, 20));
        int tw = DateTimeChooser.getPreferredWidth(this) + this.table.getCellPadding() * 2;
        columns.add(new TableColumnInfo(Words.OUTBOUND_BOUNDS, "", null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.RETURN_BOUNDS, "", null, null, "", tw, tw, tw));
        tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + this.table.getCellPadding() * 2;
        columns.add(new TableColumnInfo("", "", null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setUseWriteAccessRight(true);
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        InventoryTransitionEntryComplete e = new InventoryTransitionEntryComplete();
        e.setClientOId(Long.valueOf(ADTO.getNextId()));
        e.setOutboundBounds(new Timestamp(System.currentTimeMillis()));
        e.setInboundBounds(new Timestamp(System.currentTimeMillis()));
        this.editor.getModel().getNode().getChildNamed(this.attributeName).addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)e, true, false), 0L);
        this.revalidate();
    }

    @Override
    public void childRemoved() {
        this.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl p = new TableRowImpl(model, true);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode(node.getChildNamed(this.attributeName));
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        boolean allInventorySet = true;
        Iterator it = this.table.getModel().getNode().getFailSafeChildIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            InventoryLight inventoryLight = (InventoryLight)n.getChildNamed(InventoryTransitionEntryComplete_.inventory).getValue();
            if (inventoryLight != null) continue;
            allInventorySet = false;
        }
        if (!allInventorySet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ALL_BOUNDS_HAS_AN_INVENTORY_SET));
        }
        return a;
    }

    public void showFlightPopup(Component comp, ListNode<List<InventoryTransitionFlightComplete>, InventoryTransitionFlightComplete> node, int x, int y) {
        InnerPopUp2 pop = InnerPopUp2.getInnerPopUp();
        pop.setAttributes(comp, true, true, Words.FLIGHTS);
        FlightChooserPopup p = new FlightChooserPopup(node);
        pop.setView(p);
        pop.showPopUp(x, y, 350, 250, null, comp);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    SearchTextField2Listener {
        private static final long serialVersionUID = 1L;
        private SearchTextField2<InventoryLight> inventoryField;
        private TextLabel infoField;
        private DateTimeChooser enRouteBorder;
        private DateTimeChooser returnsBorder;
        private TextButton includeOutFlights;
        private TextButton excludeOutFlights;
        private TextButton includeReturnFlights;
        private TextButton excludeReturnFlights;
        private DeleteButton delete;
        private boolean dates;

        public TableRowImpl(Table2RowModel m, boolean needDates) {
            super(m);
            this.dates = needDates;
            this.setLayout(new RowLayout());
            if (this.dates) {
                Node startDate = m.getNode().getChildNamed(InventoryTransitionEntryComplete_.outboundBounds);
                Node endDate = m.getNode().getChildNamed(InventoryTransitionEntryComplete_.inboundBounds);
                if (startDate.getValue() == null) {
                    startDate.setValue((Object)new Timestamp(System.currentTimeMillis()), 0L);
                }
                if (endDate.getValue() == null) {
                    endDate.setValue((Object)new Timestamp(System.currentTimeMillis()), 0L);
                }
                this.enRouteBorder = new DateTimeChooser((Node<Timestamp>)startDate);
                this.returnsBorder = new DateTimeChooser((Node<Timestamp>)endDate);
                this.includeOutFlights = new TextButton(Words.INCLUDE);
                this.excludeOutFlights = new TextButton(Words.EXCLUDE);
                this.includeOutFlights.addButtonListener(this);
                this.excludeOutFlights.addButtonListener(this);
                this.includeReturnFlights = new TextButton(Words.INCLUDE);
                this.excludeReturnFlights = new TextButton(Words.EXCLUDE);
                this.includeReturnFlights.addButtonListener(this);
                this.excludeReturnFlights.addButtonListener(this);
            }
            this.inventoryField = SearchTextField2Factory.getInventorySearchField(true, (Node<InventoryLight>)m.getNode().getChildNamed(InventoryTransitionEntryComplete_.inventory));
            this.inventoryField.addSearchTextFieldListener(this);
            this.infoField = new TextLabel();
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.loadCompleteInventory((Node<InventoryLight>)this.model.getNode().getChildNamed(InventoryTransitionEntryComplete_.inventory));
            this.add(this.inventoryField);
            this.add(this.infoField);
            if (this.dates) {
                this.add(this.enRouteBorder);
                this.add(this.returnsBorder);
                this.add(this.includeOutFlights);
                this.add(this.excludeOutFlights);
                this.add(this.includeReturnFlights);
                this.add(this.excludeReturnFlights);
            }
            this.add(this.delete);
        }

        public Timestamp getReturnsBoundary() {
            return this.returnsBorder.getTimestamp();
        }

        public Timestamp getEnRouteBoundary() {
            return this.enRouteBorder.getTimestamp();
        }

        @Override
        public void requestFocusInWindowNow() {
            this.inventoryField.requestFocusInWindowNow();
        }

        public Node<? extends InventoryReference> getInventoryNode() {
            return this.inventoryField.getNode();
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.inventoryField);
            if (this.dates) {
                CheckedListAdder.addToList(focusList, this.enRouteBorder);
                CheckedListAdder.addToList(focusList, this.returnsBorder);
                CheckedListAdder.addToList(focusList, this.includeOutFlights);
                CheckedListAdder.addToList(focusList, this.excludeOutFlights);
                CheckedListAdder.addToList(focusList, this.includeReturnFlights);
                CheckedListAdder.addToList(focusList, this.excludeReturnFlights);
            }
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.inventoryField.setEnabled(isEnabled);
            this.infoField.setEnabled(isEnabled);
            if (this.dates) {
                this.enRouteBorder.setEnabled(isEnabled);
                this.returnsBorder.setEnabled(isEnabled);
                this.includeOutFlights.setEnabled(isEnabled);
                this.excludeOutFlights.setEnabled(isEnabled);
                this.includeReturnFlights.setEnabled(isEnabled);
                this.excludeReturnFlights.setEnabled(isEnabled);
            }
            this.delete.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.inventoryField.kill();
            this.infoField.kill();
            this.delete.kill();
            if (this.enRouteBorder != null) {
                this.enRouteBorder.kill();
            }
            if (this.returnsBorder != null) {
                this.returnsBorder.kill();
            }
            if (this.includeOutFlights != null) {
                this.includeOutFlights.kill();
            }
            if (this.excludeOutFlights != null) {
                this.excludeOutFlights.kill();
            }
            if (this.includeReturnFlights != null) {
                this.includeReturnFlights.kill();
            }
            if (this.excludeReturnFlights != null) {
                this.excludeReturnFlights.kill();
            }
            this.inventoryField = null;
            this.infoField = null;
            this.enRouteBorder = null;
            this.returnsBorder = null;
            this.includeOutFlights = null;
            this.excludeOutFlights = null;
            this.includeReturnFlights = null;
            this.excludeReturnFlights = null;
            this.delete = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getParentModel().getNode().removeChild(this.getModel().getNode(), 0L);
            } else if (source == this.includeOutFlights) {
                BoundsDetailsPanel.this.showFlightPopup(source, (ListNode<List<InventoryTransitionFlightComplete>, InventoryTransitionFlightComplete>)((ListNode)this.model.getNode().getChildNamed(InventoryTransitionEntryComplete_.includedOutFlights)), x, y);
            } else if (source == this.excludeOutFlights) {
                BoundsDetailsPanel.this.showFlightPopup(source, (ListNode<List<InventoryTransitionFlightComplete>, InventoryTransitionFlightComplete>)((ListNode)this.model.getNode().getChildNamed(InventoryTransitionEntryComplete_.excludedOutFlights)), x, y);
            } else if (source == this.includeReturnFlights) {
                BoundsDetailsPanel.this.showFlightPopup(source, (ListNode<List<InventoryTransitionFlightComplete>, InventoryTransitionFlightComplete>)((ListNode)this.model.getNode().getChildNamed(InventoryTransitionEntryComplete_.includedReturnFlights)), x, y);
            } else if (source == this.excludeReturnFlights) {
                BoundsDetailsPanel.this.showFlightPopup(source, (ListNode<List<InventoryTransitionFlightComplete>, InventoryTransitionFlightComplete>)((ListNode)this.model.getNode().getChildNamed(InventoryTransitionEntryComplete_.excludedReturnFlights)), x, y);
            }
        }

        @Override
        public void newValueSelected(SearchTextField2 source, Node<?> n) throws ClientServerCallException {
            if (source.isItemSelected()) {
                this.model.getParentModel().getTable().getAddButton().requestFocusInWindowNow();
                InventoryLight l = (InventoryLight)source.getNode().getValue();
                Timestamp ts = CalendarUtil.getInventoryTimestamp((InventoryLight)l);
                this.model.getNode().getChildNamed(InventoryTransitionEntryComplete_.outboundBounds).setValue((Object)ts, 0L);
                this.model.getNode().getChildNamed(InventoryTransitionEntryComplete_.inboundBounds).setValue((Object)ts, 0L);
                this.loadCompleteInventory(source.getNode());
            }
        }

        private void loadCompleteInventory(Node<InventoryLight> node) {
            if (node.getValue(InventoryLight.class) != null) {
                new InventoryLoader((InventoryLight)node.getValue(InventoryLight.class), new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        if (node.getValue(InventoryComplete.class) != null) {
                            TableRowImpl.this.createInventoryDescription((InventoryComplete)node.getValue(InventoryComplete.class));
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                    }
                }, node, this);
            }
        }

        private void createInventoryDescription(InventoryComplete i) {
            DateConverter dateC = (DateConverter)ConverterRegistry.getConverter(DateConverter.class);
            DayTimeConverter dayTimeC = (DayTimeConverter)ConverterRegistry.getConverter(DayTimeConverter.class);
            String t = Phrase.getPhrase((String)Phrase.STYLED_INVENTORY_DESCRIPTION, (Object[])new Object[]{i.getPartly() != false ? Words.YES : Words.NO_ANSWER, dateC.convert((Object)i.getInventoryDate(), null, new Object[0]), dayTimeC.convert((Object)i.getInventoryTime(), null, new Object[0]), i.getDescription() != null ? i.getDescription() : ""});
            String t2 = Phrase.getPhrase((String)Phrase.STYLED_INVENTORY_STORE_TEXT, (Object[])new Object[]{i.getPartly() != false ? Words.YES : Words.NO_ANSWER, dateC.convert((Object)i.getInventoryDate(), null, new Object[0]), dayTimeC.convert((Object)i.getInventoryTime(), null, new Object[0]), i.getDescription() != null ? i.getDescription() : ""});
            if (this.infoField != null) {
                this.infoField.setText(t2);
                this.infoField.setOverriddenToolTipText(t);
            }
        }

        private class RowLayout
        extends DefaultLayout {
            private RowLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.dates ? TableRowImpl.this.getDefaultRowHeight() * 2 : TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                int currentX = 0;
                int border = BoundsDetailsPanel.this.horizontalBorder;
                TableRowImpl.this.inventoryField.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(TableRowImpl.this.dates ? (double)border : ((double)parent.getHeight() - TableRowImpl.this.inventoryField.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.inventoryField.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.inventoryField.getPreferredSize().getHeight());
                TableRowImpl.this.infoField.setLocation(currentX + TableRowImpl.this.getCellPadding(), TableRowImpl.this.inventoryField.getY() + TableRowImpl.this.inventoryField.getHeight() + BoundsDetailsPanel.this.inner_verticalBorder);
                TableRowImpl.this.infoField.setSize(TableRowImpl.this.inventoryField.getWidth(), parent.getHeight() - (TableRowImpl.this.infoField.getY() + BoundsDetailsPanel.this.verticalBorder));
                if (TableRowImpl.this.dates) {
                    currentX += w;
                    w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                    TableRowImpl.this.enRouteBorder.setLocation(currentX + TableRowImpl.this.getCellPadding(), border);
                    TableRowImpl.this.enRouteBorder.setSize(TableRowImpl.this.enRouteBorder.getPreferredSize());
                    TableRowImpl.this.includeOutFlights.setLocation(currentX + TableRowImpl.this.getCellPadding(), TableRowImpl.this.enRouteBorder.getY() + TableRowImpl.this.enRouteBorder.getHeight() + border / 2);
                    TableRowImpl.this.includeOutFlights.setSize(TableRowImpl.this.includeOutFlights.getPreferredSize());
                    TableRowImpl.this.excludeOutFlights.setLocation(TableRowImpl.this.includeOutFlights.getX() + TableRowImpl.this.includeOutFlights.getWidth() + border, TableRowImpl.this.includeOutFlights.getY());
                    TableRowImpl.this.excludeOutFlights.setSize(TableRowImpl.this.excludeOutFlights.getPreferredSize());
                    currentX += w;
                    w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(2);
                    TableRowImpl.this.returnsBorder.setLocation(currentX + TableRowImpl.this.getCellPadding(), border);
                    TableRowImpl.this.returnsBorder.setSize(TableRowImpl.this.enRouteBorder.getPreferredSize());
                    TableRowImpl.this.includeReturnFlights.setLocation(currentX + TableRowImpl.this.getCellPadding(), TableRowImpl.this.includeOutFlights.getY());
                    TableRowImpl.this.includeReturnFlights.setSize(TableRowImpl.this.includeReturnFlights.getPreferredSize());
                    TableRowImpl.this.excludeReturnFlights.setLocation(TableRowImpl.this.includeReturnFlights.getX() + TableRowImpl.this.includeReturnFlights.getWidth() + border, TableRowImpl.this.includeOutFlights.getY());
                    TableRowImpl.this.excludeReturnFlights.setSize(TableRowImpl.this.excludeReturnFlights.getPreferredSize());
                    currentX += w;
                    w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(3);
                } else {
                    currentX += w;
                    w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                }
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(TableRowImpl.this.dates ? (double)border : ((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

