/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.inventorytransition.details;

import ch.icit.pegasus.client.converter.PegasusFileConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.RemarkButton;
import ch.icit.pegasus.client.gui.utils.buttons.ViewButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionComplete_;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionFileComplete_;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionLight;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.InventoryTransitionAccess;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class FileBrowserDetailsPanel
extends TableDetailsPanel<InventoryTransitionLight> {
    private static final long serialVersionUID = 1L;
    private boolean downloadable;

    public FileBrowserDetailsPanel(RowEditor<InventoryTransitionLight> editor, RDProvider provider) {
        super(editor, provider, false);
        this.setTitleText(Words.REPORTS);
        this.downloadable = provider.isWritable(InventoryTransitionAccess.DOWNLOAD_FILE);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.DATE, null, null, null, "", 40, 40, 40));
        int tw = 2 * this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl p = new TableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode(node.getChildNamed(InventoryTransitionComplete_.transitionReports));
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel name;
        private ViewButton viewButton;
        private InfoButton info;
        private RemarkButton description;
        private CheckBox finalize;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new Layout());
            this.name = new TextLabel(m.getNode().getChildNamed(InventoryTransitionFileComplete_.file), ConverterRegistry.getConverter(PegasusFileConverter.class));
            this.viewButton = new ViewButton();
            this.viewButton.addButtonListener(this);
            this.info = new InfoButton();
            this.info.installStringViewer(this.createInfo());
            this.description = new RemarkButton(false);
            this.description.addButtonListener(this);
            this.finalize = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(InventoryTransitionFileComplete_.finalized));
            this.add(this.name);
            this.add(this.viewButton);
            this.add(this.info);
            this.add(this.description);
            this.add(this.finalize);
        }

        private String createInfo() {
            return (String)this.model.getNode().getChildNamed(InventoryTransitionFileComplete_.parameterString).getValue();
        }

        @Override
        public List<Component> getFocusComponents() {
            return new ArrayList<Component>();
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.name.setEnabled(isEnabled);
            this.viewButton.setEnabled(isEnabled && FileBrowserDetailsPanel.this.downloadable);
            this.info.setEnabled(isEnabled);
            this.description.setEnabled(isEnabled);
            this.finalize.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.name.kill();
            this.viewButton.kill();
            this.info.kill();
            this.description.kill();
            this.finalize.kill();
            this.name = null;
            this.viewButton = null;
            this.info = null;
            this.description = null;
            this.finalize = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.viewButton) {
                InnerPopupFactory.showFileDownloadPopup((Node<PegasusFileComplete>)this.model.getNode().getChildNamed(InventoryTransitionFileComplete_.file), this, null, false);
            } else if (source == this.description) {
                InnerPopupFactory.showEnterMessagePopup(Words.FILE_DESCRIPTION, null, this, this.model.getNode().getChildNamed(InventoryTransitionFileComplete_.description), x, y);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0) - (3 * TableRowImpl.this.getInnerCellPadding() + 2 * TableRowImpl.this.getCellPadding() + InfoButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + RemarkButton.getPreferredWidth() + CheckBox.getPreferredWidth());
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w, (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                TableRowImpl.this.info.setLocation(TableRowImpl.this.name.getX() + TableRowImpl.this.name.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.info.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.info.setSize(TableRowImpl.this.info.getPreferredSize());
                TableRowImpl.this.description.setLocation(TableRowImpl.this.info.getX() + TableRowImpl.this.info.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.description.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.description.setSize(TableRowImpl.this.description.getPreferredSize());
                TableRowImpl.this.finalize.setLocation(TableRowImpl.this.description.getX() + TableRowImpl.this.description.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.finalize.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.finalize.setSize(TableRowImpl.this.finalize.getPreferredSize());
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.setControlsX(currentX += TableRowImpl.this.model.getParentModel().getColumnWidth(0));
                TableRowImpl.this.viewButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.viewButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.viewButton.setSize(TableRowImpl.this.viewButton.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container arg0) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }
}

