/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.inventorytransition.details.utils;

import ch.icit.pegasus.client.converter.FlightNoWithStateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.multiprint.ScrollablePopupInsert;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionFlightComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionFlightComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class FlightChooserPopup
extends ScrollablePopupInsert {
    private static final long serialVersionUID = 1L;
    private Table2 table = new Table2(true, Words.TABLE_ADD, false, false);

    public FlightChooserPopup(ListNode<List<InventoryTransitionFlightComplete>, InventoryTransitionFlightComplete> flights) {
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                InventoryTransitionFlightComplete e = new InventoryTransitionFlightComplete();
                e.setClientOId(Long.valueOf(ADTO.getNextId()));
                Node p = INodeCreator.getDefaultImpl().getNode4DTO((Object)e, true, false);
                FlightChooserPopup.this.table.getModel().getNode().addChild(p, 0L);
                FlightChooserPopup.this.validate();
                FlightChooserPopup.this.popup.createFocusCycle();
            }

            @Override
            public void childRemoved() {
                FlightChooserPopup.this.validate();
                FlightChooserPopup.this.popup.createFocusCycle();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int tw = DateChooser.getPreferredWidth(this.table, false) + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(Words.DATE, tw, tw, tw));
        columns.add(new TableColumnInfo(Words.FLIGHT, 120, 120, 120));
        tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo("", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.table.getModel().setNode((Node)flights);
        this.getViewContainer().setLayout(new Layout());
        this.getViewContainer().add(this.table);
        this.setEnabled(true);
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.table.getFocusComponents();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.table.kill();
        this.table = null;
    }

    @Override
    public boolean validateContent() {
        boolean foundEmptyFlight = false;
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl ri = (TableRowImpl)p;
            boolean rb = ri.validateRow();
            if (rb) continue;
            foundEmptyFlight = true;
        }
        return !foundEmptyFlight;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private DateChooser dateChooser;
        private SearchTextField2<FlightLight> search;
        private DeleteButton deleted;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new RowLayout());
            ViewNode date = new ViewNode("");
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            if (m.getNode().getChildNamed(InventoryTransitionFlightComplete_.flight).getValue() != null) {
                ts = (Timestamp)m.getNode().getChildNamed(new DtoField[]{InventoryTransitionFlightComplete_.flight, FlightLight_.std}).getValue();
            }
            date.setValue((Object)ts, 0L);
            this.dateChooser = new DateChooser();
            this.dateChooser.setNode((Node)date);
            this.search = SearchTextField2Factory.getFlightSearchField(true, m.getNode().getChildNamed(InventoryTransitionFlightComplete_.flight));
            this.search.setDefaultEntryConverter(ConverterRegistry.getConverter(FlightNoWithStateConverter.class));
            this.search.setDefaultViewConverter(ConverterRegistry.getConverter(FlightNoWithStateConverter.class));
            this.search.setNode(m.getNode().getChildNamed(InventoryTransitionFlightComplete_.flight));
            Object[] o = new Object[]{date, true};
            this.search.setAdditionalSearchField(o);
            this.deleted = new DeleteButton();
            this.deleted.addButtonListener(this);
            this.add(this.dateChooser);
            this.add(this.search);
            this.add(this.deleted);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.dateChooser);
            CheckedListAdder.addToList(a, this.search);
            CheckedListAdder.addToList(a, this.deleted);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.dateChooser.setEnabled(isEnabled);
            this.search.setEnabled(isEnabled);
            this.deleted.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.dateChooser.kill();
            this.search.kill();
            this.deleted.kill();
            this.dateChooser = null;
            this.search = null;
            this.deleted = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleted) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        public boolean validateRow() {
            if (this.model.getNode().getChildNamed(InventoryTransitionFlightComplete_.flight).getValue() == null) {
                this.search.setInvalid();
                return false;
            }
            return true;
        }

        private class RowLayout
        extends DefaultLayout {
            private RowLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.dateChooser.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.dateChooser.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.dateChooser.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.dateChooser.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.search.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.search.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.search.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.search.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.deleted.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.deleted.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.deleted.setSize(TableRowImpl.this.deleted.getPreferredSize());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            FlightChooserPopup.this.table.setLocation(0, 0);
            FlightChooserPopup.this.table.setSize(parent.getSize());
        }
    }
}

