/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.invoice.creator;

import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.TableModel;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.invoice.InvoiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationList;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientExceptionCollection;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.invoice.FlightInvoiceConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.InvoiceHintComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class InvoiceCreatorModuleDataHandler
implements IDataHandler {
    @Override
    public String getRemoteValidationText() {
        return null;
    }

    public void updateData(Node node, RemoteLoader model, ProgressListener l) {
    }

    @Override
    public long getLoadingID() {
        return 0L;
    }

    public Class<?> getCommittingClass() {
        return null;
    }

    public void createInvoices(Component source, final List<InvoiceComplete> invoices, final RemoteLoader model, final ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ScreenValidationList r = new ScreenValidationList();
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                for (InvoiceComplete i : invoices) {
                    i.setGroupExportByCabinClass(Boolean.valueOf(true));
                    i.setInvoiceType(InvoiceTypeE.NORMAL);
                    l.stateChanged(Phrase.getPhrase((String)Phrase.GENERATE_INVOICE_FOR, (Object[])new Object[]{i.getCustomer().getName()}));
                    if (i.getConfigurations().isEmpty()) continue;
                    if (i.getEligibleLocations().isEmpty()) {
                        i.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                    }
                    if (i.getCustomer() == null) {
                        r.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_CUSTOMER));
                        continue;
                    }
                    if (i.getEligibleLocations().isEmpty()) {
                        r.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_LOCATION_IS_SET));
                        continue;
                    }
                    try {
                        ArrayList<Object> newConfigs = new ArrayList<Object>();
                        for (InvoiceConfigurationComplete c : i.getConfigurations()) {
                            if (c instanceof FlightInvoiceConfigurationComplete) {
                                FlightInvoiceConfigurationComplete ic = (FlightInvoiceConfigurationComplete)c;
                                for (FlightLight f : ic.getFlights()) {
                                    boolean invoiceHandlings = true;
                                    boolean invoiceMeals = true;
                                    boolean invoiceStandards = true;
                                    boolean invoiceAdditionals = true;
                                    boolean invoiceHandlingFromStowing = true;
                                    if (f.getFlightState() == FlightStateE.CANCELLED) {
                                        if (!f.getPredefineInvoiceCanceledFlightMeal().booleanValue()) {
                                            invoiceMeals = false;
                                        }
                                        if (!f.getPredefineInvoiceCanceledFlightAdditional().booleanValue()) {
                                            invoiceAdditionals = false;
                                        }
                                        if (!f.getPredefineInvoiceCanceledFlightHandling().booleanValue()) {
                                            invoiceHandlings = false;
                                        }
                                        if (!f.getPredefineInvoiceCanceledFlightStandard().booleanValue()) {
                                            invoiceStandards = false;
                                        }
                                        if (!f.getPredefineInvoiceCanceledFlightHandlingFromStowing().booleanValue()) {
                                            invoiceHandlingFromStowing = false;
                                        }
                                    }
                                    FlightInvoiceConfigurationComplete newFlightConfig = new FlightInvoiceConfigurationComplete();
                                    newFlightConfig.setHandling(Boolean.valueOf(invoiceHandlings));
                                    newFlightConfig.setMeals(Boolean.valueOf(invoiceMeals));
                                    newFlightConfig.setStandard(Boolean.valueOf(invoiceStandards));
                                    newFlightConfig.setAdditional(Boolean.valueOf(invoiceAdditionals));
                                    newFlightConfig.setHandlingFromStowing(Boolean.valueOf(invoiceHandlingFromStowing));
                                    newFlightConfig.setInvoice(i);
                                    newFlightConfig.getFlights().add(f);
                                    newConfigs.add(newFlightConfig);
                                }
                                continue;
                            }
                            newConfigs.add(c);
                        }
                        i.setConfigurations(newConfigs);
                        l.stateChanged(Words.SAVE + " " + i.getCustomer().getName());
                        InvoiceComplete ni = (InvoiceComplete)((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).createInvoice(i).getValue();
                        if (ni == null) {
                            r.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.UNABLE_TO_CREATE_INVOICE, (Object[])new Object[]{i.getCustomer().getName()})));
                            continue;
                        }
                        r.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, Phrase.getPhrase((String)Phrase.INVOICE_CREATED, (Object[])new Object[]{i.getCustomer().getName()})));
                    }
                    catch (Exception e) {
                        r.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.UNABLE_TO_CREATE_INVOICE, (Object[])new Object[]{i.getCustomer()}) + ": " + e.getMessage()));
                    }
                }
                if (ScreenValidationObject.isError((List)r)) {
                    throw new ClientExceptionCollection(Words.UNABLE_TO_CREATE_ANY_INVOICE, r);
                }
                Node n = new Node();
                n.setValue((Object)r, 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void createNewData(Node node, RemoteLoader model, boolean sameNode, ProgressListener l) {
    }

    public Node resetData(Node node) {
        return null;
    }

    @Override
    public void loadMasterData(final long id, final RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                progressListener.stateChanged(Words.LOAD_DATA + " 1/6");
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                progressListener.stateChanged(Words.LOAD_DATA + " 2/6");
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                progressListener.stateChanged(Words.LOAD_DATA + " 3/6");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(FlightCategoryComplete.class);
                progressListener.stateChanged(Words.LOAD_DATA + " 4/6");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(HaulTypeComplete.class);
                progressListener.stateChanged(Words.LOAD_DATA + " 5/6");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
                progressListener.stateChanged(Words.LOAD_DATA + " 6/6");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InvoiceHintComplete.class);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return loader;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void setModel(TableModel model) {
    }

    public Node createEmptyNode() {
        return null;
    }

    public boolean reloadDataBeforeOpening(Node node, RemoteLoader listener, ProgressListener progressListener) {
        return false;
    }

    public boolean reloadDataAfterClosing(Node node, RemoteLoader listener, ProgressListener progressListener) {
        return this.reloadDataBeforeOpening(node, listener, progressListener);
    }

    public void doRemoteValidation(Node node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

