/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.invoice.manager;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.invoice.InvoiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientValidationException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.invoice.FlightInvoiceConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.invoice.HandlingCostInvoiceConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceLight;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceReference;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceStateE;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceTypeE;
import ch.icit.pegasus.server.core.dtos.invoice.ManualInvoiceConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.invoice.ProductInvoiceConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.invoice.PurchaseInvoiceConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.invoice.RequisitionInvoiceConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.invoice.ServiceProductInvoiceConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.invoice.TradeGoodInvoiceConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.InvoiceHintComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.product.TaxRateComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;

public class InvoiceModuleDataHandler
extends DefaultDataHandler<InvoiceReference, InvoiceComplete> {
    private InvoiceLight latestInvoice;

    public InvoiceModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public void updateData(final Node<InvoiceReference> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Iterator it;
                InvoiceComplete i = (InvoiceComplete)node.getValue(InvoiceComplete.class);
                if (i.getInvoiceType() == InvoiceTypeE.MANUAL_CREDIT_NOTE) {
                    i.setExcludeVAT(Boolean.valueOf(false));
                    i.setExcludeAirportTax(Boolean.valueOf(false));
                    i.setGroupForClass(Boolean.valueOf(false));
                    i.setReferencedInvoice(null);
                    i.setSplitFood(Boolean.valueOf(false));
                    it = i.getConfigurations().iterator();
                    ArrayList<InvoiceConfigurationComplete> delete = new ArrayList<InvoiceConfigurationComplete>();
                    while (it.hasNext()) {
                        InvoiceConfigurationComplete ii = (InvoiceConfigurationComplete)it.next();
                        boolean isSet = false;
                        if (ii instanceof ManualInvoiceConfigurationComplete) {
                            if (((ManualInvoiceConfigurationComplete)ii).getPositions().size() == 0) {
                                delete.add(ii);
                            } else {
                                isSet = true;
                            }
                        }
                        if (ii instanceof ProductInvoiceConfigurationComplete) {
                            if (((ProductInvoiceConfigurationComplete)ii).getProducts().size() == 0) {
                                delete.add(ii);
                            } else {
                                isSet = true;
                            }
                        }
                        if (!isSet) {
                            it.remove();
                            continue;
                        }
                        ii.setInvoice(i);
                    }
                    for (InvoiceConfigurationComplete invoiceConfigurationComplete : delete) {
                        i.getConfigurations().remove(invoiceConfigurationComplete);
                    }
                } else {
                    it = i.getConfigurations().iterator();
                    ArrayList<InvoiceConfigurationComplete> delete = new ArrayList<InvoiceConfigurationComplete>();
                    while (it.hasNext()) {
                        ProductInvoiceConfigurationComplete p;
                        ServiceProductInvoiceConfigurationComplete c;
                        FlightInvoiceConfigurationComplete ii1;
                        InvoiceConfigurationComplete ii = (InvoiceConfigurationComplete)it.next();
                        boolean isSet = false;
                        if (ii instanceof FlightInvoiceConfigurationComplete) {
                            ii1 = (FlightInvoiceConfigurationComplete)ii;
                            if (ii1.getFlights().size() > 0) {
                                isSet = true;
                            }
                            if (ii1.getHandling().booleanValue()) {
                                isSet = true;
                            }
                            if (ii1.getMeals().booleanValue()) {
                                isSet = true;
                            }
                            if (ii1.getStandard().booleanValue()) {
                                isSet = true;
                            }
                        }
                        if (ii instanceof TradeGoodInvoiceConfigurationComplete && (ii1 = (TradeGoodInvoiceConfigurationComplete)ii).getTradeGoods().size() > 0) {
                            isSet = true;
                        }
                        if (ii instanceof ManualInvoiceConfigurationComplete) {
                            if (((ManualInvoiceConfigurationComplete)ii).getPositions().size() == 0) {
                                delete.add(ii);
                            } else {
                                isSet = true;
                            }
                        }
                        if (ii instanceof ServiceProductInvoiceConfigurationComplete && !(c = (ServiceProductInvoiceConfigurationComplete)ii).getServiceProducts().isEmpty()) {
                            isSet = true;
                        }
                        if (ii instanceof RequisitionInvoiceConfigurationComplete && !(c = (RequisitionInvoiceConfigurationComplete)ii).getRequisitions().isEmpty()) {
                            isSet = true;
                        }
                        if (ii instanceof PurchaseInvoiceConfigurationComplete && !(c = (PurchaseInvoiceConfigurationComplete)ii).getPurchaseOrders().isEmpty()) {
                            isSet = true;
                        }
                        if (ii instanceof ProductInvoiceConfigurationComplete && !(p = (ProductInvoiceConfigurationComplete)ii).getProducts().isEmpty()) {
                            isSet = true;
                        }
                        if (ii instanceof HandlingCostInvoiceConfigurationComplete && !(c = (HandlingCostInvoiceConfigurationComplete)ii).getHandlingCosts().isEmpty()) {
                            isSet = true;
                        }
                        if (!isSet) {
                            it.remove();
                            continue;
                        }
                        ii.setInvoice(i);
                    }
                    for (InvoiceConfigurationComplete invoiceConfigurationComplete : delete) {
                        i.getConfigurations().remove(invoiceConfigurationComplete);
                    }
                }
                i = (InvoiceComplete)((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).updateInvoice(i).getValue();
                if (InvoiceModuleDataHandler.this.latestInvoice != null && i.getState() == InvoiceStateE.CANCELLED && InvoiceModuleDataHandler.this.latestInvoice.getState() != InvoiceStateE.CANCELLED) {
                    InvoiceLight i2 = (InvoiceLight)((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).createCreditNote((InvoiceReference)i, new DateWrapper(System.currentTimeMillis())).getValue();
                    InnerPopupFactory.showMessageDialog(Phrase.getPhrase((String)Phrase.CREDIT_NOTE_CREATED, (Object[])new Object[]{i2.getNumber()}), Words.INVOICE_CREDIT_NOTE, (Component)InvoiceModuleDataHandler.this.tableView);
                }
                node.removeExistingValues();
                node.setValue((Object)i, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void createNewData(final Node<InvoiceComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                InvoiceComplete i = (InvoiceComplete)node.getValue(InvoiceComplete.class);
                if (i.getCustomer() == null) {
                    throw new ClientValidationException(new ScreenValidationObject[]{new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_CUSTOMER)});
                }
                if (i.getEligibleLocations().isEmpty()) {
                    i.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                i = (InvoiceComplete)((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).createInvoice(i).getValue();
                node.removeExistingValues();
                node.setValue((Object)i, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                InvoiceLight l = (InvoiceLight)node.getValue();
                InvoiceComplete c = (InvoiceComplete)((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).getInvoice(new InvoiceReference(l.getId())).getValue();
                InvoiceModuleDataHandler.this.latestInvoice = (InvoiceLight)c;
                node.removeExistingValues();
                node.setValue((Object)c, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public void loadMasterData(long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                InvoiceModuleDataHandler.this.setCurrentLoadMaximum(8);
                InvoiceModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                InvoiceModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllInvoiceStates();
                InvoiceModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                InvoiceModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(TaxRateComplete.class);
                InvoiceModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InvoiceHintComplete.class);
                InvoiceModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(HaulTypeComplete.class);
                InvoiceModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllInvoiceTypes();
                InvoiceModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(FlightCategoryComplete.class);
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return InvoiceModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return InvoiceModuleDataHandler.this.loadingID;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<InvoiceComplete> resetData(Node<InvoiceComplete> node) {
        return new DTONode();
    }

    @Override
    public Class<InvoiceComplete> getCommittingClass() {
        return InvoiceComplete.class;
    }

    @Override
    public Node<InvoiceComplete> createEmptyNode() {
        InvoiceComplete c = new InvoiceComplete();
        c.setState(InvoiceStateE.PLANNED);
        c.setExcludeVAT(Boolean.valueOf(true));
        c.setClientOId(Long.valueOf(ADTO.getNextId()));
        PeriodComplete p = new PeriodComplete();
        p.setClientOId(Long.valueOf(p.getNextId()));
        c.setGroupExportByCabinClass(Boolean.valueOf(true));
        p.setStartDate(new Date(System.currentTimeMillis()));
        p.setEndDate(new Date(System.currentTimeMillis()));
        c.setPeriod(p);
        c.setInvoiceDate(new Date(System.currentTimeMillis()));
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)c, false, false);
    }

    @Override
    public void doRemoteValidation(Node<InvoiceReference> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

