/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.invoice.manager.details;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.SaveButton;
import ch.icit.pegasus.client.gui.utils.buttons.ViewButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete_;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceLight;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceReportHistoryComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.InvoiceAccess;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public abstract class HistoryPanel
extends TableDetailsPanel<InvoiceLight> {
    private static final long serialVersionUID = 1L;
    private boolean canFinalize;
    private boolean canPrint;

    public HistoryPanel(RowEditor<InvoiceLight> editor, RDProvider provider) {
        super(editor, provider, false);
        this.setTitleText(Words.INVOICE_HISTORY + this.getTitleSuffix());
        this.canFinalize = provider.isWritable(InvoiceAccess.FINALIZE);
        this.canPrint = provider.isWritable(InvoiceAccess.PRINT);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int tw = DateChooser.getPreferredWidth(this, false) + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(Words.DATE, "", null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.USER, "", null, null, "", 35, 35, 35));
        tw = CheckBox.getPreferredWidth() + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(Words.FINAL, "", null, null, "", tw, tw, tw));
        tw = this.canPreview() ? 2 * this.table.getCellPadding() + 40 + this.table.getInnerCellPadding() : 2 * this.table.getCellPadding() + 20;
        columns.add(new TableColumnInfo("", "", null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setProvider(this.provider);
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl t = new TableRowImpl(model);
        if (this.canPreview()) {
            t.setUseControlSkin(Table2RowPanel.TableControlsType.TWO);
        } else {
            t.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        }
        return t;
    }

    public abstract boolean canPreview();

    public abstract DtoField getAttribute();

    public abstract String getTitleSuffix();

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode(node.getChildNamed(this.getAttribute()));
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel date;
        private TextLabel user;
        private CheckBox finalVersion;
        private SaveButton save;
        private ViewButton view;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new RowLayout());
            this.date = new TextLabel(m.getNode().getChildNamed(new DtoField[]{InvoiceReportHistoryComplete_.report, PegasusFileComplete_.uploadTime}), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.user = new TextLabel(m.getNode().getChildNamed(new DtoField[]{InvoiceReportHistoryComplete_.report, PegasusFileComplete_.uploadUser}), ConverterRegistry.getConverter(UserConverter.class));
            this.finalVersion = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(InvoiceReportHistoryComplete_.finalVersion));
            this.save = new SaveButton();
            if (HistoryPanel.this.canPreview()) {
                this.view = new ViewButton();
            }
            this.save.addButtonListener(this);
            if (HistoryPanel.this.canPreview()) {
                this.view.addButtonListener(this);
            }
            this.add(this.date);
            this.add(this.user);
            this.add(this.finalVersion);
            this.add(this.save);
            if (HistoryPanel.this.canPreview()) {
                this.add(this.view);
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.finalVersion);
            CheckedListAdder.addToList(a, this.save);
            if (HistoryPanel.this.canPreview()) {
                CheckedListAdder.addToList(a, this.view);
            }
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new DtoField[]{InvoiceReportHistoryComplete_.report, PegasusFileComplete_.uploadTime}).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(new DtoField[]{InvoiceReportHistoryComplete_.report, PegasusFileComplete_.uploadUser}).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(InvoiceReportHistoryComplete_.finalVersion).getValue();
                }
                case 3: {
                    return null;
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.date.setEnabled(isEnabled);
            this.user.setEnabled(isEnabled);
            this.finalVersion.setEnabled(isEnabled && HistoryPanel.this.canFinalize);
            if (HistoryPanel.this.canPreview()) {
                this.view.setEnabled(isEnabled && HistoryPanel.this.canPrint);
            }
            this.save.setEnabled(isEnabled && HistoryPanel.this.canPrint);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.date.kill();
            this.date = null;
            this.user.kill();
            this.user = null;
            this.finalVersion.kill();
            this.finalVersion = null;
            this.save.kill();
            this.save = null;
            if (HistoryPanel.this.canPreview()) {
                this.view.kill();
            }
            this.view = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            boolean save = true;
            if (source == this.save) {
                save = true;
            } else if (source == this.view) {
                save = false;
            }
            InnerPopupFactory.showFileDownloadPopup((Node<PegasusFileComplete>)this.model.getNode().getChildNamed(InvoiceReportHistoryComplete_.report), this, null, save);
        }

        private class RowLayout
        extends DefaultLayout {
            private RowLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = 0;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                TableRowImpl.this.date.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.date.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.date.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.date.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.user.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.user.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.user.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.user.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.finalVersion.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.finalVersion.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.finalVersion.setSize(TableRowImpl.this.finalVersion.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.save.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.save.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.save.setSize(TableRowImpl.this.save.getPreferredSize());
                if (HistoryPanel.this.canPreview()) {
                    TableRowImpl.this.view.setLocation(TableRowImpl.this.save.getX() + TableRowImpl.this.save.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.view.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.view.setSize(TableRowImpl.this.view.getPreferredSize());
                }
            }
        }
    }
}

