/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.invoice.manager.details.utils;

import ch.icit.pegasus.client.converter.Airport2Converter;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.SortableTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiTaxesComboBox;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceLight_;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceStateE;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceTypeE;
import ch.icit.pegasus.server.core.dtos.invoice.ManualInvoicePositionComplete;
import ch.icit.pegasus.server.core.dtos.invoice.ManualInvoicePositionComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ManualInvoiceEntriesPopupInsert
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    private Table2 table;
    private TitledItem<SearchTextField2> deliveryAirport;
    private Node node;

    @Override
    public void enterPressed(PopupAction isOK) {
        if (this.table.getModel().getNode().getChildCount() > 0 && !this.deliveryAirport.getElement().isItemSelected()) {
            this.deliveryAirport.getElement().setInvalid();
            return;
        }
        this.node.commit();
        super.enterPressed(isOK);
    }

    public ManualInvoiceEntriesPopupInsert(Node n, RDProvider provider) {
        this.node = n;
        this.border = 10;
        boolean isOpen = this.node.getParent().getParent().getChildNamed(InvoiceLight_.state).getValue() != InvoiceStateE.CLOSED && this.node.getParent().getParent().getChildNamed(InvoiceLight_.state).getValue() != InvoiceStateE.CANCELLED && this.node.getParent().getParent().getChildNamed(InvoiceLight_.state).getValue() != InvoiceStateE.CREDIT_NOTE || this.node.getParent().getParent().getChildNamed(InvoiceLight_.state).getValue() == InvoiceStateE.CREDIT_NOTE && this.node.getParent().getParent().getChildNamed(InvoiceLight_.invoiceType).getValue() == InvoiceTypeE.MANUAL_CREDIT_NOTE;
        this.table = new Table2(isOpen, Words.ADD, false, false);
        this.table.setComparator(new Comparator<Table2RowPanel>(){

            @Override
            public int compare(Table2RowPanel o1, Table2RowPanel o2) {
                ManualInvoicePositionComplete pos1 = (ManualInvoicePositionComplete)o1.getModel().getNode().getValue();
                ManualInvoicePositionComplete pos2 = (ManualInvoicePositionComplete)o2.getModel().getNode().getValue();
                if (pos1.getSequence() == null) {
                    return pos2.getSequence() == null ? 1 : 0;
                }
                if (pos2.getSequence() == null) {
                    return -1;
                }
                return pos1.getSequence().compareTo(pos2.getSequence());
            }
        });
        this.table.setScrollDownOnAdd(true);
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                ManualInvoiceEntriesPopupInsert.this.validate();
                ManualInvoiceEntriesPopupInsert.this.ensureSequenceNo();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                ManualInvoicePositionComplete pos = new ManualInvoicePositionComplete();
                pos.setClientOId(Long.valueOf(ADTO.getNextId()));
                SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                pos.setPrice(new PriceComplete(s.getCurrency(), Double.valueOf(0.0)));
                pos.setName("");
                pos.setSequence(Integer.valueOf(ManualInvoiceEntriesPopupInsert.this.table.getRowCount()));
                Node nn = INodeCreator.getDefaultImpl().getNode4DTO((Object)pos, true, false);
                ManualInvoiceEntriesPopupInsert.this.table.getModel().getNode().addChild(nn, System.currentTimeMillis());
                ManualInvoiceEntriesPopupInsert.this.ensureSequenceNo();
                ManualInvoiceEntriesPopupInsert.this.validate();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 100, 100, 100));
        int dw = this.table.getCellPadding() * 2 + InputComboBox.getPreferredWidth(this, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
        columns.add(new TableColumnInfo(Words.COST, null, null, null, "", dw, dw, dw));
        columns.add(new TableColumnInfo(Words.TAXES, null, null, null, "", dw, dw, dw));
        dw = 3 * DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getCellPadding() * 2 + 2 * this.table.getInnerCellPadding();
        columns.add(new TableColumnInfo("", null, null, null, "", dw, dw, dw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.75);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.25);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.setLayout(new Layout());
        this.table.getModel().setNode(n.getChildNamed(new String[]{"positions"}));
        this.table.resortTable();
        Node delAirPort = n.getChildNamed(new String[]{"deliveryAirport"});
        delAirPort.setConverter(Airport2Converter.class);
        this.deliveryAirport = new TitledItem<SearchTextField2<AirportComplete>>(SearchTextField2Factory.getAirportSearchField(true, delAirPort), Words.DELIVERY_AIRPORT, TitledItem.TitledItemOrientation.NORTH);
        this.add(this.table);
        this.add(this.deliveryAirport);
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        a.addAll(this.table.getFocusComponents());
        CheckedListAdder.addToList(a, this.deliveryAirport);
        return a;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.deliveryAirport.kill();
        this.deliveryAirport = null;
        this.table.kill();
        this.table = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
        this.deliveryAirport.setEnabled(isEnabled);
    }

    private void ensureSequenceNo() {
        int count = 0;
        for (Table2RowPanel table2RowPanel : this.table.getRows()) {
            table2RowPanel.getModel().getNode().getChildNamed(ManualInvoicePositionComplete_.sequence).setValue((Object)count, 0L);
            ++count;
        }
    }

    private class TableRowImpl
    extends SortableTable2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextField name;
        private InputComboBox price;
        private MultiTaxesComboBox taxes;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setSortAttributeName(ManualInvoicePositionComplete_.sequence);
            this.setStartEndOffset(0, 1);
            this.setLayout(new InnerLayout());
            this.name = new TextField(m.getNode().getChildNamed(ManualInvoicePositionComplete_.name));
            this.price = new InputComboBox(m.getNode().getChildNamed(new DtoField[]{ManualInvoicePositionComplete_.price, PriceComplete_.price}), m.getNode().getChildNamed(new DtoField[]{ManualInvoicePositionComplete_.price, PriceComplete_.currency}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
            this.taxes = new MultiTaxesComboBox(m.getNode().getChildNamed(ManualInvoicePositionComplete_.taxes));
            if (ManualInvoiceEntriesPopupInsert.this.node.getParent().getParent().getChildNamed(InvoiceLight_.state).getValue() == InvoiceStateE.CLOSED) {
                this.disableDeleteButton();
            }
            this.add(this.name);
            this.add(this.price);
            this.add(this.taxes);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            a.addAll(this.name.getFocusComponents());
            a.addAll(this.price.getFocusComponents());
            a.addAll(this.taxes.getFocusComponents());
            return a;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.name.kill();
            this.name = null;
            this.price.kill();
            this.price = null;
            if (this.taxes != null) {
                this.taxes.kill();
            }
            this.taxes = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.name.setEnabled(isEnabled);
            this.price.setEnabled(isEnabled);
            this.taxes.setEnabled(isEnabled);
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = 0;
                int currentX = 0;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.price.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.price.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.price.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.taxes.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.taxes.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.taxes.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.taxes.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.layoutSortButtons(currentX, parent.getHeight());
                TableRowImpl.this.setControlsX(currentX);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 200);
        }

        @Override
        public void layoutContainer(Container parent) {
            int ch = 10;
            ManualInvoiceEntriesPopupInsert.this.table.setLocation(0, 0);
            ManualInvoiceEntriesPopupInsert.this.table.setSize(parent.getWidth(), (int)((double)parent.getHeight() - ((double)(ManualInvoiceEntriesPopupInsert.this.table.getY() + ch) + ManualInvoiceEntriesPopupInsert.this.deliveryAirport.getPreferredSize().getHeight())));
            ManualInvoiceEntriesPopupInsert.this.deliveryAirport.setLocation(ch, ManualInvoiceEntriesPopupInsert.this.table.getY() + ManualInvoiceEntriesPopupInsert.this.table.getHeight() + ch);
            ManualInvoiceEntriesPopupInsert.this.deliveryAirport.setSize(parent.getWidth() - 2 * ch, (int)ManualInvoiceEntriesPopupInsert.this.deliveryAirport.getPreferredSize().getHeight());
        }
    }
}

