/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.itemsubstitution.creator.utils;

import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiHaulTypeSelectionComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiSelectionPanel;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextField;
import ch.icit.pegasus.client.gui.utils.tables.FlightSearchTable;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;

public class SubstitutionFlights
extends BorderedInletPanel
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<SearchTextField> flightNo;
    private TitledItem<ComboBox> flightState;
    private TitledItem<MultiSelectionPanel<MultiHaulTypeSelectionComboBox>> haulType;
    private TitledPeriodEditor period;
    private TitledItem<SearchTextField2<CustomerLight>> customer;
    private TextButton addButton;
    private TextButton clearButton;
    private TitledItem<Table2> flightTable;
    private Node<FlightSearchConfiguration> node;

    public SubstitutionFlights() {
        super(true);
        this.setHasBackground(true);
        this.setTitleText("Flights");
        FlightSearchConfiguration conf = new FlightSearchConfiguration();
        conf.setDayPeriod(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
        this.node = INodeCreator.getDefaultImpl().getNode4DTO((Object)conf, false, false);
        this.flightNo = new TitledItem<SearchTextField>(new SearchTextField(), Words.FLIGHT_NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.flightState = new TitledItem<ComboBox>(ComboBoxFactory.getFlightStateComboBox(true), Words.STATE, TitledItem.TitledItemOrientation.NORTH);
        MultiHaulTypeSelectionComboBox haulCombo = new MultiHaulTypeSelectionComboBox(INodeCreator.getDefaultImpl().createNodes(new ArrayList(), false));
        this.haulType = new TitledItem<MultiSelectionPanel<MultiHaulTypeSelectionComboBox>>(new MultiSelectionPanel<MultiHaulTypeSelectionComboBox>(haulCombo), Words.HAUL_TYPE, TitledItem.TitledItemOrientation.NORTH);
        this.period = new TitledPeriodEditor((Node<Date>)this.node.getChildNamed(new String[]{"dayPeriod-startDate"}), (Node<Date>)this.node.getChildNamed(new String[]{"dayPeriod-endDate"}), true, null);
        this.customer = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, this.node.getChildNamed(new String[]{"customer"})), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.addButton = new TextButton(Words.SEARCH);
        this.clearButton = new TextButton(Words.CLEAR);
        this.addButton.addButtonListener(this);
        this.clearButton.addButtonListener(this);
        this.flightTable = new TitledItem<FlightSearchTable>(new FlightSearchTable(), Words.FLIGHTS, TitledItem.TitledItemOrientation.NORTH);
        this.flightTable.setIgnorePrefHeight(true);
        this.setLayout(new Layout());
        this.add(this.flightNo);
        this.add(this.flightState);
        this.add(this.haulType);
        this.add(this.period);
        this.add(this.customer);
        this.add(this.addButton);
        this.add(this.clearButton);
        this.add(this.flightTable);
    }

    private int layoutItem(int currentX, int currentY, int prefWidth, int border, Component comp) {
        comp.setLocation(currentX, currentY);
        if (prefWidth != 0) {
            comp.setSize(prefWidth, (int)comp.getPreferredSize().getHeight());
        } else {
            comp.setSize(comp.getPreferredSize());
        }
        return comp.getX() + comp.getWidth() + border;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            SubstitutionFlights.this.layoutTitle(parent);
            int y = SubstitutionFlights.this.getTitleHeight() + 5;
            int currentX = 0;
            int border = 10;
            currentX = SubstitutionFlights.this.layoutItem(border, y, 100, border, SubstitutionFlights.this.flightNo);
            currentX = SubstitutionFlights.this.layoutItem(currentX, y, 100, border, SubstitutionFlights.this.flightState);
            currentX = SubstitutionFlights.this.layoutItem(currentX, y, 100, border, SubstitutionFlights.this.haulType);
            currentX = SubstitutionFlights.this.layoutItem(currentX, y, 100, border, SubstitutionFlights.this.period);
            currentX = SubstitutionFlights.this.layoutItem(currentX, y, 100, border, SubstitutionFlights.this.customer);
            currentX = SubstitutionFlights.this.layoutItem(currentX, y + 23, 100, border, SubstitutionFlights.this.addButton);
            currentX = SubstitutionFlights.this.layoutItem(currentX, y + 23, 100, border, SubstitutionFlights.this.clearButton);
            SubstitutionFlights.this.flightTable.setLocation(border, SubstitutionFlights.this.flightNo.getY() + SubstitutionFlights.this.flightNo.getHeight() + border);
            SubstitutionFlights.this.flightTable.setSize(parent.getWidth() - 2 * border, parent.getHeight() - (SubstitutionFlights.this.flightTable.getY() + border));
        }
    }
}

