/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.itemsubstitution.creator.utils;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.production.ItemSubstitutionTypeE;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;

public class SubstitutionPanel
extends BorderedInletPanel
implements ItemListener,
ButtonListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<ComboBox> type;
    private TitledItem<SearchComboBox> cabinClass;
    private TitledItem<SearchTextField2<ProductVariantLight>> product;
    private TitledItem<SearchTextField2<RecipeVariantLight>> recipe;
    private TitledItem<SearchTextField2<BasicArticleLight>> originArticle;
    private InfoButton originArticleInfo;
    private TitledItem<SearchTextField2<BasicArticleLight>> newArticle;
    private InfoButton newArticleInfo;
    private TitledItem<SearchTextField2<RecipeVariantLight>> originRecipe;
    private TitledItem<SearchTextField2<RecipeVariantLight>> newRecipe;
    private TitledItem<SearchTextField2<ProductVariantLight>> originProduct;
    private TitledItem<SearchTextField2<ProductVariantLight>> newProduct;
    private TitledItem<InputComboBox2> originAmount;
    private CheckBox allOriginAmount;
    private TitledItem<InputComboBox2> newAmount;
    private CheckBox allNewAmount;
    private TitledItem<CheckBox> unknownAllergens;
    private TitledItem<TextField> remark;
    private TextButton insertSubstitutions;
    private ItemSubstitutionTypeE currentType = ItemSubstitutionTypeE.ARTICLE_BY_ARTICLE;

    public SubstitutionPanel() {
        super(true);
        this.setHasBackground(true);
        this.setTitleText("Substitution");
        this.setLayout(new Layout());
        this.installItems();
        for (ItemSubstitutionTypeE t : ItemSubstitutionTypeE.values()) {
            this.type.getElement().addItem(t);
        }
    }

    private void installItems() {
        this.type = new TitledItem<ComboBox>(new ComboBox(), Words.TYPE, TitledItem.TitledItemOrientation.NORTH);
        this.type.getElement().addItemListener(this);
        this.type.getFader().setPermanent(true);
        this.cabinClass = new TitledItem<SearchComboBox>(SearchComboBoxFactory.getCabinClassSearchField(true, new DTOProxyNode()), Words.CABIN_CLASS, TitledItem.TitledItemOrientation.NORTH);
        this.cabinClass.getFader().setPermanent(true);
        this.product = new TitledItem<SearchTextField2<ProductVariantLight>>(SearchTextField2Factory.getProductVariantSearchField(true, new DTOProxyNode()), Words.PRODUCT, TitledItem.TitledItemOrientation.NORTH);
        this.product.getFader().setPermanent(true);
        this.recipe = new TitledItem<SearchTextField2<RecipeVariantLight>>(SearchTextField2Factory.getRecipeVariantSearchField(true, new DTOProxyNode()), Words.RECIPE, TitledItem.TitledItemOrientation.NORTH);
        this.recipe.getFader().setPermanent(true);
        this.originProduct = new TitledItem<SearchTextField2<ProductVariantLight>>(SearchTextField2Factory.getProductVariantSearchField(true, new DTOProxyNode()), Words.ORIGIN_PRODUCT, TitledItem.TitledItemOrientation.NORTH);
        this.originProduct.getFader().setPermanent(true);
        this.newProduct = new TitledItem<SearchTextField2<ProductVariantLight>>(SearchTextField2Factory.getProductVariantSearchField(true, new DTOProxyNode()), Words.SUBSTITUTE_PRODUCT, TitledItem.TitledItemOrientation.NORTH);
        this.newProduct.getFader().setPermanent(true);
        this.originRecipe = new TitledItem<SearchTextField2<RecipeVariantLight>>(SearchTextField2Factory.getRecipeVariantSearchField(true, new DTOProxyNode()), Words.ORIGIN_RECIPE, TitledItem.TitledItemOrientation.NORTH);
        this.originRecipe.getFader().setPermanent(true);
        this.newRecipe = new TitledItem<SearchTextField2<RecipeVariantLight>>(SearchTextField2Factory.getRecipeVariantSearchField(true, new DTOProxyNode()), Words.SUBSTITUTE_RECIPE, TitledItem.TitledItemOrientation.NORTH);
        this.newRecipe.getFader().setPermanent(true);
        this.originArticle = new TitledItem<SearchTextField2<BasicArticleLight>>(SearchTextField2Factory.getBasicArticleSearchField(true, new DTOProxyNode()), Words.ORIGIN_ARTICLE, TitledItem.TitledItemOrientation.NORTH);
        this.originArticle.getFader().setPermanent(true);
        this.newArticle = new TitledItem<SearchTextField2<BasicArticleLight>>(SearchTextField2Factory.getBasicArticleSearchField(true, new DTOProxyNode()), Words.SUBSTITUTE_ARTICLE, TitledItem.TitledItemOrientation.NORTH);
        this.newArticle.getFader().setPermanent(true);
        this.originArticleInfo = new InfoButton();
        this.originArticleInfo.getFader().setPermanent(true);
        this.newArticleInfo = new InfoButton();
        this.newArticleInfo.getFader().setPermanent(true);
        this.originAmount = new TitledItem<InputComboBox2>(new InputComboBox2(null, null, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE), Words.AMOUNT, TitledItem.TitledItemOrientation.NORTH);
        this.originAmount.getFader().setPermanent(true);
        this.newAmount = new TitledItem<InputComboBox2>(new InputComboBox2(null, null, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE), Words.AMOUNT, TitledItem.TitledItemOrientation.NORTH);
        this.newAmount.getFader().setPermanent(true);
        this.allOriginAmount = new CheckBox();
        this.allOriginAmount.getFader().setPermanent(true);
        this.allNewAmount = new CheckBox();
        this.allNewAmount.getFader().setPermanent(true);
        this.allOriginAmount.setChecked(true);
        this.allNewAmount.setChecked(true);
        this.unknownAllergens = new TitledItem<CheckBox>(new CheckBox(), Words.UNKNOWN_ALLERGENS, TitledItem.TitledItemOrientation.EAST);
        this.unknownAllergens.getFader().setPermanent(true);
        this.remark = new TitledItem<TextField>(new TextField(), Words.REMARK, TitledItem.TitledItemOrientation.NORTH);
        this.remark.getFader().setPermanent(true);
        this.insertSubstitutions = new TextButton(Words.INSERT_SUBSTITUTION);
        this.insertSubstitutions.addButtonListener(this);
        this.insertSubstitutions.getFader().setPermanent(true);
        this.add(this.type);
        this.add(this.cabinClass);
        this.add(this.product);
        this.add(this.recipe);
        this.add(this.originProduct);
        this.add(this.newProduct);
        this.add(this.originRecipe);
        this.add(this.newRecipe);
        this.add(this.originArticle);
        this.add(this.originArticleInfo);
        this.add(this.newArticle);
        this.add(this.newArticleInfo);
        this.add(this.originAmount);
        this.add(this.newAmount);
        this.add(this.allOriginAmount);
        this.add(this.allNewAmount);
        this.add(this.unknownAllergens);
        this.add(this.remark);
        this.add(this.insertSubstitutions);
        this.type.fadeIn();
        this.cabinClass.fadeIn();
        this.originAmount.fadeIn();
        this.newAmount.fadeIn();
        this.unknownAllergens.fadeIn();
        this.remark.fadeIn();
        this.insertSubstitutions.fadeIn();
        this.selectType(ItemSubstitutionTypeE.ARTICLE_BY_ARTICLE);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.allNewAmount.isChecked()) {
            this.newAmount.setEnabled(false);
        } else {
            this.newAmount.setEnabled(isEnabled);
        }
        if (this.allOriginAmount.isChecked()) {
            this.originAmount.setEnabled(false);
        } else {
            this.originAmount.setEnabled(isEnabled);
        }
    }

    private void selectType(ItemSubstitutionTypeE newType) {
        if (this.currentType != newType) {
            switch (newType) {
                case ARTICLE_BY_ARTICLE: {
                    this.product.fadeIn();
                    this.recipe.fadeIn();
                    this.originProduct.fadeOut(false);
                    this.newProduct.fadeOut(false);
                    this.originRecipe.fadeOut(false);
                    this.newRecipe.fadeOut(false);
                    this.originArticle.fadeIn();
                    this.originArticleInfo.fadeIn();
                    this.newArticle.fadeIn();
                    this.newArticleInfo.fadeIn();
                    break;
                }
                case ARTICLE_BY_RECIPE: {
                    this.product.fadeIn();
                    this.recipe.fadeOut(false);
                    this.originProduct.fadeOut(false);
                    this.newProduct.fadeOut(false);
                    this.originRecipe.fadeOut(false);
                    this.newRecipe.fadeIn();
                    this.originArticle.fadeIn();
                    this.originArticleInfo.fadeIn();
                    this.newArticle.fadeOut(false);
                    this.newArticleInfo.fadeOut(false);
                    break;
                }
                case PRODUCT_BY_PRODUCT: {
                    this.product.fadeOut(false);
                    this.recipe.fadeOut(false);
                    this.originProduct.fadeIn();
                    this.newProduct.fadeIn();
                    this.originRecipe.fadeOut(false);
                    this.newRecipe.fadeOut(false);
                    this.originArticle.fadeOut(false);
                    this.originArticleInfo.fadeOut(false);
                    this.newArticle.fadeOut(false);
                    this.newArticleInfo.fadeOut(false);
                    break;
                }
                case RECIPE_BY_ARTICLE: {
                    this.product.fadeIn();
                    this.recipe.fadeOut(false);
                    this.originProduct.fadeOut(false);
                    this.newProduct.fadeOut(false);
                    this.originRecipe.fadeIn();
                    this.newRecipe.fadeOut(false);
                    this.originArticle.fadeOut(false);
                    this.originArticleInfo.fadeOut(false);
                    this.newArticle.fadeIn();
                    this.newArticleInfo.fadeIn();
                    break;
                }
                case RECIPE_BY_RECIPE: {
                    this.product.fadeIn();
                    this.recipe.fadeOut(false);
                    this.originProduct.fadeOut(false);
                    this.newProduct.fadeOut(false);
                    this.originRecipe.fadeIn();
                    this.newRecipe.fadeIn();
                    this.originArticle.fadeOut(false);
                    this.originArticleInfo.fadeOut(false);
                    this.newArticle.fadeOut(false);
                    this.newArticleInfo.fadeOut(false);
                    break;
                }
            }
            this.currentType = newType;
        }
        this.setEnabled(this.isEnabled());
    }

    private int layoutItem(int currentX, int currentY, int prefWidth, int border, Component comp) {
        comp.setLocation(currentX, currentY);
        if (prefWidth != 0) {
            comp.setSize(prefWidth, (int)comp.getPreferredSize().getHeight());
        } else {
            comp.setSize(comp.getPreferredSize());
        }
        return comp.getX() + comp.getWidth() + border;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.selectType((ItemSubstitutionTypeE)this.type.getElement().getSelectedItem());
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.allNewAmount) {
            this.setEnabled(this.isEnabled());
        }
        if (source == this.allOriginAmount) {
            this.setEnabled(this.isEnabled());
        }
    }

    private List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        return o;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 170);
        }

        @Override
        public void layoutContainer(Container parent) {
            SubstitutionPanel.this.layoutTitle(parent);
            int currentX = 10;
            int border = 10;
            int y = SubstitutionPanel.this.getTitleHeight() + 5;
            currentX = SubstitutionPanel.this.layoutItem(currentX, y, 200, border, SubstitutionPanel.this.type);
            currentX = SubstitutionPanel.this.layoutItem(currentX, y, 150, border, SubstitutionPanel.this.cabinClass);
            switch (SubstitutionPanel.this.currentType) {
                case ARTICLE_BY_ARTICLE: {
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 200, border, SubstitutionPanel.this.product);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 200, border, SubstitutionPanel.this.recipe);
                    y = SubstitutionPanel.this.product.getY() + SubstitutionPanel.this.product.getHeight() + border / 4;
                    currentX = border;
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 200, 3, SubstitutionPanel.this.originArticle);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y + 23, 0, border, SubstitutionPanel.this.originArticleInfo);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y + 23, 0, 3, SubstitutionPanel.this.allOriginAmount);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 0, border, SubstitutionPanel.this.originAmount);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 200, 3, SubstitutionPanel.this.newArticle);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y + 23, 0, border, SubstitutionPanel.this.newArticleInfo);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y + 23, 0, 3, SubstitutionPanel.this.allNewAmount);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 0, border, SubstitutionPanel.this.newAmount);
                    break;
                }
                case ARTICLE_BY_RECIPE: {
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 200, border, SubstitutionPanel.this.product);
                    y = SubstitutionPanel.this.product.getY() + SubstitutionPanel.this.product.getHeight() + border / 4;
                    currentX = border;
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 200, 3, SubstitutionPanel.this.originArticle);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y + 23, 0, border, SubstitutionPanel.this.originArticleInfo);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y + 23, 0, 3, SubstitutionPanel.this.allOriginAmount);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 0, border, SubstitutionPanel.this.originAmount);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 200, border, SubstitutionPanel.this.newRecipe);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y + 23, 0, 3, SubstitutionPanel.this.allNewAmount);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 0, border, SubstitutionPanel.this.newAmount);
                    break;
                }
                case PRODUCT_BY_PRODUCT: {
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 200, border, SubstitutionPanel.this.originProduct);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y + 23, 0, 3, SubstitutionPanel.this.allOriginAmount);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 0, border, SubstitutionPanel.this.originAmount);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 200, border, SubstitutionPanel.this.newProduct);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y + 23, 0, 3, SubstitutionPanel.this.allNewAmount);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 0, border, SubstitutionPanel.this.newAmount);
                    break;
                }
                case RECIPE_BY_ARTICLE: {
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 200, border, SubstitutionPanel.this.product);
                    y = SubstitutionPanel.this.product.getY() + SubstitutionPanel.this.product.getHeight() + border / 4;
                    currentX = border;
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 200, border, SubstitutionPanel.this.originRecipe);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y + 23, 0, 3, SubstitutionPanel.this.allOriginAmount);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 0, border, SubstitutionPanel.this.originAmount);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 200, 3, SubstitutionPanel.this.newArticle);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y + 23, 0, border, SubstitutionPanel.this.newArticleInfo);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y + 23, 0, 3, SubstitutionPanel.this.allNewAmount);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 0, border, SubstitutionPanel.this.newAmount);
                    break;
                }
                case RECIPE_BY_RECIPE: {
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 200, border, SubstitutionPanel.this.product);
                    y = SubstitutionPanel.this.product.getY() + SubstitutionPanel.this.product.getHeight() + border / 4;
                    currentX = border;
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 200, border, SubstitutionPanel.this.originRecipe);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y + 23, 0, 3, SubstitutionPanel.this.allOriginAmount);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 0, border, SubstitutionPanel.this.originAmount);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 200, border, SubstitutionPanel.this.newRecipe);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y + 23, 0, 3, SubstitutionPanel.this.allNewAmount);
                    currentX = SubstitutionPanel.this.layoutItem(currentX, y, 0, border, SubstitutionPanel.this.newAmount);
                    break;
                }
            }
            y = SubstitutionPanel.this.newAmount.getY() + SubstitutionPanel.this.newAmount.getHeight() + border / 4;
            currentX = border;
            currentX = SubstitutionPanel.this.layoutItem(currentX, y + 23, 0, border, SubstitutionPanel.this.unknownAllergens);
            currentX = SubstitutionPanel.this.layoutItem(currentX, y, 200, border, SubstitutionPanel.this.remark);
            currentX = SubstitutionPanel.this.layoutItem(currentX, y + 23, 0, border, SubstitutionPanel.this.insertSubstitutions);
        }
    }
}

