/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.itemsubstitution.details;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextArea;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.production.ItemSubstitutionComplete_;
import ch.icit.pegasus.server.core.dtos.production.ItemSubstitutionLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class BasicDetailsPanel
extends DefaultDetailsPanel<ItemSubstitutionLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDDateChooser> date;
    private TitledItem<RDComboBox> department;
    private TitledItem<RDTextField> name;
    private TitledItem<RDTextArea> comment;
    private TitledItem<SearchTextField2<CustomerLight>> customerSearch;

    public BasicDetailsPanel(RowEditor<ItemSubstitutionLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.BASIC_DATA);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.date = new TitledItem<RDDateChooser>(new RDDateChooser(provider), Words.DATE, TitledItem.TitledItemOrientation.NORTH);
        this.department = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(CostCenterConverter.class), true), Words.DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
        this.comment = new TitledItem<RDTextArea>(new RDTextArea(provider), Words.COMMENT, TitledItem.TitledItemOrientation.NORTH);
        this.comment.setIgnorePrefHeight(true);
        this.customerSearch = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, null), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.setCustomLayouter(new Layout());
        this.addToView(this.name);
        this.addToView(this.date);
        this.addToView(this.department);
        this.addToView(this.comment);
        this.addToView(this.customerSearch);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.date.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        if (this.name.getElement().isWritable() && (this.editor.getModel().getNode().getChildNamed(ItemSubstitutionComplete_.name).getValue() == null || this.editor.getModel().getNode().getChildNamed(ItemSubstitutionComplete_.name).getValue().equals(""))) {
            this.name.getElement().setInvalid();
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NAME_IS_SET));
        }
        return o;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.name.setEnabled(isEnabled);
        this.date.setEnabled(isEnabled);
        this.department.setEnabled(isEnabled);
        this.comment.setEnabled(isEnabled);
        this.customerSearch.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.name.kill();
        this.department.kill();
        this.date.kill();
        this.comment.kill();
        this.customerSearch.kill();
        this.name = null;
        this.department = null;
        this.date = null;
        this.comment = null;
        this.customerSearch = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.department);
        CheckedListAdder.addToList(focusList, this.date);
        CheckedListAdder.addToList(focusList, this.comment);
        CheckedListAdder.addToList(focusList, this.customerSearch);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.name.getElement().setNode(node.getChildNamed(ItemSubstitutionComplete_.name));
        this.department.getElement().setNode(node.getChildNamed(ItemSubstitutionComplete_.department));
        if (this.department.getElement().getEditor() != null) {
            ((ComboBox)this.department.getElement().getEditor()).setPossibleValues(NodeToolkit.getAffixList(InternalCostCenterComplete.class));
        }
        this.date.getElement().setNode(node.getChildNamed(ItemSubstitutionComplete_.date));
        this.comment.getElement().setNode(node.getChildNamed(ItemSubstitutionComplete_.comment));
        Node cust = node.getChildNamed(ItemSubstitutionComplete_.customer);
        if (cust == null) {
            cust = new DTOProxyNode();
            cust.setName(ItemSubstitutionComplete_.customer);
            node.addChild(cust, 0L);
        }
        this.customerSearch.getElement().setNode(cust);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = BasicDetailsPanel.this.verticalBorder;
            h += 200;
            return new Dimension(0, h += BasicDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            BasicDetailsPanel.this.name.setLocation(BasicDetailsPanel.this.horizontalBorder, BasicDetailsPanel.this.verticalBorder);
            BasicDetailsPanel.this.name.setSize(250, ((BasicDetailsPanel)BasicDetailsPanel.this).name.getPreferredSize().height);
            BasicDetailsPanel.this.date.setLocation(BasicDetailsPanel.this.name.getX() + BasicDetailsPanel.this.name.getWidth() + BasicDetailsPanel.this.horizontalBorder, BasicDetailsPanel.this.verticalBorder);
            BasicDetailsPanel.this.date.setSize(BasicDetailsPanel.this.date.getPreferredSize());
            BasicDetailsPanel.this.department.setLocation(BasicDetailsPanel.this.date.getX() + BasicDetailsPanel.this.date.getWidth() + BasicDetailsPanel.this.horizontalBorder, BasicDetailsPanel.this.verticalBorder);
            BasicDetailsPanel.this.department.setSize(150, ((BasicDetailsPanel)BasicDetailsPanel.this).department.getPreferredSize().height);
            BasicDetailsPanel.this.comment.setLocation(BasicDetailsPanel.this.department.getX() + BasicDetailsPanel.this.department.getWidth() + BasicDetailsPanel.this.horizontalBorder, BasicDetailsPanel.this.name.getY());
            BasicDetailsPanel.this.comment.setSize(200, 200);
            BasicDetailsPanel.this.customerSearch.setLocation(BasicDetailsPanel.this.horizontalBorder, BasicDetailsPanel.this.name.getY() + BasicDetailsPanel.this.name.getHeight() + BasicDetailsPanel.this.verticalBorder);
            BasicDetailsPanel.this.customerSearch.setSize(150, (int)BasicDetailsPanel.this.customerSearch.getPreferredSize().getHeight());
        }
    }
}

