/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.itemsubstitution.details;

import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2HeaderPanel;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.production.ItemSubstitutionComplete_;
import ch.icit.pegasus.server.core.dtos.production.ItemSubstitutionEntryComplete;
import ch.icit.pegasus.server.core.dtos.production.ItemSubstitutionEntryComplete_;
import ch.icit.pegasus.server.core.dtos.production.ItemSubstitutionTypeE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ItemSubstitutionAccess;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public abstract class ProductByProductSubstitutionDetailsPanel<T extends IDTO>
extends TableDetailsPanel<T> {
    private static final long serialVersionUID = -4552350129677539999L;

    public ProductByProductSubstitutionDetailsPanel(RowEditor<T> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.PRODUCT_BY_PRODUCT_SUBSTITUTIONS);
    }

    @Override
    public Table2Model createNewTableModel(List<TableColumnInfo> columns) {
        Table2Model m = new Table2Model(columns, true){

            @Override
            public boolean shouldAddRow(Node node) {
                boolean t = super.shouldAddRow(node);
                return t && node.getChildNamed(ItemSubstitutionEntryComplete_.substitutionType).getValue() == ItemSubstitutionTypeE.PRODUCT_BY_PRODUCT;
            }
        };
        return m;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean b = isEnabled;
        if (!this.getShowFlightColumn() && Boolean.TRUE.equals(this.editor.getModel().getNode().getChildNamed(FlightLight_.substitutionsApproved).getValue())) {
            b = this.provider.isWritable(ItemSubstitutionAccess.EDIT_APPROVED_FLIGHT);
        }
        super.setEnabled(b);
    }

    public abstract boolean getShowFlightColumn();

    @Override
    public void validateRemote(List<ScreenValidationObject> callBack) throws ClientServerCallException {
    }

    @Override
    public void setNode(Node<?> node) {
        if (this.getShowFlightColumn()) {
            this.table.getModel().setNode(node.getChildNamed(ItemSubstitutionComplete_.substitutions));
        } else {
            this.table.getModel().setNode(node.getChildNamed(new DtoField[]{ItemSubstitutionComplete_.substitutions, ItemSubstitutionComplete_.substitutions}));
        }
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        if (this.getShowFlightColumn()) {
            columns.add(new TableColumnInfo(Words.FLIGHT, null, null, null, "", 100, 100, 100));
        }
        columns.add(new TableColumnInfo(Words.CABIN_CLASS, null, null, null, "", 100, 100, 100));
        columns.add(new TableColumnInfo(Words.ORIGIN_PRODUCT, null, null, null, "", 100, 100, 100));
        int wt = 2 * this.table.getCellPadding() + CheckBox.getPreferredWidth() + 5 + InputComboBox.getPreferredWidth(this.table, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
        columns.add(new TableColumnInfo(Words.AMOUNT, null, null, null, "", wt, wt, wt));
        columns.add(new TableColumnInfo(Words.SUBSTITUTE_PRODUCT, null, null, null, "", 100, 100, 100));
        columns.add(new TableColumnInfo(Words.AMOUNT, null, null, null, "", wt, wt, wt));
        int tw = 2 * this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo(Words.UNKNOWN_ALLERGENS, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.REMARK, null, null, null, "", 100, 100, 100));
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        if (this.getShowFlightColumn()) {
            ((TableColumnInfo)columns.get(0)).setxExpand(0.15);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.15);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.3);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(4)).setxExpand(0.3);
            ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(7)).setxExpand(0.1);
            columns.get(8).setxExpand(0.0);
        } else {
            ((TableColumnInfo)columns.get(0)).setxExpand(0.15);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.35);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.35);
            ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(6)).setxExpand(0.15);
            ((TableColumnInfo)columns.get(7)).setxExpand(0.0);
        }
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setRequestFocusOnAdd(true);
        table.setUseWriteAccessRight(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        ItemSubstitutionEntryComplete le = new ItemSubstitutionEntryComplete();
        le.setSubstitutionType(ItemSubstitutionTypeE.PRODUCT_BY_PRODUCT);
        le.setClientOId(Long.valueOf(ADTO.getNextId()));
        le.setReplacedQuantity(new QuantityComplete(Double.valueOf(0.0), settings.getPieceUnit()));
        le.setOriginQuantity(new QuantityComplete(Double.valueOf(0.0), settings.getPieceUnit()));
        le.setUseCompleteOriginQuantity(Boolean.valueOf(true));
        le.setUseCompleteReplacedQuantity(Boolean.valueOf(true));
        this.table.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)le, true, false), System.currentTimeMillis());
        this.editor.revalidate();
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        List<ScreenValidationObject> validationObjects = super.validateParagraph();
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl r = (TableRowImpl)p;
            List<ScreenValidationObject> b = r.validateRow();
            validationObjects.addAll(b);
        }
        return validationObjects;
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        if (isHeader) {
            return new Table2HeaderPanel(model, 7);
        }
        TableRowImpl p = new TableRowImpl(model);
        return p;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    SearchTextField2Listener {
        private static final long serialVersionUID = 1L;
        private SearchTextField2<FlightLight> flight;
        private SearchComboBox cabinClass;
        private SearchTextField2<ProductComplete> originProduct;
        private SearchTextField2<ProductComplete> newProduct;
        private CheckBox useCompleteOrigin;
        private CheckBox useCompleteReplaced;
        private InputComboBox originAmount;
        private InputComboBox replacedAmount;
        private CheckBox unknownAllergens;
        private TextField remark;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            if (ProductByProductSubstitutionDetailsPanel.this.getShowFlightColumn()) {
                this.flight = SearchTextField2Factory.getFlightSearchField(true, m.getNode().getChildNamed(ItemSubstitutionEntryComplete_.flight));
                Object[] o = new Object[]{m.getNode().getParent().getParent().getChildNamed(ItemSubstitutionComplete_.date), true};
                this.flight.setAdditionalSearchField(o);
                this.flight.addSearchTextFieldListener(this);
            }
            this.originProduct = SearchTextField2Factory.getProductSearchField(true, m.getNode().getChildNamed(ItemSubstitutionEntryComplete_.originProd));
            this.originProduct.addSearchTextFieldListener(this);
            Node customerNode = ProductByProductSubstitutionDetailsPanel.this.editor.getModel().getNode().getChildNamed(ItemSubstitutionComplete_.customer);
            Object[] ps = new Object[3];
            ps[2] = customerNode;
            this.originProduct.setAdditionalSearchField(ps);
            this.newProduct = SearchTextField2Factory.getProductSearchField(true, m.getNode().getChildNamed(ItemSubstitutionEntryComplete_.newProd));
            this.newProduct.addSearchTextFieldListener(this);
            this.newProduct.setAdditionalSearchField(ps);
            this.cabinClass = SearchComboBoxFactory.getCabinClassSearchField(true, m.getNode().getChildNamed(ItemSubstitutionEntryComplete_.cabinClass));
            this.cabinClass.addSearchTextFieldListener(this);
            this.useCompleteOrigin = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ItemSubstitutionEntryComplete_.useCompleteOriginQuantity));
            this.useCompleteReplaced = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ItemSubstitutionEntryComplete_.useCompleteReplacedQuantity));
            this.useCompleteOrigin.addButtonListener(this);
            this.useCompleteReplaced.addButtonListener(this);
            this.originAmount = new InputComboBox(m.getNode().getChildNamed(new DtoField[]{ItemSubstitutionEntryComplete_.originQuantity, QuantityComplete_.quantity}), m.getNode().getChildNamed(new DtoField[]{ItemSubstitutionEntryComplete_.originQuantity, QuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
            this.replacedAmount = new InputComboBox(m.getNode().getChildNamed(new DtoField[]{ItemSubstitutionEntryComplete_.replacedQuantity, QuantityComplete_.quantity}), m.getNode().getChildNamed(new DtoField[]{ItemSubstitutionEntryComplete_.replacedQuantity, QuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
            this.unknownAllergens = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ItemSubstitutionEntryComplete_.unknownAllergens));
            this.remark = new TextField(m.getNode().getChildNamed(ItemSubstitutionEntryComplete_.remark), TextFieldType.NORMAL);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new InnerLayout());
            if (ProductByProductSubstitutionDetailsPanel.this.getShowFlightColumn()) {
                this.add(this.flight);
            }
            this.add(this.originProduct);
            this.add(this.newProduct);
            this.add(this.cabinClass);
            this.add(this.originAmount);
            this.add(this.replacedAmount);
            this.add(this.remark);
            this.add(this.delete);
            this.add(this.unknownAllergens);
            this.add(this.useCompleteOrigin);
            this.add(this.useCompleteReplaced);
        }

        public List<ScreenValidationObject> validateRow() {
            ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
            boolean substitutionsWritable = ProductByProductSubstitutionDetailsPanel.this.provider.isWritable(ItemSubstitutionComplete_.substitutions);
            if (substitutionsWritable) {
                int index = ProductByProductSubstitutionDetailsPanel.this.table.getRowIndex(this) + 1;
                if (ProductByProductSubstitutionDetailsPanel.this.getShowFlightColumn()) {
                    if (this.model.getNode().getChildNamed(ItemSubstitutionEntryComplete_.flight).getValue() == null) {
                        this.flight.setInvalid();
                        a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.FLIGHT_ON_ROW_MUST_BE_SET, (Object[])new Object[]{index})));
                    } else {
                        this.flight.setValid();
                    }
                }
                boolean itemSet = false;
                if (this.model.getNode().getChildNamed(ItemSubstitutionEntryComplete_.originProd).getValue() != null) {
                    itemSet = true;
                    this.originProduct.setValid();
                }
                if (this.model.getNode().getChildNamed(ItemSubstitutionEntryComplete_.newProd).getValue() != null) {
                    itemSet = true;
                    this.newProduct.setValid();
                }
                if (!itemSet) {
                    this.originProduct.setInvalid();
                    this.newProduct.setInvalid();
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ENSURE_ATLEAST_ORIGIN_OR_NEW_PRODUCT_IS_SET_ON_ROW, (Object[])new Object[]{index})));
                }
            }
            return a;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (ProductByProductSubstitutionDetailsPanel.this.getShowFlightColumn()) {
                this.flight.kill();
            }
            this.cabinClass.kill();
            this.originProduct.kill();
            this.newProduct.kill();
            this.originAmount.kill();
            this.replacedAmount.kill();
            this.remark.kill();
            this.delete.kill();
            this.useCompleteOrigin.kill();
            this.useCompleteReplaced.kill();
            this.unknownAllergens.kill();
            this.newProduct = null;
            this.flight = null;
            this.cabinClass = null;
            this.originProduct = null;
            this.originAmount = null;
            this.replacedAmount = null;
            this.remark = null;
            this.delete = null;
            this.useCompleteOrigin = null;
            this.useCompleteReplaced = null;
            this.unknownAllergens = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.flight);
            CheckedListAdder.addToList(focusList, this.cabinClass);
            CheckedListAdder.addToList(focusList, this.originProduct);
            CheckedListAdder.addToList(focusList, this.newProduct);
            CheckedListAdder.addToList(focusList, this.useCompleteOrigin);
            CheckedListAdder.addToList(focusList, this.originAmount);
            CheckedListAdder.addToList(focusList, this.useCompleteReplaced);
            CheckedListAdder.addToList(focusList, this.replacedAmount);
            CheckedListAdder.addToList(focusList, this.unknownAllergens);
            CheckedListAdder.addToList(focusList, this.remark);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            if (ProductByProductSubstitutionDetailsPanel.this.getShowFlightColumn()) {
                this.flight.setEnabled(isEnabled);
            }
            this.cabinClass.setEnabled(isEnabled);
            this.originProduct.setEnabled(isEnabled);
            this.newProduct.setEnabled(isEnabled);
            boolean hasOrigin = this.model.getNode().getChildNamed(ItemSubstitutionEntryComplete_.originProd).getValue() != null;
            this.useCompleteOrigin.setEnabled(isEnabled && hasOrigin);
            this.originAmount.setEnabled(isEnabled && hasOrigin && !this.useCompleteOrigin.isChecked());
            boolean hasReplaced = this.model.getNode().getChildNamed(ItemSubstitutionEntryComplete_.newProd).getValue() != null;
            this.useCompleteReplaced.setEnabled(isEnabled && hasReplaced);
            this.replacedAmount.setEnabled(isEnabled && hasReplaced && !this.useCompleteReplaced.isChecked());
            this.unknownAllergens.setEnabled(isEnabled);
            this.remark.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            } else {
                this.setEnabled(this.isEnabled());
            }
        }

        @Override
        public void newValueSelected(SearchTextField2 source, Node<?> n) throws ClientServerCallException {
            if (source == this.originProduct) {
                this.setEnabled(this.isEnabled());
                this.newProduct.requestFocusInWindowNow();
            } else if (source == this.newProduct) {
                this.setEnabled(this.isEnabled());
                if (ProductByProductSubstitutionDetailsPanel.this.table.getAddButton() != null) {
                    ProductByProductSubstitutionDetailsPanel.this.table.getAddButton().requestFocusInWindowNow();
                }
            } else if (source == this.flight) {
                this.cabinClass.requestFocusInWindowNow();
            } else if (source == this.cabinClass) {
                this.originProduct.requestFocusInWindowNow();
            }
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                int index = 1;
                if (ProductByProductSubstitutionDetailsPanel.this.getShowFlightColumn()) {
                    TableRowImpl.this.flight.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.flight.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.flight.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.flight.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                    index = 2;
                }
                TableRowImpl.this.cabinClass.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cabinClass.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.cabinClass.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.cabinClass.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.originProduct.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.originProduct.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.originProduct.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.originProduct.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.useCompleteOrigin.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.useCompleteOrigin.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.useCompleteOrigin.setSize(TableRowImpl.this.useCompleteOrigin.getPreferredSize());
                TableRowImpl.this.originAmount.setLocation(TableRowImpl.this.useCompleteOrigin.getX() + TableRowImpl.this.useCompleteOrigin.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.originAmount.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.originAmount.setSize(w - (2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding() + TableRowImpl.this.useCompleteOrigin.getWidth()), (int)TableRowImpl.this.originAmount.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.newProduct.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.newProduct.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.newProduct.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.newProduct.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.useCompleteReplaced.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.useCompleteReplaced.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.useCompleteReplaced.setSize(TableRowImpl.this.useCompleteReplaced.getPreferredSize());
                TableRowImpl.this.replacedAmount.setLocation(TableRowImpl.this.useCompleteReplaced.getX() + TableRowImpl.this.useCompleteReplaced.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.replacedAmount.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.replacedAmount.setSize(w - (2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding() + TableRowImpl.this.useCompleteReplaced.getWidth()), (int)TableRowImpl.this.replacedAmount.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.unknownAllergens.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.unknownAllergens.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.unknownAllergens.setSize(TableRowImpl.this.unknownAllergens.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.remark.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.remark.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.remark.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.remark.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

