/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.jobs;

import ch.icit.pegasus.client.converter.BooleanConverter;
import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.jobs.JobsModuleDataHandler;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased.utils.DepartmentConverter;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.RowPanel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.JobSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.ArticlePreparationJobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.JobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.JobComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.JobAccess;
import ch.icit.pegasus.server.core.dtos.search.JobSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StoreSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class JobsModule
extends ScreenTableView<JobComplete, JobSearchConfiguration.JOB_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_CUSTOMER = "customer_filter";
    private static final String FILTER_TYPE = "type_filter";
    private static final String FILTER_DONE = "done_filter";
    private static final String FILTER_DEPARTMENT = "department_filter";
    private static final String FILTER_PERIOD = "period_filter";
    private ComboBox jobType;
    private ComboBox jobDone;
    private ComboBox departments;
    private CustomerLight customerFilter;
    private ComboBoxFactory.JobType typeFilter;
    private Boolean doneFilter;
    private CostCenterComplete departmentFilter;
    private PeriodComplete periodFilter;

    public JobsModule() {
        super(JobComplete.class);
        this.isSynchronSearch = false;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return JobAccess.MODULE_JOB;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", StoreSearchConfiguration.STORE_COLUMN.CODE + "<>" + true);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.jobType = ComboBoxFactory.getJobType(true);
        this.filterChain.addSelectionComboBox(this.jobType, 100, FILTER_TYPE, Words.TYPE, Words.ALL);
        TitledPeriodEditor periodEditor = this.filterChain.addPeriodSelection(FILTER_PERIOD, new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()), Words.DATE, false);
        periodEditor.setCheckBoxEnabled();
        periodEditor.setCheckBoxChecked(false);
        periodEditor.setCommitOnFocusLost(true);
        this.filterChain.addCustomerSearchField(FILTER_CUSTOMER);
        this.jobDone = ComboBoxFactory.getJobDone(true);
        this.filterChain.addSelectionComboBox(this.jobDone, 100, FILTER_DONE, Words.STATE, Words.ALL);
        this.departments = new ComboBox(null, null, ConverterRegistry.getConverter(CostCenterConverter.class));
        this.filterChain.addSelectionComboBox(this.departments, 150, FILTER_DEPARTMENT, Words.COSTCENTER, Words.ALL);
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<JobComplete, JobSearchConfiguration.JOB_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.customerFilter = null;
            this.typeFilter = null;
            this.doneFilter = null;
            this.departmentFilter = null;
            this.periodFilter = null;
        } else {
            if (name == FILTER_CUSTOMER) {
                this.customerFilter = value instanceof CustomerLight ? (CustomerLight)value : (value instanceof Node ? (((Node)value).getValue() instanceof CustomerLight ? (CustomerLight)((Node)value).getValue() : null) : null);
            }
            if (name == FILTER_DONE) {
                this.doneFilter = value != null ? (value.equals(Words.OPEN) ? Boolean.valueOf(false) : (value.equals(Words.CLOSED) ? Boolean.valueOf(true) : null)) : null;
            }
            if (name == FILTER_DEPARTMENT) {
                if (value instanceof String) {
                    if (value.equals(Words.ALL)) {
                        this.departmentFilter = null;
                    }
                } else {
                    this.departmentFilter = value instanceof Node ? (((Node)value).getValue() instanceof CostCenterComplete ? (CostCenterComplete)((Node)value).getValue() : null) : null;
                }
            }
            if (name == FILTER_TYPE && value instanceof ComboBoxFactory.JobType) {
                this.typeFilter = (ComboBoxFactory.JobType)((Object)value);
            }
            if (name == FILTER_PERIOD) {
                this.periodFilter = ((TitledPeriodEditor)value).getPeriod();
            }
        }
        JobSearchConfiguration c = new JobSearchConfiguration();
        c.setCustomer(this.customerFilter);
        c.setDepartment(this.departmentFilter);
        c.setPeriod(this.periodFilter);
        c.setDone(this.doneFilter);
        c.setJobType(this.typeFilter != null ? this.typeFilter.toString() : null);
        c.setNumResults(this.numberOfShownResults);
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.departments.refreshPossibleValues(NodeToolkit.getAffixList(InternalCostCenterComplete.class));
        this.departments.addItem(Words.ALL);
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<JobComplete> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(JobSearchAlgorithm.class);
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<JobComplete> model) {
        if (model == null) {
            return false;
        }
        if (screen.getInvokingName().equals(JobAccess.ACTION_PREPARE_ARTICLE_PB.getIdentifier()) || screen.getInvokingName().equals(JobAccess.ACTION_PREPARE_ARTICLE_CB.getIdentifier())) {
            if (model.getNode().getValue() instanceof ArticlePreparationJobComplete) {
                if (((JobComplete)model.getNode().getValue()).getJobStartUser() == null) {
                    return false;
                }
                return !Boolean.TRUE.equals(((JobComplete)model.getNode().getValue()).getJobDone());
            }
            return false;
        }
        if (screen.getInvokingName().equals(JobAccess.ACTION_PROCESS_START.getIdentifier()) && ((JobComplete)model.getNode().getValue()).getJobStartUser() != null) {
            return false;
        }
        if (screen.getInvokingName().equals(JobAccess.ACTION_PROCESS_DONE.getIdentifier())) {
            if (Boolean.TRUE.equals(((JobComplete)model.getNode().getValue()).getJobDone())) {
                return false;
            }
            if (((JobComplete)model.getNode().getValue()).getJobStartUser() == null) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isDeletable(RowModel<JobComplete> model) {
        return false;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<JobComplete> getRowEditorFactory() {
        return model -> {
            RowEditor rowEditor = new RowEditor(model);
            rowEditor.setIgnoreCancelQuestion(true);
            rowEditor.hideCloseButton();
            rowEditor.setCancelButtonText(TextButton.BUTTON_TYPES.CLOSE);
            RDProvider p = this.createProvider(model.isAddRow());
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    public boolean isRowExpandable(Node<JobComplete> node) {
        return false;
    }

    @Override
    protected RowPanel<JobComplete> getNewAddRow() {
        return null;
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new JobsModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> info = new ArrayList<TableColumnInfo>();
        info.add(new TableColumnInfo(Words.TYPE, "", (Class)StringConverter.class, null, JobComplete_.jobTypeString, 160));
        info.add(new TableColumnInfo(Words.NAME, "", StringConverter.class, null, JobComplete_.jobName, 80, Integer.MAX_VALUE, 80));
        info.add(new TableColumnInfo(Words.QUANTITY, "", (Class)StringConverter.class, null, JobComplete_.quantityString, 120));
        info.add(new TableColumnInfo(Words.CLOSED, "", BooleanConverter.class, null, JobComplete_.jobDone, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith));
        info.add(new TableColumnInfo(Words.DEPARMENT, "", (Class)DepartmentConverter.class, null, JobComplete_.department, TableColumnInfo.departmentWidth));
        info.add(new TableColumnInfo(Words.DATE, "", (Class)DateConverter.class, (Enum<?>)JobSearchConfiguration.JOB_COLUMN.PERIOD, JobComplete_.jobSchedule, TableColumnInfo.dateColumnWidth));
        return info;
    }
}

