/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.kitchenforecast;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.screentemplates.TitledScreenInsert;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.KitchenForecastConfigPanel_ComboStyle;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.KitchenreportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PreparationGroupComplete;
import ch.icit.pegasus.server.core.dtos.report.KitchenForecastReportConfiguration;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.KitchenForecastAccess;
import ch.icit.pegasus.server.core.dtos.search.CustomerSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class KitchenForecastModule
extends TitledScreenInsert
implements ButtonListener,
Module {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel viewPort = new BorderedInletPanel(false, true);
    private KitchenForecastConfigPanel_ComboStyle configPanel;
    private LoadingAnimation animation;
    private Table2 table;
    private TitledItem<CheckBox> checkAll;
    private TablePanelAddSaveButton exportButton;

    public KitchenForecastModule() {
        this.viewPort.setLayout(new ViewPortLayout());
        UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        RDProvider provider = null;
        for (ModuleAccessRightComplete module : user.getModules()) {
            if (!module.getModule().getInvokingName().equals(KitchenForecastAccess.MODULE_KITCHEN_FORE_CAST.getIdentifier())) continue;
            provider = new RDProvider(module);
        }
        this.configPanel = new KitchenForecastConfigPanel_ComboStyle(provider);
        this.table = new Table2(false, "", true, true, Words.CUSTOMER);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int tw = this.table.getCellPadding() * 2 + CheckBox.getPreferredWidth();
        columns.add(new TableColumnInfo("", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.NO_NUMBER, TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth));
        columns.add(new TableColumnInfo(Words.CODE, TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth));
        columns.add(new TableColumnInfo(Words.NAME, 120, Integer.MAX_VALUE, 120));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(1.0);
        this.table.setSortedColumn(1);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.checkAll = new TitledItem<CheckBox>(new CheckBox(), Words.CHECK_ALL, TitledItem.TitledItemOrientation.EAST);
        this.checkAll.getElement().addButtonListener(this);
        this.table.enableAdditionalComponent(this.checkAll);
        this.setLayout(new Layout());
        this.setOpaque(false);
        this.viewPort.setLayout(new ViewPortLayout());
        this.viewPort.add(this.configPanel);
        this.viewPort.add(this.table);
        this.exportButton = new TablePanelAddSaveButton(Words.EXPORT);
        this.exportButton.addButtonListener(this);
        this.add(this.viewPort);
        this.add(this.exportButton);
        this.startDownload();
    }

    private void showAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.viewPort.add((Component)this.animation, 0);
            this.animation.fadeIn();
            this.animation.start();
        }
        this.animation.stateChanged(text);
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.kill();
            this.animation = null;
        }
    }

    private void startDownload() {
        this.setEnabled(false);
        this.showAnimation(Words.LOAD_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperArticleCategoriesCached();
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(FlightCategoryComplete.class);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(HaulTypeComplete.class);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperProductCategoriesCached();
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(PreparationGroupComplete.class);
                CustomerSearchConfiguration config = new CustomerSearchConfiguration();
                SearchResultIterator sri = new SearchResultIterator((ASearchConfiguration)config);
                ViewNode cn = new ViewNode("Customers");
                for (CustomerLight c : sri) {
                    if (c.getIsDeleted().booleanValue()) continue;
                    cn.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)c, false, true), 0L);
                }
                return cn;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        if (KitchenForecastModule.this.table != null) {
                            KitchenForecastModule.this.table.getModel().setNode(node);
                            KitchenForecastModule.this.configPanel.loadComboData();
                            KitchenForecastModule.this.stopAnimationsImmediately();
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)KitchenForecastModule.this);
                        KitchenForecastModule.this.stopAnimationsImmediately();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void undo() {
    }

    public void redo() {
    }

    @Override
    public String getScreenTitle() {
        return Words.KITCHEN_FORECAST;
    }

    @Override
    public void stopAnimationsImmediately() {
        this.hideAnimation();
        this.setEnabled(true);
    }

    @Override
    public void escapeKeyPressed() {
    }

    @Override
    public void saveKeyPressed() {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.table != null) {
            this.table.setEnabled(isEnabled);
        }
        if (this.configPanel != null) {
            this.configPanel.setEnabled(isEnabled);
        }
        if (this.exportButton != null) {
            this.exportButton.setEnabled(isEnabled);
        }
        if (this.checkAll != null) {
            this.checkAll.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.viewPort.kill();
        this.table.kill();
        this.exportButton.kill();
        if (this.animation != null) {
            this.animation.kill();
        }
        this.checkAll.kill();
        this.configPanel.kill();
        this.checkAll = null;
        this.viewPort = null;
        this.configPanel = null;
        this.table = null;
        this.exportButton = null;
        this.animation = null;
    }

    private void checkAll(boolean checked) {
        for (Table2RowPanel p : this.table.getRows()) {
            ((TableRowImpl)p).setChecked(checked);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.checkAll.getElement()) {
            this.checkAll(this.checkAll.getElement().isChecked());
        } else if (source == this.exportButton) {
            this.showAnimation(Words.CREATE_KITCHEN_FORECAST);
            this.getMainFrame().getTitleBar().setHUDButtonsEnabled(false, 255255);
            this.setEnabled(false);
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    KitchenForecastReportConfiguration config = KitchenForecastModule.this.configPanel.getConfig();
                    ArrayList warnings = new ArrayList();
                    config.setCustomers(new ArrayList());
                    for (Table2RowPanel p : KitchenForecastModule.this.table.getRows()) {
                        TableRowImpl pp = (TableRowImpl)p;
                        if (!pp.isChecked()) continue;
                        config.getCustomers().add(pp.getCustomer());
                    }
                    SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                    if (CompanyUtil.isNoPro((SystemSettingsComplete)settings)) {
                        config.setIncludeProducedFlights(Boolean.valueOf(false));
                    }
                    List ref = ((KitchenreportServiceManager)ServiceManagerRegistry.getService(KitchenreportServiceManager.class)).createKitchenForecastReport(config, new ListWrapper(warnings)).getList();
                    for (PegasusFileComplete pf : ref) {
                        File f = FileTransferUtil.download((PegasusFileComplete)pf, (FileTransferListener[])new FileTransferListener[0]);
                        PrintPopupToolkit.previewFile(f);
                    }
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_EXPORTED, KitchenForecastModule.this);
                            KitchenForecastModule.this.hideAnimation();
                            KitchenForecastModule.this.getMainFrame().getTitleBar().setHUDButtonsEnabled(true, 255255);
                            KitchenForecastModule.this.setEnabled(true);
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog((Exception)exception, (Component)KitchenForecastModule.this);
                            KitchenForecastModule.this.hideAnimation();
                            KitchenForecastModule.this.getMainFrame().getTitleBar().setHUDButtonsEnabled(true, 255255);
                            KitchenForecastModule.this.setEnabled(true);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private CheckBox check;
        private TextLabel customerNo;
        private TextLabel customerName;
        private TextLabel customerCode;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new RowLayout());
            this.check = new CheckBox();
            this.customerNo = new TextLabel(m.getNode().getChildNamed(CustomerLight_.number), ConverterRegistry.getConverter(IntegerConverter.class));
            this.customerName = new TextLabel(m.getNode().getChildNamed(CustomerLight_.name));
            this.customerCode = new TextLabel(m.getNode().getChildNamed(CustomerLight_.code));
            this.add(this.check);
            this.add(this.customerNo);
            this.add(this.customerCode);
            this.add(this.customerName);
        }

        public void setChecked(boolean b) {
            this.check.setChecked(b);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.check);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: 
                case 1: {
                    return this.model.getNode().getChildNamed(CustomerLight_.number).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(CustomerLight_.code).getValue();
                }
                case 3: {
                    return this.model.getNode().getChildNamed(CustomerLight_.name).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.check.setEnabled(isEnabled);
            this.customerCode.setEnabled(isEnabled);
            this.customerName.setEnabled(isEnabled);
            this.customerNo.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.check.kill();
            this.customerCode.kill();
            this.customerName.kill();
            this.customerNo.kill();
            this.check = null;
            this.customerCode = null;
            this.customerName = null;
            this.customerNo = null;
        }

        public boolean isChecked() {
            return this.check.isChecked();
        }

        public CustomerLight getCustomer() {
            return (CustomerLight)this.model.getNode().getValue();
        }

        private class RowLayout
        extends DefaultLayout {
            private RowLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.check.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.check.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.check.setSize(TableRowImpl.this.check.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                TableRowImpl.this.customerNo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customerNo.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.customerNo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.customerNo.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(2);
                TableRowImpl.this.customerCode.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customerCode.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.customerCode.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.customerCode.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(3);
                TableRowImpl.this.customerName.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customerName.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.customerName.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.customerName.getPreferredSize().getHeight());
            }
        }
    }

    private class ViewPortLayout
    extends DefaultLayout {
        private ViewPortLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (KitchenForecastModule.this.animation != null) {
                KitchenForecastModule.this.animation.setLocation((int)((double)parent.getWidth() - KitchenForecastModule.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - KitchenForecastModule.this.animation.getPreferredSize().getHeight()) / 2);
                KitchenForecastModule.this.animation.setSize(KitchenForecastModule.this.animation.getPreferredSize());
            }
            KitchenForecastModule.this.configPanel.setLocation(border, border);
            KitchenForecastModule.this.configPanel.setSize(parent.getWidth() - (3 * border + 465), (int)KitchenForecastModule.this.configPanel.getPreferredSize().getHeight());
            KitchenForecastModule.this.table.setLocation(parent.getWidth() - 465 - border, border);
            KitchenForecastModule.this.table.setSize(465, parent.getHeight() - (KitchenForecastModule.this.table.getY() + border));
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = KitchenForecastModule.this.layoutTitle(parent);
            KitchenForecastModule.this.viewPort.setLocation(0, y + AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("screen_vertical_border_to_tabletitle")));
            KitchenForecastModule.this.viewPort.setSize(parent.getWidth(), (int)((double)parent.getHeight() - ((double)(KitchenForecastModule.this.viewPort.getY() + 10 + 10) + KitchenForecastModule.this.exportButton.getPreferredSize().getHeight())));
            KitchenForecastModule.this.exportButton.setLocation(KitchenForecastModule.this.viewPort.getX(), KitchenForecastModule.this.viewPort.getY() + KitchenForecastModule.this.viewPort.getHeight() + 10);
            KitchenForecastModule.this.exportButton.setSize(KitchenForecastModule.this.exportButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

