/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.knifetracking.knife;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.KnifeStateEConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.knifetracking.knife.KnifeModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.knifetracking.knife.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.KnifeSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.KnifeAccess;
import ch.icit.pegasus.server.core.dtos.search.KnifeSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.tracking.knife.KnifeComplete;
import ch.icit.pegasus.server.core.dtos.tracking.knife.KnifeComplete_;
import ch.icit.pegasus.server.core.dtos.tracking.knife.KnifeStateE;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class KnifeModule
extends ScreenTableView<KnifeComplete, KnifeSearchConfiguration.KNIFE_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_BARCODE = "barcode_filter";
    private static final String FILTER_STATE = "state_filter";
    private static final String FILTER_DEPARTMENT = "department_filter";
    private String searchFilter;
    private KnifeStateE stateFilter;
    private InternalCostCenterComplete costCenterFilter;
    private ComboBox stateBox;
    private ComboBox departmentBox;

    public KnifeModule() {
        super(KnifeComplete.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public boolean isDeletable(RowModel<KnifeComplete> model) {
        return true;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return KnifeAccess.MODULE_KNIFE;
    }

    public KnifeModuleDataHandler getDataHandler() {
        return (KnifeModuleDataHandler)this.getTable().getModel().getDataHandler();
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", KnifeSearchConfiguration.KNIFE_COLUMN.BARCODE + "<>" + true);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.addSearchField(FILTER_BARCODE, Words.NAME, "");
        this.stateBox = ComboBoxFactory.getKnifeState(true);
        this.departmentBox = new ComboBox(null, null, ConverterRegistry.getConverter(CostCenterConverter.class));
        this.filterChain.addSelectionComboBox(this.stateBox, 150, FILTER_STATE, Words.STATE, Words.ALL);
        this.filterChain.addSelectionComboBox(this.departmentBox, 150, FILTER_DEPARTMENT, Words.DEPARTMENT, Words.ALL);
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<KnifeComplete, KnifeSearchConfiguration.KNIFE_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.searchFilter = "";
            this.stateFilter = null;
            this.costCenterFilter = null;
        } else if (name == FILTER_BARCODE) {
            this.searchFilter = (String)value;
        } else if (name == FILTER_STATE) {
            this.stateFilter = value instanceof KnifeStateE ? (KnifeStateE)value : null;
        } else if (name == FILTER_DEPARTMENT) {
            this.costCenterFilter = value instanceof Node ? (InternalCostCenterComplete)((Node)value).getValue() : (value instanceof InternalCostCenterComplete ? (InternalCostCenterComplete)value : null);
        }
        KnifeSearchConfiguration c = new KnifeSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setBarcode(this.searchFilter);
        c.setKnifeState(this.stateFilter);
        c.setDepartment(this.costCenterFilter);
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public SearchAlgorithm<KnifeComplete> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(KnifeSearchAlgorithm.class);
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        List costCenters = (List)NodeToolkit.getAffixList(InternalCostCenterComplete.class).getValue();
        this.departmentBox.refreshPossibleValues(INodeCreator.getDefaultImpl().createNodes(costCenters, false));
        this.departmentBox.addItem(Words.ALL);
        this.departmentBox.setSelectedItem(Words.ALL);
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<KnifeComplete> model) {
        KnifeComplete ab = (KnifeComplete)model.getNode().getValue();
        return model != null;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.ONE;
    }

    @Override
    protected RowEditorFactory<KnifeComplete> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<KnifeComplete> rowEditor = new MessageProvidedRowEditor<KnifeComplete>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            SpecificationDetailsPanel d1 = new SpecificationDetailsPanel((RowEditor<KnifeComplete>)rowEditor, p);
            rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new KnifeModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> info = new ArrayList<TableColumnInfo>();
        info.add(new TableColumnInfo(Words.BARCODE, "", (Class)StringConverter.class, (Enum<?>)KnifeSearchConfiguration.KNIFE_COLUMN.BARCODE, KnifeComplete_.barcode, TableColumnInfo.numberColumnWithExpandWidth * 3));
        info.add(new TableColumnInfo(Words.DEPARTMENT, "", (Class)CostCenterConverter.class, (Enum<?>)KnifeSearchConfiguration.KNIFE_COLUMN.DEPARTMENT, KnifeComplete_.department, TableColumnInfo.dateColumnWidth * 2));
        info.add(new TableColumnInfo(Words.STATE, "", (Class)KnifeStateEConverter.class, (Enum<?>)KnifeSearchConfiguration.KNIFE_COLUMN.KNIFE_STATE, KnifeComplete_.knifeState, TableColumnInfo.dateColumnWidth));
        return info;
    }
}

