/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.login;

import ch.icit.pegasus.client.ApplicationSettingsLoader;
import ch.icit.pegasus.client.Main;
import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.ScreenViewProvider;
import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.gui.hud.HistoryObject;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.flight.utils.NewFlightCreatedUpdater;
import ch.icit.pegasus.client.gui.modules.serverdown.ServerDownScreen;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.Screen;
import ch.icit.pegasus.client.gui.utils.ScreenInsert;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CapsLockActivePanel;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.textfield.PasswordTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.exchange.migros.MigrosExchangeServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.ESpecsServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.EdelweissServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.NoProExchangeServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.PickNPayServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.RetailInMotionServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.session.SessionManager;
import ch.icit.pegasus.client.util.InfoBox;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightAccess;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemViewSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginModule
extends ScreenInsert
implements LafListener,
ButtonListener,
RemoteLoader,
InnerPopUpListener2,
Module,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(LoginModule.class);
    private TextField userField;
    private TextField pwdField;
    public static final boolean DEBUG = true;
    private CapsLockActivePanel capslockPanel;
    private TextLabel userLabel;
    private TextLabel pwdLabel;
    private TextLabel errorLabel;
    private TextButton okButton;
    private TextButton exitButton;
    private TextLabel serverSelectorLabel;
    private ComboBox serverSelector;
    private LoadingAnimation loadingAnimation;
    private SessionManager sessionManager;
    private MainFrame frame;
    private Timer timeoutTimer;
    private int timeout = 300000;

    public LoginModule(SessionManager sessionManager, final MainFrame frame, Boolean noAutologin) {
        boolean error = false;
        this.sessionManager = sessionManager;
        this.frame = frame;
        this.addMouseMotionListener(frame);
        this.addMouseListener(frame);
        ThreadSafeLoader.setAnimationMinTime(5000L);
        this.userField = new TextField();
        this.userField.setProgress(1.0f);
        this.pwdField = new PasswordTextField();
        this.pwdField.setProgress(1.0f);
        this.userLabel = new TextLabel();
        this.pwdLabel = new TextLabel();
        this.errorLabel = new TextLabel();
        this.errorLabel.setText(Words.USERNAME_OR_PASSWORD_IS_WRONG);
        this.capslockPanel = new CapsLockActivePanel();
        this.capslockPanel.setProgress(0.0f);
        boolean hasCombo = AttributesConverter.getBoolean4String(ApplicationSettingsLoader.getLoader().getAttribute("server_selector_on"));
        hasCombo = true;
        if (hasCombo) {
            this.serverSelectorLabel = new TextLabel();
            this.serverSelector = new ComboBox();
            List ejbConfigContext = null;
            try {
                ejbConfigContext = EjbContextFactory.getInstance().getOrbConfigsAndReload();
            }
            catch (Throwable e) {
                this.errorLabel.setText(Words.ORB_CONFIG_NOT_FOUND);
                log.error("Unable to load Orbconfigs " + e.getMessage());
                error = true;
            }
            if (ejbConfigContext != null) {
                int i = 0;
                for (EjbContextFactory.EjbContextConfig oc : ejbConfigContext) {
                    StringBuilder str = new StringBuilder();
                    str.append(++i).append(" - ").append(oc.getName());
                    this.serverSelector.addItem(str.toString());
                }
                this.serverSelectorLabel.setProgress(1.0f);
                this.serverSelector.setProgress(1.0f);
                this.serverSelector.selectItem(this.serverSelector.getItemAt(0));
            }
        }
        this.okButton = new TextButton();
        this.exitButton = new TextButton(TextButton.BUTTON_TYPES.QUIT);
        this.userLabel.setText(Words.USERNAME);
        this.pwdLabel.setText(Words.PASSWORD);
        this.okButton.setText(Words.LOGIN);
        if (this.serverSelectorLabel != null) {
            this.serverSelectorLabel.setText(Words.SERVER);
        }
        this.okButton.addButtonListener(this);
        this.exitButton.addButtonListener(this);
        this.userField.addActionListener(this);
        this.pwdField.addActionListener(this);
        this.setOpaque(false);
        this.setLayout(new LoginLayout());
        this.lafAttributeChanged("All attribues changed");
        this.errorLabel.setVisible(false);
        ArrayList<Component> a = new ArrayList<Component>();
        a.addAll(this.userField.getFocusComponents());
        a.addAll(this.pwdField.getFocusComponents());
        a.add(this.okButton);
        a.add(this.exitButton);
        this.add(this.userField);
        this.add(this.pwdField);
        this.add(this.capslockPanel);
        this.add(this.userLabel);
        this.add(this.pwdLabel);
        this.add(this.errorLabel);
        this.add(this.okButton);
        this.add(this.exitButton);
        if (hasCombo) {
            this.add(this.serverSelector);
            this.add(this.serverSelectorLabel);
        }
        if (!noAutologin.booleanValue()) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    LoginModule.this.startTimeOut();
                    LoginModule.this.setEnabled(false);
                    LoginModule.this.showAnimation();
                    Node node = new Node();
                    UserComplete dto = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).authenticateUserByAutoLogin();
                    if (dto == null) {
                        node.setValue((Object)false, 0L);
                        return node;
                    }
                    node.setValue((Object)true, 0L);
                    LoginModule.this.loadMasterDataAndInitSystem(frame, dto);
                    return node;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            if (node.getValue(Boolean.class) == Boolean.TRUE) {
                                LoginModule.this.login_step_four();
                                LoginModule.this.stopTimeOut();
                            } else {
                                LoginModule.this.setEnabled(true);
                                LoginModule.this.hideAnimation();
                                LoginModule.this.stopTimeOut();
                            }
                        }

                        public void errorOccurred(ClientException exception) {
                            LoginModule.this.setEnabled(true);
                            LoginModule.this.hideAnimation();
                            LoginModule.this.stopTimeOut();
                        }
                    };
                }

                @Override
                public long getID() {
                    return System.currentTimeMillis();
                }
            };
            if (!error) {
                ThreadSafeLoader.run(run);
            }
        }
        if (error) {
            this.errorLabel.setVisible(true);
            this.serverSelector.setEnabled(false);
            this.okButton.setEnabled(false);
            this.userField.setEnabled(false);
            this.pwdField.setEnabled(false);
        }
    }

    private void loadMasterDataAndInitSystem(MainFrame frame, UserComplete currentUser) throws ClientGetFromServerException, ClientServerCallException {
        ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).setCurrentUser(currentUser);
        ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getAllLocations();
        UnitToolkit.loadUnits();
        SystemSettingsComplete settings = (SystemSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached().getValue();
        SystemViewSettingsComplete viewSettings = (SystemViewSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getViewSettingsUnCached().getValue();
        ((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).getRetailInMotionSettingsCached();
        ((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).getRetailInMotionStockImageSettingsCached();
        ((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).getRetailInMotionTransactionExchangeSettingsCached();
        ((ESpecsServiceManager)ServiceManagerRegistry.getService(ESpecsServiceManager.class)).getEspescSettingsCached();
        ((EdelweissServiceManager)ServiceManagerRegistry.getService(EdelweissServiceManager.class)).getSettingsCached();
        ((PickNPayServiceManager)ServiceManagerRegistry.getService(PickNPayServiceManager.class)).getSettingsCached();
        ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getRestaurantSettingsCached();
        ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getWeeklyPlanSettingsCached();
        ((MigrosExchangeServiceManager)ServiceManagerRegistry.getService(MigrosExchangeServiceManager.class)).getSettingsCached();
        ((NoProExchangeServiceManager)ServiceManagerRegistry.getService(NoProExchangeServiceManager.class)).getSettingsCached();
        ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getPurchaseReleaseSettingsCached();
        ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperProductCategoriesCached();
        ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperRecipeCategoriesCached();
        ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperArticleCategoriesCached();
        frame.getSessionManager().setSessionValid();
        Main.initTimeZoneAndLocale(settings);
        if (CompanyUtil.isFPB((SystemSettingsComplete)settings)) {
            RDProvider provider;
            ModuleAccessRightComplete flightModule = null;
            for (ModuleAccessRightComplete module : currentUser.getModules()) {
                if (!module.getModule().getInvokingName().equals(FlightAccess.MODULE_FLIGHT.getIdentifier())) continue;
                flightModule = module;
            }
            if (flightModule != null && (provider = new RDProvider(flightModule)).isWritable(FlightAccess.CHECK_FOR_NEW_FLIGHTS_IN_BACKGROUND)) {
                NewFlightCreatedUpdater flightChecker = new NewFlightCreatedUpdater(frame);
                frame.setFlightChecker(flightChecker);
            }
        }
    }

    public void login_step_one() {
        if (this.pwdField.getText().isEmpty()) {
            return;
        }
        this.setEnabled(false);
        this.showAnimation();
        if (this.serverSelector != null) {
            String s = (String)this.serverSelector.getSelectedItem();
            int i = Integer.valueOf(s.substring(0, 1));
            EjbContextFactory.getInstance().setSelectedServer(i - 1);
        }
        String msg = null;
        try {
            msg = EjbContextFactory.getInstance().getSelectedServerMSG();
        }
        catch (IOException e) {
            InnerPopupFactory.showErrorDialog(Words.UNABLE_TO_DOWNLOAD_SERVER_INFORMATION, (Component)this);
            this.setEnabled(true);
            this.stopTimeOut();
            this.hideAnimation();
        }
        if (msg != null && !msg.isEmpty()) {
            InnerPopupFactory.showWarningDialog(msg, this, (Component)this.okButton);
        } else {
            this.login_step_two();
        }
    }

    private void login_step_two() {
        if (this.userField == null || this.pwdField == null) {
            return;
        }
        this.login_step_three(this.userField.getText(), this.pwdField.getText());
    }

    private void login_step_three(final String aUser, final String aPwd) {
        this.startTimeOut();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                String u = aUser;
                String p = aPwd;
                if (u == null) {
                    u = "";
                }
                if (p == null) {
                    p = "";
                }
                Node node = new Node();
                InfoBox dto = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).authenticateUser(u, p);
                if (dto != null) {
                    if (dto.getUser() == null) {
                        LoginModule.this.errorLabel.setText(dto.getErrorText());
                        node.setValue((Object)false, 0L);
                        return node;
                    }
                } else {
                    node.setValue((Object)false, 0L);
                    return node;
                }
                node.setValue((Object)true, 0L);
                LoginModule.this.loadMasterDataAndInitSystem(LoginModule.this.frame, dto.getUser());
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        if (node.getValue(Boolean.class) == Boolean.TRUE) {
                            LoginModule.this.login_step_four();
                            LoginModule.this.stopTimeOut();
                        } else {
                            LoginModule.this.setEnabled(true);
                            LoginModule.this.hideAnimation();
                            if (LoginModule.this.errorLabel != null) {
                                LoginModule.this.errorLabel.setVisible(true);
                            }
                            LoginModule.this.stopTimeOut();
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        LoginModule.this.setEnabled(true);
                        LoginModule.this.hideAnimation();
                        if (LoginModule.this.errorLabel != null) {
                            LoginModule.this.errorLabel.setVisible(true);
                        }
                        LoginModule.this.stopTimeOut();
                    }
                };
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void login_step_four() {
        this.setEnabled(true);
        this.hideAnimation();
        if (((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser().getPasswordExpiryDate() == null || ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser().getPasswordExpiryDate().getTime() < System.currentTimeMillis()) {
            InnerPopupFactory.showPasswordChangePopup(this.okButton, new InnerPopUpListener2(){

                @Override
                public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                    if (xargs == null) {
                        if (LoginModule.this.serverSelector != null) {
                            LoginModule.this.serverSelector.kill();
                            LoginModule.this.serverSelector = null;
                            LoginModule.this.serverSelectorLabel.kill();
                            LoginModule.this.serverSelectorLabel = null;
                        }
                    } else {
                        LoginModule.this.frame.sessionChanged(LoginModule.this.sessionManager);
                        LoginModule.this.frame.getTitleBar().sessionChanged(LoginModule.this.sessionManager);
                    }
                }
            }, ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), true);
        } else {
            this.frame.sessionChanged(this.sessionManager);
            this.frame.getTitleBar().sessionChanged(this.sessionManager);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.okButton) {
            this.login_step_one();
        } else {
            System.exit(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.pwdField.getText().isEmpty()) {
            return;
        }
        this.login_step_one();
    }

    private void serverDown() {
        this.frame.showScreen((Screen)ScreenViewProvider.forName(new HistoryObject(ServerDownScreen.class.getName(), "Server is down", null), this.frame), null);
    }

    private void showAnimation() {
        if (this.loadingAnimation == null) {
            this.loadingAnimation = new LoadingAnimation();
            this.loadingAnimation.stateChanged(Words.SEND_LOGIN_CREDENTIALS);
            this.add((Component)this.loadingAnimation, 0);
            this.loadingAnimation.start();
            this.loadingAnimation.fadeIn();
            this.revalidate();
        }
    }

    private void hideAnimation() {
        if (this.loadingAnimation != null) {
            this.loadingAnimation.fadeOut(true);
            this.loadingAnimation.stop();
            this.loadingAnimation = null;
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.removeMouseMotionListener(this.frame);
        this.removeMouseListener(this.frame);
        this.userField.kill();
        this.userField = null;
        this.pwdField.kill();
        this.pwdField = null;
        this.userLabel.kill();
        this.userLabel = null;
        this.pwdLabel.kill();
        this.pwdLabel = null;
        this.errorLabel.kill();
        this.errorLabel = null;
        this.okButton.kill();
        this.okButton = null;
        this.exitButton.kill();
        this.exitButton = null;
        if (this.serverSelector != null) {
            this.serverSelector.kill();
            this.serverSelector = null;
        }
        if (this.serverSelectorLabel != null) {
            this.serverSelectorLabel.kill();
            this.serverSelectorLabel = null;
        }
        if (this.loadingAnimation != null) {
            this.loadingAnimation.stop();
            this.loadingAnimation.kill();
            this.loadingAnimation = null;
        }
        if (this.capslockPanel != null) {
            this.capslockPanel.kill();
            this.capslockPanel = null;
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintChildren(g2);
    }

    @Override
    public void lafAttributeChanged(String att) {
        if ("All attribues changed".equals(att)) {
            this.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("login_font_size"), LafLoader.getLafLoader().getAttribute("login_font_type")));
            this.userLabel.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("login_font_size"), LafLoader.getLafLoader().getAttribute("login_font_type")));
            this.pwdLabel.setFont(this.userLabel.getFont());
            if (this.serverSelectorLabel != null) {
                this.serverSelectorLabel.setFont(this.userLabel.getFont());
                this.serverSelectorLabel.setForeground(this.pwdLabel.getComponentForeground());
            }
            this.errorLabel.setFont(this.pwdLabel.getFont());
            this.errorLabel.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_error_string_color")));
            this.validate();
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.pwdLabel == null) {
            return;
        }
        this.pwdLabel.setEnabled(isEnabled);
        this.userLabel.setEnabled(isEnabled);
        this.userField.setEnabled(isEnabled);
        this.pwdField.setEnabled(isEnabled);
        this.okButton.setEnabled(isEnabled);
        this.exitButton.setEnabled(isEnabled);
        this.capslockPanel.setEnabled(isEnabled);
        if (this.serverSelectorLabel != null) {
            this.serverSelectorLabel.setEnabled(isEnabled);
            this.serverSelector.setEnabled(isEnabled);
        }
    }

    public void remoteObjectLoaded(Node<?> node) {
        if (!this.isKilled()) {
            if (this.serverSelector != null) {
                this.serverSelector.kill();
                this.serverSelector = null;
                this.serverSelectorLabel.kill();
                this.serverSelectorLabel = null;
            }
            this.errorLabel.setVisible(true);
            ThreadSafeLoader.setAnimationMinTime(0L);
        }
    }

    public void errorOccurred(ClientException exception) {
        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)this);
        this.setEnabled(true);
        this.stopTimeOut();
        this.hideAnimation();
    }

    @Override
    public void stopAnimationsImmediately() {
    }

    public void redo() {
    }

    public void undo() {
    }

    @Override
    public void escapeKeyPressed() {
    }

    @Override
    public void saveKeyPressed() {
    }

    @Override
    public void screenSet() {
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (xargs == null) {
            this.setEnabled(true);
            this.stopTimeOut();
            this.hideAnimation();
            return;
        }
        this.login_step_two();
    }

    private void stopTimeOut() {
        if (this.timeoutTimer != null) {
            this.timeoutTimer.stop();
            this.timeoutTimer = null;
        }
    }

    private void startTimeOut() {
        if (this.timeoutTimer == null) {
            this.timeoutTimer = new Timer(this.timeout, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoginModule.this.serverDown();
                }
            });
            this.timeoutTimer.setRepeats(false);
            this.timeoutTimer.start();
        }
    }

    private class LoginLayout
    extends DefaultLayout {
        private LoginLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int maxWidth;
            if (LoginModule.this.loadingAnimation != null) {
                LoginModule.this.loadingAnimation.setLocation((int)(((double)parent.getWidth() - LoginModule.this.loadingAnimation.getPreferredSize().getWidth()) / 2.0), (int)(((double)parent.getHeight() - LoginModule.this.loadingAnimation.getPreferredSize().getHeight()) / 2.0));
                LoginModule.this.loadingAnimation.setSize(LoginModule.this.loadingAnimation.getPreferredSize());
            }
            if ((double)(maxWidth = (int)LoginModule.this.userLabel.getPreferredSize().getWidth()) < LoginModule.this.pwdLabel.getPreferredSize().getWidth()) {
                maxWidth = (int)LoginModule.this.pwdLabel.getPreferredSize().getWidth();
            }
            if (LoginModule.this.serverSelectorLabel != null && (double)maxWidth < LoginModule.this.serverSelectorLabel.getPreferredSize().getWidth()) {
                maxWidth = (int)LoginModule.this.serverSelectorLabel.getPreferredSize().getWidth();
            }
            LoginModule.this.userLabel.setLocation(302, 140);
            LoginModule.this.userLabel.setSize(maxWidth, (int)LoginModule.this.userLabel.getPreferredSize().getHeight());
            LoginModule.this.pwdLabel.setLocation(LoginModule.this.userLabel.getX(), LoginModule.this.userLabel.getY() + LoginModule.this.userLabel.getHeight() + 8);
            LoginModule.this.pwdLabel.setSize(maxWidth, (int)LoginModule.this.pwdLabel.getPreferredSize().getHeight());
            int currentY = LoginModule.this.pwdLabel.getY() + LoginModule.this.pwdLabel.getHeight() + 8;
            if (LoginModule.this.serverSelectorLabel != null) {
                LoginModule.this.serverSelectorLabel.setLocation(LoginModule.this.userLabel.getX(), currentY);
                LoginModule.this.serverSelectorLabel.setSize(maxWidth, (int)LoginModule.this.serverSelectorLabel.getPreferredSize().getHeight());
                currentY = LoginModule.this.serverSelectorLabel.getY() + LoginModule.this.serverSelectorLabel.getHeight() + 8;
            }
            int cTextFieldWidth = 264 - maxWidth;
            currentY = LoginModule.this.pwdLabel.getY() + LoginModule.this.pwdLabel.getHeight() + 8;
            LoginModule.this.userField.setLocation(LoginModule.this.userLabel.getX() + (maxWidth += 10), LoginModule.this.userLabel.getY() + 5);
            LoginModule.this.userField.setSize(cTextFieldWidth, (int)LoginModule.this.userField.getPreferredSize().getHeight());
            LoginModule.this.userField.getTextField().requestFocus();
            LoginModule.this.pwdField.setLocation(LoginModule.this.pwdLabel.getX() + maxWidth, LoginModule.this.pwdLabel.getY() + 5);
            LoginModule.this.pwdField.setSize(cTextFieldWidth, (int)LoginModule.this.pwdField.getPreferredSize().getHeight());
            if (LoginModule.this.capslockPanel != null) {
                LoginModule.this.capslockPanel.setLocation(LoginModule.this.pwdField.getX() + LoginModule.this.pwdField.getWidth() + 5, (int)((double)LoginModule.this.pwdField.getY() + ((double)LoginModule.this.pwdField.getHeight() - LoginModule.this.capslockPanel.getPreferredSize().getHeight()) / 2.0));
                LoginModule.this.capslockPanel.setSize(LoginModule.this.capslockPanel.getPreferredSize());
            }
            if (LoginModule.this.serverSelector != null) {
                LoginModule.this.serverSelector.setLocation(LoginModule.this.serverSelectorLabel.getX() + maxWidth, LoginModule.this.serverSelectorLabel.getY() + 5);
                LoginModule.this.serverSelector.setSize(cTextFieldWidth, (int)LoginModule.this.serverSelector.getPreferredSize().getHeight());
                currentY = LoginModule.this.serverSelectorLabel.getY() + LoginModule.this.serverSelectorLabel.getHeight() + 8;
            }
            if (LoginModule.this.errorLabel.isVisible()) {
                LoginModule.this.errorLabel.setLocation(LoginModule.this.pwdField.getX(), currentY - 5);
                LoginModule.this.errorLabel.setSize(LoginModule.this.errorLabel.getPreferredSize());
                currentY += LoginModule.this.errorLabel.getHeight();
            }
            LoginModule.this.okButton.setLocation(LoginModule.this.pwdField.getX(), currentY);
            LoginModule.this.okButton.setSize(LoginModule.this.okButton.getPreferredSize());
            LoginModule.this.exitButton.setLocation(LoginModule.this.okButton.getX() + 10 + LoginModule.this.okButton.getWidth(), LoginModule.this.okButton.getY());
            LoginModule.this.exitButton.setSize(LoginModule.this.exitButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

