/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.TaxRateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.CountryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.util.TaxRateValueComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.util.TaxRateValueComplete_;
import ch.icit.pegasus.server.core.dtos.product.TaxRateComplete;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class AirportConfig
extends MasterDataInsert<AirportComplete>
implements RemoteLoader {
    private static final long serialVersionUID = 1L;

    public AirportConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new AirportConfigPanel();
    }

    @Override
    public AirportComplete getNewObject() {
        AirportComplete a = new AirportComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<? extends AirportComplete> getMasterDataClass() {
        return AirportComplete.class;
    }

    @Override
    public String getInsertName() {
        return Words.AIRPORTS;
    }

    private String getTaxRates(Node<List<TaxRateValueComplete>> taxes) {
        String t = "";
        Iterator it = taxes.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            Node rate = n.getChildNamed(TaxRateValueComplete_.rate);
            Node value = n.getChildNamed(TaxRateValueComplete_.value);
            t = t + ((TaxRateComplete)rate.getValue()).getCode() + "=" + value.getValue() + ", ";
        }
        if (!t.isEmpty()) {
            t = t.substring(0, t.length() - 2);
        }
        return t;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(AirportComplete_.code).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(AirportComplete_.code).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.CODE_IS_NOT_UNIQUE, (Object[])new Object[]{n.getChildNamed(AirportComplete_.code).getValue()})));
                continue;
            }
            codes.add((String)n.getChildNamed(AirportComplete_.code).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_CODE_IS_SET));
        }
        return a;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private ComboBox taxRate;
        private NumberTextField fee;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.taxRate = new ComboBox(m.getNode().getChildNamed(TaxRateValueComplete_.rate), NodeToolkit.getAffixList(TaxRateComplete.class), ConverterRegistry.getConverter(TaxRateConverter.class));
            this.fee = new NumberTextField(m.getNode().getChildNamed(TaxRateValueComplete_.value), TextFieldType.DOUBLE);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new InnerLayout());
            this.add(this.taxRate);
            this.add(this.fee);
            this.add(this.delete);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.taxRate.kill();
            this.fee.kill();
            this.delete.kill();
            this.taxRate = null;
            this.delete = null;
            this.fee = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.taxRate);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.taxRate.setEnabled(isEnabled);
            this.fee.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.taxRate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.taxRate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.taxRate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.taxRate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.fee.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.fee.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.fee.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.fee.getPreferredSize().getHeight());
                TableRowImpl.this.setControlsX(currentX += w);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }

    private class AirportConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> code;
        private TitledItem<TextField> description;
        private TitledItem<CheckBox> domestic;
        private TitledItem<SearchTextField2<CountryComplete>> country;
        private Table2 taxratesTable;
        private TitledItem<TextField> timeZone;

        public AirportConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            try {
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(TaxRateComplete.class);
            }
            catch (ClientServerCallException e) {
                e.printStackTrace();
            }
            this.code = new TitledItem<TextField>(new TextField(null), Words.CODE, TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(null), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
            this.domestic = new TitledItem<CheckBox>(new CheckBox(), Words.DOMESTIC, TitledItem.TitledItemOrientation.EAST);
            this.country = new TitledItem<SearchTextField2<CountryComplete>>(SearchTextField2Factory.getCountrySearchField(false, null), WordsToolkit.toCapitalLetter((String)Words.COUNTRY), TitledItem.TitledItemOrientation.NORTH);
            this.timeZone = new TitledItem<TextField>(new TextField(), Words.TIME_ZONE, TitledItem.TitledItemOrientation.NORTH);
            this.taxratesTable = new Table2(true, Words.ADD, true, true, Words.TAXE_RATE);
            this.taxratesTable.setButtonHandler(new Table2ButtonHandler(){

                @Override
                public void childRemoved() {
                }

                @Override
                public void addButtonPressed(int x, int y, Button source) {
                    TaxRateValueComplete n = new TaxRateValueComplete(null, Double.valueOf(0.0));
                    n.setClientOId(Long.valueOf(ADTO.getNextId()));
                    AirportConfigPanel.this.taxratesTable.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)n, false, false), System.currentTimeMillis());
                }
            });
            ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
            columns.add(new TableColumnInfo(Words.TAX_RATE, null, null, null, "", 40, 40, 40));
            columns.add(new TableColumnInfo(Words.AIRPORT_FEE_PERCENT, null, null, null, "", 40, 40, 40));
            int tw = 2 * this.taxratesTable.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
            columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
            ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
            this.taxratesTable.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
            this.setLayout(new AALayout());
            this.add(this.taxratesTable);
            this.add(this.code);
            this.add(this.domestic);
            this.add(this.description);
            this.add(this.country);
            this.add(this.timeZone);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.code.getFocusComponents();
            a.addAll(this.description.getFocusComponents());
            CheckedListAdder.addToList(a, this.country);
            CheckedListAdder.addToList(a, this.domestic);
            CheckedListAdder.addToList(a, this.timeZone);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.code.setVisibleContainer(pane);
            this.description.setVisibleContainer(pane);
            this.country.setVisibleContainer(pane);
            this.domestic.setVisibleContainer(pane);
            this.timeZone.setVisibleContainer(pane);
            this.taxratesTable.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.description.kill();
            this.domestic.kill();
            this.country.kill();
            this.taxratesTable.kill();
            this.timeZone.kill();
            this.code = null;
            this.domestic = null;
            this.description = null;
            this.country = null;
            this.taxratesTable = null;
            this.timeZone = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.code.setEnabled(b);
            this.description.setEnabled(b);
            this.country.setEnabled(b);
            this.domestic.setEnabled(b);
            this.taxratesTable.setEnabled(b);
            this.timeZone.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.code.getElement().setNode(node.getChildNamed(AirportComplete_.code));
            this.description.getElement().setNode(node.getChildNamed(AirportComplete_.name));
            this.country.getElement().setNode(node.getChildNamed(AirportComplete_.country));
            this.domestic.getElement().setNode(node.getChildNamed(AirportComplete_.domestic));
            this.taxratesTable.getModel().setNode(node.getChildNamed(AirportComplete_.taxes));
            this.timeZone.getElement().setNode(node.getChildNamed(AirportComplete_.timeZone));
            this.setEnabled(true);
            AirportConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return AirportComplete_.code;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                AirportConfigPanel.this.code.setLocation(AirportConfig.this.masterDataTable.getCellPadding(), AirportConfig.this.masterDataTable.getCellPadding());
                AirportConfigPanel.this.code.setSize(200, (int)AirportConfigPanel.this.code.getPreferredSize().getHeight());
                AirportConfigPanel.this.description.setLocation(AirportConfig.this.masterDataTable.getCellPadding(), AirportConfigPanel.this.code.getY() + AirportConfigPanel.this.code.getHeight() + AirportConfig.this.masterDataTable.getCellPadding());
                AirportConfigPanel.this.description.setSize(200, (int)AirportConfigPanel.this.description.getPreferredSize().getHeight());
                AirportConfigPanel.this.country.setLocation(AirportConfig.this.masterDataTable.getCellPadding(), AirportConfigPanel.this.description.getY() + AirportConfigPanel.this.description.getHeight() + AirportConfig.this.masterDataTable.getCellPadding());
                AirportConfigPanel.this.country.setSize(200, (int)AirportConfigPanel.this.country.getPreferredSize().getHeight());
                AirportConfigPanel.this.domestic.setLocation(AirportConfig.this.masterDataTable.getCellPadding(), AirportConfigPanel.this.country.getY() + AirportConfigPanel.this.country.getHeight() + AirportConfig.this.masterDataTable.getCellPadding());
                AirportConfigPanel.this.domestic.setSize(AirportConfigPanel.this.domestic.getPreferredSize());
                AirportConfigPanel.this.timeZone.setLocation(AirportConfig.this.masterDataTable.getCellPadding(), AirportConfigPanel.this.domestic.getY() + AirportConfigPanel.this.domestic.getHeight() + AirportConfig.this.masterDataTable.getCellPadding());
                AirportConfigPanel.this.timeZone.setSize(AirportConfigPanel.this.timeZone.getPreferredSize());
                AirportConfigPanel.this.taxratesTable.setLocation(AirportConfig.this.masterDataTable.getCellPadding(), AirportConfigPanel.this.timeZone.getY() + AirportConfigPanel.this.timeZone.getHeight() + AirportConfig.this.masterDataTable.getCellPadding());
                AirportConfigPanel.this.taxratesTable.setSize(400, 300);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

