/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.ArticleCategoryConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.CategoryConfig;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.AMasterDataComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AllergenCharacteristicComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ArticleCategoryConfig
extends CategoryConfig<ArticleCategoryComplete> {
    private static final long serialVersionUID = 1L;

    public ArticleCategoryConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public String getInsertName() {
        return Words.ARTICLE_CATEGORIES;
    }

    @Override
    public int getMaxDepth() {
        return ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getArticleCategoryDepth();
    }

    private void ensureParentReference(ArticleCategoryComplete parent) {
        for (ArticleCategoryLight child : parent.getSubCategories()) {
            child.setParent(parent);
            if (!(child instanceof ArticleCategoryComplete)) continue;
            this.ensureParentReference((ArticleCategoryComplete)child);
        }
    }

    private Set<ArticleCategoryComplete> getCategoriesToDeleteRecursive(ArticleCategoryComplete categoryComplete) {
        HashSet<ArticleCategoryComplete> cats = new HashSet<ArticleCategoryComplete>();
        if (Boolean.TRUE.equals(categoryComplete.getIsDeleted()) && categoryComplete.getParent() != null && categoryComplete.getDeleteUser() == null && categoryComplete.getId() != null) {
            cats.add(categoryComplete);
        }
        for (ArticleCategoryComplete articleCategoryComplete : categoryComplete.getSubCategories()) {
            cats.addAll(this.getCategoriesToDeleteRecursive(articleCategoryComplete));
        }
        return cats;
    }

    private Set<ArticleCategoryComplete> getCategoriesToRestoreRecursive(ArticleCategoryComplete categoryComplete) {
        HashSet<ArticleCategoryComplete> cats = new HashSet<ArticleCategoryComplete>();
        if (Boolean.FALSE.equals(categoryComplete.getIsDeleted()) && categoryComplete.getParent() != null && categoryComplete.getDeleteUser() != null && categoryComplete.getId() != null) {
            cats.add(categoryComplete);
        }
        for (ArticleCategoryComplete articleCategoryComplete : categoryComplete.getSubCategories()) {
            cats.addAll(this.getCategoriesToRestoreRecursive(articleCategoryComplete));
        }
        return cats;
    }

    @Override
    public Node saveDataImpl(Node<?> node) throws ClientServerCallException {
        Iterator it = node.getChilds();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            n.commitThis(ArticleCategoryComplete.class);
            ArticleCategoryComplete cat = (ArticleCategoryComplete)n.getValue(ArticleCategoryComplete.class);
            this.ensureParentReference(cat);
            if (!cat.getUseShelfLife().booleanValue()) {
                cat.setShelfLife(null);
            }
            this.deleteShelfLife(cat);
            Set<ArticleCategoryComplete> innerDelete = this.getCategoriesToDeleteRecursive(cat);
            Set<ArticleCategoryComplete> innerRestore = this.getCategoriesToRestoreRecursive(cat);
            for (ArticleCategoryComplete articleCategoryComplete : innerDelete) {
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).delete((AMasterDataComplete)articleCategoryComplete);
            }
            for (ArticleCategoryComplete articleCategoryComplete : innerRestore) {
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).restore((AMasterDataComplete)articleCategoryComplete);
            }
            cat = cat.getId() == null ? (ArticleCategoryComplete)((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).create((AMasterDataComplete)cat).getValue() : (cat.getIsDeleted() != false && cat.getDeleteUser() == null ? (ArticleCategoryComplete)((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).delete((AMasterDataComplete)cat).getValue() : (cat.getIsDeleted() == false && cat.getDeleteUser() != null ? (ArticleCategoryComplete)((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).restore((AMasterDataComplete)cat).getValue() : (ArticleCategoryComplete)((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).update((AMasterDataComplete)cat).getValue()));
            n.removeExistingValues();
            n.setValue((Object)cat, 0L);
            n.updateNode();
        }
        return node;
    }

    public void deleteShelfLife(ArticleCategoryComplete cat) {
        if (cat.getSubCategories() != null) {
            for (ArticleCategoryComplete acc : cat.getSubCategories()) {
                this.deleteShelfLife(acc);
                if (Boolean.TRUE.equals(acc.getUseShelfLife())) continue;
                acc.setShelfLife(null);
            }
        }
    }

    @Override
    public Converter getTopTitleConverter() {
        return ConverterRegistry.getConverter(ArticleCategoryConverter.class);
    }

    @Override
    public Node loadDataImpl(Node<?> node) throws ClientServerCallException {
        ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
        ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(AllergenCharacteristicComplete.class, false);
        Node n = INodeCreator.getDefaultImpl().createNodes(((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperArticleCategoriesWithDeleted().getList(), false);
        return n;
    }

    @Override
    protected boolean validateCategory(Node cat, int depth) {
        double d;
        Object value;
        boolean ret = super.validateCategory(cat, depth);
        if (!ret) {
            return ret;
        }
        if (Boolean.TRUE.equals(cat.getChildNamed(ArticleCategoryComplete_.useWaste).getValue())) {
            value = cat.getChildNamed(ArticleCategoryComplete_.defaultCookingWaste).getValue();
            d = 0.0;
            if (value instanceof Double) {
                d = (Double)value;
            } else if (value instanceof Integer) {
                d = ((Integer)value).doubleValue();
            } else if (value instanceof Long) {
                d = ((Long)value).doubleValue();
            }
            if (d >= 100.0) {
                return false;
            }
        }
        if (Boolean.TRUE.equals(cat.getChildNamed(ArticleCategoryComplete_.usePurchaseWaste).getValue())) {
            value = cat.getChildNamed(ArticleCategoryComplete_.defaultPurchaseWaste).getValue();
            d = 0.0;
            if (value instanceof Double) {
                d = (Double)value;
            } else if (value instanceof Integer) {
                d = ((Integer)value).doubleValue();
            } else if (value instanceof Long) {
                d = ((Long)value).doubleValue();
            }
            if (d >= 100.0) {
                return false;
            }
        }
        if (Boolean.TRUE.equals(cat.getChildNamed(ArticleCategoryComplete_.useTenderWaste).getValue())) {
            value = cat.getChildNamed(ArticleCategoryComplete_.defaultTenderCookingWaste).getValue();
            d = 0.0;
            if (value instanceof Double) {
                d = (Double)value;
            } else if (value instanceof Integer) {
                d = ((Integer)value).doubleValue();
            } else if (value instanceof Long) {
                d = ((Long)value).doubleValue();
            }
            if (d >= 100.0) {
                return false;
            }
        }
        if (Boolean.TRUE.equals(cat.getChildNamed(ArticleCategoryComplete_.useTenderPurchaseWaste).getValue())) {
            value = cat.getChildNamed(ArticleCategoryComplete_.defaultTenderPurchaseWaste).getValue();
            d = 0.0;
            if (value instanceof Double) {
                d = (Double)value;
            } else if (value instanceof Integer) {
                d = ((Integer)value).doubleValue();
            } else if (value instanceof Long) {
                d = ((Long)value).doubleValue();
            }
            if (d >= 100.0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public ArticleCategoryComplete createNewCategory() {
        ArticleCategoryComplete c = new ArticleCategoryComplete();
        c.setClientOId(Long.valueOf(ADTO.getNextId()));
        c.setDisplay(Boolean.valueOf(true));
        return c;
    }
}

