/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleMemberShipTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleMemberShipTypeComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete_;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ArticleMemberShipTypeConfig
extends MasterDataInsert<ArticleMemberShipTypeComplete> {
    private static final long serialVersionUID = 1L;

    public ArticleMemberShipTypeConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new ALaCarteConfigPanel();
    }

    @Override
    public ArticleMemberShipTypeComplete getNewObject() {
        ArticleMemberShipTypeComplete a = new ArticleMemberShipTypeComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                return ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllUnCached(ArticleMemberShipTypeConfig.this.getMasterDataClass(), true);
            }

            @Override
            public RemoteLoader getInvoker() {
                return ArticleMemberShipTypeConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Class<ArticleMemberShipTypeComplete> getMasterDataClass() {
        return ArticleMemberShipTypeComplete.class;
    }

    @Override
    public String getInsertName() {
        return Words.ARTICLE_MEMBER_SHIP;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        boolean descriptionSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(ArticleMemberShipTypeComplete_.description).getValue() == null) {
                descriptionSet = false;
            }
            if (n.getChildNamed(ArticleMemberShipTypeComplete_.code).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(ArticleMemberShipTypeComplete_.code).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.CODE_IS_NOT_UNIQUE, (Object[])new Object[]{n.getChildNamed(SpecialMenuTypeComplete_.code).getValue()})));
                continue;
            }
            codes.add((String)n.getChildNamed(ArticleMemberShipTypeComplete_.code).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_CODE_IS_SET));
        }
        if (!descriptionSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_DESCRIPTION_IS_SET));
        }
        return a;
    }

    private class ALaCarteConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> code;
        private TitledItem<TextField> description;

        public ALaCarteConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.code = new TitledItem<TextField>(new TextField(null), Words.CODE, TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(null), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.code);
            this.add(this.description);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.code.getFocusComponents();
            a.addAll(this.description.getFocusComponents());
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.code.setVisibleContainer(pane);
            this.description.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.description.kill();
            this.code = null;
            this.description = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.code.setEnabled(b);
            this.description.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.code.getElement().setNode(node.getChildNamed(ArticleMemberShipTypeComplete_.code));
            this.description.getElement().setNode(node.getChildNamed(ArticleMemberShipTypeComplete_.description));
            this.setEnabled(true);
            ArticleMemberShipTypeConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return ArticleMemberShipTypeComplete_.code;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                ALaCarteConfigPanel.this.code.setLocation(ArticleMemberShipTypeConfig.this.masterDataTable.getCellPadding(), ArticleMemberShipTypeConfig.this.masterDataTable.getCellPadding());
                ALaCarteConfigPanel.this.code.setSize(200, (int)ALaCarteConfigPanel.this.code.getPreferredSize().getHeight());
                ALaCarteConfigPanel.this.description.setLocation(ArticleMemberShipTypeConfig.this.masterDataTable.getCellPadding(), ALaCarteConfigPanel.this.code.getY() + ALaCarteConfigPanel.this.code.getHeight() + ArticleMemberShipTypeConfig.this.masterDataTable.getCellPadding());
                ALaCarteConfigPanel.this.description.setSize(200, (int)ALaCarteConfigPanel.this.description.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(parent.getSize());
            }
        }
    }
}

