/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.DateUnitEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbComponentTable;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbGroupTable;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbNavigator;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbPanel;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbTable;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.ArticleCategoryConfig;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.ProductCategoryConfig;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.RecipeCategoryConfig;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.submodules.tool.product.spec.utils.GroupLoader;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2HeaderPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.buttons.RestoreButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.popup.inserts.ArticleCategoryDetailsPopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.ProductCategoryCustomerRestrictionPopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.RecipeCookingWastePopupInsert;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.ADTO_;
import ch.icit.pegasus.server.core.dtos.masterdata.AMasterDataComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryLight;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryLight_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeCategoryLight;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeCategoryLight_;
import ch.icit.pegasus.server.core.dtos.supply.ProductCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.ProductCategoryLight;
import ch.icit.pegasus.server.core.dtos.supply.ProductCategoryLight_;
import ch.icit.pegasus.server.core.dtos.system.ADeletableDTO_;
import ch.icit.pegasus.server.core.dtos.util.DateDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.DateDurationComplete_;
import ch.icit.pegasus.server.core.dtos.util.DateUnitE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public abstract class CategoryConfig<T extends AMasterDataComplete>
extends DefaultDataInsert {
    private static final long serialVersionUID = 1L;
    private InnerBreadCrumbPanel panel;
    protected Node<?> node;

    public CategoryConfig(MasterDataModule p) {
        super(p);
        this.setLayout(new Layout());
    }

    @Override
    public void insertElements() {
        this.panel = new InnerBreadCrumbPanel(null, this.getMaxDepth(), null);
        this.add(this.panel);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.panel.kill();
        }
        this.panel = null;
    }

    public abstract int getMaxDepth();

    public abstract T createNewCategory();

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.panel.setEnabled(isEnabled);
        }
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        boolean isValid = true;
        if (this.node != null) {
            Iterator it = this.node.getChilds();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                if (this.validateCategory(n, this.getMaxDepth())) continue;
                isValid = false;
            }
        }
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        if (!isValid) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Categories and Sub Categories are set. Each Category needs " + this.getMaxDepth() + " Sub Categories"));
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Wastes are smaller than 100%."));
        }
        return a;
    }

    protected boolean validateCategory(Node cat, int depth) {
        if (depth == 1 && cat.getValue() != null) {
            return true;
        }
        boolean isValid = true;
        if (cat.getChildNamed(ADeletableDTO_.isDeleted).getValue() != null && !((Boolean)cat.getChildNamed(ADeletableDTO_.isDeleted).getValue()).booleanValue()) {
            Iterator it = cat.getChildNamed(ArticleCategoryComplete_.subCategories).getChilds();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                if (this.validateCategory(n, depth - 1)) continue;
                isValid = false;
            }
            if (cat.getChildNamed(ArticleCategoryComplete_.subCategories).getChildCount() == 0) {
                return false;
            }
        }
        return isValid;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        this.setNode(node);
    }

    public void setNode(Node<?> node) {
        this.node = node;
        if (this.isInserted) {
            this.panel.setNode(this.node);
        }
    }

    public abstract Node saveDataImpl(Node<?> var1) throws ClientServerCallException;

    public abstract Node loadDataImpl(Node<?> var1) throws ClientServerCallException;

    public abstract Converter getTopTitleConverter();

    @Override
    public void saveIt() {
        super.saveIt();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                return CategoryConfig.this.saveDataImpl(CategoryConfig.this.node);
            }

            @Override
            public RemoteLoader getInvoker() {
                return CategoryConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                return CategoryConfig.this.loadDataImpl(null);
            }

            @Override
            public RemoteLoader getInvoker() {
                return CategoryConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            CategoryConfig.this.layoutAnimation(parent);
            if (CategoryConfig.this.isInserted) {
                CategoryConfig.this.panel.setLocation(1, 1);
                CategoryConfig.this.panel.setSize(parent.getWidth() - 2, parent.getHeight() - 2);
            }
        }
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextField field;
        private TextField categoryCode;
        private CheckBox crewCommission;
        private CheckBox airlineCommission;
        private CheckBox display;
        private Button deleteButton;
        private EditButton customsEdit;
        private NumberTextField cookingWasteField;
        private CheckBox isCookingWasteActive;
        private NumberTextField purchaseWasteField;
        private CheckBox isPurchaseWasteActive;
        private NumberTextField cookingTenderWasteField;
        private CheckBox isCookingTenderWasteActive;
        private NumberTextField purchaseTenderWasteField;
        private CheckBox isPurchaseTenderWasteActive;
        private CheckBox aisRelevant;
        private EditButton editButton;
        boolean isDelete;
        private CheckBox shelfLifeMandatory;
        private CheckBox isShelfLifeActive;
        private ComboBox shelfLifeUnit;
        private NumberTextField shelfLifeAmount;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.isDelete = false;
            this.setSelectable(true);
            this.field = new TextField(m.getNode().getChildNamed(ArticleCategoryLight_.name));
            this.field.setProgress(1.0f);
            this.display = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ArticleCategoryLight_.display));
            this.display.setProgress(1.0f);
            this.categoryCode = new TextField(m.getNode().getChildNamed(ArticleCategoryLight_.code));
            if (m.getNode().getValue() instanceof AMasterDataComplete) {
                this.ensureButtonState();
            }
            this.field.setSelectionDelegate(this);
            this.setProgress(1.0f);
            this.setLayout(new Layout());
            if (m.getNode().getValue() instanceof ArticleCategoryLight) {
                this.isCookingWasteActive = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ArticleCategoryLight_.useWaste));
                this.isCookingWasteActive.addButtonListener(this);
                this.cookingWasteField = new NumberTextField(TextFieldType.DOUBLE);
                this.cookingWasteField.setNode(m.getNode().getChildNamed(ArticleCategoryLight_.defaultCookingWaste));
                this.add(this.isCookingWasteActive);
                this.add(this.cookingWasteField);
                this.isCookingTenderWasteActive = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ArticleCategoryLight_.useTenderWaste));
                this.isCookingTenderWasteActive.addButtonListener(this);
                this.cookingTenderWasteField = new NumberTextField(TextFieldType.DOUBLE);
                this.cookingTenderWasteField.setNode(m.getNode().getChildNamed(ArticleCategoryLight_.defaultTenderCookingWaste));
                this.add(this.isCookingTenderWasteActive);
                this.add(this.cookingTenderWasteField);
                this.isPurchaseWasteActive = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ArticleCategoryLight_.usePurchaseWaste));
                this.isPurchaseWasteActive.addButtonListener(this);
                this.purchaseWasteField = new NumberTextField(TextFieldType.DOUBLE);
                this.purchaseWasteField.setNode(m.getNode().getChildNamed(ArticleCategoryLight_.defaultPurchaseWaste));
                this.add(this.isPurchaseWasteActive);
                this.add(this.purchaseWasteField);
                this.isPurchaseTenderWasteActive = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ArticleCategoryLight_.useTenderPurchaseWaste));
                this.isPurchaseTenderWasteActive.addButtonListener(this);
                this.purchaseTenderWasteField = new NumberTextField(TextFieldType.DOUBLE);
                this.purchaseTenderWasteField.setNode(m.getNode().getChildNamed(ArticleCategoryLight_.defaultTenderPurchaseWaste));
                this.add(this.isPurchaseTenderWasteActive);
                this.add(this.purchaseTenderWasteField);
                this.aisRelevant = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ArticleCategoryLight_.allergenSheetRelevant));
                this.add(this.aisRelevant);
                this.shelfLifeMandatory = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ArticleCategoryLight_.shelfLifeMandatory));
                this.add(this.shelfLifeMandatory);
                this.isShelfLifeActive = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ArticleCategoryLight_.useShelfLife));
                this.isShelfLifeActive.addButtonListener(this);
                ArticleCategoryLight value = (ArticleCategoryLight)m.getNode().getValue();
                if (value.getShelfLife() == null) {
                    DateDurationComplete shelfLifeDuration = new DateDurationComplete();
                    shelfLifeDuration.setDuration(Double.valueOf(0.0));
                    shelfLifeDuration.setUnit(DateUnitE.DAY);
                    shelfLifeDuration.setClientOId(Long.valueOf(ADTO.getNextId()));
                    value.setShelfLife(shelfLifeDuration);
                }
                this.shelfLifeAmount = new NumberTextField(TextFieldType.DOUBLE);
                this.shelfLifeAmount.setNode(m.getNode().getChildNamed(new DtoField[]{ArticleCategoryLight_.shelfLife, DateDurationComplete_.duration}));
                this.shelfLifeUnit = new ComboBox(m.getNode().getChildNamed(new DtoField[]{ArticleCategoryLight_.shelfLife, DateDurationComplete_.unit}), StaticEnumServiceManager.getAllDateDurations(), ConverterRegistry.getConverter(DateUnitEConverter.class));
                this.add(this.isShelfLifeActive);
                this.add(this.shelfLifeAmount);
                this.add(this.shelfLifeUnit);
                this.customsEdit = new EditButton();
                this.customsEdit.addButtonListener(this);
                this.add(this.customsEdit);
            } else if (m.getNode().getValue() instanceof ProductCategoryLight) {
                this.crewCommission = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ProductCategoryLight_.commissionForCrew));
                this.airlineCommission = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ProductCategoryLight_.commissionForAirline));
                this.editButton = new EditButton();
                this.editButton.addButtonListener(this);
                this.add(this.crewCommission);
                this.add(this.airlineCommission);
                this.add(this.editButton);
            } else if (m.getNode().getValue() instanceof RecipeCategoryLight) {
                this.editButton = new EditButton();
                this.editButton.addButtonListener(this);
                this.add(this.editButton);
            }
            this.add(this.field);
            this.add(this.display);
            this.add(this.categoryCode);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton) {
                this.model.getNode().getChildNamed(ADeletableDTO_.isDeleted).setValue((Object)(!this.isDelete ? 1 : 0), System.currentTimeMillis());
                if (this.model.getNode().getChildNamed(ADTO_.id).getValue() == null) {
                    this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
                } else {
                    this.ensureButtonState();
                    this.revalidate();
                }
            } else if (this.isCookingWasteActive == source) {
                this.setEnabled(this.isEnabled());
            } else if (this.isPurchaseWasteActive == source) {
                this.setEnabled(this.isEnabled());
            } else if (this.isCookingTenderWasteActive == source) {
                this.setEnabled(this.isEnabled());
            } else if (this.isPurchaseTenderWasteActive == source) {
                this.setEnabled(this.isEnabled());
            } else if (this.editButton == source) {
                if (this.model.getNode().getValue() instanceof ProductCategoryLight) {
                    InnerPopUp2 popup = InnerPopUp2.getInnerPopUp(PopupType.NORMAL);
                    popup.setAttributes(this, true, true, Words.CUSTOMER_RESTRICTION);
                    popup.setView(new ProductCategoryCustomerRestrictionPopupInsert((Node<ProductCategoryComplete>)this.getModel().getNode()));
                    popup.showPopUp(x, y, 600, 400, null, this);
                } else {
                    InnerPopUp2 popup = InnerPopUp2.getInnerPopUp(PopupType.NORMAL);
                    popup.setAttributes(this, true, true, Words.COOKING_WASTE);
                    popup.setView(new RecipeCookingWastePopupInsert(this.getModel().getNode().getChildNamed(RecipeCategoryLight_.cookingWaste)));
                    popup.showPopUp(x, y, 600, 400, null, this);
                }
            } else if (this.customsEdit == source) {
                InnerPopUp2 popup = InnerPopUp2.getInnerPopUp(PopupType.NORMAL);
                popup.setAttributes(this, true, true, Words.CUSTOMS_TARIFF);
                popup.setView(new ArticleCategoryDetailsPopupInsert((Node<ArticleCategoryLight>)this.getModel().getNode()));
                popup.showPopUp(x, y, 600, 100, null, this);
            } else if (this.isShelfLifeActive == source) {
                this.setEnabled(this.isEnabled());
            }
        }

        private void ensureButtonState() {
            this.isDelete = (Boolean)this.model.getNode().getChildNamed(ADeletableDTO_.isDeleted).getValue();
            if (!this.isDelete) {
                if (this.deleteButton instanceof RestoreButton) {
                    this.deleteButton.kill();
                    this.deleteButton = null;
                }
                if (this.deleteButton == null) {
                    this.deleteButton = new DeleteButton();
                    this.add(this.deleteButton);
                    this.deleteButton.addButtonListener(this);
                }
            } else {
                if (this.deleteButton instanceof DeleteButton) {
                    this.deleteButton.kill();
                    this.deleteButton = null;
                }
                if (this.deleteButton == null) {
                    this.deleteButton = new RestoreButton();
                    this.add(this.deleteButton);
                    this.deleteButton.addButtonListener(this);
                }
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.field.kill();
            this.field = null;
            if (this.editButton != null) {
                this.editButton.kill();
            }
            this.editButton = null;
            this.display.kill();
            this.display = null;
            this.categoryCode.kill();
            this.categoryCode = null;
            if (this.customsEdit != null) {
                this.customsEdit.kill();
            }
            this.customsEdit = null;
            if (this.isCookingWasteActive != null) {
                this.isCookingWasteActive.kill();
            }
            if (this.cookingWasteField != null) {
                this.cookingWasteField.kill();
            }
            this.isCookingWasteActive = null;
            this.cookingWasteField = null;
            if (this.isCookingTenderWasteActive != null) {
                this.isCookingTenderWasteActive.kill();
            }
            if (this.cookingTenderWasteField != null) {
                this.cookingTenderWasteField.kill();
            }
            this.isCookingTenderWasteActive = null;
            this.cookingTenderWasteField = null;
            if (this.isPurchaseWasteActive != null) {
                this.isPurchaseWasteActive.kill();
            }
            if (this.purchaseWasteField != null) {
                this.purchaseWasteField.kill();
            }
            this.isPurchaseWasteActive = null;
            this.purchaseWasteField = null;
            if (this.isPurchaseTenderWasteActive != null) {
                this.isPurchaseTenderWasteActive.kill();
            }
            if (this.purchaseTenderWasteField != null) {
                this.purchaseTenderWasteField.kill();
            }
            this.isPurchaseTenderWasteActive = null;
            this.purchaseTenderWasteField = null;
            if (this.crewCommission != null) {
                this.crewCommission.kill();
            }
            this.crewCommission = null;
            if (this.airlineCommission != null) {
                this.airlineCommission.kill();
            }
            this.airlineCommission = null;
            if (this.aisRelevant != null) {
                this.aisRelevant.kill();
            }
            this.aisRelevant = null;
            if (this.shelfLifeMandatory != null) {
                this.shelfLifeMandatory.kill();
            }
            this.shelfLifeMandatory = null;
            if (this.isShelfLifeActive != null) {
                this.isShelfLifeActive.kill();
            }
            this.isShelfLifeActive = null;
            if (this.shelfLifeAmount != null) {
                this.shelfLifeAmount.kill();
            }
            this.shelfLifeAmount = null;
            if (this.shelfLifeUnit != null) {
                this.shelfLifeUnit.kill();
            }
            this.shelfLifeUnit = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.field.getFocusComponents();
            a.addAll(this.categoryCode.getFocusComponents());
            CheckedListAdder.addToList(a, this.isPurchaseWasteActive);
            CheckedListAdder.addToList(a, this.purchaseWasteField);
            CheckedListAdder.addToList(a, this.isPurchaseTenderWasteActive);
            CheckedListAdder.addToList(a, this.purchaseTenderWasteField);
            CheckedListAdder.addToList(a, this.isCookingWasteActive);
            CheckedListAdder.addToList(a, this.cookingWasteField);
            CheckedListAdder.addToList(a, this.isCookingTenderWasteActive);
            CheckedListAdder.addToList(a, this.cookingTenderWasteField);
            CheckedListAdder.addToList(a, this.crewCommission);
            CheckedListAdder.addToList(a, this.airlineCommission);
            CheckedListAdder.addToList(a, this.customsEdit);
            CheckedListAdder.addToList(a, this.aisRelevant);
            CheckedListAdder.addToList(a, this.shelfLifeMandatory);
            CheckedListAdder.addToList(a, this.isShelfLifeActive);
            CheckedListAdder.addToList(a, this.shelfLifeAmount);
            CheckedListAdder.addToList(a, this.shelfLifeUnit);
            a.addAll(this.display.getFocusComponents());
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return this.field.getText();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b;
            this.field.setEnabled(isEnabled);
            this.display.setEnabled(isEnabled);
            this.categoryCode.setEnabled(isEnabled);
            this.deleteButton.setEnabled(isEnabled);
            if (this.editButton != null) {
                this.editButton.setEnabled(isEnabled);
            }
            if (this.isCookingWasteActive != null) {
                this.isCookingWasteActive.setEnabled(isEnabled);
                b = this.isCookingWasteActive.isChecked();
                this.cookingWasteField.setEnabled(isEnabled && b);
            }
            if (this.isPurchaseWasteActive != null) {
                this.isPurchaseWasteActive.setEnabled(isEnabled);
                b = this.isPurchaseWasteActive.isChecked() && isEnabled;
                this.purchaseWasteField.setEnabled(b);
            }
            if (this.isCookingTenderWasteActive != null) {
                this.isCookingTenderWasteActive.setEnabled(isEnabled);
                b = this.isCookingTenderWasteActive.isChecked();
                this.cookingTenderWasteField.setEnabled(isEnabled && b);
            }
            if (this.isPurchaseTenderWasteActive != null) {
                this.isPurchaseTenderWasteActive.setEnabled(isEnabled);
                b = this.isPurchaseTenderWasteActive.isChecked() && isEnabled;
                this.purchaseTenderWasteField.setEnabled(b);
            }
            if (this.crewCommission != null) {
                this.crewCommission.setEnabled(isEnabled);
            }
            if (this.airlineCommission != null) {
                this.airlineCommission.setEnabled(isEnabled);
            }
            if (this.customsEdit != null) {
                this.customsEdit.setEnabled(isEnabled);
            }
            if (this.aisRelevant != null) {
                this.aisRelevant.setEnabled(isEnabled);
            }
            if (this.shelfLifeMandatory != null) {
                this.shelfLifeMandatory.setEnabled(isEnabled);
            }
            if (this.isShelfLifeActive != null) {
                this.isShelfLifeActive.setEnabled(isEnabled);
                b = this.isShelfLifeActive.isChecked() && isEnabled;
                this.shelfLifeAmount.setEnabled(b);
                this.shelfLifeUnit.setEnabled(b);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.field.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.field.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.field.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.field.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                int t = 0;
                TableRowImpl.this.categoryCode.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.categoryCode.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.categoryCode.setSize(w - (2 * TableRowImpl.this.getCellPadding() + t), (int)TableRowImpl.this.categoryCode.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                int index = 3;
                if (TableRowImpl.this.isPurchaseWasteActive != null && TableRowImpl.this.isCookingWasteActive != null && TableRowImpl.this.purchaseWasteField != null && TableRowImpl.this.cookingWasteField != null) {
                    int uw = w - 3 * TableRowImpl.this.getCellPadding();
                    uw = (int)((double)uw - TableRowImpl.this.isPurchaseWasteActive.getPreferredSize().getWidth() * 2.0);
                    uw -= 2 * TableRowImpl.this.getInnerCellPadding();
                    uw /= 2;
                    int uw2 = w - 3 * TableRowImpl.this.getCellPadding();
                    uw2 = (int)((double)uw2 - TableRowImpl.this.isShelfLifeActive.getPreferredSize().getWidth() * 2.0);
                    uw2 -= 2 * TableRowImpl.this.getInnerCellPadding();
                    uw2 /= 2;
                    TableRowImpl.this.isPurchaseWasteActive.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.isCookingWasteActive.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.isPurchaseWasteActive.setSize(TableRowImpl.this.isPurchaseWasteActive.getPreferredSize());
                    TableRowImpl.this.purchaseWasteField.setLocation(TableRowImpl.this.isPurchaseWasteActive.getX() + TableRowImpl.this.isPurchaseWasteActive.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.purchaseWasteField.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.purchaseWasteField.setSize(uw, (int)TableRowImpl.this.purchaseWasteField.getPreferredSize().getHeight());
                    TableRowImpl.this.isPurchaseTenderWasteActive.setLocation(TableRowImpl.this.purchaseWasteField.getX() + TableRowImpl.this.purchaseWasteField.getWidth() + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.isPurchaseTenderWasteActive.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.isPurchaseTenderWasteActive.setSize(TableRowImpl.this.isPurchaseTenderWasteActive.getPreferredSize());
                    TableRowImpl.this.purchaseTenderWasteField.setLocation(TableRowImpl.this.isPurchaseTenderWasteActive.getX() + TableRowImpl.this.isPurchaseTenderWasteActive.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.purchaseWasteField.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.purchaseTenderWasteField.setSize(uw, (int)TableRowImpl.this.purchaseWasteField.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                    TableRowImpl.this.isCookingWasteActive.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.isCookingWasteActive.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.isCookingWasteActive.setSize(TableRowImpl.this.isCookingWasteActive.getPreferredSize());
                    TableRowImpl.this.cookingWasteField.setLocation(TableRowImpl.this.isCookingWasteActive.getX() + TableRowImpl.this.isCookingWasteActive.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cookingWasteField.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.cookingWasteField.setSize(uw, (int)TableRowImpl.this.cookingWasteField.getPreferredSize().getHeight());
                    TableRowImpl.this.isCookingTenderWasteActive.setLocation(TableRowImpl.this.cookingWasteField.getX() + TableRowImpl.this.cookingTenderWasteField.getWidth() + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.isCookingWasteActive.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.isCookingTenderWasteActive.setSize(TableRowImpl.this.isCookingTenderWasteActive.getPreferredSize());
                    TableRowImpl.this.cookingTenderWasteField.setLocation(TableRowImpl.this.isCookingTenderWasteActive.getX() + TableRowImpl.this.isCookingTenderWasteActive.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cookingWasteField.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.cookingTenderWasteField.setSize(uw, (int)TableRowImpl.this.cookingTenderWasteField.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                    TableRowImpl.this.aisRelevant.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.aisRelevant.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.aisRelevant.setSize(TableRowImpl.this.aisRelevant.getPreferredSize());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                    TableRowImpl.this.shelfLifeMandatory.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.shelfLifeMandatory.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.shelfLifeMandatory.setSize(TableRowImpl.this.shelfLifeMandatory.getPreferredSize());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(6);
                    TableRowImpl.this.isShelfLifeActive.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.isCookingWasteActive.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.isShelfLifeActive.setSize(TableRowImpl.this.isShelfLifeActive.getPreferredSize());
                    TableRowImpl.this.shelfLifeAmount.setLocation(TableRowImpl.this.isShelfLifeActive.getX() + TableRowImpl.this.isShelfLifeActive.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.shelfLifeAmount.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.shelfLifeAmount.setSize(uw2 - 20, (int)TableRowImpl.this.shelfLifeAmount.getPreferredSize().getHeight());
                    TableRowImpl.this.shelfLifeUnit.setLocation(TableRowImpl.this.shelfLifeAmount.getX() + TableRowImpl.this.shelfLifeAmount.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.shelfLifeUnit.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.shelfLifeUnit.setSize(uw2 + 20, (int)TableRowImpl.this.shelfLifeUnit.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(7);
                    index = 8;
                } else if (TableRowImpl.this.isCookingTenderWasteActive != null && TableRowImpl.this.cookingTenderWasteField != null) {
                    int uw = w - 2 * TableRowImpl.this.getCellPadding();
                    uw = (int)((double)uw - TableRowImpl.this.isCookingTenderWasteActive.getPreferredSize().getWidth());
                    TableRowImpl.this.isCookingTenderWasteActive.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.isCookingTenderWasteActive.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.isCookingTenderWasteActive.setSize(TableRowImpl.this.isCookingTenderWasteActive.getPreferredSize());
                    TableRowImpl.this.cookingTenderWasteField.setLocation(TableRowImpl.this.isCookingTenderWasteActive.getX() + TableRowImpl.this.isCookingTenderWasteActive.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cookingTenderWasteField.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.cookingTenderWasteField.setSize(uw -= TableRowImpl.this.getInnerCellPadding(), (int)TableRowImpl.this.cookingTenderWasteField.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                    index = 4;
                } else if (TableRowImpl.this.editButton != null) {
                    TableRowImpl.this.editButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.editButton.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.editButton.setSize(TableRowImpl.this.editButton.getPreferredSize());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                    index = 4;
                }
                if (TableRowImpl.this.customsEdit != null) {
                    TableRowImpl.this.customsEdit.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customsEdit.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.customsEdit.setSize(TableRowImpl.this.customsEdit.getPreferredSize());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                }
                if (TableRowImpl.this.crewCommission != null) {
                    TableRowImpl.this.crewCommission.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.crewCommission.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.crewCommission.setSize(TableRowImpl.this.crewCommission.getPreferredSize());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                }
                if (TableRowImpl.this.airlineCommission != null) {
                    TableRowImpl.this.airlineCommission.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.airlineCommission.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.airlineCommission.setSize(TableRowImpl.this.airlineCommission.getPreferredSize());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(index++);
                }
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.display.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.display.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.display.setSize(TableRowImpl.this.display.getPreferredSize());
                if (TableRowImpl.this.deleteButton != null) {
                    TableRowImpl.this.deleteButton.setLocation(TableRowImpl.this.display.getX() + TableRowImpl.this.display.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.deleteButton.setSize(TableRowImpl.this.deleteButton.getPreferredSize());
                }
            }
        }
    }

    private class InnerComponentTable
    extends BreadCrumbComponentTable {
        private static final long serialVersionUID = 1L;

        public InnerComponentTable(IDataHandler dataHandler, BreadCrumbPanel master, GroupLoader loader, String buttonText, RDProvider provider, Node node) {
            super(dataHandler, master, loader, buttonText, provider, null);
            this.setNode(node);
        }

        @Override
        public Converter getTotalConverter() {
            return null;
        }

        @Override
        public void setTotalCostAlgorithm() {
        }

        @Override
        public Table2RowPanel getComponentTableRow(Table2RowModel model, boolean isHeader) {
            if (isHeader) {
                return new Table2HeaderPanel(model, 7);
            }
            return new TableRowImpl(model);
        }

        @Override
        public void addButtonPressed(int x, int y) {
            Object c = CategoryConfig.this.createNewCategory();
            Node n = INodeCreator.getDefaultImpl().getNode4DTO(c, true, false);
            this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
        }

        @Override
        public void childRemoved() {
            CategoryConfig.this.revalidate();
        }

        @Override
        public List<TableColumnInfo> getColumns(Node node) {
            ArrayList<TableColumnInfo> a = new ArrayList<TableColumnInfo>();
            a.add(new TableColumnInfo(Words.NAME, 100, 100, 100));
            a.add(new TableColumnInfo(Words.CODE, 120, 120, 120));
            int index = 2;
            if (CategoryConfig.this instanceof ArticleCategoryConfig) {
                a.add(new TableColumnInfo(Words.PURCHASE_WASTE_AND_TENDER, 180, 180, 180));
                a.add(new TableColumnInfo(Words.COOKING_WASTE_AND_TENDER, 180, 180, 180));
                a.add(new TableColumnInfo(Words.SHOW_ON_AIS, 40, 40, 40));
                a.add(new TableColumnInfo(Words.SHELF_MANDATORY, 40, 40, 40));
                a.add(new TableColumnInfo(Words.SHELF_GARANTEED, 150, 150, 150));
                a.add(new TableColumnInfo(Words.CUSTOMS, 40, 40, 40));
                ((TableColumnInfo)a.get(2)).setxExpand(0.0);
                ((TableColumnInfo)a.get(3)).setxExpand(0.0);
                ((TableColumnInfo)a.get(4)).setxExpand(0.0);
                ((TableColumnInfo)a.get(5)).setxExpand(0.0);
                ((TableColumnInfo)a.get(6)).setxExpand(0.0);
                ((TableColumnInfo)a.get(7)).setxExpand(0.0);
                index = 8;
            }
            if (CategoryConfig.this instanceof RecipeCategoryConfig) {
                a.add(new TableColumnInfo(Words.COOKING_WASTE_TENDER, 90, 90, 90));
                ((TableColumnInfo)a.get(2)).setxExpand(0.0);
                index = 3;
            }
            int tw = 0;
            if (CategoryConfig.this instanceof ProductCategoryConfig) {
                tw = 60;
                a.add(new TableColumnInfo(Words.CUSTOMER_RESTRICTION, tw, tw, tw));
                a.add(new TableColumnInfo(Words.CREW_COMMISSION, tw, tw, tw));
                a.add(new TableColumnInfo(Words.AIRLINE_COMMISSION, tw, tw, tw));
                ((TableColumnInfo)a.get(index)).setxExpand(0.0);
                ((TableColumnInfo)a.get(index + 1)).setxExpand(0.0);
                ((TableColumnInfo)a.get(index + 2)).setxExpand(0.0);
            }
            tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + 2 * this.getTable().getCellPadding() + this.getTable().getInnerCellPadding() + CheckBox.getPreferredWidth();
            a.add(new TableColumnInfo(Words.SHOW, tw, tw, tw));
            ((TableColumnInfo)a.get(a.size() - 1)).setxExpand(0.0);
            ((TableColumnInfo)a.get(0)).setxExpand(1.0);
            ((TableColumnInfo)a.get(1)).setxExpand(0.0);
            return a;
        }

        public Converter getTitleConverter() {
            return CategoryConfig.this.getTopTitleConverter();
        }

        @Override
        public int getSortingIndex() {
            return 0;
        }
    }

    private class InnerGroupTable
    extends BreadCrumbGroupTable {
        private static final long serialVersionUID = 1L;

        public InnerGroupTable(IDataHandler dataHandler, BreadCrumbPanel master, String buttonText, RDProvider provider, Node node) {
            super(dataHandler, master, buttonText, provider);
            this.setNode(node);
        }

        @Override
        public Table2RowPanel getGroupTableRow(Table2RowModel model, boolean isHeader) {
            if (isHeader) {
                return new Table2HeaderPanel(model, 7);
            }
            return new TableRowImpl(model);
        }

        @Override
        public void addButtonPressed() {
            Object c = CategoryConfig.this.createNewCategory();
            Node n = INodeCreator.getDefaultImpl().getNode4DTO(c, true, false);
            this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
        }

        @Override
        public void childRemoved() {
            CategoryConfig.this.revalidate();
        }

        @Override
        public List<TableColumnInfo> getColumns() {
            ArrayList<TableColumnInfo> a = new ArrayList<TableColumnInfo>();
            a.add(new TableColumnInfo(Words.NAME, 200, 200, 200));
            ((TableColumnInfo)a.get(0)).setxExpand(1.0);
            a.add(new TableColumnInfo(Words.CODE, 60, 60, 60));
            ((TableColumnInfo)a.get(1)).setxExpand(0.0);
            int index = 2;
            if (CategoryConfig.this instanceof ArticleCategoryConfig) {
                a.add(new TableColumnInfo(Words.PURCHASE_WASTE_AND_TENDER, 180, 180, 180));
                a.add(new TableColumnInfo(Words.COOKING_WASTE_AND_TENDER, 180, 180, 180));
                a.add(new TableColumnInfo(Words.SHOW_ON_AIS, 40, 40, 40));
                a.add(new TableColumnInfo(Words.SHELF_MANDATORY, 40, 40, 40));
                a.add(new TableColumnInfo(Words.SHELF_GARANTEED, 150, 150, 150));
                a.add(new TableColumnInfo(Words.DETAILS, 40, 40, 40));
                ((TableColumnInfo)a.get(2)).setxExpand(0.0);
                ((TableColumnInfo)a.get(3)).setxExpand(0.0);
                ((TableColumnInfo)a.get(4)).setxExpand(0.0);
                ((TableColumnInfo)a.get(5)).setxExpand(0.0);
                ((TableColumnInfo)a.get(6)).setxExpand(0.0);
                ((TableColumnInfo)a.get(7)).setxExpand(0.0);
                index = 8;
            }
            if (CategoryConfig.this instanceof RecipeCategoryConfig) {
                a.add(new TableColumnInfo(Words.COOKING_WASTE, 90, 90, 90));
                ((TableColumnInfo)a.get(2)).setxExpand(0.0);
                index = 3;
            }
            int tw = 0;
            if (CategoryConfig.this instanceof ProductCategoryConfig) {
                tw = 60;
                a.add(new TableColumnInfo(Words.CUSTOMER_RESTRICTION, tw, tw, tw));
                a.add(new TableColumnInfo(Words.CREW_COMMISSION, tw, tw, tw));
                a.add(new TableColumnInfo(Words.AIRLINE_COMMISSION, tw, tw, tw));
                ((TableColumnInfo)a.get(index)).setxExpand(0.0);
                ((TableColumnInfo)a.get(index + 1)).setxExpand(0.0);
                ((TableColumnInfo)a.get(index + 2)).setxExpand(0.0);
            }
            tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + 2 * this.getTable().getCellPadding() + this.getTable().getInnerCellPadding() + CheckBox.getPreferredWidth();
            a.add(new TableColumnInfo(Words.SHOW, tw, tw, tw));
            ((TableColumnInfo)a.get(a.size() - 1)).setxExpand(0.0);
            return a;
        }

        @Override
        public Comparator<?> getGroupComparator() {
            return null;
        }

        public Converter getTitleConverter() {
            return CategoryConfig.this.getTopTitleConverter();
        }

        @Override
        public int getSortingIndex() {
            return 0;
        }
    }

    private class InnerBreadCrumbPanel
    extends BreadCrumbPanel {
        private static final long serialVersionUID = 1L;

        public InnerBreadCrumbPanel(IDataHandler dataHandler, int maxDepth, RDProvider provider) {
            super(dataHandler, maxDepth, provider);
            this.setFirstTableWidth(890);
        }

        @Override
        public Converter getTotalConverter() {
            return null;
        }

        @Override
        public GroupLoader getGroupLoader() {
            return null;
        }

        @Override
        public BreadCrumbNavigator getNavigatorComponent() {
            return null;
        }

        @Override
        public BreadCrumbTable getGroupTable(Node node) {
            return new InnerGroupTable(null, this, "Add", null, node);
        }

        @Override
        public BreadCrumbTable getComponentTable(Node node, int depth) {
            return new InnerComponentTable(null, this, null, "Add", null, node);
        }

        @Override
        public void setNode(Node node) {
            if (!this.getTables().hasNext()) {
                this.addGroupTable(node);
            }
        }

        @Override
        public Node getNode() {
            return null;
        }

        @Override
        public InnerPopUp2 getAddGroupPopup(Button source, int x, int y, BreadCrumbTable t) {
            return null;
        }

        @Override
        public void setTotalCostAlgorithm() {
        }

        @Override
        public void processPopUpClose(Object ... xargs) {
        }

        @Override
        public DtoField<?> getSelectionChildName() {
            return ArticleCategoryComplete_.subCategories;
        }
    }
}

