/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyVariantComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyVariantComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class CurrencyConfig
extends MasterDataInsert<CurrencyComplete> {
    private static final long serialVersionUID = 1L;

    public CurrencyConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public CurrencyComplete getNewObject() {
        CurrencyComplete c = new CurrencyComplete();
        c.setClientOId(Long.valueOf(ADTO.getNextId()));
        return c;
    }

    @Override
    public Class<? extends CurrencyComplete> getMasterDataClass() {
        return CurrencyComplete.class;
    }

    @Override
    public String getInsertName() {
        return Words.CURRENCIES;
    }

    @Override
    public DetailsPanel getDetails() {
        return new CurrencyDetailsPanel();
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean nameSet = true;
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(CurrencyComplete_.name).getValue() == null) {
                nameSet = false;
            }
            if (n.getChildNamed(CurrencyComplete_.code).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(CurrencyComplete_.code).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ENSURE_CODE_IS_UNIQUE, (Object[])new Object[]{n.getChildNamed(CurrencyComplete_.code).getValue()})));
                continue;
            }
            codes.add((String)n.getChildNamed(CurrencyComplete_.code).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ALL_CODES_ARE_SET));
        }
        if (!nameSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ALL_NAMES_ARE_SET));
        }
        return a;
    }

    private class CurrencyDetailsPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> code = new TitledItem<TextField>(new TextField(), WordsToolkit.toCapitalLetter((String)Words.CODE), TitledItem.TitledItemOrientation.NORTH);
        private TitledItem<TextField> name = new TitledItem<TextField>(new TextField(), WordsToolkit.toCapitalLetter((String)Words.NAME), TitledItem.TitledItemOrientation.NORTH);
        private TitledItem<CheckBox> isEMU = new TitledItem<CheckBox>(new CheckBox(), WordsToolkit.toCapitalLetter((String)Words.EMU), TitledItem.TitledItemOrientation.EAST);
        private TitledPeriodEditor periodEditor;
        private Table2 currencyVariantTable;

        public CurrencyDetailsPanel() {
            PeriodComplete p = new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()));
            this.periodEditor = new TitledPeriodEditor((Node<PeriodComplete>)INodeCreator.getDefaultImpl().getNode4DTO((Object)p, false, false), null);
            this.insertTable();
            this.setLayout(new Layout());
            this.add(this.periodEditor);
            this.add(this.code);
            this.add(this.name);
            this.add(this.isEMU);
        }

        private void insertTable() {
            this.currencyVariantTable = new Table2(true, Words.ADD, true, true, "Variants");
            this.currencyVariantTable.setButtonHandler(new Table2ButtonHandler(){

                @Override
                public void childRemoved() {
                    CurrencyDetailsPanel.this.revalidate();
                }

                @Override
                public void addButtonPressed(int x, int y, Button source) {
                    CurrencyVariantComplete lastestVariant = null;
                    Node node = null;
                    if (CurrencyDetailsPanel.this.currencyVariantTable.getRowCount() > 0) {
                        node = CurrencyDetailsPanel.this.currencyVariantTable.getRowAt(CurrencyDetailsPanel.this.currencyVariantTable.getRowCount() - 1).getModel().getNode();
                        lastestVariant = (CurrencyVariantComplete)node.getValue();
                    }
                    CurrencyVariantComplete nv = new CurrencyVariantComplete();
                    nv.setClientOId(Long.valueOf(ADTO.getNextId()));
                    nv.setBase((CurrencyComplete)CurrencyDetailsPanel.this.getNode().getValue());
                    nv.setExchangeRate(Double.valueOf(1.0));
                    if (lastestVariant == null) {
                        nv.setValidityPeriod(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
                    } else {
                        Date newStartDate = new Date(System.currentTimeMillis());
                        PeriodComplete startPeriod = new PeriodComplete(newStartDate, newStartDate);
                        nv.setValidityPeriod(new PeriodComplete(new Date(startPeriod.getEndDate().getTime()), new Date(lastestVariant.getValidityPeriod().getEndDate().getTime())));
                        lastestVariant.getValidityPeriod().setEndDate(new Date(startPeriod.getStartDate().getTime() - 1L));
                        Node validity = node.getChildNamed(CurrencyVariantComplete_.validityPeriod);
                        validity.updateNode();
                    }
                    Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)nv, true, false);
                    CurrencyDetailsPanel.this.currencyVariantTable.getModel().getNode().addChild(n, 0L);
                }
            });
            ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
            int tw = 2 * this.currencyVariantTable.getCellPadding() + TitledPeriodEditor.getPreferredWidth(this, false, true);
            columns.add(new TableColumnInfo(Words.FROM, null, null, null, "", tw, tw, tw));
            tw = 2 * this.currencyVariantTable.getCellPadding() + DateChooser.getPreferredWidth(this, true);
            columns.add(new TableColumnInfo(Words.EXCHANGE_RATE, null, null, null, "", 40, 40, 40));
            tw = 2 * this.currencyVariantTable.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
            columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
            ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
            this.currencyVariantTable.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
            this.add(this.currencyVariantTable);
        }

        @Override
        public DtoField getAttributeName() {
            return CurrencyComplete_.code;
        }

        @Override
        public void setNode(Node<?> n) {
            super.setNode(n);
            this.code.getElement().setNode(n.getChildNamed(CurrencyComplete_.code));
            this.name.getElement().setNode(n.getChildNamed(CurrencyComplete_.name));
            this.isEMU.getElement().setNode(n.getChildNamed(CurrencyComplete_.isEMU));
            this.periodEditor.setStartDateNode(n.getChildNamed(new DtoField[]{CurrencyComplete_.period, PeriodComplete_.startDate}));
            this.periodEditor.setEndDateNode(n.getChildNamed(new DtoField[]{CurrencyComplete_.period, PeriodComplete_.endDate}));
            this.currencyVariantTable.getModel().setNode(n.getChildNamed(CurrencyComplete_.variants));
            this.setEnabled(true);
            CurrencyConfig.this.setEnabled(true);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.name.kill();
            this.isEMU.kill();
            this.periodEditor.kill();
            this.currencyVariantTable.kill();
            this.code = null;
            this.name = null;
            this.isEMU = null;
            this.periodEditor = null;
            this.currencyVariantTable = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.code.setEnabled(b);
            this.name.setEnabled(b);
            this.isEMU.setEnabled(b);
            this.periodEditor.setEnabled(b);
            this.currencyVariantTable.setEnabled(b);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.code.getFocusComponents();
            CheckedListAdder.addToList(a, this.name);
            CheckedListAdder.addToList(a, this.isEMU);
            CheckedListAdder.addToList(a, this.periodEditor);
            CheckedListAdder.addToList(a, this.currencyVariantTable);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.name.setVisibleContainer(pane);
            this.code.setVisibleContainer(pane);
            this.isEMU.setVisibleContainer(pane);
            this.periodEditor.setVisibleContainer(pane);
            this.currencyVariantTable.setVisibleContainer(pane);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        private class TableRowImpl
        extends Table2RowPanel
        implements ButtonListener {
            private static final long serialVersionUID = 1L;
            private TitledPeriodEditor period;
            private TextField exchangeRate;
            private DeleteButton deleteButton;

            public TableRowImpl(Table2RowModel m) {
                super(m);
                this.period = new TitledPeriodEditor((Node<Date>)m.getNode().getChildNamed(new DtoField[]{CurrencyVariantComplete_.validityPeriod, PeriodComplete_.startDate}), (Node<Date>)m.getNode().getChildNamed(new DtoField[]{CurrencyVariantComplete_.validityPeriod, PeriodComplete_.endDate}), false, null, CurrencyVariantComplete_.validityPeriod.getFieldName());
                this.period.enableInfinity(false, true);
                this.period.setStartDateNode(m.getNode().getChildNamed(new DtoField[]{CurrencyVariantComplete_.validityPeriod, PeriodComplete_.startDate}));
                this.period.setEndDateNode(m.getNode().getChildNamed(new DtoField[]{CurrencyVariantComplete_.validityPeriod, PeriodComplete_.endDate}));
                this.exchangeRate = new NumberTextField(m.getNode().getChildNamed(CurrencyVariantComplete_.exchangeRate), TextFieldType.DOUBLE);
                ((NumberTextField)this.exchangeRate).setUseMaxDecimals(false);
                this.deleteButton = new DeleteButton();
                this.deleteButton.addButtonListener(this);
                this.setLayout(new InnerLayout());
                this.add(this.period);
                this.add(this.exchangeRate);
                this.add(this.deleteButton);
            }

            @Override
            public List<Component> getFocusComponents() {
                ArrayList<Component> a = new ArrayList<Component>();
                CheckedListAdder.addToList(a, this.period);
                CheckedListAdder.addToList(a, this.exchangeRate);
                CheckedListAdder.addToList(a, this.deleteButton);
                return a;
            }

            @Override
            public Object getObject4Column(int column) {
                return this.model.getNode().getChildNamed(new DtoField[]{CurrencyVariantComplete_.validityPeriod, PeriodComplete_.endDate}).getValue();
            }

            @Override
            public void buttonPressed(Button source, int x, int y) {
                this.getModel().getParentModel().getTable().getModel().getNode().removeChild(this.getModel().getNode(), 0L);
            }

            @Override
            public void setEnabled(boolean isEnabled) {
                super.setEnabled(isEnabled);
                this.period.setEnabled(isEnabled);
                this.exchangeRate.setEnabled(isEnabled);
                this.deleteButton.setEnabled(isEnabled);
            }

            @Override
            public void kill() {
                if (this.isKilled()) {
                    return;
                }
                super.kill();
                this.period.kill();
                this.exchangeRate.kill();
                this.deleteButton.kill();
                this.period = null;
                this.exchangeRate = null;
                this.deleteButton = null;
            }

            private class InnerLayout
            extends DefaultLayout {
                private InnerLayout() {
                }

                @Override
                public Dimension preferredLayoutSize(Container parent) {
                    return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
                }

                @Override
                public void layoutContainer(Container parent) {
                    int currentX = 0;
                    int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                    TableRowImpl.this.period.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.period.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.period.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.period.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                    TableRowImpl.this.exchangeRate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.exchangeRate.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.exchangeRate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.exchangeRate.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(2);
                    TableRowImpl.this.setControlsX(currentX);
                    TableRowImpl.this.deleteButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.deleteButton.setSize(TableRowImpl.this.deleteButton.getPreferredSize());
                }
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                int h = CurrencyConfig.this.masterDataTable.getCellPadding();
                h = (int)((double)h + CurrencyDetailsPanel.this.code.getPreferredSize().getHeight());
                h += CurrencyConfig.this.masterDataTable.getCellPadding();
                h = (int)((double)h + CurrencyDetailsPanel.this.name.getPreferredSize().getHeight());
                h += CurrencyConfig.this.masterDataTable.getCellPadding();
                h += CurrencyConfig.this.masterDataTable.getCellPadding();
                h = (int)((double)h + CurrencyDetailsPanel.this.isEMU.getPreferredSize().getHeight());
                h += CurrencyConfig.this.masterDataTable.getCellPadding();
                h = (int)((double)h + CurrencyDetailsPanel.this.periodEditor.getPreferredSize().getHeight());
                h += CurrencyConfig.this.masterDataTable.getCellPadding();
                h += 250;
                return new Dimension(0, h += CurrencyConfig.this.masterDataTable.getCellPadding());
            }

            @Override
            public void layoutContainer(Container parent) {
                CurrencyDetailsPanel.this.code.setLocation(CurrencyConfig.this.masterDataTable.getCellPadding(), CurrencyConfig.this.masterDataTable.getCellPadding());
                CurrencyDetailsPanel.this.code.setSize(200, (int)CurrencyDetailsPanel.this.code.getPreferredSize().getHeight());
                CurrencyDetailsPanel.this.name.setLocation(CurrencyConfig.this.masterDataTable.getCellPadding(), CurrencyDetailsPanel.this.code.getY() + CurrencyDetailsPanel.this.code.getHeight() + CurrencyConfig.this.masterDataTable.getCellPadding());
                CurrencyDetailsPanel.this.name.setSize(200, (int)CurrencyDetailsPanel.this.name.getPreferredSize().getHeight());
                CurrencyDetailsPanel.this.isEMU.setLocation(CurrencyConfig.this.masterDataTable.getCellPadding(), CurrencyDetailsPanel.this.name.getY() + CurrencyDetailsPanel.this.name.getHeight() + CurrencyConfig.this.masterDataTable.getCellPadding());
                CurrencyDetailsPanel.this.isEMU.setSize(CurrencyDetailsPanel.this.isEMU.getPreferredSize());
                CurrencyDetailsPanel.this.periodEditor.setLocation(CurrencyDetailsPanel.this.isEMU.getX(), CurrencyDetailsPanel.this.isEMU.getY() + CurrencyDetailsPanel.this.isEMU.getHeight() + CurrencyConfig.this.masterDataTable.getCellPadding());
                CurrencyDetailsPanel.this.periodEditor.setSize(CurrencyDetailsPanel.this.periodEditor.getPreferredSize());
                CurrencyDetailsPanel.this.currencyVariantTable.setLocation(CurrencyDetailsPanel.this.isEMU.getX(), CurrencyDetailsPanel.this.periodEditor.getY() + CurrencyDetailsPanel.this.periodEditor.getHeight() + CurrencyConfig.this.masterDataTable.getCellPadding());
                CurrencyDetailsPanel.this.currencyVariantTable.setSize(500, 250);
            }
        }
    }
}

