/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowSelectionListener;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.VerticalSeparator;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.RestoreButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.ADTO_;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AMasterDataComplete;
import ch.icit.pegasus.server.core.dtos.system.ADeletableDTO;
import ch.icit.pegasus.server.core.dtos.system.ADeletableDTO_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;

public abstract class DataInsert<T>
extends DefaultDataInsert
implements Table2RowSelectionListener {
    private static final long serialVersionUID = 1L;
    protected Table2 masterDataTable;
    protected DetailsPanel panel;
    protected VerticalSeparator sep1;
    protected ComboBox filter;

    public DataInsert(MasterDataModule p) {
        super(p);
        boolean withAddButton = this.getNewObject() != null;
        this.masterDataTable = new Table2(withAddButton, Words.ADD, false, false);
        this.sep1 = new VerticalSeparator();
        this.masterDataTable.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                DataInsert.this.validate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                DataInsert.this.addButtonPressed();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 30, 30, 30));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        this.masterDataTable.setModel(new Table2Model(columns, model -> new TableRowImpl(model, this.panel.getConverter(), this.panel.getAttributeName())));
        this.masterDataTable.getModel().addTableSelectionListener(this);
        this.masterDataTable.setSortedColumn(0, true);
        this.setLayout(new Layout());
        this.add(this.masterDataTable);
        this.panel = this.getDetails();
        this.panel.setEnabled(false);
        this.add(this.panel);
        this.add(this.sep1);
    }

    public void commitRows() {
        for (Table2RowPanel rowPanel : this.masterDataTable.getRowsFailSafe()) {
            TableRowImpl row = (TableRowImpl)rowPanel;
            this.commitSingleRow(row.getModel().getNode());
        }
    }

    public void commitSingleRow(Node<?> node) {
    }

    @Override
    public Node getNode() {
        return this.masterDataTable.getModel().getNode();
    }

    public void initFilterList() {
    }

    @Override
    protected void updateNode(Node n, ADTO dto) {
        n.removeExistingValues();
        n.setValue((Object)dto, 0L);
        n.updateNode();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        this.skin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
        g2.clip(new RoundRectangle2D.Double(1.0, 1.0, this.getWidth() - 2, this.getHeight() - 2, 5.0, 5.0));
        this.paintChildren(g2);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.masterDataTable != null) {
            this.masterDataTable.setEnabled(isEnabled);
        }
        if (this.panel != null) {
            this.panel.setEnabled(isEnabled);
        }
        if (this.sep1 != null) {
            this.sep1.setEnabled(isEnabled);
        }
        if (this.filter != null) {
            this.filter.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.masterDataTable != null) {
            this.masterDataTable.kill();
        }
        if (this.panel != null) {
            this.panel.kill();
        }
        if (this.sep1 != null) {
            this.sep1.kill();
        }
        this.masterDataTable = null;
        this.panel = null;
        this.sep1 = null;
        if (this.filter != null) {
            this.filter.kill();
            this.filter = null;
        }
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        if (ScreenValidationObject.isErrorList(node)) {
            InnerPopupFactory.showErrorDialog((List)node.getValue(), "Unable to load data", (Component)this);
        } else if (node != null && this.currentState == DefaultDataInsert.LoadingState.LOAD && this.masterDataTable != null && this.masterDataTable.getModel() != null && (this.masterDataTable.getModel().getNode() == null || this.masterDataTable.getModel().getNode().equals(node))) {
            this.masterDataTable.getModel().setNode(node);
        }
    }

    public void addButtonPressed() {
        if (this.masterDataTable.getModel().getNode() != null) {
            T a = this.getNewObject();
            Node n = INodeCreator.getDefaultImpl().getNode4DTO(a, false, false);
            this.masterDataTable.getModel().getNode().addChild(n, System.currentTimeMillis());
        }
    }

    public abstract T getNewObject();

    public abstract DetailsPanel getDetails();

    public abstract Class<? extends T> getMasterDataClass();

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = this.masterDataTable.getFocusComponents();
        a.addAll(this.panel.getFocusComponents());
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.masterDataTable.setVisibleContainer(pane);
        this.panel.setVisibleContainer(pane);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.masterDataTable.requestFocusInWindowNow();
    }

    @Override
    public void tableRowSelected(Table2 sourceTable, Table2RowPanel panel) {
        this.setEnabled(false);
        this.panel.setEnabled(false);
        if (panel != null) {
            this.panel.setNode(panel.getModel().getNode());
        } else {
            this.setEnabled(true);
            this.panel.setEnabled(false);
        }
    }

    public DetailsPanel getPanel() {
        return this.panel;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            DataInsert.this.layoutAnimation(parent);
            DataInsert.this.masterDataTable.setLocation(1, 1);
            DataInsert.this.masterDataTable.setSize(parent.getWidth() / 3, parent.getHeight() - (DataInsert.this.masterDataTable.getY() + 2));
            DataInsert.this.sep1.setLocation(DataInsert.this.masterDataTable.getX() + DataInsert.this.masterDataTable.getWidth(), DataInsert.this.masterDataTable.getY());
            DataInsert.this.sep1.setSize((int)DataInsert.this.sep1.getPreferredSize().getWidth(), DataInsert.this.masterDataTable.getHeight());
            if (DataInsert.this.panel != null) {
                DataInsert.this.panel.setLocation(DataInsert.this.masterDataTable.getX() + DataInsert.this.masterDataTable.getWidth() + 10, DataInsert.this.masterDataTable.getY());
                DataInsert.this.panel.setSize(parent.getWidth() - DataInsert.this.panel.getX(), DataInsert.this.masterDataTable.getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(parent.getSize());
        }
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private TextLabel label;
        private Button deleteButton;
        private boolean isDelete;

        public TableRowImpl(Table2RowModel m, Converter<?, ?> viewConverter, DtoField attribute) {
            super(m);
            this.isDelete = false;
            this.setSelectable(true);
            Node n = attribute != null ? m.getNode().getChildNamed(attribute) : m.getNode();
            this.label = new TextLabel(n, viewConverter);
            this.setLayout(new InnerLayout());
            n.addNodeListener((NodeListener)this);
            if (m.getNode().getValue() instanceof AMasterDataComplete) {
                this.ensureDeleteState();
            } else if (m.getNode().getValue() instanceof ADeletableDTO) {
                this.ensureDeleteState();
            } else if (m.getNode().getValue() instanceof ReportFileComplete) {
                this.ensureDeleteState();
            }
            this.add(this.label);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            Node deletedNode = this.model.getNode().getChildNamed(ADeletableDTO_.isDeleted);
            if (deletedNode != null) {
                deletedNode.setValue((Object)(!this.isDelete ? 1 : 0), 0L);
                if (this.model.getNode().getChildNamed(ADTO_.id).getValue() == null) {
                    DataInsert.this.masterDataTable.getModel().getNode().removeChild(this.model.getNode(), System.currentTimeMillis());
                } else {
                    this.ensureDeleteState();
                }
            }
        }

        private void ensureDeleteState() {
            boolean bl = this.isDelete = this.model.getNode().getChildNamed(ADeletableDTO_.isDeleted) != null ? (Boolean)this.model.getNode().getChildNamed(ADeletableDTO_.isDeleted).getValue() : false;
            if (this.isDelete) {
                if (this.deleteButton instanceof DeleteButton) {
                    this.deleteButton.kill();
                    this.deleteButton = null;
                }
                if (this.deleteButton == null) {
                    this.deleteButton = new RestoreButton();
                    this.deleteButton.addButtonListener(this);
                    this.add(this.deleteButton);
                }
            } else {
                if (this.deleteButton instanceof RestoreButton) {
                    this.deleteButton.kill();
                    this.deleteButton = null;
                }
                if (this.deleteButton == null) {
                    this.deleteButton = new DeleteButton();
                    this.deleteButton.addButtonListener(this);
                    this.add(this.deleteButton);
                }
            }
            this.setEnabled(DataInsert.this.isEnabled());
            this.revalidate();
        }

        @Override
        public Object getObject4Column(int column) {
            return this.label.getText();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.label.setEnabled(isEnabled);
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(isEnabled);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.label.kill();
            this.label = null;
            if (this.deleteButton != null) {
                this.deleteButton.kill();
                this.deleteButton = null;
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        public void valueChanged(Node<?> node) {
            if (this.label != null) {
                this.label.updateString();
            }
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int pw = 0;
                if (TableRowImpl.this.deleteButton != null) {
                    pw = (int)(TableRowImpl.this.deleteButton.getPreferredSize().getWidth() + (double)TableRowImpl.this.getInnerCellPadding());
                }
                TableRowImpl.this.label.setLocation(TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.label.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.label.setSize(parent.getWidth() - (2 * TableRowImpl.this.getCellPadding() + pw), (int)TableRowImpl.this.label.getPreferredSize().getHeight());
                if (TableRowImpl.this.deleteButton != null) {
                    TableRowImpl.this.deleteButton.setLocation(TableRowImpl.this.label.getX() + TableRowImpl.this.label.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.deleteButton.setSize(TableRowImpl.this.deleteButton.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }
}

