/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.HolidayPlanComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.HolidayPlanTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HolidayPlanTypeComplete_;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class HolidayPlanTypeConfig
extends MasterDataInsert<HolidayPlanTypeComplete> {
    private static final long serialVersionUID = 1L;

    public HolidayPlanTypeConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new HolidayTypeConfigPanel();
    }

    @Override
    public HolidayPlanTypeComplete getNewObject() {
        HolidayPlanTypeComplete a = new HolidayPlanTypeComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<HolidayPlanTypeComplete> getMasterDataClass() {
        return HolidayPlanTypeComplete.class;
    }

    @Override
    public String getInsertName() {
        return Words.HOLIDAY_PLAN_TYPES;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(HolidayPlanTypeComplete_.name).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(HolidayPlanTypeComplete_.name).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.NAME_IS_NOT_UNIQUE, (Object[])new Object[]{n.getChildNamed(HolidayPlanTypeComplete_.name).getValue()})));
                continue;
            }
            codes.add((String)n.getChildNamed(HolidayPlanTypeComplete_.name).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NAME_IS_SET));
        }
        return a;
    }

    private class HolidayTypeConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> name;
        private TitledItem<TextField> description;

        public HolidayTypeConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.name = new TitledItem<TextField>(new TextField(null), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(null), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.name);
            this.add(this.description);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.name.getFocusComponents();
            a.addAll(this.description.getFocusComponents());
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.name.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.name.setVisibleContainer(pane);
            this.description.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.name.kill();
            this.description.kill();
            this.name = null;
            this.description = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.name.setEnabled(b);
            this.description.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.name.getElement().setNode(node.getChildNamed(HolidayPlanTypeComplete_.name));
            this.description.getElement().setNode(node.getChildNamed(HolidayPlanTypeComplete_.description));
            this.setEnabled(true);
            HolidayPlanTypeConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return HolidayPlanComplete_.name;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                HolidayTypeConfigPanel.this.name.setLocation(HolidayPlanTypeConfig.this.masterDataTable.getCellPadding(), HolidayPlanTypeConfig.this.masterDataTable.getCellPadding());
                HolidayTypeConfigPanel.this.name.setSize(200, (int)HolidayTypeConfigPanel.this.name.getPreferredSize().getHeight());
                HolidayTypeConfigPanel.this.description.setLocation(HolidayPlanTypeConfig.this.masterDataTable.getCellPadding(), HolidayTypeConfigPanel.this.name.getY() + HolidayTypeConfigPanel.this.name.getHeight() + HolidayPlanTypeConfig.this.masterDataTable.getCellPadding());
                HolidayTypeConfigPanel.this.description.setSize(200, (int)HolidayTypeConfigPanel.this.description.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

